/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.JdbcCPConn;
import com.ingres.gcf.jdbc.JdbcDS;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.SQLException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public abstract class JdbcCPDS
extends JdbcDS
implements ConnectionPoolDataSource,
Serializable {
    private int initialPoolSize = 0;
    private int minPoolSize = 0;
    private int maxPoolSize = 0;
    private int maxIdleTime = 0;
    private int propertyCycle = 0;
    private int maxStatements = 0;

    protected JdbcCPDS() {
        this.initialize();
    }

    private void initialize() {
        this.title = this.trace.getTraceName() + "-ConnectionPoolDataSource[" + this.inst_id + "]";
        this.tr_id = "CPDSrc[" + this.inst_id + "]";
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int n) {
        this.initialPoolSize = n;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int n) {
        this.minPoolSize = n;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int n) {
        this.maxIdleTime = n;
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public void setPropertyCycle(int n) {
        this.propertyCycle = n;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int n) {
        this.maxStatements = n;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPooledConnection()");
        }
        JdbcCPConn jdbcCPConn = new JdbcCPConn(this.connect(null, null), this.trace);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPooledConnection(): " + jdbcCPConn);
        }
        return jdbcCPConn;
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPooledConnection('" + string + "','*****')");
        }
        JdbcCPConn jdbcCPConn = new JdbcCPConn(this.connect(string, string2), this.trace);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPooledConnection(): " + jdbcCPConn);
        }
        return jdbcCPConn;
    }

    @Override
    protected void initReference(Reference reference) {
        super.initReference(reference);
        if (this.initialPoolSize != 0) {
            this.encodeIntRef(reference, "initialPoolSize", this.initialPoolSize);
        }
        if (this.minPoolSize != 0) {
            this.encodeIntRef(reference, "minPoolSize", this.minPoolSize);
        }
        if (this.maxPoolSize != 0) {
            this.encodeIntRef(reference, "maxPoolSize", this.maxPoolSize);
        }
        if (this.maxIdleTime != 0) {
            this.encodeIntRef(reference, "maxIdleTime", this.maxIdleTime);
        }
        if (this.propertyCycle != 0) {
            this.encodeIntRef(reference, "propertyCycle", this.propertyCycle);
        }
        if (this.maxStatements != 0) {
            this.encodeIntRef(reference, "maxStatements", this.maxStatements);
        }
    }

    @Override
    protected void initInstance(Reference reference) {
        super.initInstance(reference);
        RefAddr refAddr = reference.get("initialPoolSize");
        if (refAddr != null) {
            this.initialPoolSize = this.decodeIntRef(refAddr);
        }
        if ((refAddr = reference.get("minPoolSize")) != null) {
            this.minPoolSize = this.decodeIntRef(refAddr);
        }
        if ((refAddr = reference.get("maxPoolSize")) != null) {
            this.maxPoolSize = this.decodeIntRef(refAddr);
        }
        if ((refAddr = reference.get("maxIdleTime")) != null) {
            this.maxIdleTime = this.decodeIntRef(refAddr);
        }
        if ((refAddr = reference.get("propertyCycle")) != null) {
            this.propertyCycle = this.decodeIntRef(refAddr);
        }
        if ((refAddr = reference.get("maxStatements")) != null) {
            this.maxStatements = this.decodeIntRef(refAddr);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }
}

