/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class PersistentPropertyDescriptor
extends PropertyDescriptor {
    private Field mField;

    public PersistentPropertyDescriptor(Class clazz, Field field) throws IntrospectionException {
        super(field.getName(), clazz, null, null);
        this.mField = field;
    }

    public PersistentPropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        super(string, method, method2);
        this.mField = null;
    }

    public synchronized Class getPropertyType() {
        if (this.mField == null) {
            return super.getPropertyType();
        }
        return this.mField.getType();
    }

    public Field getField() {
        return this.mField;
    }

    public boolean hasField() {
        return this.mField != null;
    }

    public boolean hasGetter() {
        return this.getReadMethod() != null;
    }

    public boolean hasSetter() {
        return this.getWriteMethod() != null;
    }

    public static boolean hasField(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor instanceof PersistentPropertyDescriptor) {
            return ((PersistentPropertyDescriptor)propertyDescriptor).hasField();
        }
        return false;
    }

    public static boolean hasGetter(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor instanceof PersistentPropertyDescriptor) {
            return ((PersistentPropertyDescriptor)propertyDescriptor).hasGetter();
        }
        return propertyDescriptor.getReadMethod() != null;
    }

    public static boolean hasSetter(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor instanceof PersistentPropertyDescriptor) {
            return ((PersistentPropertyDescriptor)propertyDescriptor).hasSetter();
        }
        return propertyDescriptor.getWriteMethod() != null;
    }

    public static Field getField(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor instanceof PersistentPropertyDescriptor) {
            return ((PersistentPropertyDescriptor)propertyDescriptor).getField();
        }
        return null;
    }

    public static Class getDeclaringClass(PropertyDescriptor propertyDescriptor) {
        Field field = PersistentPropertyDescriptor.getField(propertyDescriptor);
        if (field != null) {
            return field.getDeclaringClass();
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            return method.getDeclaringClass();
        }
        method = propertyDescriptor.getWriteMethod();
        if (method != null) {
            return method.getDeclaringClass();
        }
        return null;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        if (this.mField != null) {
            n = n * 10 + this.mField.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (!bl) {
            return bl;
        }
        if (!(object instanceof PersistentPropertyDescriptor)) {
            return false;
        }
        PersistentPropertyDescriptor persistentPropertyDescriptor = (PersistentPropertyDescriptor)object;
        if (this.mField == null) {
            return persistentPropertyDescriptor.mField == null;
        }
        return this.mField.equals(persistentPropertyDescriptor.mField);
    }
}

