/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.cache.ClassAnalizer;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.intersys.objects.reflect.TypeModifiers;
import com.jalapeno.tools.objects.DefaultMappingProvider;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.Java2DBPropertyMapping;
import com.jalapeno.tools.objects.Java2DBPropertyMappingDelegator;
import com.jalapeno.tools.objects.MappingToolInterface;
import com.jalapeno.tools.objects.NamedQuery;
import com.jalapeno.tools.objects.PersistentPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultMappingTool
implements MappingToolInterface,
TypeModifiers {
    private static final Java2DBMapping[] EMPTY_ARRAY = new Java2DBMapping[0];
    private Set mDependencies;
    private SortedSet mExclusions;
    private Map mMappedClasses;
    private Map mTypeMap;
    private Java2DBMapping[] mMappingProviders = new Java2DBMapping[1];
    private int mMerger = -1;

    public DefaultMappingTool(Set set) {
        this();
        this.mDependencies = set;
    }

    public DefaultMappingTool() {
        this.mMappingProviders[0] = new DefaultMappingProvider(this);
    }

    @Override
    public void setDependecies(Set set) {
        this.mDependencies = set;
    }

    @Override
    public void addMetadataProvider(Java2DBMapping java2DBMapping) {
        int n = this.mMappingProviders.length;
        Java2DBMapping[] java2DBMappingArray = new Java2DBMapping[n + 1];
        java2DBMappingArray[0] = java2DBMapping;
        System.arraycopy(this.mMappingProviders, 0, java2DBMappingArray, 1, n);
        this.mMappingProviders = java2DBMappingArray;
    }

    @Override
    public void setDefaultAccessLevel(int n) {
        int n2 = this.mMappingProviders.length - 1;
        ((DefaultMappingProvider)this.mMappingProviders[n2]).setDefaultAccessLevel(n);
    }

    @Override
    public void setDefaultAccessType(int n) {
        int n2 = this.mMappingProviders.length - 1;
        ((DefaultMappingProvider)this.mMappingProviders[n2]).setDefaultAccessType(n);
    }

    @Override
    public void setDefaultJavaProjectionPackage(String string) {
        int n = this.mMappingProviders.length - 1;
        ((DefaultMappingProvider)this.mMappingProviders[n]).setDefaultJavaProjectionPackage(string);
    }

    @Override
    public void setIgnoreNestedGenerics(boolean bl) {
        int n = this.mMappingProviders.length - 1;
        ((DefaultMappingProvider)this.mMappingProviders[n]).setIgnoreNestedGenerics(bl);
    }

    @Override
    public String cacheFieldNameFor(Object object, Set set) {
        String string = this.cacheFieldNameFor(object);
        if (set == null || !set.contains(string)) {
            return string;
        }
        return string;
    }

    @Override
    public Set listUnmappedFields(Class clazz) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            if (!(java2DBMapping instanceof ClassMerger)) continue;
            hashSet.addAll(((ClassMerger)java2DBMapping).listUnmappedFields(clazz));
        }
        return hashSet;
    }

    @Override
    public String cacheMappedClassNameFor(String string) {
        if (this.mMappedClasses == null) {
            return null;
        }
        String string2 = (String)this.mMappedClasses.get(string);
        return string2;
    }

    @Override
    public void classMapped(String string, String string2, boolean bl) {
        if (this.mTypeMap == null) {
            this.mTypeMap = new HashMap();
        }
        this.mTypeMap.put(string, string2);
        if (!bl) {
            return;
        }
        if (this.mMappedClasses == null) {
            this.mMappedClasses = new HashMap();
        }
        this.mMappedClasses.put(string, string2);
    }

    @Override
    public Map getTypemap() {
        return this.mMappedClasses;
    }

    @Override
    public void addExclusions(Collection collection) {
        if (collection == null) {
            return;
        }
        if (this.mExclusions == null) {
            this.mExclusions = new TreeSet();
        }
        this.mExclusions.addAll(collection);
    }

    @Override
    public boolean registerDependency(Class clazz) {
        if (this.testForExclusion(clazz.getName())) {
            return false;
        }
        if (this.mDependencies != null) {
            this.mDependencies.add(clazz);
        }
        return true;
    }

    @Override
    public boolean testForExclusion(String string) {
        if (this.mExclusions == null) {
            return false;
        }
        SortedSet<String> sortedSet = this.mExclusions.headSet(string + "\u0000");
        if (sortedSet.isEmpty()) {
            return false;
        }
        String string2 = sortedSet.last();
        return string.startsWith(string2);
    }

    public Java2DBMapping[] getMappingProviders() {
        return this.mMappingProviders;
    }

    @Override
    public String cacheFieldTypeFor(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            this.findMerger();
            return this.mMappingProviders[this.mMerger].cacheFieldTypeFor(object);
        }
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i]);
            string = java2DBPropertyMappingDelegator.cacheFieldTypeFor(object);
            if (string != null) {
                return string;
            }
            int n = java2DBPropertyMappingDelegator.getPropertyKind(object);
            switch (n) {
                case 64: {
                    return "%Library.GlobalCharacterStream";
                }
                case 32: {
                    return "%Library.GlobalBinaryStream";
                }
            }
            CacheRelationshipInfo cacheRelationshipInfo = java2DBPropertyMappingDelegator.relationshipFor(object);
            if (cacheRelationshipInfo != null && cacheRelationshipInfo.inverseClass != null && cacheRelationshipInfo.inverseClass instanceof Class) {
                string = this.cacheClassNameFor((Class)cacheRelationshipInfo.inverseClass);
            }
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public CacheRelationshipInfo relationshipFor(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            this.findMerger();
            return this.mMappingProviders[this.mMerger].relationshipFor(object);
        }
        CacheRelationshipInfo cacheRelationshipInfo = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i]);
            cacheRelationshipInfo = java2DBPropertyMappingDelegator.relationshipFor(object);
            if (cacheRelationshipInfo == null) continue;
            if (cacheRelationshipInfo.inverseField == null) {
                this.tryToFindInverseField(java2DBPropertyMappingDelegator, object, cacheRelationshipInfo);
            }
            if ((cacheRelationshipInfo = this.checkIfReference(java2DBPropertyMappingDelegator, object, cacheRelationshipInfo)) != null && cacheRelationshipInfo.inverseClass == null) {
                this.tryToGuessInverseClass(cacheRelationshipInfo, object);
            }
            this.makeCardinalityConsistent(java2DBPropertyMappingDelegator, object, cacheRelationshipInfo);
            return cacheRelationshipInfo;
        }
        return cacheRelationshipInfo;
    }

    private void makeCardinalityConsistent(Java2DBPropertyMapping java2DBPropertyMapping, Object object, CacheRelationshipInfo cacheRelationshipInfo) {
        if (cacheRelationshipInfo == null) {
            return;
        }
        if (cacheRelationshipInfo.pointsToManyOrChildren) {
            return;
        }
        if (cacheRelationshipInfo.inverseClass == null) {
            return;
        }
        if (cacheRelationshipInfo.inverseField == null) {
            return;
        }
        CacheRelationshipInfo cacheRelationshipInfo2 = this.findInverseRelationship(java2DBPropertyMapping, object, cacheRelationshipInfo);
        if (cacheRelationshipInfo2 == null) {
            return;
        }
        if (cacheRelationshipInfo2.parentChild) {
            cacheRelationshipInfo.parentChild = true;
        }
    }

    @Override
    public String cacheClassNameFor(Class clazz) {
        Java2DBMapping java2DBMapping;
        String string = this.cacheMappedClassNameFor(clazz.getName());
        if (string != null) {
            return string;
        }
        String string2 = null;
        for (int i = 0; i < this.mMappingProviders.length && (string2 = (java2DBMapping = this.mMappingProviders[i]).cacheClassNameFor(clazz)) == null; ++i) {
        }
        if (string2 != null) {
            String string3 = this.packageNameFor(clazz);
            int n = string2.lastIndexOf(46);
            if (string3 == null) {
                if (n < 0) {
                    string3 = "User";
                }
            } else if (n > 0) {
                string2 = string2.substring(n + 1);
            }
            if (string3 != null) {
                string2 = string3 + "." + string2;
            }
        }
        return string2;
    }

    @Override
    public String sqlTableNameFor(Class clazz) {
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            string = java2DBMapping.sqlTableNameFor(clazz);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public String cacheFieldNameFor(Object object) {
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i]);
            string = java2DBPropertyMappingDelegator.cacheFieldNameFor(object);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public String primaryKeyNameFor(Class clazz) {
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            string = java2DBMapping.primaryKeyNameFor(clazz);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public CacheIndexInfo[] allIndicesFor(Class clazz) {
        CacheIndexInfo[] cacheIndexInfoArray = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            cacheIndexInfoArray = java2DBMapping.allIndicesFor(clazz);
            if (cacheIndexInfoArray == null || cacheIndexInfoArray.length <= 0) continue;
            int n = 0;
            while (i < cacheIndexInfoArray.length) {
                try {
                    if (cacheIndexInfoArray[n].getProperties() == null && cacheIndexInfoArray[n].getColumnArray() == null) {
                        throw new NullPointerException("Properties null: \nclass: " + clazz.getName() + " name: " + cacheIndexInfoArray[n].getName() + "\nProvider: " + java2DBMapping);
                    }
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
                ++i;
            }
            return cacheIndexInfoArray;
        }
        return cacheIndexInfoArray;
    }

    @Override
    public int getAccessLevel(Class clazz) {
        int n = -1;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            n = java2DBMapping.getAccessLevel(clazz);
            if (n <= 0) continue;
            return n;
        }
        return n;
    }

    @Override
    public String getJavaProjectionPackage(Class clazz) {
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            string = java2DBMapping.getJavaProjectionPackage(clazz);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public String getJavaProjectionClassName(Class clazz) {
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            string = java2DBMapping.getJavaProjectionClassName(clazz);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public int getAccessType(Class clazz) {
        int n = -1;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            n = java2DBMapping.getAccessType(clazz);
            if (n <= 0) continue;
            return n;
        }
        return n;
    }

    @Override
    public boolean isSerial(Class clazz) {
        boolean bl = false;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            bl = java2DBMapping.isSerial(clazz);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    @Override
    public String getVersionID(Class clazz) {
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            string = java2DBMapping.getVersionID(clazz);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public int getPropertyKind(Object object) {
        Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator;
        if (!(object instanceof PropertyDescriptor)) {
            this.findMerger();
            return this.mMappingProviders[this.mMerger].getPropertyKind(object);
        }
        int n = -1;
        for (int i = 0; i < this.mMappingProviders.length && (n = (java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i])).getPropertyKind(object)) < 0; ++i) {
        }
        if (n == 33032) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator2;
            String string = null;
            for (int i = 0; i < this.mMappingProviders.length - 1 && (string = (java2DBPropertyMappingDelegator2 = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i])).cacheFieldTypeFor(object)) == null; ++i) {
            }
            n = string != null ? 0 : 264;
        }
        return n;
    }

    @Override
    public boolean isFetchTypeEager(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            this.findMerger();
            return this.mMappingProviders[this.mMerger].isFetchTypeEager(object);
        }
        boolean bl = false;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i]);
            bl = java2DBPropertyMappingDelegator.isFetchTypeEager(object);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    @Override
    public boolean isClassTransient(Class clazz) {
        boolean bl = false;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            bl = java2DBMapping.isClassTransient(clazz);
            if (!bl) continue;
            return bl;
        }
        Class<?> clazz2 = clazz.getDeclaringClass();
        if (clazz2 != null) {
            bl = this.isClassTransient(clazz2);
        }
        return bl;
    }

    @Override
    public boolean isMemberTransient(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            this.findMerger();
            return this.mMappingProviders[this.mMerger].isMemberTransient(object);
        }
        boolean bl = false;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i]);
            bl = java2DBPropertyMappingDelegator.isMemberTransient(object);
            if (!bl) continue;
            return bl;
        }
        Class clazz = DefaultMappingProvider.typeOfField((PropertyDescriptor)object);
        return this.isClassTransient(clazz);
    }

    @Override
    public Map getPropertyParameters(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            this.findMerger();
            return this.mMappingProviders[this.mMerger].getPropertyParameters(object);
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i]);
            Map map = java2DBPropertyMappingDelegator.getPropertyParameters(object);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                if (hashMap.containsKey(entry.getKey())) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    @Override
    public String getDatabaseID(Class clazz) {
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            string = java2DBMapping.getDatabaseID(clazz);
            if (string == null) continue;
            DefaultMappingProvider defaultMappingProvider = this.getDefaultProvider();
            string = defaultMappingProvider.replaceDollars(string);
            string = defaultMappingProvider.replaceUnderscores(string);
            return string;
        }
        return string;
    }

    @Override
    public int getDatabaseIDType(Class clazz) {
        int n = -1;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            n = java2DBMapping.getDatabaseIDType(clazz);
            if (n < 0) continue;
            return n;
        }
        return n;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            this.mMappingProviders[i].close();
            this.mMappingProviders[i] = null;
        }
        this.mMappingProviders = EMPTY_ARRAY;
    }

    @Override
    public void setHelperMapping(Java2DBMapping java2DBMapping) {
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping2 = this.mMappingProviders[i];
            java2DBMapping2.setHelperMapping(java2DBMapping);
        }
    }

    @Override
    public void setSelfHelperMapping() {
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            java2DBMapping.setHelperMapping(this);
        }
    }

    @Override
    public boolean isPopulatable(Class clazz) {
        boolean bl = false;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            bl = java2DBMapping.isPopulatable(clazz);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    @Override
    public boolean isXMLSerializable(Class clazz) {
        boolean bl = false;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            bl = java2DBMapping.isXMLSerializable(clazz);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    @Override
    public Map getClassParameters(Class clazz) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            Map map = java2DBMapping.getClassParameters(clazz);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                if (hashMap.containsKey(entry.getKey())) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    @Override
    public String getExtendedClass(Class clazz) {
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            string = java2DBMapping.getExtendedClass(clazz);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public String[] getImplementedClasses(Class clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            String[] stringArray = java2DBMapping.getImplementedClasses(clazz);
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (arrayList.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public boolean isPropertyRequired(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            this.findMerger();
            return this.mMappingProviders[this.mMerger].isPropertyRequired(object);
        }
        boolean bl = false;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i]);
            bl = java2DBPropertyMappingDelegator.isPropertyRequired(object);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    @Override
    public void setDefaultReplacement(char c, String string) {
        this.getDefaultProvider().setDefaultReplacement(c, string);
    }

    @Override
    public void setUseGettersOnly(boolean bl) {
        this.getDefaultProvider().setUseGettersOnly(bl);
    }

    private DefaultMappingProvider getDefaultProvider() {
        int n = this.mMappingProviders.length - 1;
        return (DefaultMappingProvider)this.mMappingProviders[n];
    }

    private CacheRelationshipInfo checkIfReference(Java2DBPropertyMapping java2DBPropertyMapping, Object object, CacheRelationshipInfo cacheRelationshipInfo) {
        String string = java2DBPropertyMapping instanceof Java2DBPropertyMappingDelegator ? ((Java2DBPropertyMappingDelegator)java2DBPropertyMapping).getProviderName() : java2DBPropertyMapping.getClass().getName();
        if (!string.endsWith("HibernateProvider")) {
            return cacheRelationshipInfo;
        }
        if (!(object instanceof PropertyDescriptor)) {
            return cacheRelationshipInfo;
        }
        if (cacheRelationshipInfo.pointsToManyOrChildren) {
            return cacheRelationshipInfo;
        }
        Class clazz = PersistentPropertyDescriptor.getDeclaringClass((PropertyDescriptor)object);
        if (this.cacheClassName(cacheRelationshipInfo).equals(clazz.getName())) {
            return null;
        }
        if (cacheRelationshipInfo.inverseField != null) {
            return cacheRelationshipInfo;
        }
        return null;
    }

    @Override
    public String cacheClassName(CacheRelationshipInfo cacheRelationshipInfo) {
        if (cacheRelationshipInfo.inverseClass instanceof Class) {
            return this.cacheClassNameFor((Class)cacheRelationshipInfo.inverseClass);
        }
        return (String)cacheRelationshipInfo.inverseClass;
    }

    private void tryToFindInverseField(Java2DBPropertyMapping java2DBPropertyMapping, Object object, CacheRelationshipInfo cacheRelationshipInfo) {
        CacheRelationshipInfo cacheRelationshipInfo2;
        if (!(object instanceof PropertyDescriptor)) {
            return;
        }
        Class clazz = PersistentPropertyDescriptor.getDeclaringClass((PropertyDescriptor)object);
        if (cacheRelationshipInfo.inverseClass == null) {
            this.tryToGuessInverseClass(cacheRelationshipInfo, object);
        }
        Set set = this.getFields(cacheRelationshipInfo.inverseClass, clazz.getClassLoader());
        String string = this.cacheClassNameFor(clazz);
        String string2 = this.cacheFieldNameFor(object);
        for (Object e : set) {
            cacheRelationshipInfo2 = java2DBPropertyMapping.relationshipFor(e);
            if (cacheRelationshipInfo2 == null) continue;
            if (cacheRelationshipInfo2.inverseClass == null) {
                this.tryToGuessInverseClass(cacheRelationshipInfo2, e);
            }
            if (!string.equals(this.cacheClassName(cacheRelationshipInfo2)) || !string2.equals(cacheRelationshipInfo2.inverseField)) continue;
            cacheRelationshipInfo.inverseField = this.cacheFieldNameFor(e);
            return;
        }
        for (Object e : set) {
            cacheRelationshipInfo2 = java2DBPropertyMapping.relationshipFor(e);
            if (cacheRelationshipInfo2 == null || !string.equals(this.cacheClassName(cacheRelationshipInfo2))) continue;
            cacheRelationshipInfo.inverseField = this.cacheFieldNameFor(e);
            return;
        }
        for (Object e : set) {
            String string3;
            int n = java2DBPropertyMapping.getPropertyKind(e);
            if (n == 0 || !string.equals(string3 = java2DBPropertyMapping.cacheFieldTypeFor(e))) continue;
            cacheRelationshipInfo.inverseField = this.cacheFieldNameFor(e);
            return;
        }
    }

    private CacheRelationshipInfo findInverseRelationship(Java2DBPropertyMapping java2DBPropertyMapping, Object object, CacheRelationshipInfo cacheRelationshipInfo) {
        CacheRelationshipInfo cacheRelationshipInfo2;
        if (!(object instanceof PropertyDescriptor)) {
            return null;
        }
        Class clazz = PersistentPropertyDescriptor.getDeclaringClass((PropertyDescriptor)object);
        Set set = this.getFields(cacheRelationshipInfo.inverseClass, clazz.getClassLoader());
        if (set == null) {
            return null;
        }
        String string = this.cacheClassNameFor(clazz);
        String string2 = this.cacheFieldNameFor(object);
        for (Object e : set) {
            cacheRelationshipInfo2 = java2DBPropertyMapping.relationshipFor(e);
            if (cacheRelationshipInfo2 == null) continue;
            if (cacheRelationshipInfo2.inverseClass == null) {
                this.tryToGuessInverseClass(cacheRelationshipInfo2, e);
            }
            if (!string.equals(this.cacheClassName(cacheRelationshipInfo2)) || !string2.equals(cacheRelationshipInfo2.inverseField)) continue;
            cacheRelationshipInfo.inverseField = this.cacheFieldNameFor(e);
            return cacheRelationshipInfo2;
        }
        for (Object e : set) {
            cacheRelationshipInfo2 = java2DBPropertyMapping.relationshipFor(e);
            if (cacheRelationshipInfo2 == null || !string.equals(this.cacheClassName(cacheRelationshipInfo2))) continue;
            cacheRelationshipInfo.inverseField = this.cacheFieldNameFor(e);
            return cacheRelationshipInfo2;
        }
        return null;
    }

    private void tryToGuessInverseClass(CacheRelationshipInfo cacheRelationshipInfo, Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            return;
        }
        DefaultMappingProvider defaultMappingProvider = (DefaultMappingProvider)this.mMappingProviders[this.mMappingProviders.length - 1];
        cacheRelationshipInfo.inverseClass = defaultMappingProvider.javaFieldTypeFor(object);
    }

    @Override
    public Set getFields(Object object, ClassLoader classLoader) {
        Set set;
        Class<?> clazz;
        if (object instanceof Class) {
            clazz = (Class<?>)object;
        } else {
            try {
                if (!(object instanceof String)) {
                    return null;
                }
                clazz = Class.forName((String)object, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        int n = this.getAccessType(clazz);
        switch (n) {
            case 12001: {
                set = ClassAnalizer.getPersistableFields(clazz, null, this.getAccessLevel(clazz), false);
                break;
            }
            case 12006: {
                set = ClassAnalizer.getGetSetPairs(clazz, this.getAccessLevel(clazz), false);
                break;
            }
            case 12002: {
                set = ClassAnalizer.getGetSetPairs(clazz, this.getAccessLevel(clazz), true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported access type.");
            }
        }
        return set;
    }

    private void findMerger() {
        if (this.mMerger >= 0) {
            return;
        }
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            if (!(this.mMappingProviders[i] instanceof ClassMerger)) continue;
            this.mMerger = i;
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public String sqlColumnNameFor(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            this.findMerger();
            return this.mMappingProviders[this.mMerger].sqlColumnNameFor(object);
        }
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBPropertyMappingDelegator java2DBPropertyMappingDelegator = new Java2DBPropertyMappingDelegator(this.mMappingProviders[i]);
            string = java2DBPropertyMappingDelegator.sqlColumnNameFor(object);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    @Override
    public String packageNameFor(Class clazz) {
        Java2DBMapping java2DBMapping;
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length && (string = (java2DBMapping = this.mMappingProviders[i]).packageNameFor(clazz)) == null; ++i) {
        }
        return string;
    }

    @Override
    public String sqlSchemaNameFor(Class clazz) {
        Java2DBMapping java2DBMapping;
        String string = null;
        for (int i = 0; i < this.mMappingProviders.length && (string = (java2DBMapping = this.mMappingProviders[i]).sqlSchemaNameFor(clazz)) == null; ++i) {
        }
        return string;
    }

    @Override
    public List getNamedQueries(Class clazz) {
        ArrayList<NamedQuery> arrayList = new ArrayList<NamedQuery>();
        for (int i = 0; i < this.mMappingProviders.length; ++i) {
            Java2DBMapping java2DBMapping = this.mMappingProviders[i];
            List list = java2DBMapping.getNamedQueries(clazz);
            if (list == null) continue;
            for (NamedQuery namedQuery : list) {
                if (arrayList.contains(namedQuery)) continue;
                arrayList.add(namedQuery);
            }
        }
        return arrayList;
    }

    protected static interface ClassMerger
    extends Java2DBMapping {
        public Set listUnmappedFields(Class var1);
    }
}

