/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.DatabaseWithReferenceMap;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.Persistent;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.ExtentManager;
import com.jalapeno.runtime.CachePOJOExtentManager;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.ObjectCopierFromPojo;
import com.jalapeno.runtime.ObjectFactory;
import com.jalapeno.runtime.PojoOperations;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ProxyManager {
    static boolean ENABLE_CACHE_ASSERTIONS = false;
    protected Database mDB;
    protected Database mFullDB;
    private CachePOJOExtentManager mExtentManager;

    protected Persistent findProxy(Object object, boolean bl) throws Exception {
        if (object instanceof Persistent) {
            return (Persistent)object;
        }
        return this.manager().findProxy(object, bl);
    }

    public Collection attachAll() throws Exception {
        return this.attachAll(this.manager().currentCache());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection attachAll(Collection collection) throws Exception {
        HashMap hashMap = new HashMap();
        DetachedObjectsManager detachedObjectsManager = this.manager();
        ObjectCopierFromPojo objectCopierFromPojo = new ObjectCopierFromPojo(this.manager(), this.getClassLoader(), hashMap, true);
        for (Object e : collection) {
            if (hashMap.containsKey(e)) continue;
            DetachedObjectsManager detachedObjectsManager2 = detachedObjectsManager;
            synchronized (detachedObjectsManager2) {
                Database database = this.mDB;
                synchronized (database) {
                    this.attachInternalNoSync(e, objectCopierFromPojo);
                }
            }
        }
        return hashMap.values();
    }

    protected void refreshAll(boolean bl) throws Exception {
        Collection collection = this.manager().currentCache();
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (hashMap.containsKey(e)) continue;
            try {
                Persistent persistent = this.findProxy(e, true);
                if (persistent == null) continue;
                persistent._reload();
                persistent.copyTo(e, hashMap, bl);
            }
            catch (CacheException cacheException) {
                if (cacheException.getCode() == 5809) {
                    iterator.remove();
                    continue;
                }
                throw cacheException;
            }
        }
    }

    protected Persistent attachInternal(Object object, boolean bl, boolean bl2) throws Exception {
        return this.attachInternal(object, bl, null, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Persistent attachInternal(Object object, boolean bl, Map map, boolean bl2, boolean bl3) throws Exception {
        DetachedObjectsManager detachedObjectsManager;
        DetachedObjectsManager detachedObjectsManager2 = detachedObjectsManager = this.manager();
        synchronized (detachedObjectsManager2) {
            Database database = this.mDB;
            synchronized (database) {
                return this.attachInternalNoSync(object, bl, map, bl2, bl3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Persistent attachInternalNoSync(Object object, boolean bl, Map map, boolean bl2, boolean bl3) throws Exception {
        if (this.mDB instanceof DatabaseWithReferenceMap) {
            ((DatabaseWithReferenceMap)this.mDB).setInAttachMode(true);
        }
        try {
            Object object2;
            Persistent persistent = this.findProxy(object, false);
            if (persistent == null) {
                if (!bl2) {
                    Persistent persistent2 = null;
                    return persistent2;
                }
                object2 = this.findImplementation(object.getClass());
                persistent = (Persistent)object2.newInstance((String)null);
            }
            if (ObjectFactory.isUnswizzledShadow(object)) {
                object2 = persistent;
                return object2;
            }
            try {
                object2 = persistent.attach(object, bl, bl3);
                if (map != null) {
                    map.putAll(object2);
                }
            }
            catch (CacheException cacheException) {
                throw cacheException;
            }
            catch (Exception exception) {
                if (Logger.debugOn()) {
                    exception.printStackTrace(Logger.out);
                }
                throw new CacheException(exception, "Failed to copy from instance of " + object.getClass().getName() + " with id " + persistent.getId());
            }
            object2 = persistent;
            return object2;
        }
        finally {
            if (this.mDB instanceof DatabaseWithReferenceMap) {
                ((DatabaseWithReferenceMap)this.mDB).setInAttachMode(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Persistent attachInternalNoSync(Object object, ObjectCopierFromPojo objectCopierFromPojo) throws Exception {
        if (this.mDB instanceof DatabaseWithReferenceMap) {
            ((DatabaseWithReferenceMap)this.mDB).setInAttachMode(true);
        }
        try {
            Object object2;
            Persistent persistent = this.findProxy(object, false);
            if (persistent == null) {
                object2 = this.findImplementation(object.getClass());
                persistent = (Persistent)object2.newInstance((String)null);
            }
            if (ObjectFactory.isUnswizzledShadow(object)) {
                object2 = persistent;
                return object2;
            }
            try {
                persistent.attach(object, objectCopierFromPojo);
            }
            catch (CacheException cacheException) {
                throw cacheException;
            }
            catch (Exception exception) {
                if (Logger.debugOn()) {
                    exception.printStackTrace(Logger.out);
                }
                throw new CacheException(exception, "Failed to copy from instance of " + object.getClass().getName() + " with id " + persistent.getId());
            }
            object2 = persistent;
            return object2;
        }
        finally {
            if (this.mDB instanceof DatabaseWithReferenceMap) {
                ((DatabaseWithReferenceMap)this.mDB).setInAttachMode(false);
            }
        }
    }

    public CacheClass findImplementation(Class clazz) throws ClassNotFoundException, CacheException {
        Class clazz2 = ObjectFactory.getOriginalClass(clazz);
        return this.manager().findImplementation(clazz2);
    }

    protected String findImplementationName(Class clazz) throws ClassNotFoundException, CacheException, SQLException {
        Class clazz2 = ObjectFactory.getOriginalClass(clazz);
        return this.findImplementationName(clazz2.getName());
    }

    protected String findImplementationName(String string) throws ClassNotFoundException, CacheException, SQLException {
        return this.manager().findCacheClassNameForPOJO(string);
    }

    protected static CandidateKey parseKeyString(CacheClass cacheClass, String string) throws CacheException {
        int n = string.indexOf(58);
        if (n < 0) {
            return ProxyManager.createCandidateKey(cacheClass, string);
        }
        int n2 = string.indexOf(123);
        if (n2 < 0) {
            return ProxyManager.createCandidateKey(cacheClass, string);
        }
        int n3 = string.indexOf(125);
        if (n3 < 0) {
            return ProxyManager.createCandidateKey(cacheClass, string);
        }
        String string2 = string.substring(0, n).trim();
        if (!cacheClass.getName().equals(string2)) {
            throw new CacheException("Given key value is for class " + string2 + ". Must be for class " + cacheClass.getName());
        }
        String string3 = string.substring(n + 1, n2).trim();
        int n4 = string.indexOf(91);
        int n5 = string.indexOf(93);
        if (n4 < 0 || n5 < 0) {
            throw new CacheException("Key string: " + string + " contains no value");
        }
        string = string.substring(n4 + 1, n5);
        CandidateKey candidateKey = cacheClass.createKey(string3, string);
        return candidateKey;
    }

    protected static CandidateKey createCandidateKey(CacheClass cacheClass, String string) throws CacheException {
        CandidateKey candidateKey = cacheClass.createBestCandidateKey();
        candidateKey.set(string);
        return candidateKey;
    }

    protected DetachedObjectsManager manager() {
        DetachedObjectsManager detachedObjectsManager = ((SysDatabase)this.mDB).getDetachedObjectsManager();
        detachedObjectsManager.enableAsertions(ENABLE_CACHE_ASSERTIONS);
        return detachedObjectsManager;
    }

    protected CacheClass findCacheClassForPOJO(String string) throws Exception {
        return this.manager().findCacheClassForPOJO(string);
    }

    protected static CandidateKey findPrimaryKey(Object object, CacheClass cacheClass) throws CacheException {
        if (object instanceof CandidateKey) {
            return (CandidateKey)object;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            String string = Array.get(object, 0).toString();
            for (int i = 1; i < n; ++i) {
                string = string + "," + Array.get(object, i).toString();
            }
            return ProxyManager.parseKeyString(cacheClass, string);
        }
        return ProxyManager.parseKeyString(cacheClass, object.toString());
    }

    public Database getFullDatabase() throws Exception {
        if (this.mFullDB == null) {
            this.mFullDB = this.mDB;
            if (this.mFullDB.isLightConnection()) {
                Connection connection = this.mFullDB.createStatement().getConnection();
                this.mFullDB = CacheDatabase.getDatabase(connection);
                if (this.mDB.transactionLevel(false) > 0 && this.mFullDB.transactionLevel(true) <= 0) {
                    this.mFullDB.transactionStart();
                }
            }
        }
        return this.mFullDB;
    }

    public Statement createStatement() throws CacheException {
        return this.mDB.createStatement();
    }

    protected void deleteClassDefinition(String string) throws Exception {
        this.manager().removeClass(string);
        this.getFullDatabase().utilities().deleteClassDefintion(string);
    }

    public ExtentManager extentManager() {
        if (this.mExtentManager == null) {
            this.mExtentManager = new CachePOJOExtentManager(this);
        }
        return this.mExtentManager;
    }

    public void purgeEverything() throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object/Entity Manager is Closed.");
        }
        this.manager().clear();
        this.mDB.closeAllObjects();
    }

    public Serializable getId(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        return this.manager().getId(object);
    }

    public void purgeFromMemory(Object object) throws Exception {
        this.manager().purge(object);
    }

    public void removeFromDatabase(Class clazz, Object object) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        if (object == null) {
            throw new NullPointerException("Object to delete can not be null");
        }
        CacheClass cacheClass = this.findImplementation(clazz);
        Id id = clazz.isAssignableFrom(object.getClass()) ? (Id)this.getId(object) : PojoOperations.toId(object);
        cacheClass.deleteObject(id);
    }

    protected ClassLoader getClassLoader() {
        return ((SysDatabase)this.mDB).getClassLoader();
    }
}

