/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.CacheObject;
import com.intersys.cache.LazyList;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickBulkInsertWorker;
import com.intersys.cache.quick.QuickDatabase;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.cache.quick.ThirdPartyDatabase;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.XSQL.DSI.JPAQuery;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.POJOIterator;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassInfo;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.jalapeno.Adaptor;
import com.jalapeno.ApplicationContext;
import com.jalapeno.MapFactory;
import com.jalapeno.ObjectManager;
import com.jalapeno.ObjectManagerFactory;
import com.jalapeno.Settings;
import com.jalapeno.Utilities;
import com.jalapeno.runtime.CacheMapFactory;
import com.jalapeno.runtime.CachePOJOUtilities;
import com.jalapeno.runtime.DependencyResolver;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.InstanceSettings;
import com.jalapeno.runtime.JalapenoHelperInterface;
import com.jalapeno.runtime.ObjectBackedMap;
import com.jalapeno.runtime.ObjectCopierToPojo;
import com.jalapeno.runtime.ObjectFactory;
import com.jalapeno.runtime.PojoOperations;
import com.jalapeno.runtime.PopulateUtils;
import com.jalapeno.runtime.ProxyManager;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class CacheObjectManager
extends ProxyManager
implements ObjectManager {
    private static final int SAVE_FLAG_LIMITED_REFRESH = 256;
    private static final int SAVE_FLAG_NO_REFRESH = 512;
    private static final int SAVE_FLAG_1_REFRESH = 1024;
    private static final int SAVE_FLAG_SAVE_REQ_PROPS_ONLY = 1;
    private Connection mConnectionToClose;
    private PopulateUtils mPopulateUtils;
    private CachePOJOUtilities mUtilities;
    private boolean mAllowProxy = true;
    private Settings mSettings;
    private boolean mInImplicitTransaction = false;
    private boolean mOptimizeTransactions = true;
    private boolean mQueryServerTMode = false;
    private Object mWire;
    private Object mTmpSysList;
    private DataSource mDataSource;
    private MapFactory mMapFactory;
    private int mConcurrency;
    private int mSavePolicy = -1;
    private long mTransactionCount = 0L;

    public CacheObjectManager(String string, String string2, String string3, Settings settings) throws CacheException {
        if (string.startsWith("jdbc:Cache://")) {
            this.mDB = CacheDatabase.getLightDatabase(string, string2, string3);
        } else {
            try {
                Connection connection = DriverManager.getConnection(string, string2, string3);
                this.mDB = CacheDatabase.getLightDatabase(connection);
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Error initializing connection to Third-Party database: " + string);
            }
        }
        this.setUp(settings);
    }

    public CacheObjectManager(String string, String string2, String string3, String string4) throws CacheException {
        if ("full".equalsIgnoreCase(string4)) {
            this.mDB = CacheDatabase.getDatabase(string, string2, string3);
        } else if (string4 == null || "light".equalsIgnoreCase(string4)) {
            this.mDB = CacheDatabase.getLightDatabase(string, string2, string3);
        } else {
            throw new IllegalArgumentException("Unknown connection mode: " + string4);
        }
        this.setUp(null);
    }

    public CacheObjectManager(Connection connection, Settings settings) throws CacheException {
        this(connection, null, false, settings);
    }

    public CacheObjectManager(Connection connection, String string, boolean bl, Settings settings) throws CacheException {
        if ("full".equalsIgnoreCase(string)) {
            this.mDB = CacheDatabase.getDatabase(connection);
        } else if (string == null || "light".equalsIgnoreCase(string)) {
            this.mDB = CacheDatabase.getLightDatabase(connection);
        } else {
            throw new IllegalArgumentException("Unknown connection mode: " + string);
        }
        if (bl) {
            this.closeConnectionOnClose(connection);
        }
        this.setUp(settings);
    }

    public CacheObjectManager(Database database) {
        this.mDB = database;
        this.setUp(null);
    }

    private static boolean limitedRefresh(int n) {
        return (n & 0x100) == 256;
    }

    private static boolean oneLevelRefresh(int n) {
        return (n & 0x400) == 1024;
    }

    private static boolean noRefresh(int n) {
        return (n & 0x200) == 512;
    }

    private static boolean saveReqPropsOnly(int n) {
        return (n & 1) == 1;
    }

    public ObjectServerInfo getServerInfo() {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        return this.mDB.getServerInfo();
    }

    public void setProfileOn(int n) throws CacheException {
        this.mDB.setProfileOn(n);
    }

    public void setProfileOff(int n) throws CacheException {
        this.mDB.setProfileOff(n);
    }

    public void resetProfile(int n) throws CacheException {
        this.mDB.resetProfile(n);
    }

    public int getNumberOfServerCalls(int n) throws CacheException {
        return this.mDB.getNumberOfServerCalls(n);
    }

    public Map getSentMeesages(int n) {
        return this.mDB.getSentMessages(n);
    }

    public long getServerTime(int n) throws CacheException {
        return this.mDB.getServerTime(n);
    }

    private final void setUp(Settings settings) {
        this.determineTransactionOptimization();
        this.determineConcurrency();
        if (settings == null) {
            this.mSettings = new InstanceSettings(this);
            return;
        }
        this.mDB.setDefaultLockMode(settings.getDefaultLockMode());
        this.mSettings = new InstanceSettings(this, settings);
    }

    private void determineConcurrency() {
        String string = "com.jalapeno.om.concurrency";
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return;
        }
        this.mConcurrency = Integer.parseInt(string2);
    }

    private void determineTransactionOptimization() {
        String string = "com.jalapeno.transaction.optimization";
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return;
        }
        if ("ENABLE".equalsIgnoreCase(string2)) {
            this.mQueryServerTMode = false;
            this.mOptimizeTransactions = true;
        } else if ("DISABLE".equalsIgnoreCase(string2)) {
            this.mQueryServerTMode = false;
            this.mOptimizeTransactions = false;
        } else if ("ASSERT".equalsIgnoreCase(string2)) {
            this.mQueryServerTMode = true;
            this.mOptimizeTransactions = false;
        } else {
            throw new IllegalArgumentException("Invalid value for System Property " + string + ": " + string2);
        }
    }

    public String getTransactionOptimization() {
        String string = this.mOptimizeTransactions ? "OPTIMIZE" : "DISABLE OPTIMIZATION";
        string = this.mQueryServerTMode ? string + " | QUERY SERVER" : string + " | DO NOT QUERY SERVER";
        return string;
    }

    public static boolean accepts(Connection connection) {
        try {
            CacheConnection cacheConnection = JDBCAdapter.getCacheConnection(connection);
            return cacheConnection != null;
        }
        catch (CacheServerException cacheServerException) {
            return false;
        }
    }

    @Override
    public synchronized void startTransaction() throws CacheException {
        this.mInImplicitTransaction = false;
        if (this.isDbInTransaction()) {
            if (this.mDB.isLightConnection()) {
                return;
            }
            throw new CacheException("Already in transaction.");
        }
        this.mDB.transactionStart();
        if (this.mDB.isLightConnection()) {
            if (this.mFullDB != null && this.mFullDB.isOpen()) {
                this.mFullDB.transactionStart();
            } else if (this.mQueryServerTMode) {
                ((LightDatabase)this.mDB).runDummySP();
            }
        }
    }

    @Override
    public synchronized void commit() throws Exception {
        this.commit(true);
    }

    @Override
    public synchronized void commit(boolean bl) throws Exception {
        ++this.mTransactionCount;
        boolean bl2 = false;
        if (this.isDbInTransaction()) {
            if (!this.mInImplicitTransaction && bl) {
                this.flushWithoutRefresh();
                bl2 = true;
            }
            if (this.mDB.isLightConnection() && this.mOptimizeTransactions) {
                ((LightDatabase)this.mDB).transactionCommitAndRestart();
                this.mInImplicitTransaction = true;
            } else {
                this.mInImplicitTransaction = false;
                this.mDB.transactionCommit();
            }
            if (bl2) {
                this.refreshAfterFlush();
            }
        } else {
            this.mInImplicitTransaction = false;
            throw new CacheException("Not in transaction.");
        }
    }

    @Override
    public synchronized void rollback() throws Exception {
        ++this.mTransactionCount;
        this.mInImplicitTransaction = false;
        if (!this.isDbInTransaction()) {
            throw new CacheException("Not in transaction.");
        }
        this.mDB.transactionRollback();
        this.refreshAll(this.mAllowProxy);
    }

    @Override
    public boolean isInTransaction() throws CacheException {
        if (this.mInImplicitTransaction) {
            return false;
        }
        return this.isDbInTransaction();
    }

    private boolean isDbInTransaction() throws CacheException {
        return this.mDB.transactionLevel(this.mQueryServerTMode) > 0;
    }

    protected void startImplicitTransaction() throws CacheException {
        if (!this.mInImplicitTransaction && !this.isDbInTransaction()) {
            this.startTransaction();
            this.mInImplicitTransaction = true;
        }
    }

    protected boolean isInImplicitTransaction() {
        return this.mInImplicitTransaction;
    }

    public void setAdaptor(Adaptor adaptor) {
        this.manager().getObjectFactory().setAdaptor(adaptor);
    }

    public boolean removeAdaptor(Adaptor adaptor) {
        return this.manager().getObjectFactory().removeAdaptor(adaptor);
    }

    public void removeAllAdaptors() {
        this.manager().getObjectFactory().removeAllAdaptors();
    }

    public int getMaxBatchSize() {
        if (this.mDB != null && this.mDB.isLightConnection()) {
            return ((LightDatabase)this.mDB).getMaxBatchSize();
        }
        return 0;
    }

    public int getConcurrency() {
        return this.mConcurrency;
    }

    public void setConcurrency(int n) {
        this.mConcurrency = n;
    }

    public void setMaxBatchSize(int n) {
        if (this.mDB != null && this.mDB.isLightConnection()) {
            ((LightDatabase)this.mDB).setMaxBatchSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object openById(Class clazz, Object object) throws Exception {
        CacheRootObject cacheRootObject;
        DetachedObjectsManager detachedObjectsManager;
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        CacheClass cacheClass = this.findImplementation(clazz);
        Id id = PojoOperations.toId(object);
        DetachedObjectsManager detachedObjectsManager2 = detachedObjectsManager = this.manager();
        synchronized (detachedObjectsManager2) {
            cacheRootObject = (CacheRootObject)cacheClass.openObject(id);
        }
        if (ObjectHandle.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            return cacheRootObject;
        }
        detachedObjectsManager2 = detachedObjectsManager;
        synchronized (detachedObjectsManager2) {
            return cacheRootObject.detach(this.mAllowProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object openByPrimaryKey(Class clazz, Object object) throws Exception {
        CacheRootObject cacheRootObject;
        CandidateKey candidateKey;
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        CacheClass cacheClass = this.findImplementation(clazz);
        if (object instanceof CandidateKey) {
            candidateKey = (CandidateKey)object;
        } else if (object.getClass().isArray()) {
            candidateKey = cacheClass.createBestCandidateKey();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                candidateKey.set(i, Array.get(object, i).toString());
            }
        } else {
            candidateKey = CacheObjectManager.parseKeyString(cacheClass, object.toString());
        }
        DetachedObjectsManager detachedObjectsManager = this.manager();
        Object object2 = detachedObjectsManager;
        synchronized (object2) {
            cacheRootObject = (CacheRootObject)cacheClass.openByKey(candidateKey);
        }
        if (Logger.debugOn()) {
            object2 = new CandidateKey(candidateKey.getMetadata());
            ((CandidateKey)object2).setFromObject(cacheRootObject);
            if (!candidateKey.equals(object2)) {
                throw new SystemError("Open by Primary Key returned wrong object: " + candidateKey + ": " + object2);
            }
        }
        if (ObjectHandle.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            return cacheRootObject;
        }
        object2 = detachedObjectsManager;
        synchronized (object2) {
            return cacheRootObject.detach(this.mAllowProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator openByQuery(Class clazz, String string, Object[] objectArray) throws Exception {
        Iterator iterator;
        DetachedObjectsManager detachedObjectsManager;
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        CacheClass cacheClass = this.findImplementation(clazz);
        DetachedObjectsManager detachedObjectsManager2 = detachedObjectsManager = this.manager();
        synchronized (detachedObjectsManager2) {
            iterator = this.mDB.openByQuery(cacheClass.getName(), string, objectArray);
        }
        if (ObjectHandle.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            return iterator;
        }
        return new POJOIterator(iterator, this.mAllowProxy);
    }

    @Override
    public Iterator openByQuery(String string, Object[] objectArray) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        Iterator iterator = this.mDB.openByQuery(string, objectArray);
        return new POJOIterator(iterator, this.mAllowProxy);
    }

    public Iterator openByQuery(String string, Object[] objectArray, boolean bl) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        Iterator iterator = this.mDB.openByQuery(string, objectArray);
        if (!bl) {
            iterator = new POJOIterator(iterator, this.mAllowProxy);
        }
        return iterator;
    }

    protected void closeConnectionOnClose(Connection connection) {
        this.mConnectionToClose = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        DetachedObjectsManager detachedObjectsManager;
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is already closed.");
        }
        DetachedObjectsManager detachedObjectsManager2 = detachedObjectsManager = this.manager();
        synchronized (detachedObjectsManager2) {
            if (this.mFullDB != null && this.mFullDB != this.mDB) {
                this.mFullDB.close();
                this.mFullDB = null;
            }
            this.mDB.closeAllObjects();
            this.mDB.close();
            this.mDB = null;
            if (this.mConnectionToClose != null) {
                this.mConnectionToClose.close();
            }
        }
    }

    @Override
    public boolean isOpen() throws Exception {
        if (this.mDB == null) {
            return false;
        }
        return this.mDB.isOpen();
    }

    @Override
    public Utilities utilities() {
        if (this.mUtilities == null) {
            this.mUtilities = new CachePOJOUtilities(this);
        }
        return this.mUtilities;
    }

    public void removeFromDatabase(Class clazz, Serializable serializable) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        CacheClass cacheClass = this.findImplementation(clazz);
        Id id = PojoOperations.toId(serializable);
        cacheClass.deleteObject(id);
    }

    @Override
    public Object getPrimaryKey(Object object) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        if (object instanceof Persistent) {
            Persistent persistent = (Persistent)object;
            return persistent.getBestCandidateKey();
        }
        if (object instanceof ObjectHandle) {
            return null;
        }
        Persistent persistent = this.findProxy(object, true);
        if (persistent != null) {
            return persistent.getBestCandidateKey();
        }
        return this.manager().findPojoPrimaryKey(object, null);
    }

    @Override
    public Serializable save(Object object, boolean bl) throws Exception {
        long l = this.mTransactionCount;
        boolean bl2 = this.implicitCommitMightBeRequired();
        Serializable serializable = this.save(object, bl, 0, null);
        if (this.mInImplicitTransaction && this.mTransactionCount == l && bl2) {
            this.commit(false);
        }
        return serializable;
    }

    private boolean implicitCommitMightBeRequired() {
        return this.mInImplicitTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Serializable save(Object list, boolean bl, int n, Map map) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        DetachedObjectsManager detachedObjectsManager = this.manager();
        if (list instanceof Persistent) {
            Persistent persistent = (Persistent)((Object)list);
            persistent.save();
            return persistent.getId();
        }
        list = CacheObjectManager.getDBObject(list);
        CacheClass cacheClass = null;
        Class<Object> clazz = list.getClass();
        boolean bl2 = false;
        if (clazz.isArray()) {
            list = Arrays.asList((Object[])list);
            clazz = List.class;
            bl2 = true;
        } else {
            try {
                cacheClass = this.findImplementation(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Collection.class.isAssignableFrom(clazz) || Iterator.class.isAssignableFrom(clazz)) {
                    bl2 = true;
                }
                throw classNotFoundException;
            }
        }
        if (bl2) {
            if (bl && list instanceof Collection) {
                this.resolveObjectGraph(list, false);
            } else {
                this.saveCollection(list, bl, false, false, 0, null);
            }
            return null;
        }
        JalapenoHelperInterface jalapenoHelperInterface = this.manager().getObjectFactory().getHelper(cacheClass, this.getClassLoader());
        if (this.mDB.isLightConnection()) {
            if (ObjectFactory.isUnswizzledShadow(list)) {
                if (jalapenoHelperInterface.hasIdPlaceholder()) {
                    return jalapenoHelperInterface.getPojoId(list);
                }
            } else if (jalapenoHelperInterface.eligibleForQuickSave(list, this, bl, CacheObjectManager.saveReqPropsOnly(n))) {
                DetachedObjectsManager detachedObjectsManager2 = detachedObjectsManager;
                synchronized (detachedObjectsManager2) {
                    Database database = this.mDB;
                    synchronized (database) {
                        CacheObject cacheObject = null;
                        Serializable serializable = jalapenoHelperInterface.hasIdPlaceholder() ? jalapenoHelperInterface.getPojoId(list) : this.getId(list);
                        if (serializable != null && (cacheObject = ((LightDatabase)this.mDB).getProxyFromCache(cacheClass, serializable.toString())) != null && !cacheObject.isClosed()) {
                            cacheObject.setPojo(list);
                        }
                        return this.doQuickSave(list, cacheClass, cacheObject, n);
                    }
                }
            }
        }
        this.startImplicitTransaction();
        try {
            Serializable serializable;
            if (ObjectFactory.isUnswizzledShadow(list)) {
                Persistent persistent = this.attachInternal(list, bl, null, true, CacheObjectManager.saveReqPropsOnly(n));
                serializable = persistent.getId();
            } else if (bl && n == 0 && this.mDB.isLightConnection()) {
                Database database = this.mDB;
                synchronized (database) {
                    serializable = this.resolveObjectGraph(list);
                }
            } else {
                serializable = this.doClassicSave(list, bl, n, map);
            }
            if (this.mInImplicitTransaction) {
                this.commit();
            }
            return serializable;
        }
        catch (Exception exception) {
            if (this.mInImplicitTransaction) {
                try {
                    DetachedObjectsManager detachedObjectsManager3 = detachedObjectsManager;
                    synchronized (detachedObjectsManager3) {
                        this.rollback();
                    }
                }
                catch (Exception exception2) {
                    System.err.println("Transaction rollback failed.");
                    System.err.println("Rollback cause:");
                    exception.printStackTrace(System.err);
                    throw exception2;
                }
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable doClassicSave(Object object, boolean bl, int n, Map map) throws Exception {
        DetachedObjectsManager detachedObjectsManager;
        Persistent persistent = this.attachInternal(object, bl, null, true, CacheObjectManager.saveReqPropsOnly(n));
        Id id = persistent.getId();
        DetachedObjectsManager detachedObjectsManager2 = detachedObjectsManager = this.manager();
        synchronized (detachedObjectsManager2) {
            persistent.save(bl);
        }
        id = persistent.getId();
        if (CacheObjectManager.noRefresh(n)) {
            if (map != null) {
                map.put(object, persistent);
            }
        } else if (CacheObjectManager.limitedRefresh(n)) {
            this.doLimitedRefresh(persistent, object);
        } else if (this.refetchAfterSave()) {
            if (!ObjectFactory.isProxy(object)) {
                persistent.copyTo(object, this.newMap(), this.allowProxy());
            }
        } else {
            this.manager().purge(object, persistent);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCollection(Object object, boolean bl, boolean bl2, boolean bl3, int n, Map map) throws Exception {
        Database database = this.mDB;
        synchronized (database) {
            this.saveCollectionNoLock(object, bl, bl2, bl3, n, map, null);
            if (this.mDB.isLightConnection()) {
                ((LightDatabase)this.mDB).checkBulkInserter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCollectionNoLock(Object iterator, boolean bl, boolean bl2, boolean bl3, int n, Map hashMap, Set hashSet) throws Exception {
        Object object;
        int n2 = 0;
        boolean bl4 = true;
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
        } else {
            bl4 = false;
        }
        int n3 = 200;
        int n4 = this.getMaxBatchSize();
        if (iterator instanceof Collection) {
            object = (Collection)((Object)iterator);
            n3 = object.size();
            iterator = object.iterator();
        }
        object = iterator;
        if (!this.mDB.isLightConnection()) {
            while (object.hasNext()) {
                if (bl2) {
                    this.insert(object.next(), bl);
                    continue;
                }
                if (bl3) {
                    this.update(object.next(), bl);
                    continue;
                }
                this.save(object.next(), bl);
            }
            return;
        }
        CacheClassInfo cacheClassInfo = null;
        JalapenoHelperInterface jalapenoHelperInterface = null;
        ArrayList<Object> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        HashMap<Object, Object> hashMap2 = null;
        if (!bl3) {
            arrayList = new ArrayList<Object>(n3);
        }
        if (!bl2) {
            arrayList2 = new ArrayList<Object>(n3);
        }
        if (CacheObjectManager.limitedRefresh(n) || this.refetchAfterSave()) {
            if (hashMap == null) {
                hashMap = new HashMap<Object, Object>(n3);
            }
        } else {
            hashMap = null;
        }
        int n5 = 1;
        while (object.hasNext()) {
            Object object2;
            Object object3 = object.next();
            object3 = CacheObjectManager.getDBObject(object3);
            if (!bl2 && ObjectFactory.isUnswizzledShadow(object3)) continue;
            ++n5;
            CacheClass cacheClass = this.findImplementation(object3.getClass());
            if (cacheClassInfo == null) {
                cacheClassInfo = cacheClass;
                jalapenoHelperInterface = this.manager().getObjectFactory().getHelper(cacheClass, this.getClassLoader());
            } else if (!cacheClassInfo.equals(cacheClass)) {
                ++n2;
                this.flushCollection(cacheClassInfo.getName(), arrayList, arrayList2, hashMap2, CacheObjectManager.saveReqPropsOnly(n));
                cacheClassInfo = cacheClass;
                jalapenoHelperInterface = this.manager().getObjectFactory().getHelper(cacheClass, this.getClassLoader());
            } else if (n4 > 0 && n5 >= n4) {
                this.flushCollection(cacheClassInfo.getName(), arrayList, arrayList2, hashMap2, CacheObjectManager.saveReqPropsOnly(n));
                n5 = 0;
            }
            boolean bl5 = bl2;
            Serializable serializable = null;
            Object object4 = null;
            if (!bl5) {
                if (jalapenoHelperInterface.hasIdPlaceholder()) {
                    serializable = jalapenoHelperInterface.getPojoId(object3);
                    if (serializable == null) {
                        bl5 = true;
                    }
                } else if (cacheClass.getBestCandidateKey() != null && (serializable = this.manager().findIdInMemory(object3)) == null) {
                    object4 = jalapenoHelperInterface.getPrimaryKey(object3);
                    if (object4 == null) {
                        object4 = this.getPrimaryKey(object3);
                    }
                    serializable = (Serializable)((LightDatabase)this.mDB).existsByKey(null, (CandidateKey)object4, false);
                }
            }
            boolean bl6 = cacheClass.isChild();
            boolean bl7 = CacheObjectManager.saveReqPropsOnly(n);
            if (!bl6 && jalapenoHelperInterface.eligibleForQuickSave(object3, this, bl, bl7)) {
                object2 = null;
                if (bl5) {
                    if (this.refetchAfterSave() || bl7) {
                        object2 = QuickPersistentObject.createPojoBackedObject((TableBasedClass)cacheClass, object3, null);
                        arrayList.add(object2);
                        if (hashMap == null) continue;
                        hashMap.put(object3, object2);
                        continue;
                    }
                    arrayList.add(object3);
                    continue;
                }
                if (serializable != null) {
                    object2 = ((LightDatabase)this.mDB).getProxyFromCache(cacheClass, serializable.toString());
                    if (object2 != null) {
                        Object object5 = object2;
                        synchronized (object5) {
                            if (object2 != null && !object2.isClosed()) {
                                object2.setPojo(object3);
                                if (hashSet.add(object2)) {
                                    object2.increaseCount();
                                }
                            } else {
                                object2 = null;
                            }
                        }
                    }
                    if (object2 == null) {
                        object2 = QuickPersistentObject.createPojoBackedObject((TableBasedClass)cacheClass, object3);
                    }
                    arrayList2.add(object2);
                    if (hashMap == null) continue;
                    hashMap.put(object3, object2);
                    continue;
                }
                if (this.supportsPKSave() && CacheObjectManager.classHasPK(cacheClass)) {
                    object2 = QuickPersistentObject.createPojoBackedObject((TableBasedClass)cacheClass, object3);
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<Object, Object>();
                    }
                    if (object4 == null) {
                        throw new SystemError("Key can not be null");
                    }
                    hashMap2.put(object4, object2);
                    if (hashMap == null) continue;
                    hashMap.put(object3, object2);
                    continue;
                }
            }
            if (bl6) {
                if (CacheObjectManager.limitedRefresh(n) || CacheObjectManager.saveReqPropsOnly(n)) {
                    this.save(object3, bl, n, null);
                    continue;
                }
                this.save(object3, bl, 512, hashMap);
                continue;
            }
            if (bl) {
                int n6 = this.mSavePolicy;
                this.mSavePolicy = 16;
                try {
                    if (bl2) {
                        this.insert(object3, bl);
                        continue;
                    }
                    if (bl3) {
                        this.update(object3, bl);
                        continue;
                    }
                    this.save(object3, bl);
                    continue;
                }
                finally {
                    this.mSavePolicy = n6;
                    continue;
                }
            }
            object2 = this.attachInternal(object3, bl, null, !bl3, CacheObjectManager.saveReqPropsOnly(n));
            if (((Persistent)object2).getId() == null) {
                arrayList.add(object2);
            } else {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList(n3);
                }
                arrayList2.add(object2);
            }
            if (hashMap == null) continue;
            hashMap.put(object3, object2);
        }
        if (!(arrayList != null && !arrayList.isEmpty() || arrayList2 != null && !arrayList2.isEmpty() || hashMap2 != null && !hashMap2.isEmpty())) {
            return;
        }
        this.flushCollection(cacheClassInfo.getName(), arrayList, arrayList2, hashMap2, CacheObjectManager.saveReqPropsOnly(n));
        if (!CacheObjectManager.noRefresh(n)) {
            this.refreshSavedCollection(hashMap, n);
        }
        if (bl4) {
            CacheObjectManager.unlockObjects(hashSet);
        }
        if (Logger.debugOn()) {
            Logger.out.println("ObjectManager.saveCollection() alternated class: " + n2 + " times");
        }
    }

    private static void unlockObjects(Collection collection) throws CacheException {
        for (CacheObject cacheObject : collection) {
            cacheObject.decreaseCount();
        }
    }

    private static boolean classHasPK(CacheClass cacheClass) throws CacheException {
        CandidateKeyInfo candidateKeyInfo = cacheClass.getBestCandidateKey();
        if (candidateKeyInfo == null) {
            return false;
        }
        if (candidateKeyInfo.isIdKey()) {
            return false;
        }
        return candidateKeyInfo.isPrimaryKey();
    }

    private void flushCollection(String string, Collection collection, Collection collection2, Map map, boolean bl) throws Exception {
        if (collection2 != null && !collection2.isEmpty()) {
            ((LightDatabase)this.mDB).saveObjects(string, collection2, true);
        }
        if (collection != null && !collection.isEmpty()) {
            if (this.refetchAfterSave() || bl) {
                ((LightDatabase)this.mDB).createObjects(string, collection, bl);
            } else {
                CacheClass cacheClass = this.mDB.getCacheClass(string);
                this.insertSimpleFeed(cacheClass, collection.iterator());
            }
        }
        if (map != null && !map.isEmpty()) {
            ((QuickDatabase)this.mDB).saveObjectsByPK(string, map, bl);
        }
        if (collection != null) {
            collection.clear();
        }
        if (collection2 != null) {
            collection2.clear();
        }
        if (map != null) {
            map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSavedCollection(Map map, int n) throws Exception {
        Object object;
        Object k;
        if (map == null) {
            return;
        }
        ObjectCopierToPojo objectCopierToPojo = this.createCopier();
        int n2 = CacheObjectManager.oneLevelRefresh(n) ? -2 : -1;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            k = entry.getKey();
            if (ObjectFactory.isProxy(k)) {
                iterator.remove();
                continue;
            }
            object = entry.getValue();
            if (CacheObjectManager.limitedRefresh(n)) {
                this.doLimitedRefresh(object, k);
                continue;
            }
            if (object instanceof CacheObject) {
                Database database = this.mDB;
                synchronized (database) {
                    CacheObject cacheObject = (CacheObject)object;
                    Object object2 = ((LightDatabase)this.mDB).isInCache(cacheObject.getZRef());
                    if (object2 != null && object2 instanceof CacheObject) {
                        cacheObject = (CacheObject)object2;
                    }
                    object = cacheObject.newJavaInstance(true);
                }
            }
            this.manager().register((Persistent)object, k);
            entry.setValue(object);
        }
        if (CacheObjectManager.limitedRefresh(n)) {
            map.clear();
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            k = entry.getKey();
            object = (CacheRootObject)entry.getValue();
            objectCopierToPojo.copyTo((CacheRootObject)object, k, n2);
            objectCopierToPojo.reset();
        }
        map.clear();
    }

    private void doLimitedRefresh(Object object, Object object2) throws Exception {
        CacheObject cacheObject = object instanceof CacheObject ? (CacheObject)object : ((CacheRootObject)object).getProxy();
        this.manager().register(cacheObject, object2);
        JalapenoHelperInterface jalapenoHelperInterface = this.getHelper(object2);
        Object object3 = cacheObject.getId();
        if (object3 != null) {
            object3 = object3.toString();
        }
        jalapenoHelperInterface.setPojoId(object2, (Serializable)object3);
        String string = cacheObject.getCacheClass().getVersionPropertyName();
        if (string != null) {
            CacheField cacheField = cacheObject.getCacheClass().getField(string);
            Object object4 = cacheField.get(cacheObject);
            jalapenoHelperInterface.setVersionProperty(object2, object4);
        }
    }

    private ObjectCopierToPojo createCopier() {
        ClassLoader classLoader = ((SysDatabase)this.mDB).getClassLoader();
        return new ObjectCopierToPojo(this.manager(), this.allowProxy(), classLoader, this.newMap());
    }

    public void insertSimpleFeed(Class clazz, Iterator iterator) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        this.insertSimpleFeed(cacheClass, iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSimpleFeed(CacheClass cacheClass, Iterator iterator) throws Exception {
        if (this.mWire == null) {
            this.mWire = SysListProxy.createSysList();
        } else {
            SysListProxy.clearList(this.mWire);
        }
        Object object = this.mWire;
        synchronized (object) {
            this.insertSimpleFeedNoLock(cacheClass, iterator);
        }
    }

    private void insertSimpleFeedNoLock(CacheClass cacheClass, Iterator iterator) throws Exception {
        String string = cacheClass.getSchemaName();
        String string2 = cacheClass.getSQLTableName();
        JalapenoHelperInterface jalapenoHelperInterface = this.getHelper(cacheClass);
        if (this.mTmpSysList == null) {
            this.mTmpSysList = SysListProxy.createSysList();
        } else {
            SysListProxy.clearList(this.mTmpSysList);
        }
        int n = this.getMaxBatchSize();
        int n2 = 0;
        QuickBulkInsertWorker quickBulkInsertWorker = ((LightDatabase)this.mDB).getBulkInserter();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            jalapenoHelperInterface.stuff(this.mTmpSysList, e, this);
            if ((n <= 0 || ++n2 < n) && iterator.hasNext()) continue;
            SysListProxy.setInteger(this.mWire, n2);
            SysListProxy.concatenate(this.mWire, this.mTmpSysList);
            if (this.mConcurrency > 1) {
                quickBulkInsertWorker.doConcurrently(string, string2, this.mWire);
            } else {
                quickBulkInsertWorker.doIt(string, string2, this.mWire);
            }
            n2 = 0;
            SysListProxy.clearList(this.mWire);
            SysListProxy.clearList(this.mTmpSysList);
        }
    }

    @Override
    public Serializable insert(Object object, boolean bl) throws Exception {
        long l = this.mTransactionCount;
        boolean bl2 = this.implicitCommitMightBeRequired();
        Serializable serializable = this.insertInternal(object, bl);
        if (this.mInImplicitTransaction && this.mTransactionCount == l && bl2) {
            this.commit(false);
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable insertInternal(Object list, boolean bl) throws Exception {
        Object object;
        if (list instanceof Persistent) {
            throw new IllegalArgumentException("Object " + list + " already exists in the database.");
        }
        CacheClass cacheClass = null;
        list = CacheObjectManager.getDBObject(list);
        Class<Object> clazz = list.getClass();
        boolean bl2 = false;
        if (clazz.isArray()) {
            list = Arrays.asList((Object[])list);
            clazz = List.class;
            bl2 = true;
        } else {
            try {
                cacheClass = this.findImplementation(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Collection.class.isAssignableFrom(clazz) || Iterator.class.isAssignableFrom(clazz)) {
                    bl2 = true;
                }
                throw classNotFoundException;
            }
        }
        if (bl2) {
            if (bl && list instanceof Collection) {
                this.resolveObjectGraph(list, true);
            } else {
                this.saveCollection(list, bl, true, false, 0, null);
            }
            return null;
        }
        if (this.mDB.isLightConnection() && (object = this.manager().getObjectFactory().getHelper(cacheClass, this.getClassLoader())).eligibleForQuickSave(list, this, bl, false)) {
            Serializable serializable = object.getPojoId(list);
            boolean bl3 = object.setPojoId(list, null);
            QuickPersistentObject quickPersistentObject = null;
            if (!bl3) {
                quickPersistentObject = QuickPersistentObject.createPojoBackedObject((TableBasedClass)cacheClass, list);
                quickPersistentObject.setCachedIdToNull();
            }
            try {
                return this.doQuickSave(list, cacheClass, quickPersistentObject, 0);
            }
            catch (Exception exception) {
                object.setPojoId(list, serializable);
                throw exception;
            }
        }
        this.startImplicitTransaction();
        try {
            Database database = this.mDB;
            synchronized (database) {
                object = this.resolveObjectGraph(list);
            }
            if (this.mInImplicitTransaction) {
                this.commit();
            }
            return object;
        }
        catch (Exception exception) {
            if (this.mInImplicitTransaction) {
                try {
                    this.rollback();
                }
                catch (Exception exception2) {
                    System.err.println("Transaction rollback failed.");
                    System.err.println("Rollback cause:");
                    exception.printStackTrace(System.err);
                    throw exception2;
                }
            }
            throw exception;
        }
    }

    private synchronized Serializable resolveObjectGraph(Object object) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        this.resolveObjectGraph(arrayList, false);
        return this.getId(object);
    }

    private synchronized void resolveObjectGraph(Collection collection, boolean bl) throws Exception {
        DependencyResolver dependencyResolver = new DependencyResolver(this);
        dependencyResolver.resolve(collection);
        int n = dependencyResolver.getMaxReqOrder();
        int n2 = dependencyResolver.getMaxOrder();
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        if (n2 > 0) {
            int n3 = this.mSavePolicy;
            this.mSavePolicy = 16;
            for (int i = 0; i < n2; ++i) {
                Set set = dependencyResolver.getOrderedObjects(i);
                this.saveCollectionNoLock(set, false, bl, false, 512, hashMap, hashSet);
            }
            this.mSavePolicy = n3;
        }
        if (n2 >= 0) {
            Set set = dependencyResolver.getOrderedObjects(n2);
            this.saveCollectionNoLock(set, false, bl, false, 512, hashMap, hashSet);
        }
        DetachedObjectsManager detachedObjectsManager = this.manager();
        dependencyResolver.markAsDirty(detachedObjectsManager);
        if (n >= 0) {
            Set set;
            int n4;
            Set set2 = dependencyResolver.getUnresolvedObjects();
            for (n4 = 0; n4 <= n; ++n4) {
                set = dependencyResolver.getOrderedObjectsRequired(n4);
                this.saveCollectionNoLock(set, false, false, false, 257, null, hashSet);
            }
            dependencyResolver = new DependencyResolver(this);
            dependencyResolver.resolve(set2);
            n = dependencyResolver.getMaxReqOrder();
            if (n >= 0) {
                throw new SystemError("Resolving Dependencies Failed");
            }
            n2 = dependencyResolver.getMaxOrder();
            for (n4 = 0; n4 <= n2; ++n4) {
                set = dependencyResolver.getOrderedObjects(n4);
                this.saveCollectionNoLock(set, false, false, false, 512, hashMap, hashSet);
            }
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                detachedObjectsManager.setDirty(iterator.next());
            }
            dependencyResolver.markAsDirty(detachedObjectsManager);
        }
        if (this.refetchAfterSave()) {
            this.refreshSavedCollection(hashMap, 1024);
        }
        CacheObjectManager.unlockObjects(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable doQuickSave(Object object, CacheClass cacheClass, CacheObject cacheObject, int n) throws Exception {
        if (cacheObject == null) {
            cacheObject = QuickPersistentObject.createPojoBackedObject((TableBasedClass)cacheClass, object);
        }
        DetachedObjectsManager detachedObjectsManager = this.manager();
        Object object2 = detachedObjectsManager;
        synchronized (object2) {
            ((QuickPersistentObject)cacheObject).save(false, CacheObjectManager.saveReqPropsOnly(n));
        }
        if (CacheObjectManager.limitedRefresh(n)) {
            this.doLimitedRefresh(cacheObject, object);
        } else if (!CacheObjectManager.noRefresh(n) && this.refetchAfterSave()) {
            object2 = this.mDB;
            synchronized (object2) {
                Object object3 = ((LightDatabase)this.mDB).isInCache(cacheObject.getZRef());
                if (object3 != null && object3 instanceof CacheObject) {
                    cacheObject = (CacheObject)object3;
                }
                Persistent persistent = (Persistent)cacheObject.newJavaInstance(true);
                persistent.copyTo(object, this.newMap(), this.allowProxy());
                this.manager().register(persistent, object);
            }
        }
        return cacheObject.getId();
    }

    @Override
    public void update(Object object, boolean bl) throws Exception {
        long l = this.mTransactionCount;
        boolean bl2 = this.implicitCommitMightBeRequired();
        this.updateInternal(object, bl);
        if (this.mInImplicitTransaction && this.mTransactionCount == l && bl2) {
            this.commit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInternal(Object list, boolean bl) throws Exception {
        Object object;
        Object object2;
        if (list instanceof Persistent) {
            Persistent persistent = (Persistent)((Object)list);
            persistent.save();
            return;
        }
        list = CacheObjectManager.getDBObject(list);
        CacheClass cacheClass = null;
        Class<Object> clazz = list.getClass();
        boolean bl2 = false;
        if (clazz.isArray()) {
            list = Arrays.asList((Object[])list);
            clazz = List.class;
            bl2 = true;
        } else {
            try {
                cacheClass = this.findImplementation(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Collection.class.isAssignableFrom(clazz) || Iterator.class.isAssignableFrom(clazz)) {
                    bl2 = true;
                }
                throw classNotFoundException;
            }
        }
        if (bl2) {
            if (bl && list instanceof Collection) {
                this.resolveObjectGraph(list, false);
            } else {
                this.saveCollection(list, bl, false, true, 0, null);
            }
            return;
        }
        if (this.mDB.isLightConnection() && (object2 = (object = this.manager().getObjectFactory().getHelper(cacheClass, this.getClassLoader())).getPojoId(list)) != null && object.eligibleForQuickSave(list, this, bl, false)) {
            Database database = this.mDB;
            synchronized (database) {
                CacheObject cacheObject = null;
                cacheObject = ((LightDatabase)this.mDB).getProxyFromCache(cacheClass, object2.toString());
                if (cacheObject != null && !cacheObject.isClosed()) {
                    cacheObject.setPojo(list);
                }
                this.doQuickSave(list, cacheClass, cacheObject, 0);
                return;
            }
        }
        this.startImplicitTransaction();
        try {
            if (bl && this.mDB.isLightConnection() && this.getId(list) != null) {
                object = this.mDB;
                synchronized (object) {
                    this.resolveObjectGraph(list);
                }
            } else {
                object = this.attachInternal(list, bl, false);
                if (object == null) {
                    throw new IllegalArgumentException("Object " + list + " is not found in the database.");
                }
                if (!ObjectFactory.isUnswizzledShadow(list)) {
                    ((Persistent)object).save(bl);
                    if (this.refetchAfterSave()) {
                        if (!ObjectFactory.isProxy(list)) {
                            ((CacheRootObject)object).copyTo(list, this.newMap(), this.allowProxy());
                        }
                    } else {
                        this.manager().purge(list, (Persistent)object);
                    }
                }
            }
            if (this.mInImplicitTransaction) {
                this.commit();
            }
        }
        catch (Exception exception) {
            if (this.mInImplicitTransaction) {
                try {
                    object2 = this.mDB;
                    synchronized (object2) {
                        this.rollback();
                    }
                }
                catch (Exception exception2) {
                    System.err.println("Transaction rollback failed.");
                    System.err.println("Rollback cause:");
                    exception.printStackTrace(System.err);
                    throw exception2;
                }
            }
            throw exception;
        }
    }

    @Override
    public void attach(Object object) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        this.attach(object, true);
    }

    public Serializable attach(Object object, boolean bl) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        Persistent persistent = this.attachInternal(object, bl, true);
        return persistent.getId();
    }

    @Override
    public void refresh(Object object) throws Exception {
        this.refresh(object, false);
    }

    @Override
    public void refresh(Object object, boolean bl) throws Exception {
        Persistent persistent;
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        HashMap hashMap = null;
        if (bl) {
            hashMap = new HashMap();
            persistent = this.attachInternal(object, true, hashMap, true, false);
        } else {
            persistent = this.findProxy(object, false);
        }
        if (bl) {
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!(entry.getValue() instanceof Persistent)) continue;
                Persistent persistent2 = (Persistent)entry.getValue();
                persistent2._reload();
            }
        } else {
            persistent._reload();
        }
        persistent.copyTo(object, this.newMap(), this.mAllowProxy);
    }

    @Override
    public MapFactory getMapFactory() {
        if (this.mMapFactory == null) {
            this.mMapFactory = new CacheMapFactory(this);
        }
        return this.mMapFactory;
    }

    @Override
    public void swizzle(Object object) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        if (!ObjectFactory.isProxy(object)) {
            this.swizzleLists(object);
            return;
        }
        Persistent persistent = this.attachInternal(object, false, true);
        persistent.swizzleOneLevel(object);
    }

    @Override
    public Object detach(Object object) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        Persistent persistent = this.attachInternal(object, true, true);
        return persistent.detach(false);
    }

    @Override
    public synchronized void flush() throws Exception {
        this.startImplicitTransaction();
        try {
            this.flushWithoutRefresh();
            this.refreshAfterFlush();
            if (this.mInImplicitTransaction) {
                this.commit();
            }
        }
        catch (Exception exception) {
            if (this.mInImplicitTransaction) {
                this.rollback();
            }
            throw exception;
        }
    }

    private synchronized void refreshAfterFlush() throws Exception {
        if (this.refetchAfterSave()) {
            this.refreshAll(this.mAllowProxy);
        } else {
            this.purgeEverything();
        }
    }

    public synchronized void flushWithoutRefresh() throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        Collection collection = this.manager().currentCache();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.saveCollection(collection, false, false, false, 512, null);
    }

    @Override
    public void removeFromDatabase(Object object) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        Serializable serializable = this.getId(object);
        if (serializable == null) {
            throw new IllegalArgumentException("Object: " + object + " is not mapped to the database");
        }
        this.removeFromDatabase(object.getClass(), serializable);
        this.purgeFromMemory(object);
    }

    @Override
    public void removeFromDatabaseByPrimaryKey(Class clazz, Object object) throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        CacheClass cacheClass = this.findImplementation(clazz);
        CandidateKey candidateKey = object instanceof CandidateKey ? (CandidateKey)object : CacheObjectManager.parseKeyString(cacheClass, object.toString());
        cacheClass.deleteObjectByKey(candidateKey);
    }

    public CacheRootObject open(String string, Id id) throws CacheException {
        CacheClass cacheClass = this.mDB.getCacheClass(string);
        return (CacheRootObject)cacheClass.openObject(id);
    }

    public PopulateUtils populateUtils() throws Exception {
        if (this.mDB == null) {
            throw new IllegalStateException("Object Manager is Closed.");
        }
        if (this.mPopulateUtils == null) {
            this.mPopulateUtils = new PopulateUtils(this.getFullDatabase());
        }
        return this.mPopulateUtils;
    }

    @Override
    public Settings settings() {
        return this.mSettings;
    }

    protected boolean allowProxy() {
        return this.mAllowProxy;
    }

    protected boolean amIUseLightConnection() {
        return this.mDB.isLightConnection();
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.mDB.setClassLoader(classLoader);
        if (this.mFullDB != null && this.mFullDB != this.mDB) {
            this.mFullDB.setClassLoader(classLoader);
        }
    }

    protected int getClientCacheType() {
        return this.manager().getCacheType();
    }

    protected static Object getDBObject(Object object) {
        if (object instanceof ObjectBackedMap) {
            return ((ObjectBackedMap)object).getObject();
        }
        return object;
    }

    protected int setClientCacheType(int n) {
        int n2 = this.manager().getCacheType();
        this.manager().setCacheType(n);
        return n2;
    }

    protected int getFetchPolicy() {
        int n = this.mSavePolicy >= 0 ? this.mSavePolicy : 0;
        return this.manager().getFetchPolicy() | n;
    }

    public JalapenoHelperInterface getHelper(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        CacheClass cacheClass = this.findImplementation(object.getClass());
        return this.getHelper(cacheClass);
    }

    public final JalapenoHelperInterface getHelper(CacheClass cacheClass) throws Exception {
        return this.manager().getObjectFactory().getHelper(cacheClass, this.getClassLoader());
    }

    protected CacheField getInverseField(CacheField cacheField, Class clazz) throws CacheException {
        CacheClass cacheClass = null;
        try {
            cacheClass = this.findImplementation(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            cacheClass = this.mDB.getCacheClass(cacheField.getElementTypeName());
        }
        String string = cacheField.getInverseFieldName();
        return cacheClass.getField(string);
    }

    protected synchronized int setFetchPolicy(int n) {
        int n2 = this.getFetchPolicy();
        if ((n & 0xF) != 0) {
            this.manager().setFetchPolicy(n & 0xF);
        }
        if ((n & 0xF0) != 0) {
            this.mSavePolicy = n & 0xF0;
        }
        return n2;
    }

    protected synchronized int getAccessMethod() {
        ObjectFactory objectFactory = this.manager().getObjectFactory();
        if (!objectFactory.mGenerateHelpers) {
            return 1024;
        }
        if (objectFactory.mRequireASM) {
            return 256;
        }
        return 512;
    }

    protected synchronized int setAccessMethod(int n) {
        int n2 = this.getAccessMethod();
        ObjectFactory objectFactory = this.manager().getObjectFactory();
        switch (n) {
            case 512: {
                objectFactory.mGenerateHelpers = true;
                objectFactory.mRequireASM = false;
                break;
            }
            case 1024: {
                objectFactory.mGenerateHelpers = false;
                objectFactory.mRequireASM = false;
                break;
            }
            case 256: {
                objectFactory.mGenerateHelpers = true;
                objectFactory.mRequireASM = true;
            }
        }
        return n2;
    }

    public void setObjectManagerFactory(ObjectManagerFactory objectManagerFactory) {
        this.manager().setObjectManagerFactory(objectManagerFactory);
        this.mDataSource = ((ApplicationContext)objectManagerFactory).getDataSource();
    }

    private Map newMap() {
        if (ENABLE_CACHE_ASSERTIONS) {
            return new IsoMorphicMap();
        }
        return new HashMap();
    }

    private boolean refetchAfterSave() {
        return this.mSavePolicy == 16 || this.mSavePolicy < 0;
    }

    private void swizzleLists(Object object) throws Exception {
        CacheClass cacheClass = this.findImplementation(object.getClass());
        CacheField[] cacheFieldArray = cacheClass.getFields();
        JalapenoHelperInterface jalapenoHelperInterface = this.manager().getObjectFactory().getHelper(cacheClass, this.getClassLoader());
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            Object object2;
            CacheField cacheField = cacheFieldArray[i];
            if (!cacheField.isCollection() || !((object2 = jalapenoHelperInterface.get(object, cacheField.getII())) instanceof LazyList)) continue;
            ((LazyList)object2).fetchAll();
        }
    }

    public String getJPAQueryTable() throws CacheException {
        return JPAQuery.TABLE_NAME((SysDatabase)this.mDB);
    }

    private boolean supportsPKSave() {
        return this.mDB instanceof QuickDatabase;
    }

    public boolean isNativeConnection() {
        return !(this.mDB instanceof ThirdPartyDatabase);
    }

    public String getBaseTable(String string) throws CacheException {
        if (this.isNativeConnection()) {
            return null;
        }
        try {
            return ((ThirdPartyDatabase)this.mDB).getBaseTable(string);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Can not detrmine table name for view: " + string);
        }
    }

    private class IsoMorphicMap
    extends HashMap {
        private IsoMorphicMap() {
        }

        @Override
        public Object put(Object object, Object object2) {
            Object object3;
            if (this.values().contains(object2)) {
                throw new IllegalArgumentException("Object " + object2 + " is already mapped.");
            }
            try {
                object3 = CacheObjectManager.this.manager().findPOJO((CacheRootObject)object, true);
                if (object3 != null && !object3.equals(object2)) {
                    throw new IllegalArgumentException("Object " + object + " is already mapped in engine.");
                }
                Persistent persistent = CacheObjectManager.this.manager().findProxy(object2, true);
                if (persistent != null && !((Object)persistent).equals(object)) {
                    throw new IllegalArgumentException("Object " + object2 + " is already mapped in engine.");
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new IllegalStateException("Failed to locally map Proxy to Pojo: " + exception);
            }
            object3 = super.put(object, object2);
            if (object3 != null) {
                throw new IllegalArgumentException("Object " + object + " is already mapped.");
            }
            return object3;
        }
    }
}

