/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.idecommon.util;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class PersistentUnitUtils {
    public static final String PU = "persistence-unit";

    public static boolean acceptsProvider(String string, String string2) throws Exception {
        Enumeration<URL> enumeration = PersistentUnitUtils.findAllDescriptors();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            if (PersistentUnitUtils.checkURL(uRL, string, string2)) continue;
            return false;
        }
        return true;
    }

    public static Enumeration<URL> findAllDescriptors() throws Exception {
        Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
        return enumeration;
    }

    public static String findDeclaredProvider(String string) throws Exception {
        Enumeration<URL> enumeration = PersistentUnitUtils.findAllDescriptors();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            Document document = PersistentUnitUtils.getPersistenUnitDescriptor(uRL);
            Node node = PersistentUnitUtils.findUnit(document, string);
            if (node == null) continue;
            Node node2 = PersistentUnitUtils.find(node, "provider");
            if (node2 == null) {
                return null;
            }
            String string2 = node2.getTextContent();
            return string2;
        }
        throw new IllegalArgumentException("Declaration of Persistent Unit named " + string + " was not found in the classpath");
    }

    public static Set<String> findAllUnits() throws Exception {
        Enumeration<URL> enumeration = PersistentUnitUtils.findAllDescriptors();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            PersistentUnitUtils.findAllUnits(uRL, treeSet);
        }
        return treeSet;
    }

    public static Set<String> findAllProviders() throws Exception {
        Enumeration<URL> enumeration = PersistentUnitUtils.findAllDescriptors();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            PersistentUnitUtils.findAllProviders(uRL, treeSet);
        }
        return treeSet;
    }

    public static Document getPersistenUnitDescriptor(URL uRL) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        InputStream inputStream = uRLConnection.getInputStream();
        DocumentBuilderFactory documentBuilderFactory = null;
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(false);
        InputSource inputSource = new InputSource(inputStream);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    private static boolean checkURL(URL uRL, String string, String string2) throws Exception {
        Document document = PersistentUnitUtils.getPersistenUnitDescriptor(uRL);
        Node node = PersistentUnitUtils.findUnit(document, string);
        if (node == null) {
            return true;
        }
        Node node2 = PersistentUnitUtils.find(node, "provider");
        if (node2 == null) {
            return true;
        }
        String string3 = node2.getTextContent();
        return string2.equals(string3);
    }

    private static void findAllUnits(URL uRL, Set<String> set) throws Exception {
        Document document = PersistentUnitUtils.getPersistenUnitDescriptor(uRL);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        PersistentUnitUtils.findAll(arrayList, document, PU);
        for (Node node : arrayList) {
            String string = PersistentUnitUtils.getUnitName(node);
            if (string == null) continue;
            set.add(string);
        }
    }

    private static void findAllProviders(URL uRL, Set<String> set) throws Exception {
        Document document = PersistentUnitUtils.getPersistenUnitDescriptor(uRL);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        PersistentUnitUtils.findAll(arrayList, document, PU);
        for (Node node : arrayList) {
            String string;
            Node node2 = PersistentUnitUtils.find(node, "provider");
            if (node2 == null || (string = node2.getTextContent()) == null) continue;
            set.add(string);
        }
    }

    private static final Node findUnit(Node node, String string) {
        Node node2 = node;
        if (PU.equals(node2.getNodeName()) && string.equals(PersistentUnitUtils.getUnitName(node2))) {
            return node2;
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = PersistentUnitUtils.findUnit(node2, string);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    private static String getUnitName(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            return null;
        }
        return node2.getTextContent();
    }

    private static final Node find(Node node, String string) {
        Node node2 = node;
        if (string.equals(node2.getNodeName())) {
            return node2;
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = PersistentUnitUtils.find(node2, string);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    private static final void findAll(List<Node> list, Node node, String string) {
        Node node2 = node;
        if (string.equals(node2.getNodeName())) {
            list.add(node2);
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            PersistentUnitUtils.findAll(list, node2, string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Set<String> set = PersistentUnitUtils.findAllUnits();
        System.out.println("All Persistent Units: ");
        for (String iterator2 : set) {
            System.out.println("\t" + iterator2);
        }
        Set<String> set2 = PersistentUnitUtils.findAllProviders();
        System.out.println("All Persistent Providers: ");
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println("\t" + string);
        }
        System.out.println("Persistent Providers by Units: ");
        for (String string : set) {
            String string2 = PersistentUnitUtils.findDeclaredProvider(string);
            System.out.println("\t" + string + ": " + string2);
        }
    }
}

