/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.xep.test;

import com.intersys.xep.Event;
import com.intersys.xep.EventQuery;
import com.intersys.xep.EventQueryIterator;
import com.intersys.xep.samples.BenchmarkSample;
import com.intersys.xep.test.Core;
import java.util.Random;

public class Benchmark
extends Core {
    private static BenchmarkSample[] data;

    Benchmark(String string, int n) throws Exception {
        super(string);
        objectCount = n * 100000;
        data = Benchmark.generateSampleData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Benchmark.checkParameters(stringArray, "(2) total number of objects (in 100,000s)\r\n  (3) run store only (s) or load only (l) [optional, defaults to running both]\r\n");
        Benchmark benchmark = new Benchmark(stringArray[0], Integer.parseInt(stringArray[1]));
        try {
            benchmark.importSchema(null);
            if (stringArray.length > 2 && stringArray[2].equalsIgnoreCase("s")) {
                benchmark.store();
            } else if (stringArray.length > 2 && stringArray[2].equalsIgnoreCase("l")) {
                benchmark.load();
            } else {
                benchmark.store();
                benchmark.load();
            }
        }
        finally {
            benchmark.close();
        }
    }

    private void store() throws Exception {
        this.deleteExtent();
        Event event = this.persister.getEvent(className);
        this.persister.startTransaction();
        System.out.println("\nStoring data...");
        long l = Benchmark.getTime();
        for (int i = 0; i < objectCount; ++i) {
            event.store(data[i % 100000]);
            if (i == 0 || i % 100000 != 0) continue;
            System.out.println("Stored " + i + " objects");
        }
        event.close();
        Benchmark.report(false, objectCount, l);
        this.persister.commit();
    }

    private void load() throws Exception {
        System.out.println("\nLoading data...");
        Event event = this.persister.getEvent(className);
        long l = 0L;
        BenchmarkSample benchmarkSample = new BenchmarkSample();
        EventQuery eventQuery = event.createQuery(sqlquery);
        eventQuery.setParameter(1, 0);
        eventQuery.setParameter(2, objectCount);
        long l2 = Benchmark.getTime();
        eventQuery.execute();
        EventQueryIterator eventQueryIterator = eventQuery.getIterator();
        while (eventQueryIterator.hasNext()) {
            benchmarkSample = (BenchmarkSample)eventQueryIterator.next();
            if (Benchmark.data[benchmarkSample.intOne].longTwo != benchmarkSample.longTwo || Benchmark.data[benchmarkSample.intOne].doubleArrayOne[3].doubleValue() != benchmarkSample.doubleArrayOne[3].doubleValue()) {
                throw new Exception("Data does not match");
            }
            ++l;
        }
        eventQuery.close();
        event.close();
        Benchmark.report(true, l, l2);
    }

    private static BenchmarkSample[] generateSampleData() {
        Random random = new Random(5283314247687391911L);
        BenchmarkSample[] benchmarkSampleArray = new BenchmarkSample[100000];
        for (int i = 0; i < 100000; ++i) {
            int n;
            benchmarkSampleArray[i] = new BenchmarkSample();
            benchmarkSampleArray[i].shortOne = (short)random.nextInt();
            benchmarkSampleArray[i].intOne = i;
            benchmarkSampleArray[i].longOne = 12345678L;
            benchmarkSampleArray[i].longTwo = random.nextLong();
            benchmarkSampleArray[i].longThree = random.nextLong();
            benchmarkSampleArray[i].longFour = i;
            benchmarkSampleArray[i].longFive = random.nextInt();
            benchmarkSampleArray[i].floatOne = random.nextFloat();
            benchmarkSampleArray[i].floatTwo = random.nextFloat();
            benchmarkSampleArray[i].floatThree = random.nextFloat();
            benchmarkSampleArray[i].floatFour = random.nextFloat();
            benchmarkSampleArray[i].doubleOne = random.nextDouble();
            benchmarkSampleArray[i].doubleTwo = random.nextDouble();
            benchmarkSampleArray[i].doubleThree = random.nextDouble();
            benchmarkSampleArray[i].doubleArrayOne = new Double[10];
            for (n = 0; n < 10; ++n) {
                benchmarkSampleArray[i].doubleArrayOne[n] = random.nextDouble();
            }
            benchmarkSampleArray[i].doubleArrayTwo = new double[10];
            for (n = 0; n < 10; ++n) {
                benchmarkSampleArray[i].doubleArrayTwo[n] = random.nextDouble();
            }
        }
        return benchmarkSampleArray;
    }

    static {
        className = "com.intersys.xep.samples.BenchmarkSample";
        sqlquery = "SELECT * FROM com_intersys_xep_samples.BenchmarkSample WHERE intOne BETWEEN ? AND ?";
    }
}

