/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.xep;

import com.intersys.mds.MDSException;
import com.intersys.mds.internal.MDSQuery;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EventQueryIterator<E>
implements Iterator {
    private final MDSQuery mdsQuery;
    private E nextElement;
    private boolean hasNextCalled;

    public EventQueryIterator(MDSQuery mDSQuery) {
        this.mdsQuery = mDSQuery;
        this.nextElement = null;
        this.hasNextCalled = false;
    }

    @Override
    public boolean hasNext() {
        try {
            this.nextElement = this.mdsQuery.next(null);
            this.hasNextCalled = true;
        }
        catch (MDSException mDSException) {
            throw new RuntimeException(mDSException);
        }
        return this.nextElement != null;
    }

    @Override
    public E next() {
        if (this.hasNextCalled) {
            this.hasNextCalled = false;
        } else {
            try {
                this.nextElement = this.mdsQuery.next(null);
            }
            catch (MDSException mDSException) {
                throw new RuntimeException(mDSException);
            }
        }
        if (this.nextElement == null) {
            throw new NoSuchElementException();
        }
        return this.nextElement;
    }

    @Override
    public void remove() {
        if (this.nextElement == null) {
            throw new IllegalStateException();
        }
        try {
            this.mdsQuery.deleteCurrent();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized void set(E e) {
        if (this.nextElement == null) {
            throw new IllegalStateException();
        }
        try {
            this.mdsQuery.updateCurrent(e);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

