/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.CacheStaticResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

public final class CacheUpdatableResultSet
extends CacheStaticResultSet {
    private PreparedStatement update;
    private Statement delete = null;
    private String statementText;
    private String[] columns;
    private HashMap values;
    private boolean onInsertRow = false;
    private int moveToCurrentRow;

    CacheUpdatableResultSet(CacheStatement cacheStatement) throws SQLException {
        super(cacheStatement);
        this.init();
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (String)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getString(n);
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Boolean)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBoolean(n);
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Byte)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getByte(n);
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Short)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getShort(n);
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Integer)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getInt(n);
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Long)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getLong(n);
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Double)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getDouble(n);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (BigDecimal)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBigDecimal(n);
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (byte[])this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBytes(n);
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Date)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getDate(n);
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Time)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getTime(n);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Timestamp)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getTimestamp(n);
    }

    @Override
    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (InputStream)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getAsciiStream(n);
    }

    @Override
    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (InputStream)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBinaryStream(n);
    }

    @Override
    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Date)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getDate(n, calendar);
    }

    @Override
    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Time)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getTime(n, calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Timestamp)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getTimestamp(n, calendar);
    }

    @Override
    public synchronized Blob getBlob(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Blob)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBlob(n);
    }

    @Override
    public synchronized Clob getClob(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Clob)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getClob(n);
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getObject(n);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.check(n);
        this.updateNull(this.columns[n]);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.check(n);
        this.updateBoolean(this.columns[n], bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.check(n);
        this.updateByte(this.columns[n], by);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.check(n);
        this.updateShort(this.columns[n], s);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.check(n);
        this.updateInt(this.columns[n], n2);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.check(n);
        this.updateLong(this.columns[n], l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.check(n);
        this.updateFloat(this.columns[n], f);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.check(n);
        this.updateDouble(this.columns[n], d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.check(n);
        this.updateBigDecimal(this.columns[n], bigDecimal);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.check(n);
        this.updateString(this.columns[n], string);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.check(n);
        this.updateBytes(this.columns[n], byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.check(n);
        this.updateDate(this.columns[n], date);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.check(n);
        this.updateTime(this.columns[n], time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.check(n);
        this.updateTimestamp(this.columns[n], timestamp);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check(n);
        this.updateAsciiStream(this.columns[n], inputStream, n2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check(n);
        this.updateBinaryStream(this.columns[n], inputStream, n2);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.check(n);
        this.updateCharacterStream(this.columns[n], reader, n2);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.check(n);
        this.updateObject(this.columns[n], object, n2);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.check(n);
        this.updateObject(this.columns[n], object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.check(string);
        this.values.put(string, null);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.check(string);
        this.values.put(string, bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.check(string);
        this.values.put(string, new Byte(by));
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.check(string);
        this.values.put(string, new Short(s));
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new Integer(n));
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.check(string);
        this.values.put(string, new Long(l));
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.check(string);
        this.values.put(string, new Float(f));
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.check(string);
        this.values.put(string, new Double(d));
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.check(string);
        this.values.put(string, bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.check(string);
        this.values.put(string, string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.check(string);
        this.values.put(string, byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.check(string);
        this.values.put(string, date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.check(string);
        this.values.put(string, time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.check(string);
        this.values.put(string, timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new ObjectWrapper(0, inputStream, n));
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new ObjectWrapper(1, inputStream, n));
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new ObjectWrapper(2, reader, n));
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new ObjectWrapper(3, object, n));
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.check(string);
        this.values.put(string, object);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.check(n);
        this.updateBlob(this.columns[n], blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.check(string);
        this.values.put(string, blob);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.check(n);
        this.updateClob(this.columns[n], clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.check(string);
        this.values.put(string, clob);
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        int n;
        if (!this.onInsertRow) {
            throw new SQLException("The cursor is currently not positioned on the insert row");
        }
        this.statementText = "INSERT INTO " + this.statement.updatableRSTableName + " (";
        for (n = 1; n < this.columns.length - 1; ++n) {
            this.statementText = this.statementText + this.columns[n] + ", ";
        }
        this.statementText = this.statementText + this.columns[this.columns.length - 1] + ") VALUES (";
        for (n = 1; n < this.columns.length - 1; ++n) {
            this.statementText = this.statementText + "?,";
        }
        this.statementText = this.statementText + "?)";
        this.update = this.statement.connection.prepareStatement(this.statementText);
        for (n = 1; n < this.columns.length; ++n) {
            if (this.values.containsKey(this.columns[n])) {
                Object v = this.values.get(this.columns[n]);
                if (v instanceof ObjectWrapper) {
                    this.setObjectWrapper(this.update, n, (ObjectWrapper)v);
                    continue;
                }
                this.update.setObject(n, v);
                continue;
            }
            if (this.statement.getColumnNullable(n) != 0) {
                this.update.setNull(n, this.statement.getColumnType(n));
                continue;
            }
            throw new SQLException("Not all non-nullable columns in the insert row have value");
        }
        this.update.executeUpdate();
        this.onInsertRow = false;
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        Object k2;
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        if (this.values.size() == 0) {
            throw new SQLException("No values to update specified");
        }
        this.statementText = "UPDATE " + this.statement.updatableRSTableName + " SET ";
        Iterator iterator = this.values.keySet().iterator();
        if (iterator.hasNext()) {
            k2 = iterator.next();
            this.statementText = this.statementText + (String)k2 + " = ?";
        }
        while (iterator.hasNext()) {
            k2 = iterator.next();
            this.statementText = this.statementText + ", " + (String)k2 + " = ?";
        }
        this.statementText = this.statementText + " WHERE " + this.columns[0] + " = ?";
        this.update = this.statement.connection.prepareStatement(this.statementText);
        int n = 1;
        for (Object k2 : this.values.keySet()) {
            Object v = this.values.get(k2);
            if (v instanceof ObjectWrapper) {
                this.setObjectWrapper(this.update, n, (ObjectWrapper)v);
            } else {
                this.update.setObject(n, v);
            }
            ++n;
        }
        this.update.setInt(n, this.rowID);
        this.update.executeUpdate();
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        if (this.onInsertRow || this.isAfterLast) {
            throw new SQLException("Invalid cursor position");
        }
        if (this.delete == null) {
            this.delete = this.statement.connection.createStatement();
        }
        this.delete.executeUpdate("DELETE FROM " + this.statement.updatableRSTableName + " WHERE " + this.columns[0] + " = " + this.rowID);
        this.currentRow = 0;
        this.closed = false;
        this.isAfterLast = false;
        this.currentColumn = this.statement.columns.size() + 1;
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.onInsertRow = true;
        this.moveToCurrentRow = this.isAfterLast ? 0 : this.currentRow;
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        if (this.onInsertRow) {
            this.currentRow = this.moveToCurrentRow;
        }
        this.onInsertRow = false;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        if (this.statement.resultSetType == 1003) {
            if (this.statement.getMaxRows() != 0 && this.currentRow == this.statement.getMaxRows()) {
                return false;
            }
            this.currentColumn = this.statement.input.wire.advance(this.currentColumn, this.statement.columns.size() + 1);
            if (this.currentColumn != this.statement.columns.size() + 1 || this.statement.input.wire.isEnd()) {
                if (this.statement.fetchDone) {
                    this.isAfterLast = true;
                    return false;
                }
                this.fetchMoreData();
                this.currentColumn = this.statement.input.wire.advance(this.currentColumn, this.statement.columns.size() + 1);
            }
            this.statement.input.wire.saveCurrentRowPosition();
            this.currentColumn = 1;
            ++this.currentRow;
            this.rowID = this.getRowID();
            return true;
        }
        boolean bl = super.next();
        if (bl) {
            this.rowID = this.getRowID();
        }
        return bl;
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        return super.isBeforeFirst();
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        return super.isAfterLast();
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        return super.isFirst();
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        return super.isLast();
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        super.beforeFirst();
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        super.afterLast();
    }

    @Override
    public synchronized boolean first() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.first();
    }

    @Override
    public synchronized boolean last() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.last();
    }

    @Override
    public synchronized boolean absolute(int n) throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.absolute(n);
    }

    @Override
    public synchronized boolean relative(int n) throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.relative(n);
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.previous();
    }

    @Override
    public synchronized int getType() throws SQLException {
        return this.statement.resultSetType;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    private synchronized void init() throws SQLException {
        int n = this.statement.columns.size();
        if (n <= 0) {
            throw new SQLException("Invalid result set");
        }
        if (this.statement.updatableRSTableName == null) {
            this.statement.updatableRSTableName = this.statement.getColumnTableName(1);
            String string = this.statement.getColumnSchemaName(1);
            this.statement.updatableRSColumnNames = new String[n];
            this.statement.updatableRSColumnNames[0] = this.statement.getColumnName(1);
            this.statement.columns.remove(0);
            for (int i = 1; i < n; ++i) {
                if (!this.statement.updatableRSTableName.equals(this.statement.getColumnTableName(i))) {
                    throw new SQLException("Positioned updates are only supported whenthe query references a single table");
                }
                this.statement.updatableRSColumnNames[i] = this.statement.getColumnName(i);
            }
            this.statement.updatableRSTableName = string + "." + this.statement.updatableRSTableName;
        }
        this.values = new HashMap();
        this.currentColumn = this.statement.columns.size() + 1;
        this.columns = this.statement.updatableRSColumnNames;
    }

    @Override
    synchronized boolean staticFetch(int n, int n2) throws SQLException {
        boolean bl = super.staticFetch(n, n2);
        if (bl) {
            this.rowID = this.getRowID();
        }
        return bl;
    }

    private void setObjectWrapper(PreparedStatement preparedStatement, int n, ObjectWrapper objectWrapper) throws SQLException {
        if (objectWrapper.type == 0) {
            preparedStatement.setAsciiStream(n, (InputStream)objectWrapper.obj, objectWrapper.lengthOrScale);
        } else if (objectWrapper.type == 1) {
            preparedStatement.setBinaryStream(n, (InputStream)objectWrapper.obj, objectWrapper.lengthOrScale);
        } else if (objectWrapper.type == 2) {
            preparedStatement.setCharacterStream(n, (Reader)objectWrapper.obj, objectWrapper.lengthOrScale);
        } else {
            int n2 = this.statement.getColumnType(n);
            if (n2 == 3 || n2 == 2) {
                preparedStatement.setObject(n, objectWrapper.obj, n2, objectWrapper.lengthOrScale);
            } else {
                preparedStatement.setObject(n, objectWrapper.obj);
            }
        }
    }

    private void check(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        if (n <= 0 || n >= this.columns.length) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
    }

    private void check(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        for (int i = 1; i <= this.columns.length + 1; ++i) {
            if (!this.columns[i].equalsIgnoreCase(string)) continue;
            return;
        }
        throw new SQLException("Invalid column name: " + string, "S1002", 463);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            l = CacheUpdatableResultSet.getInputStreamLength(inputStream, l);
        }
        this.updateAsciiStream(n, inputStream, (int)l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            l = CacheUpdatableResultSet.getInputStreamLength(inputStream, l);
        }
        this.updateBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + l);
        }
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            l = CacheUpdatableResultSet.getInputStreamLength(inputStream, l);
        }
        this.updateAsciiStream(string, inputStream, (int)l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            l = CacheUpdatableResultSet.getInputStreamLength(inputStream, l);
        }
        this.updateBinaryStream(string, inputStream, (int)l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + l);
        }
        this.updateCharacterStream(string, reader, (int)l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(string, inputStream, l);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream, -1);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, -1);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(string, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(string, inputStream, -1);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(string, reader, -1);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(string, inputStream);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(string, reader);
    }

    private static int getInputStreamLength(InputStream inputStream, long l) throws SQLException {
        int n = 0;
        try {
            n = inputStream.available();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0 || n > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + l);
        }
        return n;
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (!this.statement.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (!this.statement.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        if (!this.statement.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        if (!this.statement.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.updateCharacterStream(string, reader);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        if (!this.statement.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.updateString(n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        if (!this.statement.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server");
        }
        this.updateString(string, string2);
    }

    private static class ObjectWrapper {
        static final int ASCII_STREAM = 0;
        static final int BINARY_STREAM = 1;
        static final int CHARACTER_STREAM = 2;
        static final int OBJECT_WITH_SCALE = 3;
        int type;
        Object obj;
        int lengthOrScale;

        ObjectWrapper(int n, Object object, int n2) {
            this.obj = object;
            this.type = n;
            this.lengthOrScale = n2;
        }
    }
}

