/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.gateway;

import com.intersys.gateway.GatewayException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ImportClassLoader
extends URLClassLoader {
    private Map _classes = new HashMap();

    private ImportClassLoader(URL[] uRLArray) {
        super(uRLArray, ClassLoader.getSystemClassLoader());
    }

    public static ImportClassLoader newInstance(String string) throws MalformedURLException {
        URL[] uRLArray = new URL[]{new File(string).toURL()};
        return new ImportClassLoader(uRLArray);
    }

    private String[] getClassNamesFromDir(String string) {
        ArrayList arrayList = new ArrayList();
        this.buildDirectoryTree(string, new File(string), arrayList);
        return arrayList.toArray(new String[0]);
    }

    private void buildDirectoryTree(String string, File file, List list) {
        int n = 0;
        Class<?> clazz = null;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            String string3;
            String string4;
            if (fileArray[i].isDirectory()) {
                this.buildDirectoryTree(string, fileArray[i], list);
            }
            if ((string4 = ImportClassLoader.toURLString(fileArray[i].getPath())) == null || string4.indexOf("_Tie") != -1 || string4.indexOf("_Stub") != -1 || (string3 = ImportClassLoader.changeFileNameToClassName(string2 = string4.split(string)[1])) == null) continue;
            try {
                clazz = this.loadClass(string3, false);
                n = clazz.getModifiers();
                if (!Modifier.isPublic(n) || string3.indexOf("$") != -1 && !Modifier.isStatic(n)) continue;
                list.add(string3);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String[] getClassNamesFromJar(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        ZipFile zipFile = null;
        if (!file.isDirectory() && file.exists() && file.canRead()) {
            try {
                zipFile = new ZipFile(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (zipFile != null) {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string3 = zipEntry.getName();
                    if (string3 == null || string3.indexOf("_Tie.class") != -1 || string3.indexOf("_Stub.class") != -1 || (string2 = ImportClassLoader.changeFileNameToClassName(string3)) == null) continue;
                    try {
                        Class<?> clazz = this.loadClass(string2, false);
                        int n = clazz.getModifiers();
                        if (!Modifier.isPublic(n) || string2.indexOf("$") != -1 && !Modifier.isStatic(n)) continue;
                        arrayList.add(string2);
                    }
                    catch (Throwable throwable) {}
                }
            }
            return arrayList.toArray(new String[0]);
        }
        throw new GatewayException("Jar file not found: " + string);
    }

    public String[] getAllClassNames() throws Exception {
        URL[] uRLArray = this.getURLs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < uRLArray.length; ++i) {
            String[] stringArray = null;
            String string = uRLArray[i].getPath();
            stringArray = string.endsWith(".jar") ? this.getClassNamesFromJar(string) : this.getClassNamesFromDir(string);
            if (stringArray == null || stringArray.length <= 0) continue;
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList.toArray(new String[0]);
    }

    protected synchronized Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this._classes.get(string);
        if (clazz == null) {
            clazz = super.findClass(string);
            this._classes.put(string, clazz);
        }
        return clazz;
    }

    private static String toURLString(String string) {
        try {
            return new File(string).toURL().toExternalForm();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String changeFileNameToClassName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("File Name == null");
        }
        String string2 = null;
        if (string.toLowerCase().endsWith(".class")) {
            string2 = string.replace('/', '.');
            string2 = string2.replace('\\', '.');
            string2 = string2.substring(0, string2.length() - 6);
        }
        return string2;
    }
}

