/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.codegenerator.java;

import com.intersys.classes.CPPStoredProc;
import com.intersys.classes.GlobalCharacterStream;
import com.intersys.classes.JavaDoc;
import com.intersys.codegenerator.java.Description;
import com.intersys.codegenerator.java.DictionaryForPrimitives;
import com.intersys.codegenerator.java.GenFlags;
import com.intersys.codegenerator.java.LanguageGeneratorTemplate;
import com.intersys.codegenerator.java.OutputFile;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheReader;
import com.intersys.objects.Database;
import com.intersys.objects.ObjectHandleHolder;
import com.intersys.objects.SList;
import com.intersys.objects.StatusCode;
import com.intersys.objects.SysListHolder;
import com.intersys.objects.reflect.CacheArgumentMetadata;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheElementInfo;
import com.intersys.objects.reflect.CacheFieldMetadata;
import com.intersys.objects.reflect.CacheMethodMetadata;
import com.intersys.objects.reflect.CacheQueryMetadata;
import com.intersys.objects.reflect.ColumnMetadata;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import com.intersys.objects.reflect.UniqueIndexMetadata;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class Java
extends LanguageGeneratorTemplate {
    private Database mDB;
    private Connection mCon;
    private String mHost;
    private String mPort;
    private String mNameSpace;
    private String mCommentNameSpace;
    private HashMap mClassMap;
    private boolean mHome = false;
    private boolean mRemote = false;
    private boolean mIsSessionBean = false;
    private boolean mHasBody = true;
    private boolean mLocal = false;
    private boolean mEJB = false;
    private boolean mCMP = false;
    private String mFlags;
    private DictionaryForPrimitives mDictionary;
    private int mLength;
    private HashMap mPropertyDescriptions = null;
    private HashMap mMethodDescriptions = null;
    public final String cacheTYPElistofdatatypes = "%Library.ListOfDataTypes";
    public final String cacheTYPElistofobjects = "%Library.ListOfObjects";
    public final String cacheTYPEarrayofdatatypes = "%Library.ArrayOfDataTypes";
    public final String cacheTYPEarrayofobjects = "%Library.ArrayOfObjects";
    public final String cacheTYPEnewlistofdatatypes = "%Collection.AbstractListOfDT";
    public final String cacheTYPEnewlistofobjects = "%Collection.AbstractListOfObj";
    public final String cacheTYPEnewarrayofdatatypes = "%Collection.AbstractArrayOfDT";
    public final String cacheTYPEnewarrayofobjects = "%Collection.AbstractArrayOfObj";
    public final String cacheTYPErelationshipobject = "%Library.RelationshipObject";
    private String[] mCollectionNames = new String[]{"%Collection.AbstractArrayOfDT", "%Collection.AbstractArrayOfObj", "%Collection.AbstractListOfDT", "%Collection.AbstractListOfObj", "%Library.ArrayOfDataTypes", "%Library.ArrayOfObjects", "%Library.ListOfDataTypes", "%Library.ListOfObjects"};
    private String[] mTransformedNames = new String[]{"SysArrayOfDataTypes", "SysArrayOfObjects", "SysListOfDataTypes", "SysListOfObjects", "SysArrayOfDataTypes", "SysArrayOfObjects", "SysListOfDataTypes", "SysListOfObjects"};
    public HashMap mXlateJDBCCode;

    public Java(PrintWriter printWriter, Database database, Connection connection, String string, String string2, String string3, String string4, String string5, GenFlags genFlags, HashMap hashMap, boolean bl) {
        this.mOut = new OutputFile(printWriter);
        this.mDB = database;
        this.mCon = connection;
        this.mHost = string;
        this.mPort = string2;
        this.mNameSpace = string3;
        this.mGenFlags = genFlags;
        this.mFlags = string4;
        this.mCommentNameSpace = string5;
        this.mClassMap = hashMap;
        this.constructXlateJDBC();
        this.mDictionary = new DictionaryForPrimitives(this.mGenFlags);
        this.mHasBody = bl;
    }

    public void displaySingleInsert(CacheClassMetadata cacheClassMetadata, String[] stringArray) throws CacheException {
        this.mOut.genLn("");
        TableMetadata tableMetadata = cacheClassMetadata.getSQLTableMetadata();
        int n = this.displayInsertDeclaration(tableMetadata, "int insert", "", stringArray, false);
        this.mOut.genLn("com.intersys.jdbc.SysListProxy.clearList(wire);");
        this.mOut.genLn("com.intersys.jdbc.SysListProxy.setInteger (wire, " + n + ");");
        this.displayInsertUpdateBody(tableMetadata, stringArray, "wire", "true, null");
        this.mOut.genLn("Integer id = (Integer) statement.create (schema, table, java.sql.Types.INTEGER, wire, 1);");
        this.mOut.genLn("return id.intValue();");
        this.mOut.dec();
        this.mOut.genLn("}");
        this.mOut.resetIndent();
    }

    public void displayUpdate(CacheClassMetadata cacheClassMetadata, String[] stringArray) throws CacheException {
        this.mOut.genLn("");
        TableMetadata tableMetadata = cacheClassMetadata.getSQLTableMetadata();
        int n = this.displayInsertDeclaration(tableMetadata, "void update", "int rowid, ", stringArray, false);
        this.mOut.genLn("com.intersys.jdbc.SysListProxy.clearList(wire);");
        this.mOut.genLn("com.intersys.jdbc.SysListProxy.setInteger (wire, " + n + ");");
        this.displayInsertUpdateBody(tableMetadata, stringArray, "wire", "true, null");
        this.mOut.genLn("statement.store (schema, table, new Integer(rowid), wire, 1);");
        this.mOut.dec();
        this.mOut.genLn("}");
        this.mOut.resetIndent();
    }

    public void displayLoad(CacheClassMetadata cacheClassMetadata, String string, String[] stringArray) throws CacheException {
        if (string == null) {
            string = "load";
        }
        this.mOut.genLn("");
        this.mOut.resetIndent();
        this.mOut.inc();
        this.mOut.genLn("public Object[] " + string + " (int rowid) throws java.sql.SQLException {");
        this.mOut.inc();
        this.mOut.genLn("Object list = statement.load (schema, table, new Integer(rowid), 1);");
        this.mOut.genLn("");
        this.mOut.genLn("int idloaded = com.intersys.jdbc.SysListProxy.getInteger(list);");
        this.mOut.genLn("");
        this.mOut.genLn("if (idloaded != rowid)");
        this.mOut.inc();
        this.mOut.genLn("throw new java.sql.SQLException (\"Wrong row loaded. Rowid = \" + idloaded +\n                                        \" instead of \" + rowid);");
        this.mOut.dec();
        this.mOut.genLn("");
        this.mOut.genLn("Object[] result = new Object[" + stringArray.length + "];");
        this.mOut.genLn("");
        TableMetadata tableMetadata = cacheClassMetadata.getSQLTableMetadata();
        this.displayLoadBody(tableMetadata, stringArray, "list");
        this.mOut.genLn("return result;");
        this.mOut.dec();
        this.mOut.genLn("}");
        this.mOut.resetIndent();
    }

    public void displayBulkInsert(CacheClassMetadata cacheClassMetadata) throws CacheException {
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        if (!cacheClassMetadata.isPersistent()) {
            return;
        }
        if (cacheClassMetadata.isChild()) {
            return;
        }
        CacheClassMetadata cacheClassMetadata2 = cacheClassMetadata;
        TableMetadata tableMetadata = cacheClassMetadata.getSQLTableMetadata();
        int n = this.displayInsertDeclaration(tableMetadata, "static Object addToBatchInsert", "Object batch, java.sql.Connection con, ", null, false);
        this.mOut.genLn("if (batch == null) {");
        this.mOut.inc();
        this.mOut.genLn("if (con != null) {");
        this.mOut.inc();
        this.mOut.genLn("try {");
        this.mOut.inc();
        this.mOut.genLn("com.intersys.jdbc.CacheConnection c = com.intersys.cache.jdbcutil.JDBCAdapter.getCacheConnection (con);");
        this.mOut.genLn("batch = new com.intersys.jdbc.QuickStatement.Batch (c.getConnectionInfo ());");
        this.mOut.dec();
        this.mOut.genLn("} catch (com.intersys.objects.CacheException x) {");
        this.mOut.inc();
        this.mOut.genLn("throw new java.sql.SQLException (\"Connection is not a CacheConnection.\");");
        this.mOut.dec();
        this.mOut.genLn("}");
        this.mOut.dec();
        this.mOut.genLn("}");
        this.mOut.dec();
        this.mOut.genLn("}");
        this.mOut.genLn("com.intersys.jdbc.QuickStatement.Batch qbatch = (com.intersys.jdbc.QuickStatement.Batch) batch;");
        this.mOut.genLn("com.intersys.jdbc.SysListProxy.setInteger (qbatch.list, " + n + "); // number of columns");
        this.displayInsertUpdateBody(tableMetadata, null, "qbatch.list", "qbatch.getIsUnicode(), qbatch.getLocale ()");
        this.mOut.genLn("qbatch.flushRecord ();");
        this.mOut.genLn("return qbatch;");
        this.mOut.dec();
        this.mOut.genLn("}");
        this.mOut.genLn("");
        this.mOut.resetIndent();
        this.mOut.inc();
        this.mOut.genLn("public static java.util.List executeBatchInsert (java.sql.Connection con, Object batch, int nolock) throws java.sql.SQLException {");
        this.mOut.inc();
        String string = cacheClassMetadata.getSchemaName();
        String string2 = cacheClassMetadata.getSQLTableName();
        this.mOut.genLn("Object ids = com.intersys.jdbc.QuickStatement.Batch.execute (\"" + string + "\", \"" + string2 + "\", " + cacheClassMetadata.getRowIdJDBCCode() + ", batch, con, nolock);");
        this.mOut.genLn("return new com.intersys.objects.SList (ids);");
        this.mOut.genLn("}");
        this.mOut.resetIndent();
    }

    private int displayInsertDeclaration(TableMetadata tableMetadata, String string, String string2, String[] stringArray, boolean bl) throws CacheException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.argListForInsert(stringBuffer, tableMetadata, stringArray, bl);
        this.mOut.resetIndent();
        this.mOut.inc();
        this.mOut.genB("public " + string + " (" + string2);
        this.mOut.gen(stringBuffer.toString());
        this.mOut.genE(") throws java.sql.SQLException {");
        this.mOut.inc();
        return n;
    }

    public int argListForInsert(StringBuffer stringBuffer, TableMetadata tableMetadata, String[] stringArray, boolean bl) throws CacheException {
        int n = tableMetadata.getMinColumnNumber();
        int n2 = tableMetadata.getMaxColumnNumber();
        int n3 = 0;
        String string = "";
        if (stringArray != null) {
            SQLColumn sQLColumn;
            int n4;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                sQLColumn = tableMetadata.getColumn(stringArray[n4]);
                if (sQLColumn == null) {
                    throw new CacheException("No such column: " + stringArray[n4]);
                }
                if (!bl && sQLColumn.isRowIdColumn()) {
                    throw new CacheException("Column: " + stringArray[n4] + " is Row ID column and is not allowed in insert/update ");
                }
                if (!bl && !this.isBulkInsertArgument(sQLColumn)) {
                    throw new CacheException("Column: " + stringArray[n4] + " is not allowed in insert/update ");
                }
                this.appendOneColumnArg(stringBuffer, sQLColumn, string);
                string = ", ";
            }
            for (n4 = n; n4 <= n2; ++n4) {
                sQLColumn = tableMetadata.getColumn(n4);
                if (sQLColumn == null || sQLColumn.isRowIdColumn()) continue;
                ++n3;
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                SQLColumn sQLColumn = tableMetadata.getColumn(i);
                if (sQLColumn == null || sQLColumn.isRowIdColumn()) continue;
                ++n3;
                if (!this.isBulkInsertArgument(sQLColumn)) continue;
                this.appendOneColumnArg(stringBuffer, sQLColumn, string);
                string = ", ";
            }
        }
        return n3;
    }

    public void displayInsertUpdateBody(TableMetadata tableMetadata, String[] stringArray, String string, String string2) throws CacheException {
        int n = tableMetadata.getMinColumnNumber();
        int n2 = tableMetadata.getMaxColumnNumber();
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>(stringArray.length);
            hashSet.addAll(Arrays.asList(stringArray));
        }
        for (int i = n; i <= n2; ++i) {
            SQLColumn sQLColumn = tableMetadata.getColumn(i);
            if (hashSet != null) {
                if (hashSet.contains(sQLColumn.getName())) {
                    this.mOut.genLn("com.intersys.jdbc.SysListProxy." + this.storeColumn(sQLColumn, string, string2) + ";");
                    continue;
                }
                if (sQLColumn.isRowIdColumn()) continue;
                this.mOut.genLn("com.intersys.jdbc.SysListProxy.setUndefined(" + string + "); // for " + sQLColumn.getName());
                continue;
            }
            if (!sQLColumn.isRowIdColumn() && !this.isBulkInsertArgument(sQLColumn)) {
                this.mOut.genLn("com.intersys.jdbc.SysListProxy.setUndefined(" + string + "); // for " + sQLColumn.getName());
            }
            if (!this.isBulkInsertArgument(sQLColumn)) continue;
            this.mOut.genLn("com.intersys.jdbc.SysListProxy." + this.storeColumn(sQLColumn, string, string2) + ";");
        }
    }

    private void displayLoadBody(TableMetadata tableMetadata, String[] stringArray, String string) throws CacheException {
        int n;
        int n2 = tableMetadata.getMinColumnNumber();
        int n3 = tableMetadata.getMaxColumnNumber();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            hashMap.put(stringArray[n], new Integer(n));
        }
        for (n = n2; n <= n3; ++n) {
            SQLColumn sQLColumn = tableMetadata.getColumn(n);
            Integer n4 = (Integer)hashMap.get(sQLColumn.getName());
            if (n4 != null) {
                if (sQLColumn.isRowIdColumn()) {
                    this.mOut.genLn("result[" + n4 + "] = new Integer(idloaded);");
                    continue;
                }
                this.mOut.genLn("result[" + n4 + "] = " + this.loadColumn(sQLColumn, string));
                continue;
            }
            if (sQLColumn.isRowIdColumn()) continue;
            this.mOut.genLn("com.intersys.jdbc.SysListProxy.skip(" + string + ", 1); // for " + sQLColumn.getName());
        }
    }

    private void appendOneColumnArg(StringBuffer stringBuffer, ColumnMetadata columnMetadata, String string) {
        String string2 = this.mDictionary.getType(columnMetadata.getNativeClass());
        stringBuffer.append(string).append(string2).append(" ").append(columnMetadata.getExternalName());
    }

    @Override
    public void doArgPostInvoke(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        CacheArgumentMetadata[] cacheArgumentMetadataArray = cacheMethodMetadata.getArgumentTypes();
        if (!cacheArgumentMetadataArray[n].isByReference()) {
            return;
        }
        if (cacheArgumentMetadataArray[n].isLiteral(true)) {
            this.mOut.genE("        " + cacheArgumentMetadataArray[n].getJavaName() + ".set(res[" + (cacheMethodMetadata.getRefOrdinal(n) + 1) + "]." + this.mDictionary.getAccessor(cacheArgumentMetadataArray[n].getAccessorName()) + ");");
        } else {
            this.mOut.genE("        {");
            this.mOut.genE("        com.intersys.cache.CacheObject cobj = res[" + (cacheMethodMetadata.getRefOrdinal(n) + 1) + "].getCacheObject();");
            this.mOut.genE("        if (cobj != null) {");
            this.mOut.genE("            if (cobj.getOref() != oldref_" + (n + 1) + ") {");
            this.mOut.genE("                ObjectHandle ro = (" + cacheArgumentMetadataArray[n].getRealClass() + ")(cobj.newJavaInstance());");
            this.mOut.genE("                " + cacheArgumentMetadataArray[n].getJavaName() + ".set(ro);");
            this.mOut.genE("            }");
            this.mOut.genE("        }");
            this.mOut.genE("        else {");
            this.mOut.genE("            " + cacheArgumentMetadataArray[n].getJavaName() + ".set((ObjectHandle)null);");
            this.mOut.genE("        }");
            this.mOut.genE("        }");
        }
    }

    @Override
    public void doArgPreInvoke(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        if (cacheMethodMetadata.hasSignatureConflict()) {
            return;
        }
        CacheArgumentMetadata[] cacheArgumentMetadataArray = cacheMethodMetadata.getArgumentTypes();
        boolean bl = false;
        int n2 = cacheArgumentMetadataArray[n].getClientTypeId();
        String string = "";
        if (!cacheArgumentMetadataArray[n].isByReference()) {
            if (cacheArgumentMetadataArray[n].isLiteral(true) && (n2 == 19 || n2 == 20)) {
                if (n2 == 19) {
                    string = "createFilemanDate";
                }
                if (n2 == 20) {
                    string = "createFilemanTimestamp";
                }
                bl = true;
                this.mOut.genE("        args[" + n + "] = com.intersys.cache.Dataholder." + string + "(" + cacheArgumentMetadataArray[n].getJavaName() + ");");
            }
            if (!bl) {
                this.mOut.genE("        args[" + n + "] = new com.intersys.cache.Dataholder(" + cacheArgumentMetadataArray[n].getJavaName() + ");");
            }
        } else {
            if (cacheArgumentMetadataArray[n].isLiteral(true)) {
                if (n2 == 19 || n2 == 20) {
                    bl = true;
                    if (n2 == 19) {
                        string = "createFilemanDate";
                    }
                    if (n2 == 20) {
                        string = "createFilemanTimestamp";
                    }
                    this.mOut.genE("        args[" + n + "] = com.intersys.cache.Dataholder." + string + " (" + cacheArgumentMetadataArray[n].getJavaName() + ".value);");
                }
                if (!bl) {
                    this.mOut.genE("        args[" + n + "] = com.intersys.cache.Dataholder.create (" + cacheArgumentMetadataArray[n].getJavaName() + ".value);");
                }
            } else {
                this.mOut.genE("        ObjectHandle ro_" + (n + 1) + " = " + cacheArgumentMetadataArray[n].getJavaName() + ".value;");
                this.mOut.genE("        int oldref_" + (n + 1) + " = (ro_" + (n + 1) + " == null) ? 0 : ro_" + (n + 1) + ".getOref()" + ";");
                this.mOut.genE("         if (ro_" + (n + 1) + " != null) {");
                this.mOut.genE("            args[" + n + "] = new com.intersys.cache.Dataholder (com.intersys.cache.Dataholder.OREF, oldref_" + (n + 1) + ");");
                this.mOut.genE("        } else {");
                this.mOut.genE("            args[" + n + "] = new com.intersys.cache.Dataholder (com.intersys.cache.Dataholder.OREF, null);");
                this.mOut.genE("        }");
            }
            this.mOut.genE("        _refs[" + cacheMethodMetadata.getRefOrdinal(n) + "] = " + (n + 1) + ";");
        }
    }

    @Override
    public void doBodyIntroducer(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        if (cacheMethodMetadata.hasSignatureConflict()) {
            return;
        }
        this.mLength = n;
        int n2 = this.countNumberRefs(cacheMethodMetadata);
        this.mOut.genE("        com.intersys.cache.Dataholder[] args = new com.intersys.cache.Dataholder[" + n + "];");
        if (n2 > 0) {
            this.mOut.genE("        int[] _refs = new int[" + n2 + "];");
        }
    }

    @Override
    public void doBodyTerminator(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata) throws CacheException {
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        int n = this.countNumberRefs(cacheMethodMetadata);
        boolean bl = cacheMethodMetadata.isClassMethod();
        CacheElementInfo cacheElementInfo = cacheMethodMetadata.getJavaReturnElement();
        int n2 = 0;
        if (cacheElementInfo != null) {
            n2 = cacheMethodMetadata.getJavaReturnElement().getClientTypeId();
        }
        if (n2 == 11) {
            this.mOut.gen("        " + (bl ? "db" : "getDatabase()") + ".");
            if (n == 0) {
                this.mOut.genE("parseStatus(res);");
            } else {
                this.mOut.genE("parseStatus(res[0]);");
            }
        }
        if (cacheMethodMetadata.hasSignatureConflict()) {
            this.mOut.genE("    }");
            return;
        }
        String string = "res" + (n > 0 ? "[0]" : "");
        if (n2 == 0 || n2 == 11) {
            this.mOut.genE("        return;");
            this.mOut.genE("    }");
            return;
        }
        if (n2 != 4) {
            this.mOut.genE("        return " + string + "." + this.mDictionary.getAccessor(cacheMethodMetadata.getReturnAccessorMethod()) + ";");
        } else {
            this.mOut.genE("        com.intersys.cache.CacheObject cobj = " + string + ".getCacheObject();");
            this.mOut.genE("        if (cobj == null)");
            this.mOut.genE("            return null;");
            this.mOut.genE("        return (" + cacheElementInfo.getJavaTypeName() + ")(cobj.newJavaInstance());");
        }
        this.mOut.genE("    }");
    }

    @Override
    public void doClassConstructors(CacheClassMetadata cacheClassMetadata) throws CacheException {
    }

    @Override
    public void doClassIntroducer(CacheClassMetadata cacheClassMetadata) throws CacheException {
        String string;
        int n;
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        String string2 = cacheClassMetadata.getName();
        String string3 = cacheClassMetadata.getJavaPackage();
        if (string3 != null) {
            this.mOut.genE("package " + string3 + ";");
        }
        String[] stringArray = this.getReferences(string2);
        CacheClass cacheClass = cacheClassMetadata.getSuperclass();
        String string4 = "";
        if (cacheClass != null) {
            string4 = cacheClass.getName();
        }
        this.mOut.genE("");
        this.mOut.genE("");
        this.mOut.genE("/**");
        this.mOut.genE(" * Cache' Java Class Generated for class " + cacheClassMetadata.getName() + " on version " + this.getZV() + ".<br>");
        Description description = new Description(this.mDB, cacheClassMetadata);
        String string5 = description.getDescription();
        if (string5 != null) {
            this.mOut.genE(" * Description: " + string5);
        }
        String string6 = this.htmlTransform(string2);
        this.mOut.genE(" *");
        String string7 = " * @see <a href = \"http://" + this.mGenFlags.mDocumaticHost + ":" + this.mGenFlags.mDocumaticPort + "/csp/documatic/%25CSP.Documatic.cls?APP=1&PAGE=CLASS&LIBRARY=" + this.htmlTransform(this.mCommentNameSpace) + "&CLASSNAME=" + string6 + "</A>";
        this.mOut.genE(string7);
        this.mOut.genE("**/");
        this.mOut.genE("");
        String string8 = "";
        String string9 = "";
        if (!this.mGenFlags.getIsInterface() && !cacheClassMetadata.isPersistent()) {
            string8 = "java.io.Serializable";
            string9 = ", ";
        }
        String string10 = "";
        if (cacheClassMetadata.isAbstract()) {
            string10 = "abstract ";
        }
        String string11 = "class";
        String string12 = Java.shortName(cacheClassMetadata.getJavaClassName());
        if (this.mGenFlags.getIsInterface()) {
            string11 = "interface";
            string12 = "I" + string12;
        }
        if ((n = Arrays.binarySearch(this.mCollectionNames, cacheClassMetadata.getName())) < 0) {
            this.mOut.gen("public " + string10 + string11 + " " + string12 + " ");
        } else {
            this.mOut.gen(string11 + string12);
        }
        String string13 = this.javaSuperClassName(cacheClassMetadata.getName());
        if (string13 != null && !this.mGenFlags.getIsInterface()) {
            this.mOut.gen("extends " + string13 + " ");
        }
        if (string13 == null && !this.mGenFlags.getIsInterface()) {
            this.mOut.gen(" ");
        }
        if (this.mGenFlags.mGenerationType == 2 && !this.mGenFlags.getIsInterface()) {
            string = Java.getInterfaceName(cacheClassMetadata.getJavaClassName());
            string8 = string8 + string9 + string + " ";
            string9 = ", ";
        }
        if ((string = cacheClassMetadata.getJavaImplements()) == null) {
            string = "";
        }
        if (this.mGenFlags.mIsInterface || this.mGenFlags.mGenerationType == 1 && !string.equals("")) {
            string8 = string8 + string9 + string;
            string9 = ", ";
        }
        if (this.mGenFlags.getIsInterface()) {
            CacheClass[] cacheClassArray = cacheClassMetadata.getCacheSuperclasses();
            for (int i = 0; i < cacheClassArray.length; ++i) {
                String string14 = cacheClassArray[i].getName();
                if (Java.packageName(string14).charAt(0) == '%' || !this.mClassMap.containsKey(string14)) continue;
                String string15 = Java.getInterfaceName(string14);
                string8 = string8 + string9 + string15;
                string9 = ", ";
            }
        }
        if (!string8.equals("") && !this.mGenFlags.getIsInterface()) {
            this.mOut.gen("implements " + string8 + " ");
        }
        if (!string8.equals("") && this.mGenFlags.getIsInterface()) {
            this.mOut.gen(" extends " + string8 + " ");
        }
        this.mOut.gen("{");
        this.mOut.genE("");
        this.mPropertyDescriptions = this.getPropertyDescriptions(string2);
        this.mMethodDescriptions = this.getMethodDescriptions(string2);
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        this.mOut.genE("    private static String CACHE_CLASS_NAME = \"" + string2 + "\";");
        JavaDoc.genConstructorCacheObject(this.mDB, string2, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
        this.mOut.genE("    public " + string12 + " (com.intersys.cache.CacheObject ref) throws com.intersys.objects.CacheException {");
        this.mOut.genE("        super (ref);");
        this.mOut.genE("    }");
        this.generateConstructors(cacheClassMetadata, string2, string12);
        JavaDoc.genGetCacheClassName(this.mDB, string2, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
        this.mOut.genE("    public static String getCacheClassName( ) {");
        this.mOut.genE("        return CACHE_CLASS_NAME;");
        this.mOut.genE("    }");
        this.mOut.genE("");
        JavaDoc.genGetCacheClass(this.mDB, string2, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
        this.mOut.genE("    public com.intersys.objects.reflect.CacheClass getCacheClass( ) throws com.intersys.objects.CacheException {");
        this.mOut.genE("        return mInternal.getCacheClass();");
        this.mOut.genE("    }");
        this.mOut.genE("");
        JavaDoc.genCheckAllFieldsValid(this.mDB, string2, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
        this.mOut.genE("    public static void checkAllFieldsValid(com.intersys.objects.Database db ) throws com.intersys.objects.CacheException {");
        this.mOut.genE("        checkAllFieldsValid(db, CACHE_CLASS_NAME, " + string12 + ".class);");
        this.mOut.genE("    }");
        this.mOut.genE("");
        if (cacheClassMetadata.isPersistent()) {
            JavaDoc.genExistsWithOid(this.mDB, string2, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static boolean exists (com.intersys.objects.Database db, com.intersys.objects.Oid oid) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return exists (db, oid, CACHE_CLASS_NAME);");
            this.mOut.genE("    }");
            this.mOut.genE("");
        }
        JavaDoc.genCheckAllMethods(this.mDB, string2, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
        this.mOut.genE("    public static void checkAllMethods(com.intersys.objects.Database db ) throws com.intersys.objects.CacheException {");
        this.mOut.genE("        checkAllMethods(db, CACHE_CLASS_NAME, " + string12 + ".class);");
        this.mOut.genE("    }");
    }

    public void generateConstructors(CacheClassMetadata cacheClassMetadata, String string, String string2) throws CacheException {
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        this.mOut.genE("    public " + string2 + " (com.intersys.objects.Database db, String initstr) throws com.intersys.objects.CacheException {");
        this.mOut.genE("        super (((com.intersys.cache.SysDatabase)db).newCacheObject (CACHE_CLASS_NAME,initstr));");
        this.mOut.genE("    }");
        if (!cacheClassMetadata.isAbstract() && cacheClassMetadata.isSerial()) {
            this.mOut.genE("    public static com.intersys.classes.RegisteredObject createClientObject (com.intersys.objects.Database db)throws com.intersys.objects.CacheException {");
            this.mOut.genE("        com.intersys.cache.CacheObject cobj = (((com.intersys.cache.SysDatabase)db).newClientObject(CACHE_CLASS_NAME));");
            this.mOut.genE("        return new " + string2 + " (cobj);");
            this.mOut.genE("    }");
        }
        if (cacheClassMetadata.isSerial()) {
            this.mOut.genE("    public static com.intersys.classes.SerialObject open (com.intersys.objects.Database db, byte[] serialState) throws com.intersys.objects.CacheException {");
            this.mOut.genE("         com.intersys.cache.CacheObject cobj = ((com.intersys.cache.SysDatabase)db).deserializeObject (CACHE_CLASS_NAME, serialState);");
            this.mOut.genE("         return (com.intersys.classes.SerialObject) cobj.newJavaInstance();");
            this.mOut.genE("    }");
        }
        if (this.methodExists(string, "%New")) {
            JavaDoc.genConstructorDatabaseArg(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public " + string2 + " (com.intersys.objects.Database db) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        super (((com.intersys.cache.SysDatabase)db).newCacheObject (CACHE_CLASS_NAME));");
            this.mOut.genE("    }");
        }
        if (cacheClassMetadata.isPersistent()) {
            JavaDoc.genCreateObjects(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static void createObjects (com.intersys.objects.Database db, java.util.Collection objects) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        db.createObjects (CACHE_CLASS_NAME, objects);");
            this.mOut.genE("    }");
        }
        String string3 = "com.intersys.classes.RegisteredObject";
        if (this.methodExists(string, "%OpenId")) {
            JavaDoc.genOpenWithId(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static " + string3 + " _open (com.intersys.objects.Database db, com.intersys.objects.Id id) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return open(db, id);");
            this.mOut.genE("    }");
            JavaDoc.genOpenWithId(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static " + string3 + " open (com.intersys.objects.Database db, com.intersys.objects.Id id) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        com.intersys.cache.CacheObject cobj = (((com.intersys.cache.SysDatabase)db).openCacheObject(CACHE_CLASS_NAME, id.toString()));");
            this.mOut.genE("        return (" + string3 + ")(cobj.newJavaInstance());");
            this.mOut.genE("    }");
            JavaDoc.genOpenWithIdAndConcurrency(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static " + string3 + " _open (com.intersys.objects.Database db, com.intersys.objects.Id id, int concurrency) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return open(db, id, concurrency);");
            this.mOut.genE("    }");
            JavaDoc.genOpenWithIdAndConcurrency(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static " + string3 + " open (com.intersys.objects.Database db, com.intersys.objects.Id id, int concurrency) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        com.intersys.cache.CacheObject cobj = (((com.intersys.cache.SysDatabase)db).openCacheObject(CACHE_CLASS_NAME, id.toString(), concurrency));");
            this.mOut.genE("        return (" + string3 + ")(cobj.newJavaInstance());");
            this.mOut.genE("    }");
        }
        if (this.methodExists(string, "%Open")) {
            JavaDoc.genOpenWithOid(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static " + string3 + " _open (com.intersys.objects.Database db, com.intersys.objects.Oid oid) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return open(db, oid);");
            this.mOut.genE("    }");
            JavaDoc.genOpenWithOid(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static " + string3 + " open (com.intersys.objects.Database db, com.intersys.objects.Oid oid) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        com.intersys.cache.CacheObject cobj = (((com.intersys.cache.SysDatabase)db).openCacheObject(CACHE_CLASS_NAME, oid.getData()));");
            this.mOut.genE("        return (" + string3 + ")(cobj.newJavaInstance());");
            this.mOut.genE("    }");
            JavaDoc.genOpenWithOidAndConcurrency(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static " + string3 + " _open (com.intersys.objects.Database db, com.intersys.objects.Oid oid, int concurrency) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return open(db, oid, concurrency);");
            this.mOut.genE("    }");
            JavaDoc.genOpenWithOidAndConcurrency(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static " + string3 + " open (com.intersys.objects.Database db, com.intersys.objects.Oid oid, int concurrency) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        com.intersys.cache.CacheObject cobj = (((com.intersys.cache.SysDatabase)db).openCacheObject(CACHE_CLASS_NAME, oid.getData(), concurrency));");
            this.mOut.genE("        return (" + string3 + ")(cobj.newJavaInstance());");
            this.mOut.genE("    }");
        }
        if (cacheClassMetadata.isPersistent()) {
            UniqueIndexMetadata[] uniqueIndexMetadataArray = cacheClassMetadata.getSQLTableMetadata().getUniqueIndicies();
            int n = 0;
            if (uniqueIndexMetadataArray != null) {
                for (int i = 0; i < uniqueIndexMetadataArray.length; ++i) {
                    UniqueIndexMetadata uniqueIndexMetadata = uniqueIndexMetadataArray[i];
                    if (uniqueIndexMetadata.isRunnable() == 0) continue;
                    ++n;
                    String string4 = uniqueIndexMetadata.getObjectName();
                    JavaDoc.genCreateKey(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags, string4);
                    this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
                    this.mOut.genE("    public static com.intersys.objects.CandidateKey create" + string4 + "Key (com.intersys.objects.Database db) throws com.intersys.objects.CacheException {");
                    this.mOut.genE("        return db.getCacheClass(CACHE_CLASS_NAME).createKey(\"" + string4 + "\");");
                    this.mOut.genE("    }");
                    JavaDoc.genCreateKeyWithValue(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags, string4);
                    this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
                    this.mOut.genE("    public static com.intersys.objects.CandidateKey create" + string4 + "Key (com.intersys.objects.Database db, String value) throws com.intersys.objects.CacheException {");
                    this.mOut.genE("        return db.getCacheClass(CACHE_CLASS_NAME).createKey(\"" + string4 + "\", value);");
                    this.mOut.genE("    }");
                }
            }
            if (n > 0) {
                JavaDoc.genOpenByKey(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
                this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
                this.mOut.genE("    public static com.intersys.classes.Persistent openByKey (com.intersys.objects.Database db, com.intersys.objects.CandidateKey key) throws com.intersys.objects.CacheException {");
                this.mOut.genE("        com.intersys.cache.CacheObject cobj = ((com.intersys.cache.SysDatabase)db).openByKey (CACHE_CLASS_NAME, key, -1);");
                this.mOut.genE("        return (com.intersys.classes.Persistent) cobj.newJavaInstance();");
                this.mOut.genE("    }");
                JavaDoc.genOpenByKeyAndConcurrency(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
                this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
                this.mOut.genE("    public static com.intersys.classes.Persistent openByKey (com.intersys.objects.Database db, com.intersys.objects.CandidateKey key, int concurrency) throws com.intersys.objects.CacheException {");
                this.mOut.genE("        com.intersys.cache.CacheObject cobj = ((com.intersys.cache.SysDatabase)db).openByKey (CACHE_CLASS_NAME, key, concurrency);");
                this.mOut.genE("        return (com.intersys.classes.Persistent) cobj.newJavaInstance();");
                this.mOut.genE("    }");
            }
            JavaDoc.genOpenByQueryWithArgs(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static java.util.Iterator openByQuery (com.intersys.objects.Database db, String condition, Object[] args) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return db.openByQuery (CACHE_CLASS_NAME, condition, args);");
            this.mOut.genE("    }");
            JavaDoc.genOpenByQuery(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static java.util.Iterator openByQuery (com.intersys.objects.Database db, String condition) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return db.openByQuery (CACHE_CLASS_NAME, condition);");
            this.mOut.genE("    }");
            JavaDoc.genSaveObjects(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static void saveObjects (com.intersys.objects.Database db, java.util.Collection objects) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        db.saveObjects (CACHE_CLASS_NAME, objects);");
            this.mOut.genE("    }");
        }
        if (this.methodExists(string, "%DeleteId")) {
            JavaDoc.genDeleteWithId(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static void delete (com.intersys.objects.Database db, com.intersys.objects.Id id) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        ((com.intersys.cache.SysDatabase)db).deleteObject(CACHE_CLASS_NAME, id);");
            this.mOut.genE("    }");
            JavaDoc.genDeleteWithIdAndConcurrency(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static void delete (com.intersys.objects.Database db, com.intersys.objects.Id id, int concurrency) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        ((com.intersys.cache.SysDatabase)db).deleteObject(CACHE_CLASS_NAME, id, concurrency);");
            this.mOut.genE("    }");
            JavaDoc.genDeleteWithId(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static void _deleteId (com.intersys.objects.Database db, com.intersys.objects.Id id) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        delete(db, id);");
            this.mOut.genE("    }");
            JavaDoc.genDeleteWithIdAndConcurrency(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static void _deleteId (com.intersys.objects.Database db, com.intersys.objects.Id id, int concurrency) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        delete(db, id, concurrency);");
            this.mOut.genE("    }");
        }
        if (this.methodExists(string, "%ExistsId")) {
            JavaDoc.genExistsWithId(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static boolean exists (com.intersys.objects.Database db, com.intersys.objects.Id id) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return ((com.intersys.cache.SysDatabase)db).existsObject(CACHE_CLASS_NAME, id);");
            this.mOut.genE("    }");
            JavaDoc.genExistsWithId(this.mDB, string, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags);
            this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
            this.mOut.genE("    public static Boolean _existsId (com.intersys.objects.Database db, com.intersys.objects.Id id) throws com.intersys.objects.CacheException {");
            this.mOut.genE("        return new Boolean(exists(db, id));");
            this.mOut.genE("    }");
        }
    }

    @Override
    public void doClassTerminator(CacheClassMetadata cacheClassMetadata) throws CacheException {
        this.displayJavaMethods(cacheClassMetadata);
        this.displayBulkInsert(cacheClassMetadata);
        this.mOut.genE("}");
    }

    @Override
    public void doDefArg(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
    }

    @Override
    public void doFileTerminator(CacheClassMetadata cacheClassMetadata) throws CacheException {
    }

    public void displayStream(String string, String string2, CacheFieldMetadata cacheFieldMetadata) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        if (cacheFieldMetadata.isBinaryStream()) {
            string3 = "com.intersys.objects.CacheInputStream";
            string6 = "com.intersys.objects.CacheOutputStream";
            string5 = "getInputStream";
            string4 = "getOutputStream";
        }
        if (cacheFieldMetadata.isCharacterStream()) {
            string3 = "com.intersys.objects.CacheReader";
            string6 = "com.intersys.objects.CacheWriter";
            string5 = "getReader";
            string4 = "getWriter";
        }
        this.mOut.genE("    public " + string3 + " get" + string2 + "In() throws com.intersys.objects.CacheException {");
        this.mOut.genE("        com.intersys.cache.Dataholder dh = mInternal.getProperty(ii_" + string2 + ",");
        this.mOut.genE("                                              jj_" + string2 + ",");
        this.mOut.genE("                                              com.intersys.objects.Database.RET_OBJECT,");
        this.mOut.genE("                                              \"" + string2 + "\");");
        this.mOut.genE("        com.intersys.cache.CacheObject cobj = dh.getCacheObject();");
        this.mOut.genE("        com.intersys.cache.SysDatabase db = mInternal.getDatabase();");
        this.mOut.genE("        return (db." + string5 + " (cobj));");
        this.mOut.genE("    }");
        this.mOut.genE("    public " + string6 + " get" + string2 + "Out() throws com.intersys.objects.CacheException {");
        this.mOut.genE("        com.intersys.cache.Dataholder dh = mInternal.getProperty(ii_" + string2 + ",");
        this.mOut.genE("                                              jj_" + string2 + ",");
        this.mOut.genE("                                              com.intersys.objects.Database.RET_OBJECT,");
        this.mOut.genE("                                              \"" + string2 + "\");");
        this.mOut.genE("        com.intersys.cache.CacheObject cobj = dh.getCacheObject();");
        this.mOut.genE("        com.intersys.cache.SysDatabase db = mInternal.getDatabase();");
        this.mOut.genE("        return (db." + string4 + " (cobj));");
        this.mOut.genE("    }");
    }

    public void displayGetPrototype(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata, Holder holder, Holder holder2) throws CacheException {
        this.displayGetPrototype(cacheClassMetadata, cacheFieldMetadata, holder, holder2, "", false);
    }

    public void displayGetPrototype(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata, Holder holder, Holder holder2, String string, boolean bl) throws CacheException {
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        String string2 = cacheClassMetadata.getName();
        if (!cacheFieldMetadata.hasGet()) {
            return;
        }
        String string3 = (String)this.mPropertyDescriptions.get(cacheFieldMetadata.getName());
        String string4 = cacheFieldMetadata.getJavaName();
        holder.setValue(string4);
        String string5 = this.mDictionary.getType(cacheFieldMetadata.getJavaTypeName());
        string5 = Java.stripPrimitive(cacheFieldMetadata.isLiteral(true), string5);
        holder2.setValue(string5);
        if (cacheFieldMetadata.isStream()) {
            this.displayStream(string5, string4, cacheFieldMetadata);
            return;
        }
        if (this.mGenFlags.newCollections()) {
            if (cacheFieldMetadata.isList()) {
                string5 = "java.util.List";
            } else if (cacheFieldMetadata.isTrulyArray()) {
                string5 = "java.util.Map";
            }
        } else if (cacheFieldMetadata.isArrayOfDatatypes()) {
            string5 = "ArrayOfDataTypes";
        } else if (cacheFieldMetadata.isListOfDatatypes()) {
            string5 = "ListOfDataTypes";
        } else if (cacheFieldMetadata.isArrayOfObjects()) {
            string5 = "ArrayOfObjects";
        } else if (cacheFieldMetadata.isListOfObjects()) {
            string5 = "ListOfObjects";
        }
        holder2.setValue(string5);
        String string6 = this.calcException();
        JavaDoc.genGetMethod(this.mDB, string2, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags, string4, string5, string3);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
        this.mOut.genE("    public " + (bl ? "abstract " : "") + string5 + " " + string + "get" + string4 + "() " + string6);
    }

    @Override
    public void doGet(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata) throws CacheException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.notDisplayed(false)) {
            return;
        }
        if (cacheFieldMetadata.isCalculated() && !cacheFieldMetadata.definedGet()) {
            return;
        }
        if (!cacheFieldMetadata.hasGet()) {
            return;
        }
        Holder holder = new Holder(null);
        Holder holder2 = new Holder(null);
        this.displayGetPrototype(cacheClassMetadata, cacheFieldMetadata, holder, holder2);
        if (cacheFieldMetadata.isStream()) {
            return;
        }
        string3 = (String)holder2.getValue();
        String string4 = (String)holder.getValue();
        if (!this.mGenFlags.getIsInterface() && !cacheFieldMetadata.isCalculated() && cacheFieldMetadata.hasGetAsMethod()) {
            this.mOut.genE("        return " + string4 + "Get();");
            this.mOut.genE("    }");
            return;
        }
        if (string3.equals("GlobalBinaryStream") || string3.equals("GlobalCharacterStream")) {
            return;
        }
        string2 = this.mDictionary.getAccessor(cacheFieldMetadata.getGetAccessorName());
        if (!this.mHasBody) {
            return;
        }
        string = !cacheFieldMetadata.isLiteral() ? "RET_OBJECT" : "RET_PRIM";
        this.mOut.genE("        com.intersys.cache.Dataholder dh = mInternal.getProperty(ii_" + string4 + ",");
        this.mOut.genE("                                                jj_" + string4 + ",");
        this.mOut.genE("                                                com.intersys.objects.Database." + string + ",");
        this.mOut.genE("                                                \"" + cacheFieldMetadata.getName() + "\");");
        if (!cacheFieldMetadata.isLiteral() || cacheFieldMetadata.isStream()) {
            this.mOut.genE("        com.intersys.cache.CacheObject cobj = dh.getCacheObject();");
            this.mOut.genE("        if (cobj == null)");
            this.mOut.genE("            return null;");
            this.mOut.genE("        return (" + string3 + ")(cobj.newJavaInstance());");
        } else {
            boolean bl = cacheFieldMetadata.isLiteral();
            String string5 = this.mDictionary.getType(cacheFieldMetadata.getJavaTypeName());
            String string6 = cacheFieldMetadata.getDeclaredType();
            if (string6 == null || string6.equals("")) {
                this.mOut.genE("       return dh." + string2 + ";");
            } else if (!bl) {
                this.mOut.genE("       return (" + string6 + ")dh.getObject(\"" + string6 + "\");");
            } else {
                String string7 = this.mDictionary.getAccessor(string6, cacheFieldMetadata.getGetter());
                if (string7 == null || string7.equals("")) {
                    this.mOut.genE("       return (" + string6 + ")dh.getObject(\"" + string6 + "\");");
                } else {
                    this.mOut.genE("       return dh." + string7 + ";");
                }
            }
        }
        this.mOut.genE("    }");
        this.mOut.genE("");
    }

    @Override
    public void doGetDefinition(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata) throws CacheException {
    }

    @Override
    public void doIIJJ(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata) throws CacheException {
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        String string = cacheFieldMetadata.getJavaName();
        if (cacheFieldMetadata.getII() == 0) {
            return;
        }
        this.mOut.genE("    private static int ii_" + string + " = " + cacheFieldMetadata.getII() + ";");
        this.mOut.genE("    private static int jj_" + string + " = " + cacheFieldMetadata.getJJ() + ";");
        this.mOut.genE("    private static int kk_" + string + " = " + cacheFieldMetadata.getKK() + ";");
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        JavaDoc.genCheckPropNameValid(this.mDB, cacheClassMetadata.getName(), objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags, string);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
        this.mOut.genE("    public static void check" + string + "Valid (com.intersys.objects.Database db) throws com.intersys.objects.CacheException {");
        this.mOut.genE("        checkZobjValid(db, CACHE_CLASS_NAME, \"" + cacheFieldMetadata.getName() + "\",ii_" + string + ", jj_" + string + ", kk_" + string + ");");
        this.mOut.genE("    }");
    }

    @Override
    public void doMethodIntroducer(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata) throws CacheException {
    }

    @Override
    public void doMethodInvoke(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata) throws CacheException {
        if (this.mGenFlags.getIsInterface()) {
            return;
        }
        if (cacheMethodMetadata.hasSignatureConflict()) {
            this.mOut.genE("        throw new com.intersys.objects.CacheException(\"We cannot invoke this method since there is a conflict between the method " + cacheMethodMetadata.getName() + " in this class " + cacheClassMetadata.getName() + " and its left-most super " + cacheClassMetadata.getSuperclass().getName() + "\");");
            return;
        }
        int n = this.countNumberRefs(cacheMethodMetadata);
        boolean bl = cacheMethodMetadata.isClassMethod();
        String string = "";
        string = cacheMethodMetadata.getJavaReturnElement().getClientTypeId() == 0 ? "com.intersys.objects.Database.RET_NONE" : (cacheMethodMetadata.getJavaReturnElement().getClientTypeId() != 4 ? "com.intersys.objects.Database.RET_PRIM" : "com.intersys.objects.Database.RET_OBJECT");
        String string2 = bl ? "((SysDatabase)db).runClassMethod(CACHE_CLASS_NAME," : "mInternal.runInstanceMethod(";
        this.mOut.genE("        com.intersys.cache.Dataholder" + (n > 0 ? "[]" : "") + " res=" + string2 + "\"" + cacheMethodMetadata.getName() + "\"," + (n > 0 ? "_refs," : "") + "args," + string + ");");
    }

    @Override
    public void doMethodsPreamble(CacheClassMetadata cacheClassMetadata) throws CacheException {
    }

    @Override
    public void doPropertiesPreamble(CacheClassMetadata cacheClassMetadata) throws CacheException {
    }

    @Override
    public void doPrototypeArgument(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
        boolean bl = cacheMethodMetadata.isClassMethod();
        String string = cacheMethodMetadata.getName();
        String string2 = cacheMethodMetadata.getJavaName();
        String string3 = cacheClassMetadata.getName();
        if (this.notDisplayed(bl)) {
            return;
        }
        if (n == 0 && bl && !this.mEJB) {
            this.mOut.gen(", ");
        }
        if (n != 0) {
            this.mOut.gen(", ");
        }
        int n2 = n;
        CacheArgumentMetadata[] cacheArgumentMetadataArray = cacheMethodMetadata.getArgumentTypes();
        if (this.swapArgs(string3, string) && this.swapArgs(string3, string)) {
            n2 = n == 1 ? 2 : (n == 2 ? 1 : n);
        }
        String string4 = this.mDictionary.getType(cacheArgumentMetadataArray[n2].getJavaTypeName());
        String string5 = cacheArgumentMetadataArray[n2].getJavaName();
        this.mOut.gen(string4 + " " + string5);
    }

    @Override
    public void doPrototypeArgumentDoc(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
        String string = cacheClassMetadata.getName();
        CacheArgumentMetadata[] cacheArgumentMetadataArray = cacheMethodMetadata.getArgumentTypes();
        boolean bl = cacheMethodMetadata.isClassMethod();
        String string2 = cacheMethodMetadata.getName();
        if (this.notDisplayed(bl)) {
            return;
        }
        if (this.swapArgs(string, string2) && this.swapArgs(string, string2)) {
            if (n == 1) {
                int n2 = 2;
            } else if (n == 2) {
                boolean bl2 = true;
            } else {
                int n3 = n;
            }
        }
        CacheArgumentMetadata cacheArgumentMetadata = cacheArgumentMetadataArray[n];
        this.mOut.genE("     @param " + cacheArgumentMetadata.getJavaName() + " represented as " + this.mDictionary.getType(cacheArgumentMetadata.getJavaTypeName()));
    }

    @Override
    public void doPrototypeDefaultDoc(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
        String string = cacheClassMetadata.getName();
        CacheArgumentMetadata[] cacheArgumentMetadataArray = cacheMethodMetadata.getArgumentTypes();
        boolean bl = cacheMethodMetadata.isClassMethod();
        String string2 = cacheMethodMetadata.getName();
        if (this.notDisplayed(bl)) {
            return;
        }
        if (this.swapArgs(string, string2) && this.swapArgs(string, string2)) {
            if (n == 1) {
                int n2 = 2;
            } else if (n == 2) {
                boolean bl2 = true;
            } else {
                int n3 = n;
            }
        }
        CacheArgumentMetadata cacheArgumentMetadata = cacheArgumentMetadataArray[n];
        this.mOut.genE("     default argument " + cacheArgumentMetadata.getName() + " set to " + cacheArgumentMetadata.getDefaultValueString());
    }

    @Override
    public void doPrototypeIntroducer(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata) throws CacheException {
        int n;
        boolean bl = cacheMethodMetadata.isClassMethod();
        String string = cacheMethodMetadata.getName();
        String string2 = cacheMethodMetadata.getJavaName();
        if (this.notDisplayed(bl)) {
            return;
        }
        String string3 = "";
        if (!this.mEJB && bl) {
            string3 = "static ";
        }
        String string4 = (n = cacheMethodMetadata.getJavaReturnElement().getClientTypeId()) == 11 || n == 0 ? "void" : this.mDictionary.getType(cacheMethodMetadata.getJavaReturnElement().getJavaTypeName());
        this.mOut.gen("    public " + string3 + string4 + " " + string2 + " (" + (bl && !this.mEJB ? "com.intersys.objects.Database db" : ""));
    }

    @Override
    public void doPrototypeIntroducerDoc(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, CacheClassMetadata cacheClassMetadata2) throws CacheException {
        boolean bl = cacheMethodMetadata.isClassMethod();
        String string = cacheMethodMetadata.getName();
        String string2 = cacheMethodMetadata.getJavaName();
        if (this.notDisplayed(bl)) {
            return;
        }
        this.mOut.genE("    /**");
        this.mOut.genE("     <p>Runs method " + string2 + " in Cache.</p>");
        String string3 = (String)this.mMethodDescriptions.get(string);
        if (string3 != null && !string3.equals("")) {
            this.mOut.genE("     <p>Description: " + string3 + "</p>");
        }
        if (bl && !this.mEJB) {
            this.mOut.genE("     @param db represented as com.intersys.objects.Database");
        }
    }

    @Override
    public void doPrototypeTerminator(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata) throws CacheException {
        boolean bl = cacheMethodMetadata.isClassMethod();
        String string = cacheMethodMetadata.getName();
        String string2 = cacheMethodMetadata.getJavaName();
        if (!this.mEJB && cacheMethodMetadata.isJavaMethod()) {
            this.mOut.genE(") {");
            return;
        }
        if (!this.mEJB && !this.mGenFlags.getIsInterface()) {
            this.mOut.genE(") throws com.intersys.objects.CacheException {");
            return;
        }
        if (!this.mEJB && this.mGenFlags.getIsInterface()) {
            this.mOut.genE(") throws com.intersys.objects.CacheException;");
            return;
        }
        if (this.mEJB && this.mHasBody) {
            this.mOut.genE(") {");
            return;
        }
        if (this.notDisplayed(bl)) {
            return;
        }
        if (!this.mLocal) {
            this.mOut.genE(") throws RemoteException;");
        }
        if (this.mLocal) {
            this.mOut.genE(");");
        }
    }

    @Override
    public void doPrototypeTerminatorDoc(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
        CacheArgumentMetadata[] cacheArgumentMetadataArray;
        String string;
        int n2;
        boolean bl = cacheMethodMetadata.isClassMethod();
        String string2 = cacheClassMetadata.getName();
        String string3 = cacheMethodMetadata.getName();
        String string4 = cacheMethodMetadata.getJavaName();
        if (this.notDisplayed(bl)) {
            return;
        }
        if (!cacheMethodMetadata.isJavaMethod()) {
            this.mOut.genE("     @throws com.intersys.objects.CacheException if any error occured while running the method.");
        }
        if ((n2 = cacheMethodMetadata.getArgumentTypes().length) != n) {
            this.mOut.gen("     @see #" + string4 + "(");
            string = "";
            if (bl && !this.mEJB) {
                this.mOut.gen("com.intersys.objects.Database");
                string = ",";
            }
            cacheArgumentMetadataArray = cacheMethodMetadata.getArgumentTypes();
            for (int i = 0; i < n2; ++i) {
                int n3 = i;
                if (this.swapArgs(string2, string3)) {
                    n3 = i == 1 ? 2 : (i == 2 ? 1 : i);
                }
                CacheArgumentMetadata cacheArgumentMetadata = cacheArgumentMetadataArray[n3];
                this.mOut.gen(string + this.mDictionary.getType(cacheArgumentMetadata.getJavaTypeName()));
                string = ",";
            }
            this.mOut.genE(")");
        }
        string = this.htmlTransform(string2);
        cacheArgumentMetadataArray = this.htmlTransform(this.mCommentNameSpace);
        String string5 = this.mHost;
        this.mOut.genE("     @see <a href = \"http://" + this.mGenFlags.mDocumaticHost + ":" + this.mGenFlags.mDocumaticPort + "/csp/documatic/%25CSP.Documatic.cls?APP=1&PAGE=CLASS&LIBRARY=" + (String)cacheArgumentMetadataArray + "&CLASSNAME=" + string + "#" + string3 + "\"> Method " + string3 + "</A>");
        this.mOut.genE("    */");
    }

    @Override
    public void doQueryMethod(CacheClassMetadata cacheClassMetadata, CacheQueryMetadata cacheQueryMetadata) throws CacheException {
        int n;
        this.mOut.genE("    /**");
        this.mOut.genE("     <p>Returns a CallableStatement for query " + cacheQueryMetadata.getName() + ".</p>");
        this.mOut.genE("     @param db represented as com.intersys.objects.Database");
        this.mOut.genE("     @throws com.intersys.objects.CacheException if any error occured while running the method.");
        this.mOut.genE("    */");
        int n2 = 1;
        String[] stringArray = cacheQueryMetadata.getDefaultArgs();
        for (n = 2; n <= stringArray.length && stringArray[n - 1] != null && stringArray[n - 1].equals(""); ++n) {
        }
        n2 = stringArray.length > 1 ? n - 1 : 0;
        this.mOut.genE("    public static com.intersys.objects.CacheQuery query_" + cacheQueryMetadata.getName() + " (com.intersys.objects.Database db) throws com.intersys.objects.CacheException {");
        String string = cacheQueryMetadata.getProcName();
        int n3 = cacheQueryMetadata.getNumberOfParameters();
        this.mOut.genE("        return new com.intersys.objects.CacheQuery(db, \"" + string + "\", " + n3 + ", " + n2 + ");");
        this.mOut.genE("    }");
        this.mOut.genE("");
    }

    @Override
    public void doRefPreInvoke(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata, int n) throws CacheException {
    }

    public void displaySetPrototype(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata, Holder holder, Holder holder2) throws CacheException {
        this.displaySetPrototype(cacheClassMetadata, cacheFieldMetadata, holder, holder2, "", false);
    }

    public void displaySetPrototype(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata, Holder holder, Holder holder2, String string, boolean bl) throws CacheException {
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        String string2 = cacheClassMetadata.getName();
        if (!cacheFieldMetadata.hasGet()) {
            return;
        }
        String string3 = (String)this.mPropertyDescriptions.get(cacheFieldMetadata.getName());
        String string4 = cacheFieldMetadata.getJavaName();
        holder.setValue(string4);
        String string5 = this.mDictionary.getType(cacheFieldMetadata.getJavaTypeName());
        string5 = Java.stripPrimitive(cacheFieldMetadata.isLiteral(true), string5);
        holder2.setValue(string5);
        if (string5.equals("GlobalBinaryStream") || string5.equals("GlobalCharacterStream")) {
            return;
        }
        if (this.mGenFlags.newCollections()) {
            if (cacheFieldMetadata.isList()) {
                string5 = "java.util.List";
            } else if (cacheFieldMetadata.isTrulyArray()) {
                string5 = "java.util.Map";
            }
        } else if (cacheFieldMetadata.isArrayOfDatatypes()) {
            string5 = "ArrayOfDataTypes";
        } else if (cacheFieldMetadata.isListOfDatatypes()) {
            string5 = "ListOfDataTypes";
        } else if (cacheFieldMetadata.isArrayOfObjects()) {
            string5 = "ArrayOfObjects";
        } else if (cacheFieldMetadata.isListOfObjects()) {
            string5 = "ListOfObjects";
        }
        holder2.setValue(string5);
        String string6 = this.calcException();
        JavaDoc.genSetMethod(this.mDB, string2, objectHandleHolder, this.mGenFlags.mDocumaticPort, this.mFlags, string4, string5, string3);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
        this.mOut.genE("    public " + (bl ? "abstract " : "") + "void " + string + "set" + string4 + "(" + string5 + " value) " + string6);
    }

    @Override
    public void doSet(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata) throws CacheException {
        if (this.notDisplayed(false)) {
            return;
        }
        if (this.mGenFlags.newCollections() && (cacheFieldMetadata.isTrulyArray() || cacheFieldMetadata.isList())) {
            return;
        }
        if (!cacheFieldMetadata.hasSet()) {
            return;
        }
        if (cacheFieldMetadata.isStream()) {
            return;
        }
        Holder holder = new Holder(null);
        Holder holder2 = new Holder(null);
        this.displaySetPrototype(cacheClassMetadata, cacheFieldMetadata, holder, holder2);
        String string = (String)holder2.getValue();
        String string2 = (String)holder.getValue();
        if (!this.mGenFlags.getIsInterface() && cacheFieldMetadata.hasSetAsMethod()) {
            this.mOut.genE("        " + string2 + "Set(value);");
            this.mOut.genE("    }");
            return;
        }
        if (!this.mHasBody) {
            return;
        }
        String string3 = !cacheFieldMetadata.isLiteral() ? "com.intersys.objects.Database.RET_OBJECT" : "com.intersys.objects.Database.RET_PRIM";
        int n = cacheFieldMetadata.getClientTypeId();
        String string4 = null;
        if (n == 19 || n == 20) {
            if (n == 19) {
                string4 = "createFilemanDate";
            }
            if (n == 20) {
                string4 = "createFilemanTimestamp";
            }
            this.mOut.genE("        com.intersys.cache.Dataholder dh = com.intersys.cache.Dataholder." + string4 + " (value);");
        } else {
            this.mOut.genE("        com.intersys.cache.Dataholder dh = new com.intersys.cache.Dataholder (value);");
        }
        this.mOut.genE("        mInternal.setProperty(ii_" + string2 + ", jj_" + string2 + ",kk_" + string2 + ", " + string3 + ", \"" + cacheFieldMetadata.getName() + "\", dh);");
        this.mOut.genE("        return;");
        this.mOut.genE("    }");
        this.mOut.genE("");
    }

    @Override
    public void doSetDefinition(CacheClassMetadata cacheClassMetadata, CacheFieldMetadata cacheFieldMetadata) throws CacheException {
    }

    @Override
    public void doStoredProcedureMethod(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata) throws CacheException {
        int n;
        int n2;
        String string = cacheMethodMetadata.getStoredProcName();
        this.mOut.resetIndent();
        this.mOut.inc();
        this.mOut.genE("    /**");
        this.mOut.genE("     <p>Returns a CallableStatement for stored procedure " + string + ".</p>");
        String string2 = cacheMethodMetadata.getName();
        String string3 = (String)this.mMethodDescriptions.get(string2);
        if (string3 != null && !string3.equals("")) {
            this.mOut.genLn("     <p>Description: " + string3 + "</p>");
        }
        if (cacheMethodMetadata.isClassMethod() && !this.mEJB) {
            this.mOut.genE("     @param db represented as com.intersys.objects.Database");
        }
        if (!cacheMethodMetadata.isJavaMethod()) {
            this.mOut.genE("     @throws com.intersys.objects.CacheException if any error occured while running the method.");
        }
        String string4 = cacheClassMetadata.getName();
        String string5 = this.htmlTransform(string4);
        String string6 = this.htmlTransform(this.mCommentNameSpace);
        String string7 = this.mHost;
        this.mOut.genE("     @see <a href = \"http://" + this.mGenFlags.mDocumaticHost + ":" + this.mGenFlags.mDocumaticPort + "/csp/documatic/%25CSP.Documatic.cls?APP=1&PAGE=CLASS&LIBRARY=" + string6 + "&CLASSNAME=" + string5 + "#" + string2 + "\"> Method " + string2 + "</A>");
        this.mOut.genE("    */");
        this.mOut.genLn("public static java.sql.CallableStatement prepare_" + string + "(com.intersys.objects.Database db) throws com.intersys.objects.CacheException {");
        this.mOut.inc();
        this.mOut.genLn("java.sql.CallableStatement statement = null;");
        int n3 = cacheMethodMetadata.getJavaReturnElement().getClientTypeId();
        String string8 = n3 == 11 || n3 == 0 ? "" : "? = ";
        String string9 = "";
        String string10 = "";
        CacheArgumentMetadata[] cacheArgumentMetadataArray = cacheMethodMetadata.getArgumentTypes();
        for (n2 = 0; n2 < cacheArgumentMetadataArray.length; ++n2) {
            CacheArgumentMetadata cacheArgumentMetadata = cacheArgumentMetadataArray[n2];
            if (cacheArgumentMetadata.getJavaTypeName().equals("SQLProcContext") || cacheArgumentMetadata.getJavaTypeName().equals("com.intersys.classes.SQLProcContext")) continue;
            string9 = string9 + string10 + "?";
            string10 = " , ";
        }
        n2 = 0;
        if (n3 != 11 && n3 != 0) {
            n2 = 1;
        }
        int n4 = 1;
        for (int i = 0; i < cacheArgumentMetadataArray.length; ++i) {
            CacheArgumentMetadata cacheArgumentMetadata = cacheArgumentMetadataArray[i];
            if (cacheArgumentMetadata.getJavaTypeName().equals("SQLProcContext") || cacheArgumentMetadata.getJavaTypeName().equals("com.intersys.classes.SQLProcContext")) continue;
            if (cacheArgumentMetadata.isByReference()) {
                n2 = 1;
            }
            ++n4;
        }
        if (n2 != 0) {
            this.mOut.genLn("try {");
            this.mOut.inc();
        }
        String string11 = cacheClassMetadata.getSchemaName();
        this.mOut.genLn("statement = db.prepareCall(\"{" + string8 + " call " + string11 + "." + string + "(" + string9 + ") }\");");
        if (n3 != 11 && n3 != 0) {
            n = 1;
            CacheElementInfo cacheElementInfo = cacheMethodMetadata.getJavaReturnElement();
            this.mOut.genLn("statement.registerOutParameter(1, " + this.getJDBCString(cacheElementInfo.getJDBCType()) + ");");
        } else {
            n = 0;
        }
        n4 = 1;
        for (int i = 0; i < cacheArgumentMetadataArray.length; ++i) {
            CacheArgumentMetadata cacheArgumentMetadata = cacheArgumentMetadataArray[i];
            if (cacheArgumentMetadata.getJavaTypeName().equals("SQLProcContext") || cacheArgumentMetadata.getJavaTypeName().equals("com.intersys.classes.SQLProcContext")) continue;
            if (cacheArgumentMetadata.isByReference()) {
                this.mOut.genLn("statement.registerOutParameter(" + (n + n4) + ", " + this.getJDBCString(cacheArgumentMetadata.getJDBCType()) + ");");
                n2 = 1;
            }
            ++n4;
        }
        if (n2 != 0) {
            this.mOut.dec();
            this.mOut.genLn("}");
            this.mOut.genLn("catch (java.sql.SQLException x) {");
            this.mOut.inc();
            this.mOut.genLn("throw new com.intersys.objects.CacheException(x, \"Failed to prepare stored procedure " + string + "\");");
            this.mOut.dec();
            this.mOut.genLn("}");
        }
        this.mOut.genLn("return statement;");
        this.mOut.dec();
        this.mOut.genLn("}");
        this.mOut.genLn("");
    }

    private String[] getReferences(String string) throws CacheException {
        SysListHolder sysListHolder = new SysListHolder(null);
        CPPStoredProc.getClassReferences(this.mDB, string, sysListHolder, 2, true);
        SList sList = sysListHolder.value;
        int n = 0;
        if (sList != null) {
            n = sList.size();
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)sList.get(i);
        }
        return stringArray;
    }

    public String transformIfCollection(CacheClassMetadata cacheClassMetadata) throws CacheException {
        int n = Arrays.binarySearch(this.mCollectionNames, cacheClassMetadata.getName());
        if (n >= 0) {
            return this.mTransformedNames[n];
        }
        return Java.shortName(cacheClassMetadata.getName());
    }

    public String javaSuperClassName(String string) throws CacheException {
        CallableStatement callableStatement = null;
        try {
            String string2;
            callableStatement = this.mCon.prepareCall("{?=call %Library.CPPStoredProc_getJavaSuperClassName(?,?)}");
            callableStatement.registerOutParameter(1, -2);
            callableStatement.setString(2, string);
            callableStatement.registerOutParameter(3, 12);
            callableStatement.execute();
            byte[] byArray = callableStatement.getBytes(1);
            StatusCode statusCode = new StatusCode(byArray, this.mDB);
            this.mDB.parseStatus(statusCode);
            String string3 = string2 = callableStatement.getString(3);
            return string3;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException.getMessage());
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException.getMessage());
            }
        }
    }

    public static String shortName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String packageName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "com.intersys.classes";
    }

    public static String stripPrimitive(boolean bl, String string) {
        return string;
    }

    public boolean isDerivedFrom(String string, String string2) throws CacheException {
        CallableStatement callableStatement = null;
        try {
            boolean bl;
            callableStatement = this.mCon.prepareCall("{?=call %Library.CPPStoredProc_IsDerivedFrom(?,?,?)}");
            callableStatement.registerOutParameter(1, -2);
            callableStatement.setString(2, string);
            callableStatement.setString(3, string2);
            callableStatement.registerOutParameter(4, 16);
            callableStatement.execute();
            byte[] byArray = callableStatement.getBytes(1);
            StatusCode statusCode = new StatusCode(byArray, this.mDB);
            this.mDB.parseStatus(statusCode);
            boolean bl2 = bl = callableStatement.getBoolean(4);
            return bl2;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException.getMessage());
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException.getMessage());
            }
        }
    }

    public boolean methodExists(String string, String string2) throws CacheException {
        CallableStatement callableStatement = null;
        try {
            boolean bl;
            callableStatement = this.mCon.prepareCall("{?=call %Library.CPPStoredProc_MethodExists(?,?,?)}");
            callableStatement.registerOutParameter(1, -2);
            callableStatement.setString(2, string);
            callableStatement.setString(3, string2);
            callableStatement.registerOutParameter(4, 16);
            callableStatement.execute();
            byte[] byArray = callableStatement.getBytes(1);
            StatusCode statusCode = new StatusCode(byArray, this.mDB);
            this.mDB.parseStatus(statusCode);
            boolean bl2 = bl = callableStatement.getBoolean(4);
            return bl2;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException.getMessage());
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException.getMessage());
            }
        }
    }

    @Override
    public boolean methodDefined(String string, String string2) throws CacheException {
        CallableStatement callableStatement = null;
        try {
            boolean bl;
            callableStatement = this.mCon.prepareCall("{?=call %Library.CPPStoredProc_MethodDefined(?,?,?)}");
            callableStatement.registerOutParameter(1, -2);
            callableStatement.setString(2, string);
            callableStatement.setString(3, string2);
            callableStatement.registerOutParameter(4, 16);
            callableStatement.execute();
            byte[] byArray = callableStatement.getBytes(1);
            StatusCode statusCode = new StatusCode(byArray, this.mDB);
            this.mDB.parseStatus(statusCode);
            boolean bl2 = bl = callableStatement.getBoolean(4);
            return bl2;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException.getMessage());
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException.getMessage());
            }
        }
    }

    public HashMap getPropertyDescriptions(String string) throws CacheException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        try {
            Object object;
            preparedStatement = this.mCon.prepareStatement("Select Name, Description From %Dictionary.CompiledProperty WHERE parent=?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                if (string2 == null) {
                    string2 = "";
                }
                hashMap.put(object, string2);
            }
            object = hashMap;
            return object;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException.getMessage());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException.getMessage());
            }
        }
    }

    public HashMap getMethodDescriptions(String string) throws CacheException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        try {
            Object object;
            preparedStatement = this.mCon.prepareStatement("Select Name, Description From %Dictionary.CompiledMethod WHERE parent=?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                if (string2 == null) {
                    string2 = "";
                }
                hashMap.put(object, string2);
            }
            object = hashMap;
            return object;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException.getMessage());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException.getMessage());
            }
        }
    }

    public String getHost() {
        return this.mHost;
    }

    public String getPort() {
        return this.mPort;
    }

    public String getNameSpace() {
        return this.mNameSpace;
    }

    public String getCommentNameSpace() {
        return this.mCommentNameSpace;
    }

    private boolean notDisplayed(boolean bl) {
        if (this.mIsSessionBean && this.mHome) {
            return true;
        }
        if (!bl && this.mHome) {
            return true;
        }
        return bl && this.mRemote;
    }

    public String calcException() {
        if (this.mGenFlags.getIsInterface()) {
            return "throws com.intersys.objects.CacheException;";
        }
        if (this.mIsSessionBean && !this.mHasBody && this.mLocal) {
            return "throws EJBException;";
        }
        if (this.mCMP && !this.mHasBody && !this.mLocal) {
            return "throws RemoteException;";
        }
        if (this.mCMP && !this.mHasBody && this.mLocal) {
            return "throws EJBException;";
        }
        if (this.mCMP && this.mHasBody) {
            return ";";
        }
        if (this.mEJB && !this.mHasBody && !this.mLocal) {
            return "throws RemoteException;";
        }
        if (this.mEJB && !this.mHasBody && this.mLocal) {
            return "throws EJBException;";
        }
        if (this.mEJB && this.mHasBody) {
            return "{";
        }
        if (!this.mEJB) {
            return "throws com.intersys.objects.CacheException {";
        }
        return "";
    }

    boolean swapArgs(String string, String string2) {
        if (string.equals("%Library.AbstractArray") && string2.equals("SetAt")) {
            return true;
        }
        if (string.equals("%Library.ArrayOfObjects")) {
            if (string2.equals("SetAt")) {
                return true;
            }
            if (string2.equals("SetObjectAt")) {
                return true;
            }
            if (string2.equals("SetObjectIdAt")) {
                return true;
            }
        }
        if (string.equals("%Library.AbstractList")) {
            if (string2.equals("InsertAt")) {
                return true;
            }
            if (string2.equals("SetAt")) {
                return true;
            }
        }
        if (string.equals("%Library.ListOfObjects")) {
            if (string2.equals("InsertAt")) {
                return true;
            }
            if (string2.equals("InsertObjectAt")) {
                return true;
            }
            if (string2.equals("InsertObjectIdAt")) {
                return true;
            }
            if (string2.equals("SetAt")) {
                return true;
            }
            if (string2.equals("SetObjectAt")) {
                return true;
            }
            if (string2.equals("SetObjectIdAt")) {
                return true;
            }
        }
        if (string.equals("%Library.RelationshipObject")) {
            if (string2.equals("SetAt")) {
                return true;
            }
            if (string2.equals("SetObjectAt")) {
                return true;
            }
        }
        return false;
    }

    public String htmlTransform(String string) {
        if (string.charAt(0) == '%') {
            string = "%25" + string.substring(1);
        }
        return string;
    }

    public int countNumberRefs(CacheMethodMetadata cacheMethodMetadata) throws CacheException {
        CacheArgumentMetadata[] cacheArgumentMetadataArray = cacheMethodMetadata.getArgumentTypes();
        int n = 0;
        for (int i = 0; i < this.mLength; ++i) {
            if (!cacheArgumentMetadataArray[i].isByReference()) continue;
            ++n;
        }
        return n;
    }

    public boolean isBulkInsertArgument(ColumnMetadata columnMetadata) {
        if (!columnMetadata.isInsertable()) {
            return false;
        }
        if (columnMetadata.isForSerialField()) {
            return false;
        }
        if (columnMetadata.isCollection() && columnMetadata.isElementObject()) {
            return false;
        }
        if (!columnMetadata.isCollection() && columnMetadata.isElementPersistent()) {
            return true;
        }
        if (columnMetadata.isXClassName()) {
            return false;
        }
        if (columnMetadata.isStream()) {
            return false;
        }
        return columnMetadata.isElementDatatype();
    }

    public String storeColumn(ColumnMetadata columnMetadata, String string, String string2) {
        if (columnMetadata.isListOfDatatypes()) {
            return "setListOfDatatypes(" + string + ", " + columnMetadata.getExternalName() + ")";
        }
        if (columnMetadata.isArrayOfDatatypes()) {
            return "setMapOfDatatypes(" + string + ", " + columnMetadata.getExternalName() + ")";
        }
        if (columnMetadata.getDataTypeColumn() != 4) {
            String string3 = this.mDictionary.getMutator(columnMetadata.getInvoker()) + "(" + string + ", " + columnMetadata.getExternalName() + ")";
            return string3;
        }
        return "setString(" + string + ", " + columnMetadata.getExternalName() + ")";
    }

    private String loadColumn(ColumnMetadata columnMetadata, String string) {
        if (columnMetadata.isListOfDatatypes()) {
            return "com.intersys.jdbc.QuickStatement.getArrayList(" + string + ", " + columnMetadata.getJDBCType() + ");";
        }
        if (columnMetadata.isArrayOfDatatypes()) {
            return "com.intersys.jdbc.QuickStatement.getHashMap(" + string + ", " + columnMetadata.getJDBCType() + ");";
        }
        return "com.intersys.jdbc.QuickStatement.getObject(" + string + ", " + columnMetadata.getJDBCType() + ");";
    }

    public String getZV() throws CacheException {
        CallableStatement callableStatement = null;
        try {
            String string;
            callableStatement = this.mCon.prepareCall("{?=call %Library.CPPStoredProc_GetZV()}");
            callableStatement.registerOutParameter(1, 12);
            callableStatement.execute();
            String string2 = string = callableStatement.getString(1);
            return string2;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException.getMessage());
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException.getMessage());
            }
        }
    }

    public void outputStream(GlobalCharacterStream globalCharacterStream) throws CacheException {
        CacheReader cacheReader = globalCharacterStream.getReader();
        BufferedReader bufferedReader = new BufferedReader(cacheReader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                this.mOut.genLn(string);
            }
        }
        catch (IOException iOException) {
            throw new CacheException(iOException.getMessage());
        }
    }

    public void displayJavaMethods(CacheClassMetadata cacheClassMetadata) throws CacheException {
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        CPPStoredProc.getJavaLanguageMethods(this.mDB, cacheClassMetadata.getName(), objectHandleHolder, this.mPort, this.mFlags);
        this.outputStream((GlobalCharacterStream)objectHandleHolder.value);
    }

    public String getJDBCString(int n) {
        return (String)this.mXlateJDBCCode.get(new Integer(n));
    }

    public void constructXlateJDBC() {
        this.mXlateJDBCCode = new HashMap();
        HashMap hashMap = this.mXlateJDBCCode;
        hashMap.put(new Integer(-2), "java.sql.Types.BINARY");
        hashMap.put(new Integer(-7), "java.sql.Types.BIT");
        hashMap.put(new Integer(3), "java.sql.Types.DECIMAL");
        hashMap.put(new Integer(91), "java.sql.Types.DATE");
        hashMap.put(new Integer(91), "java.sql.Types.DATE");
        hashMap.put(new Integer(8), "java.sql.Types.DOUBLE");
        hashMap.put(new Integer(2000), "java.sql.Types.JAVA_OBJECT");
        hashMap.put(new Integer(4), "java.sql.Types.INTEGER");
        hashMap.put(new Integer(-2), "java.sql.Types.BINARY");
        hashMap.put(new Integer(-5), "java.sql.Types.BIGINT");
        hashMap.put(new Integer(-2), "java.sql.Types.BINARY");
        hashMap.put(new Integer(12), "java.sql.Types.VARCHAR");
        hashMap.put(new Integer(2), "java.sql.Types.NUMERIC");
        hashMap.put(new Integer(-2), "java.sql.Types.BINARY");
        hashMap.put(new Integer(92), "java.sql.Types.TIME");
        hashMap.put(new Integer(93), "java.sql.Types.TIMESTAMP");
        hashMap.put(new Integer(93), "java.sql.Types.TIMESTAMP");
        hashMap.put(new Integer(12), "java.sql.Types.VARCHAR");
        hashMap.put(new Integer(0), "java.sql.Types.NULL");
    }

    public static String getInterfaceName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        return string2 + "." + "I" + string;
    }

    @Override
    public boolean notProjectMethod(CacheClassMetadata cacheClassMetadata, CacheMethodMetadata cacheMethodMetadata) throws CacheException {
        if (!this.mGenFlags.getIsInterface()) {
            return false;
        }
        if (cacheMethodMetadata.isClassMethod()) {
            return true;
        }
        return !cacheMethodMetadata.isDefinedInClass();
    }

    private class Holder {
        public Object mValue;

        public Holder(Object object) {
            this.mValue = object;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object object) {
            this.mValue = object;
        }
    }
}

