/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheEvent;
import com.intersys.cache.CacheEventListener;
import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.classes.SysAbstractList;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.SystemError;
import java.sql.SQLException;
import java.util.Set;

abstract class ListBuffer
implements CacheServerSensitive,
CacheEventListener {
    private static int DEFAULT_BUFFER_SIZE = 100;
    private int mBufferSize;
    private int currentFirstIdx = 0;
    private int currentLastIdx = 0;
    private int mListSize = -1;
    private boolean mAutoLoad = false;
    private boolean mRegistered = false;
    private Object mBuffer;
    protected CacheObject mList;
    private int mLastIdx = -1;
    private int mIdleInvalidate = 0;

    public ListBuffer(SysAbstractList sysAbstractList, int n) throws CacheException {
        this.mList = sysAbstractList.mInternal;
        this.mBufferSize = n;
    }

    public ListBuffer(SysAbstractList sysAbstractList) throws CacheException {
        this(sysAbstractList, DEFAULT_BUFFER_SIZE);
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    public static int getDefaultBufferSize() {
        return DEFAULT_BUFFER_SIZE;
    }

    public static void setDefaultBufferSize(int n) {
        DEFAULT_BUFFER_SIZE = n;
    }

    public boolean getAutoLoad() {
        return this.mAutoLoad;
    }

    public void setAutoLoad(boolean bl) {
        this.mAutoLoad = bl;
    }

    public Dataholder getAt(Integer n) throws CacheException {
        if (n == null || n < 0 || n > this.count()) {
            throw new ArrayIndexOutOfBoundsException("Invalid index " + n + " of List " + this.mList.getOref());
        }
        if (this.mBufferSize <= 1) {
            return null;
        }
        int n2 = n;
        return this.getAt((int)n2).data;
    }

    protected DataWithIndex getAt(int n) throws CacheException {
        if (n < 0 || n > this.count()) {
            throw new ArrayIndexOutOfBoundsException("Invalid index " + n + " of List " + this.mList.getOref());
        }
        if (this.currentFirstIdx <= n && n < this.currentLastIdx) {
            int n2 = n - this.currentFirstIdx + 1;
            try {
                Object object = SysListProxy.getWrappedItem(this.mBuffer, n2 - 1);
                Dataholder dataholder = new Dataholder(4096, object);
                return new DataWithIndex(n2, dataholder);
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "Failed to get data from list buffer");
            }
        }
        int n3 = -1;
        if (this.count() <= this.mBufferSize) {
            n3 = 1;
        } else if (n == this.currentLastIdx || n == this.mLastIdx + 1) {
            n3 = n;
        } else if (n == this.currentFirstIdx - 1 || n == this.mLastIdx - 1) {
            n3 = n - this.mBufferSize + 1;
            if (n3 < 1) {
                n3 = 1;
            }
        } else if (this.mAutoLoad) {
            n3 = n;
        }
        if (n3 > 0) {
            this.mLastIdx = -1;
            this.load(n3);
            if (n >= this.currentLastIdx) {
                throw new CacheException("Load of List values at index " + n + " failed.");
            }
            return this.getAt(n);
        }
        this.mLastIdx = n;
        return new DataWithIndex(-1, null);
    }

    private Integer dbCount() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder dataholder = this.mList.runInstanceMethod("Count", dataholderArray, 0);
        return dataholder.getInteger();
    }

    public int count() throws CacheException {
        if (this.mBufferSize <= 1) {
            return -1;
        }
        if (this.mListSize >= 0) {
            return this.mListSize;
        }
        Integer n = this.dbCount();
        if (n == null) {
            throw new CacheException("Can not determine size of list");
        }
        this.mListSize = n;
        if (!this.mRegistered) {
            this.register();
        }
        return this.mListSize;
    }

    @Override
    public boolean onServerCall(Set set) throws CacheException {
        if (this.mList.isClosed()) {
            this.invalidateCache(true);
            this.mRegistered = false;
            return false;
        }
        if (set.size() != 1 || !set.contains(new Integer(this.mList.getOref()))) {
            throw new SystemError("Wrong change notification");
        }
        this.invalidateCache(true);
        this.mRegistered = false;
        return false;
    }

    public void close(boolean bl) throws CacheException {
        if (this.mRegistered) {
            this.unregister();
        }
    }

    @Override
    public void handleEvent(CacheEvent cacheEvent) throws CacheException {
        switch (cacheEvent.getType()) {
            case 100: 
            case 200: {
                this.close(true);
                break;
            }
            case 300: {
                this.close(false);
                break;
            }
        }
    }

    @Override
    public void onDatabaseDestroy() throws CacheException {
        this.mRegistered = false;
        this.close(true);
    }

    protected void invalidateCache(boolean bl) throws CacheException {
        this.currentFirstIdx = 0;
        this.currentLastIdx = 0;
        this.mListSize = -1;
    }

    protected void load(int n) throws CacheException {
        int n2;
        int n3;
        if (!this.mRegistered) {
            this.register();
        }
        if ((n3 = (n2 = this.count()) + 1 - n) <= 0) {
            throw new CacheException("Nothing to Load to List Buffer!");
        }
        int n4 = n3 > this.mBufferSize ? this.mBufferSize : n3;
        this.mBuffer = this.getListBuffer(n, n4);
        this.mListSize = n2;
        this.currentFirstIdx = n;
        this.currentLastIdx = n + n4;
    }

    private void register() throws CacheException {
        this.mList.getDatabase().registerSensitiveObject((CacheServerSensitive)this, this.mList.getOref());
        this.mRegistered = true;
    }

    private void unregister() throws CacheException {
        this.mList.getDatabase().unRegisterSensitiveObject(this);
        this.mRegistered = false;
    }

    public String toString() {
        try {
            return "ListBuffer: " + this.mList;
        }
        catch (Exception exception) {
            return "ListBuffer: " + exception.getMessage();
        }
    }

    protected void finalize() throws Throwable {
        this.close(true);
        super.finalize();
    }

    protected abstract Object getListBuffer(int var1, int var2) throws CacheException;

    public abstract Object _getAt(Integer var1) throws CacheException;

    protected class DataWithIndex {
        int index;
        Dataholder data;

        DataWithIndex(int n, Dataholder dataholder) {
            this.index = n;
            this.data = dataholder;
        }
    }
}

