/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.classes.AbstractCacheArray;
import com.intersys.classes.ArrayBuffer;
import com.intersys.classes.ItemOfObjects;
import com.intersys.classes.ObjectArrayBuffer;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.SerialObject;
import com.intersys.classes.SysArrayOfObjects;
import com.intersys.objects.CacheCollectionException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Oid;
import java.util.Map;

public class ArrayOfObjects
extends AbstractCacheArray {
    private String mKeyType = "String";

    public ArrayOfObjects(CacheObject cacheObject) throws CacheException {
        this.mInternal = new SysArrayOfObjects(cacheObject);
        this.setupBuffer();
    }

    public ArrayOfObjects(Database database) throws CacheException {
        this.mInternal = new SysArrayOfObjects(database);
    }

    protected ArrayOfObjects() {
    }

    public String getKeyType() {
        return this.mKeyType;
    }

    public void setKeyType(String string) {
        this.mKeyType = string == null ? "" : string;
    }

    public String getValueType() throws CacheException {
        return this.getInternal().get_elementType();
    }

    void setValueType(String string) throws CacheException {
        this.getInternal().set_elementType(string == null ? "" : string);
    }

    @Override
    public void putAll(Map map) {
        JBindDatabase jBindDatabase = (JBindDatabase)this.mInternal.getDatabase();
        try {
            jBindDatabase.putObjArrayElements(this.mInternal.getOref(), map);
            this.invalidateCache();
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public Object _removeAt(Object object) throws CacheException {
        Object object2 = this._getAt((String)object);
        Object object3 = super._removeAt(object);
        if (object2 != null && object3 instanceof Oid) {
            Oid oid;
            Oid oid2 = (Oid)object3;
            if (object2 instanceof Persistent) {
                oid = ((Persistent)object2).getOid();
            } else if (object2 instanceof SerialObject) {
                oid = ((SerialObject)object2).getOid();
            } else {
                return object3;
            }
            if (oid2.equals(oid)) {
                return object2;
            }
            if (oid == null) {
                return object3;
            }
            if (oid2.getClassName().length() == 0 && oid2.getId().equals(oid.getId())) {
                return object2;
            }
        }
        return object3;
    }

    @Override
    protected Object keyExternal2internal(Object object) {
        if (object == null || object instanceof String) {
            return object;
        }
        return object.toString();
    }

    @Override
    protected Object keyInternal2external(Object object) {
        return object;
    }

    @Override
    protected Object valueExternal2internal(Object object) {
        return object;
    }

    @Override
    protected Object valueInternal2external(Object object) {
        if (object instanceof Oid) {
            try {
                return Persistent._open(this.getDatabase(), (Oid)object);
            }
            catch (CacheException cacheException) {
                throw new CacheCollectionException(cacheException);
            }
        }
        return object;
    }

    @Override
    public Object _find(Object object) throws CacheException {
        Oid oid = ItemOfObjects.getObjectOid(object);
        return this.getInternal()._find(oid, "");
    }

    @Override
    public void _setAt(Object object, Object object2) throws CacheException {
        if (object instanceof Integer || object instanceof Short || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean) {
            object = object.toString();
        }
        if (!(object instanceof String)) {
            throw new CacheException("Key: " + object + " must be String.");
        }
        if (object == null || object.equals("")) {
            throw new ArrayIndexOutOfBoundsException("Empty string is used an index to cache array");
        }
        this.invalidateCache();
        Object object3 = ItemOfObjects.getSettableObject(object2);
        if (object3 instanceof ObjectHandle) {
            this.getInternal()._setAt(object, (ObjectHandle)object3);
            return;
        }
        if (object3 instanceof Oid) {
            this.getInternal()._setObjectAt(object, (Oid)object3);
        }
        this.getInternal()._setObjectIdAt(object, object3.toString());
    }

    public String getElementType() throws CacheException {
        return this.getInternal().get_elementType();
    }

    public static String getCacheClassName() {
        return SysArrayOfObjects.getCacheClassName();
    }

    protected void setupBuffer() throws CacheException {
        SysArrayOfObjects sysArrayOfObjects = this.getInternal();
        int n = sysArrayOfObjects.getDatabase().getCacheType();
        if (ArrayBuffer.getDefaultBufferSize() > 1 && n > 0) {
            Object object = sysArrayOfObjects.getUserData();
            if (object != null && object instanceof ArrayBuffer) {
                this.setBuffer((ArrayBuffer)object);
            } else {
                ObjectArrayBuffer objectArrayBuffer = new ObjectArrayBuffer(sysArrayOfObjects);
                this.setBuffer(objectArrayBuffer);
                sysArrayOfObjects.setUserData(objectArrayBuffer);
            }
        }
    }

    private final SysArrayOfObjects getInternal() {
        return (SysArrayOfObjects)this.mInternal;
    }
}

