/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.Dataholder;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.SerialStorage;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class QuickEmbeddedObject
extends QuickCacheObject {
    private QuickPersistentObject mStore;
    private ColumnBasedField mField;
    private Map mSetProperties;
    private SerialStorage mSerial;

    public QuickEmbeddedObject(TableBasedClass tableBasedClass) {
        super(tableBasedClass);
        this.mState = 65282;
    }

    public QuickEmbeddedObject(SerialStorage serialStorage) {
        super(serialStorage.getCacheClass());
        this.mSerial = serialStorage;
        this.mState = 65281;
    }

    public QuickEmbeddedObject(TableBasedClass tableBasedClass, QuickPersistentObject quickPersistentObject, ColumnBasedField columnBasedField) {
        super(tableBasedClass);
        this.mStore = quickPersistentObject;
        this.mField = columnBasedField;
        this.mState = 65281;
    }

    @Override
    public Dataholder getProperty(String string, boolean bl) throws CacheException {
        if (this.mSetProperties != null) {
            return (Dataholder)this.mSetProperties.get(string);
        }
        if (this.mSerial != null) {
            return this.mSerial.getProperty((ColumnBasedField)this.mClass.getField(string));
        }
        if (this.mStore == null) {
            return Dataholder.create(null);
        }
        ColumnBasedField columnBasedField = this.mField.getChildField(this.mClass.getField(string));
        if (columnBasedField == null) {
            String string2 = this.mField.columnNameForEmbProp(string);
            columnBasedField = (ColumnBasedField)this.mStore.getCacheClass().getField(string2);
        }
        return this.mStore.getProperty(columnBasedField);
    }

    @Override
    public void setProperty(String string, Dataholder dataholder) throws CacheException {
        this.mState |= 0xFF10;
        if (this.mStore != null) {
            CacheField cacheField = this.mClass.getField(string);
            ColumnBasedField columnBasedField = this.mField.getChildField(cacheField);
            if (columnBasedField == null) {
                String string2 = this.mField.columnNameForEmbProp(string);
                columnBasedField = (ColumnBasedField)this.mStore.getCacheClass().getField(string2);
            }
            this.mStore.setProperty(columnBasedField, dataholder, true, true);
            return;
        }
        if (this.mSerial != null) {
            this.mSerial.setProperty((ColumnBasedField)this.mClass.getField(string), dataholder);
            return;
        }
        if (this.mSetProperties == null) {
            this.mSetProperties = new HashMap();
        }
        this.mSetProperties.put(string, dataholder);
    }

    @Override
    public Object getSerialState(Object object) throws CacheException {
        if (this.mStore != null) {
            this.setSerialFromTable();
        }
        if (this.mSerial != null) {
            return this.mSerial.serialize(object);
        }
        return super.getSerialState(object);
    }

    private void setSerialFromTable() throws CacheException {
        this.mSerial = new SerialStorage(this.getDatabase(), this.getTypeName(), null);
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField == null) continue;
            String string = columnBasedField.getName();
            String string2 = this.mField.columnNameForEmbProp(string);
            ColumnBasedField columnBasedField2 = ((TableBasedClass)this.mStore.getCacheClass()).getColumnBasedField(string2);
            if (columnBasedField2 == null) continue;
            Dataholder dataholder = this.mStore.getProperty(columnBasedField2);
            this.mSerial.setProperty(columnBasedField, dataholder);
        }
    }

    protected void onSetStore(QuickPersistentObject quickPersistentObject, ColumnBasedField columnBasedField, TableBasedClass tableBasedClass) throws CacheException {
        int n;
        Object object;
        this.mField = columnBasedField;
        CacheField[] cacheFieldArray = tableBasedClass.getFields();
        HashSet<String> hashSet = null;
        if (!this.mClass.equals(tableBasedClass)) {
            object = this.mClass.getFields();
            hashSet = new HashSet<String>(cacheFieldArray.length);
            for (n = 0; n < ((CacheField[])object).length; ++n) {
                hashSet.add(object[n].getName());
            }
        }
        object = new Dataholder();
        for (n = 0; n < cacheFieldArray.length; ++n) {
            String string = cacheFieldArray[n].getName();
            boolean bl = !CacheModifier.isLiteral(cacheFieldArray[n].getModifiers());
            ColumnBasedField columnBasedField2 = this.mField.getChildField(cacheFieldArray[n]);
            if (columnBasedField2 == null) {
                String string2 = this.mField.columnNameForEmbProp(string);
                columnBasedField2 = (ColumnBasedField)quickPersistentObject.getCacheClass().getField(string2);
            }
            if (hashSet == null || hashSet.contains(string)) {
                quickPersistentObject.setProperty(columnBasedField2, this.getProperty(string, bl), true, true);
                continue;
            }
            quickPersistentObject.setProperty(columnBasedField2, (Dataholder)object, true, true);
        }
        this.mSetProperties = null;
        this.mSerial = null;
        this.mStore = quickPersistentObject;
        this.mClass = tableBasedClass;
    }

    protected Iterator getAllProperties() throws CacheException {
        if (this.mSetProperties == null) {
            this.mSetProperties = new HashMap();
        }
        if (this.mSerial != null) {
            this.fillSetPropertiesFromSerial();
        }
        if (this.mStore != null) {
            this.fillSetPropertiesFromTable();
        }
        return this.mSetProperties.entrySet().iterator();
    }

    private void fillSetPropertiesFromSerial() throws CacheException {
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            Dataholder dataholder;
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField == null || (dataholder = this.mSerial.getProperty(columnBasedField)) == null) continue;
            this.mSetProperties.put(columnBasedField.getName(), dataholder);
        }
    }

    private void fillSetPropertiesFromTable() throws CacheException {
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            Dataholder dataholder;
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField == null) continue;
            String string = columnBasedField.getName();
            String string2 = this.mField.columnNameForEmbProp(string);
            columnBasedField = ((TableBasedClass)this.mStore.getCacheClass()).getColumnBasedField(string2);
            if (columnBasedField == null || (dataholder = this.mStore.getProperty(columnBasedField)) == null) continue;
            this.mSetProperties.put(string, dataholder);
        }
    }

    @Override
    public int save(boolean bl) throws CacheException {
        return 0;
    }

    @Override
    public Id getId() throws CacheException {
        if (this.mSerial == null) {
            return null;
        }
        Object object = this.getSerialState(null);
        return new Id(object.toString());
    }

    public void ensureSaved() throws CacheException {
        if (this.mStore == null) {
            return;
        }
        if (this.mStore.getOid() == null || this.mStore.getOid().undefined()) {
            this.mStore.save(false);
        }
    }
}

