/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.quick.DBAdapter;
import com.intersys.cache.quick.QuickBulkInsertWorker;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheServerException;

public class QuickBulkInsertWorkerTPW
extends QuickBulkInsertWorker {
    private DBAdapter mDBAdapter;
    private int mNoLock;
    private Thread workThread;
    private CacheServerException mException;

    public QuickBulkInsertWorkerTPW(DBAdapter dBAdapter, int n) {
        this.mDBAdapter = dBAdapter;
        this.mNoLock = n;
    }

    @Override
    public void doIt(String string, String string2, Object object) throws CacheServerException {
        this.mDBAdapter.bulkCreateNoIds(string, string2, 4, object, this.mNoLock);
    }

    @Override
    public void doConcurrently(String string, String string2, Object object) throws CacheServerException, InterruptedException {
        if (this.workThread != null) {
            this.workThread.join();
        }
        Worker worker = new Worker(string, string2, object);
        this.workThread = new Thread((Runnable)worker, "Bulk Insert Worker");
        this.workThread.start();
    }

    @Override
    public void checkForException() throws Exception {
        if (this.mException != null) {
            throw this.mException;
        }
    }

    private class Worker
    implements Runnable {
        private String schema;
        private String table;
        private Object wire;

        private Worker(String string, String string2, Object object) {
            this.schema = string;
            this.table = string2;
            this.wire = SysListProxy.createSysList(SysListProxy.getBinaryData(object), true, SysListProxy.getConnectionInfo(object));
            QuickBulkInsertWorkerTPW.this.mException = null;
        }

        @Override
        public void run() {
            try {
                QuickBulkInsertWorkerTPW.this.doIt(this.schema, this.table, this.wire);
            }
            catch (CacheServerException cacheServerException) {
                QuickBulkInsertWorkerTPW.this.mException = cacheServerException;
            }
        }
    }
}

