/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.ColumnOnlyField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickCacheField;
import com.intersys.cache.quick.QuickCollectionObject;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.SQLColumn;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.JalapenoHelperInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class PojoBackedStorage
implements QuickPersistentObject.LocalStorage {
    private static final String NULL = "NULL_ID";
    private Object mPojo;
    private JalapenoHelperInterface mHelper;
    private boolean[] mSetValues;
    private String mIdStr = null;
    private CandidateKey mPK = null;
    private QuickPersistentObject mParent;

    public PojoBackedStorage(QuickPersistentObject quickPersistentObject) {
        this.mParent = quickPersistentObject;
    }

    public PojoBackedStorage(QuickPersistentObject quickPersistentObject, Object object) throws CacheException {
        this.mParent = quickPersistentObject;
        this.mPojo = object;
        this.init();
        Arrays.fill(this.mSetValues, true);
    }

    @Override
    public Dataholder getCachedId() throws CacheException {
        if (this.mIdStr != null) {
            if (this.mIdStr == NULL) {
                return null;
            }
            return new Dataholder(this.mIdStr);
        }
        try {
            Object object = !this.mHelper.hasIdPlaceholder() ? this.getIdFromDatabase() : this.mHelper.getPojoId(this.mPojo);
            if (object == null) {
                return null;
            }
            return Dataholder.create(object);
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    private Object getIdFromDatabase() throws Exception {
        LightDatabase lightDatabase = (LightDatabase)this.mParent.getDatabase();
        DetachedObjectsManager detachedObjectsManager = lightDatabase.getDetachedObjectsManager();
        Object object = detachedObjectsManager.findIdInMemory(this.mPojo);
        if (object != null) {
            this.mIdStr = object.toString();
            return object;
        }
        if (this.mPK == null) {
            this.mPK = (CandidateKey)this.mHelper.getPrimaryKey(this.mPojo);
        }
        TableBasedClass tableBasedClass = this.mParent.mClass;
        if (this.mPK == null) {
            this.mPK = detachedObjectsManager.findPojoPrimaryKey(this.mPojo, tableBasedClass);
        }
        if (this.mPK == null) {
            return null;
        }
        object = lightDatabase.existsByKey(tableBasedClass, this.mPK, true);
        this.mIdStr = object != null ? object.toString() : NULL;
        return object;
    }

    @Override
    public void setCachedId(Dataholder dataholder) throws CacheException {
        try {
            boolean bl = this.mHelper.setPojoId(this.mPojo, (Serializable)dataholder.getObject());
            if (!bl) {
                this.mIdStr = dataholder.getObject() == null ? NULL : dataholder.toString();
            }
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    @Override
    public boolean isReusable() {
        return false;
    }

    @Override
    public boolean cachedValuesNotNull() {
        return this.mPojo != null;
    }

    @Override
    public Object getInternalCachedValue(ColumnBasedField columnBasedField) throws CacheException {
        if (!PojoBackedStorage.isCacheable(columnBasedField)) {
            return null;
        }
        int n = columnBasedField.getColumnIndexForSet();
        if (!this.mSetValues[n]) {
            return null;
        }
        if (PojoBackedStorage.isFromEmbeddedObject(columnBasedField)) {
            Object object = this.getEmbeddedObject(columnBasedField, false);
            if (object == null) {
                return null;
            }
            JalapenoHelperInterface jalapenoHelperInterface = this.getHelperForEmbedded(columnBasedField);
            return this.getInternalCachedValue(object, jalapenoHelperInterface, columnBasedField);
        }
        return this.getInternalCachedValue(this.mPojo, this.mHelper, columnBasedField);
    }

    private Object getInternalCachedValue(Object object, JalapenoHelperInterface jalapenoHelperInterface, ColumnBasedField columnBasedField) throws CacheException {
        int n = columnBasedField.getII();
        try {
            Object object2 = jalapenoHelperInterface.get(object, n);
            if (columnBasedField.isCollection()) {
                TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
                object2 = new QuickCollectionObject(tableBasedClass, object2);
            } else if (object2 != null && columnBasedField.isPersistent()) {
                JalapenoHelperInterface jalapenoHelperInterface2 = this.getHelperForReferenced(columnBasedField);
                if (jalapenoHelperInterface2.hasIdPlaceholder()) {
                    object2 = jalapenoHelperInterface2.getPojoId(object2);
                    return new Dataholder(1028, object2);
                }
                TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
                QuickPersistentObject quickPersistentObject = QuickPersistentObject.createPojoBackedObject(tableBasedClass, object2);
                return new Dataholder(1026, quickPersistentObject);
            }
            return Dataholder.create(object2);
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    @Override
    public void setInternalCachedValue(ColumnBasedField columnBasedField, Object object) throws CacheException {
        boolean bl;
        if (!PojoBackedStorage.isCacheable(columnBasedField)) {
            return;
        }
        if (PojoBackedStorage.isFromEmbeddedObject(columnBasedField)) {
            Object object2 = this.getEmbeddedObject(columnBasedField, true);
            JalapenoHelperInterface jalapenoHelperInterface = this.getHelperForEmbedded(columnBasedField);
            bl = PojoBackedStorage.setInternalCachedValue(object2, jalapenoHelperInterface, columnBasedField, object);
        } else {
            bl = PojoBackedStorage.setInternalCachedValue(this.mPojo, this.mHelper, columnBasedField, object);
        }
        if (bl) {
            int n = columnBasedField.getColumnIndexForSet();
            this.mSetValues[n] = true;
        }
    }

    private static boolean isCacheable(ColumnBasedField columnBasedField) throws CacheException {
        if (columnBasedField instanceof ColumnOnlyField) {
            return false;
        }
        if (columnBasedField.isLiteral()) {
            return true;
        }
        if (columnBasedField.isCollection() && columnBasedField.isElementDatatype()) {
            return true;
        }
        return columnBasedField.isPersistent();
    }

    private static boolean setInternalCachedValue(Object object, JalapenoHelperInterface jalapenoHelperInterface, ColumnBasedField columnBasedField, Object object2) throws CacheException {
        int n = columnBasedField.getII();
        try {
            if (columnBasedField.isLiteral()) {
                if (object2 instanceof Dataholder) {
                    Dataholder dataholder = (Dataholder)object2;
                    int n2 = ((QuickCacheField)columnBasedField).getJavaTypeDHType();
                    object2 = dataholder.getObject(n2);
                }
            } else if (columnBasedField.isCollection() && columnBasedField.isElementDatatype()) {
                if (object2 instanceof Dataholder) {
                    Dataholder dataholder = (Dataholder)object2;
                    CacheObject cacheObject = dataholder.getCacheObject();
                    object2 = cacheObject == null ? null : cacheObject.newJavaInstance(true);
                }
            } else {
                return false;
            }
            jalapenoHelperInterface.set(object, n, object2);
            return true;
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    @Override
    public void initCachedValues() throws CacheException {
        this.init();
        try {
            this.mPojo = this.mHelper.newInstance();
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    private void init() throws CacheException {
        LightDatabase lightDatabase = (LightDatabase)this.mParent.getDatabase();
        ClassLoader classLoader = lightDatabase.getClassLoader();
        try {
            if (this.mHelper == null) {
                this.mHelper = lightDatabase.getDetachedObjectsManager().getObjectFactory().getHelper(this.mParent.mClass, classLoader);
            }
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
        this.mSetValues = new boolean[this.mParent.mClass.getNumberOfCachedElements()];
    }

    @Override
    public void cleanupCachedValues() {
        this.mPojo = null;
        this.mSetValues = null;
    }

    @Override
    public QuickPersistentObject instantiate(TableBasedClass tableBasedClass, Object object, int n) throws CacheException {
        return QuickPersistentObject.createPojoBackedObject(tableBasedClass, object, n);
    }

    private static boolean isFromEmbeddedObject(ColumnBasedField columnBasedField) {
        SQLColumn sQLColumn = columnBasedField.getSQLColumn();
        if (sQLColumn == null) {
            return false;
        }
        return sQLColumn.isFromEmbeddedObject();
    }

    private JalapenoHelperInterface getHelperForEmbedded(ColumnBasedField columnBasedField) throws CacheException {
        CacheClass cacheClass = columnBasedField.getSQLColumn().getContainingClass();
        return this.getHelperForType(cacheClass);
    }

    private JalapenoHelperInterface getHelperForReferenced(ColumnBasedField columnBasedField) throws CacheException {
        CacheClass cacheClass = columnBasedField.getType();
        return this.getHelperForType(cacheClass);
    }

    private JalapenoHelperInterface getHelperForType(CacheClass cacheClass) throws CacheException {
        LightDatabase lightDatabase = (LightDatabase)this.mParent.getDatabase();
        ClassLoader classLoader = lightDatabase.getClassLoader();
        try {
            return lightDatabase.getDetachedObjectsManager().getObjectFactory().getHelper(cacheClass, classLoader);
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    private Object getEmbeddedObject(ColumnBasedField columnBasedField, boolean bl) throws CacheException {
        SQLColumn sQLColumn = columnBasedField.getSQLColumn();
        ArrayList<SQLColumn> arrayList = new ArrayList<SQLColumn>();
        while (sQLColumn.isFromEmbeddedObject()) {
            sQLColumn = sQLColumn.getContainingColumn();
            arrayList.add(sQLColumn);
        }
        try {
            Object object = this.mPojo;
            JalapenoHelperInterface jalapenoHelperInterface = this.mHelper;
            for (int i = arrayList.size(); i > 0; --i) {
                sQLColumn = (SQLColumn)arrayList.get(i - 1);
                ColumnBasedField columnBasedField2 = (ColumnBasedField)sQLColumn.getField();
                int n = columnBasedField2.getII();
                CacheClass cacheClass = columnBasedField2.getType();
                Object object2 = jalapenoHelperInterface.get(object, n);
                JalapenoHelperInterface jalapenoHelperInterface2 = this.getHelperForType(cacheClass);
                if (bl && object2 == null) {
                    object2 = jalapenoHelperInterface2.newInstance();
                    jalapenoHelperInterface.set(object, n, object2);
                } else if (object2 instanceof Dataholder) {
                    object2 = ((Dataholder)object2).getCacheObject().newJavaInstance(true);
                }
                if (object2 == null) {
                    return null;
                }
                object = object2;
                jalapenoHelperInterface = jalapenoHelperInterface2;
            }
            return object;
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }
}

