/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.classes.Compiler.LG.JavaConstraintDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import com.intersys.objects.reflect.UniqueIndexMetadata;
import java.util.List;

public class UniqueIndexMetadataImpl
implements UniqueIndexMetadata {
    private int[] mColumnNumbers;
    private SQLColumn[] mUniqueIndex;
    private TableMetadata mTable;
    private String mSQLName;
    private String mObjectName;
    private String mOpenMethodName;
    private int mIsRunnable;
    private String mProperties;
    private boolean mIsPrimary;
    private boolean mIsIdKey;

    protected UniqueIndexMetadataImpl(TableMetadata tableMetadata, CacheIndexInfo cacheIndexInfo, boolean bl) {
        if (cacheIndexInfo != null) {
            int[] nArray = cacheIndexInfo.getColumnNumbers();
            this.mIsRunnable = cacheIndexInfo.isRunnable();
            this.mColumnNumbers = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.mColumnNumbers[i] = cacheIndexInfo.getColumnNumbers()[i];
            }
            this.mSQLName = cacheIndexInfo.getSQLName();
            this.mObjectName = cacheIndexInfo.getObjectName();
            if (this.mIsRunnable != 0) {
                this.mOpenMethodName = this.mObjectName + "Open";
            }
            this.mIsIdKey = cacheIndexInfo.isIdKey();
        } else {
            this.mColumnNumbers = null;
        }
        this.mTable = tableMetadata;
        this.mIsPrimary = bl;
    }

    protected UniqueIndexMetadataImpl(TableMetadata tableMetadata, JavaConstraintDef javaConstraintDef, boolean bl) throws CacheException {
        if (javaConstraintDef != null) {
            List list = javaConstraintDef.getConstraintData();
            this.mIsRunnable = javaConstraintDef.getRunnable();
            this.mColumnNumbers = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                this.mColumnNumbers[i] = Integer.parseInt(string);
            }
            this.mSQLName = javaConstraintDef.getConstraintSQLName();
            this.mObjectName = javaConstraintDef.getConstraintObjectName();
            if (this.mIsRunnable != 0) {
                this.mOpenMethodName = this.mObjectName + "Open";
            }
        } else {
            this.mColumnNumbers = null;
        }
        this.mTable = tableMetadata;
        this.mIsPrimary = bl;
    }

    @Override
    public String getSQLName() {
        return this.mSQLName;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getTableName() {
        return this.mTable.getFullName();
    }

    @Override
    public String getOpenMethodName() {
        return this.mOpenMethodName;
    }

    @Override
    public SQLColumn[] getColumns() throws CacheException {
        if (this.mColumnNumbers == null) {
            return null;
        }
        if (this.mUniqueIndex != null) {
            return this.mUniqueIndex;
        }
        this.mUniqueIndex = new SQLColumn[this.mColumnNumbers.length];
        for (int i = 0; i < this.mColumnNumbers.length; ++i) {
            this.mUniqueIndex[i] = this.mTable.getColumn(this.mColumnNumbers[i]);
        }
        return this.mUniqueIndex;
    }

    @Override
    public String getColumnNames() throws CacheException {
        if (this.mColumnNumbers == null) {
            return null;
        }
        if (this.mUniqueIndex == null) {
            this.getColumns();
        }
        String string = "";
        for (int i = 0; i < this.mUniqueIndex.length; ++i) {
            string = string + this.mUniqueIndex[i].getName();
            if (i >= this.mUniqueIndex.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    @Override
    public int getLength() {
        if (this.mColumnNumbers == null) {
            return 0;
        }
        return this.mColumnNumbers.length;
    }

    @Override
    public int getColumnNumber(String string) throws CacheException {
        if (this.mUniqueIndex == null) {
            this.getColumns();
        }
        for (int i = 0; i < this.mUniqueIndex.length; ++i) {
            if (!string.equals(this.mUniqueIndex[i].getName())) continue;
            return i;
        }
        throw new CacheException("No column with name: " + string);
    }

    @Override
    public String getCondition() {
        return null;
    }

    @Override
    public boolean isExtent() {
        return false;
    }

    @Override
    public boolean isIdKey() {
        return this.mIsIdKey;
    }

    @Override
    public String getName() {
        return this.getObjectName();
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.mIsPrimary;
    }

    @Override
    public String getProperties() throws CacheException {
        if (this.mProperties == null) {
            SQLColumn[] sQLColumnArray = this.getColumns();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < sQLColumnArray.length; ++i) {
                String string = sQLColumnArray[i].getFieldName();
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(string);
            }
            this.mProperties = stringBuffer.toString();
        }
        return this.mProperties;
    }

    @Override
    public int[] getColumnNumbers() {
        return this.mColumnNumbers;
    }

    @Override
    public String[] getColumnArray() {
        throw new UnsupportedOperationException("Method getColumnArray() is not implemented in class com.intersys.cache.metadata.UniqueIndexMetadataImpl");
    }

    public String toString() {
        String string = this.getTableName() + ":" + this.getSQLName() + " {";
        try {
            string = string + this.getColumnNames();
        }
        catch (CacheException cacheException) {
            string = string + "<ERROR: " + cacheException.getMessage() + ">";
        }
        string = string + "}";
        return string;
    }

    @Override
    public int isRunnable() {
        return this.mIsRunnable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CandidateKeyInfo)) {
            return false;
        }
        if (object == null) {
            return false;
        }
        CandidateKeyInfo candidateKeyInfo = (CandidateKeyInfo)object;
        if (!this.getTableName().equals(candidateKeyInfo.getTableName())) {
            return false;
        }
        return this.getSQLName().equals(candidateKeyInfo.getSQLName());
    }

    public int hashCode() {
        return this.getTableName().hashCode() + this.getSQLName().hashCode();
    }

    @Override
    public String getObjectName() {
        return this.mObjectName;
    }

    @Override
    public int getSequenceNumber() {
        throw new UnsupportedOperationException("Method getSequenceNumber() is not implemented in class com.intersys.cache.metadata.UniqueIndexMetadataImpl");
    }

    @Override
    public String getType() {
        return "index";
    }

    @Override
    public String getData() {
        throw new UnsupportedOperationException("Method getData() is not implemented in class com.intersys.cache.metadata.UniqueIndexMetadataImpl");
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException("Method getDescription() is not implemented in class com.intersys.cache.metadata.UniqueIndexMetadataImpl");
    }
}

