/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.classes.Compiler.LG.JavaColumnDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.AbstractTypeInfoImpl;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;

abstract class ColumnMetadataImpl
extends AbstractTypeInfoImpl
implements SQLColumn,
Comparable {
    private String mFieldName;
    private CacheField mField;
    private String mName;
    private String mTypeName;
    private int mNumber;
    private int mContainingColumn;
    private String mExternalName;
    private String mInvoker;
    private String mNativeClass;
    private boolean mIsReference;
    private int mDataTypeColumn;
    private int mColumnModifiers;
    private int mJDBCType;
    TableMetadata mTable;
    CacheClassMetadataImpl mClass;
    private static final int IS_HIDDEN = 1;
    private static final int IS_ROW_ID_COLUMN = 2;
    private static final int IS_PARENT_ID_COLUMN = 4;
    private static final int IS_X_CLASSNAME = 8;
    private static final int IS_FOR_EMBEDDED_FIELD = 16;
    protected static final int IS_FROM_EMBEDDED_FIELD = 32;
    private static final int IS_DEFINED_IN_SUPER = 64;
    private static final int IS_INSERTABLE = 128;
    private static final int IS_UPDATEABLE = 256;
    private static final int TO_BE_INSTANTIATED_FROM_EMBEDDED = 512;
    private int mTypeModifier;

    ColumnMetadataImpl(TableMetadata tableMetadata, CacheClassMetadataImpl cacheClassMetadataImpl, CacheClassMetadataImpl cacheClassMetadataImpl2, JavaColumnDef javaColumnDef) throws CacheException {
        this.mTable = tableMetadata;
        this.mFieldName = javaColumnDef.getpropName();
        this.mName = javaColumnDef.getname();
        if (this.mFieldName == null) {
            this.mFieldName = this.mName;
        }
        this.mNumber = javaColumnDef.getcolNumber();
        this.mClass = cacheClassMetadataImpl;
        if (cacheClassMetadataImpl2 == null) {
            cacheClassMetadataImpl2 = cacheClassMetadataImpl;
        }
        this.mContainingColumn = javaColumnDef.getcontainingColumn();
        this.mExternalName = javaColumnDef.getExternalName();
        if (this.mExternalName == null) {
            this.mExternalName = this.mName;
        }
        this.mIsReference = javaColumnDef.getIsReference();
        this.mDataTypeColumn = javaColumnDef.getDataTypeColumn();
        this.mJDBCType = javaColumnDef.getJDBCCode();
        this.mInvoker = cacheClassMetadataImpl2.lookupName(javaColumnDef.getInvoker());
        this.mNativeClass = cacheClassMetadataImpl2.lookupName(javaColumnDef.getNativeClass());
        this.mTypeName = this.mIsReference ? cacheClassMetadataImpl2.lookupName(javaColumnDef.getReferenceClass()) : cacheClassMetadataImpl2.lookupName(javaColumnDef.getDataType());
        this.mColumnModifiers = 0;
        if (javaColumnDef.getisHidden()) {
            this.mColumnModifiers |= 1;
        }
        if (javaColumnDef.getisRowID()) {
            this.mColumnModifiers |= 2;
        }
        if (javaColumnDef.getisXClassName()) {
            this.mColumnModifiers |= 8;
        }
        if (javaColumnDef.getisEmbedded()) {
            this.mColumnModifiers |= 0x10;
        }
        if (javaColumnDef.getisContainedInEmbedded()) {
            this.mColumnModifiers |= 0x20;
        }
        if (javaColumnDef.getToBeInstantiatedFromEmbedded()) {
            this.mColumnModifiers |= 0x200;
        }
        if (javaColumnDef.getisDefinedInSuper()) {
            this.mColumnModifiers |= 0x40;
        }
        if (javaColumnDef.getInsertable()) {
            this.mColumnModifiers |= 0x80;
        }
        if (javaColumnDef.getUpdateable()) {
            this.mColumnModifiers |= 0x100;
        }
        if (javaColumnDef.getcolNumber() == 0) {
            this.mColumnModifiers |= 4;
        }
        this.constructTypeModifier(javaColumnDef);
    }

    @Override
    public String getFieldName() {
        return this.mFieldName;
    }

    @Override
    public CacheField getField() throws CacheException {
        if (this.mField == null) {
            if (this.mClass == null) {
                return null;
            }
            if (this.mClass instanceof TableBasedClass) {
                this.mField = ((TableBasedClass)((Object)this.mClass)).getColumnBasedField(this);
            } else {
                if (this.mFieldName == null) {
                    return null;
                }
                this.mField = this.mClass.getField(this.mFieldName);
            }
        }
        return this.mField;
    }

    @Override
    public boolean isVersionColumn() throws CacheException {
        CacheField cacheField = this.getField();
        if (cacheField == null) {
            return false;
        }
        return cacheField.isVersionField();
    }

    @Override
    public TableMetadata getContainingTable() {
        return this.mTable;
    }

    @Override
    public CacheClass getContainingClass() throws CacheException {
        if (!this.isFromEmbeddedObject()) {
            return this.mClass;
        }
        CacheClass cacheClass = null;
        SQLColumn sQLColumn = this.getContainingColumn();
        if (sQLColumn != null) {
            cacheClass = sQLColumn.getContainingClass();
            CacheField cacheField = cacheClass.getField(sQLColumn.getFieldName());
            if (cacheField != null) {
                return cacheField.getType();
            }
            return cacheClass;
        }
        throw new SystemError("No parent column for column " + this.getName() + " in table " + this.mTable.getName());
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public int getNumber() {
        return this.mNumber;
    }

    public Integer getNumberWrapper() {
        return new Integer(this.getNumber());
    }

    @Override
    public boolean isHidden() {
        return (this.mColumnModifiers & 1) != 0;
    }

    @Override
    public boolean isParentIdColumn() {
        return (this.mColumnModifiers & 4) != 0;
    }

    @Override
    public boolean isRowIdColumn() {
        return (this.mColumnModifiers & 2) != 0;
    }

    @Override
    public int getContainingColumnNumber() {
        return this.mContainingColumn;
    }

    @Override
    public SQLColumn getContainingColumn() {
        if (this.getContainingColumnNumber() == -1) {
            return null;
        }
        try {
            return this.mTable.getColumn(this.getContainingColumnNumber());
        }
        catch (CacheException cacheException) {
            return null;
        }
    }

    @Override
    public boolean isDefinedInSuper() {
        return (this.mColumnModifiers & 0x40) != 0;
    }

    @Override
    public final boolean isForSerialField() {
        return (this.mColumnModifiers & 0x10) != 0;
    }

    @Override
    public final boolean isFromSerialField() {
        return (this.mColumnModifiers & 0x20) != 0;
    }

    @Override
    public final boolean isFromEmbeddedObject() {
        return (this.mColumnModifiers & 0x200) != 0;
    }

    @Override
    public final boolean isForEmbeddedObject() {
        return this.isForSerialField();
    }

    @Override
    public boolean isXClassName() {
        return (this.mColumnModifiers & 8) != 0;
    }

    @Override
    public boolean isInsertable() {
        return (this.mColumnModifiers & 0x80) != 0;
    }

    @Override
    public boolean isUpdateable() {
        return (this.mColumnModifiers & 0x100) != 0;
    }

    public int compareTo(Object object) {
        if (object instanceof Integer) {
            return this.getNumberWrapper().compareTo((Integer)object);
        }
        ColumnMetadataImpl columnMetadataImpl = (ColumnMetadataImpl)object;
        return this.getNumberWrapper().compareTo(columnMetadataImpl.getNumberWrapper());
    }

    protected void constructTypeModifier(JavaColumnDef javaColumnDef) throws CacheException {
        int n;
        this.clearTypeModifier();
        String string = this.mClass.lookupName(javaColumnDef.getCollectionType());
        if (string != null) {
            if (string.equals("ARRAY")) {
                this.addTypeModifier(1);
            } else if (string.equals("LIST")) {
                this.addTypeModifier(8);
            }
        }
        if ((n = javaColumnDef.getclassType()) == 1) {
            this.addTypeModifier(4608);
        } else if (n == 2) {
            this.addTypeModifier(8704);
        } else if (n == 3) {
            this.addTypeModifier(256);
        }
    }

    public final void clearTypeModifier() {
        this.mTypeModifier = 0;
    }

    public final void clearColumnModifier(int n) {
        this.mColumnModifiers &= ~n;
    }

    public final void addTypeModifier(int n) {
        this.mTypeModifier |= n;
    }

    @Override
    public int getTypeModifiers() {
        return this.mTypeModifier;
    }

    @Override
    public String getExternalName() {
        return this.mExternalName;
    }

    @Override
    public int getDataTypeColumn() {
        return this.mDataTypeColumn;
    }

    @Override
    public boolean isReference() {
        return this.mIsReference;
    }

    @Override
    public String getTypeName() {
        return this.mTypeName;
    }

    @Override
    public int getJDBCType() {
        return this.mJDBCType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SQLColumn)) {
            return false;
        }
        SQLColumn sQLColumn = (SQLColumn)object;
        if (!this.mName.equals(sQLColumn.getName())) {
            return false;
        }
        if (this.mNumber != sQLColumn.getNumber()) {
            return false;
        }
        return this.mTable.getName().equals(sQLColumn.getContainingTable().getName());
    }

    @Override
    public String getNativeClass() {
        return this.mNativeClass;
    }

    @Override
    public String getInvoker() {
        return this.mInvoker;
    }

    public String toString() {
        String string = this.mTable != null ? this.mTable.getFullName() : "";
        return string + "." + this.mName + "[" + this.mNumber + "]";
    }
}

