/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.objects.reflect.CacheFieldInfo;
import com.intersys.objects.reflect.CacheMethodMetadata;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Iterator {
    Object[] mArr;
    int cur;

    public ArrayIterator(Object[] objectArray) {
        this.mArr = objectArray;
        this.cur = 0;
    }

    @Override
    public boolean hasNext() {
        return this.cur < this.mArr.length;
    }

    public Object next() {
        if (this.hasNext()) {
            return this.mArr[this.cur++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class MethodSignatureIterator
    extends ArrayIterator {
        public MethodSignatureIterator(CacheMethodMetadata[] cacheMethodMetadataArray) {
            super(cacheMethodMetadataArray);
        }

        @Override
        public Object next() {
            CacheMethodMetadata cacheMethodMetadata = (CacheMethodMetadata)super.next();
            try {
                return cacheMethodMetadata.getSignature();
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage());
            }
        }
    }

    public static class FieldNameIterator
    extends ArrayIterator {
        public FieldNameIterator(CacheFieldInfo[] cacheFieldInfoArray) {
            super(cacheFieldInfoArray);
        }

        @Override
        public Object next() {
            CacheFieldInfo cacheFieldInfo = (CacheFieldInfo)super.next();
            return cacheFieldInfo.getName();
        }
    }
}

