/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jdbcutil;

import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.jdbcutil.RDBMSAdapter;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CacheUnsupportedProtocolException;
import com.intersys.objects.ObjectServerInfo;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCAdapter
extends RDBMSAdapter {
    protected static final String helperReflectClass = "%Library.CPPStoredProc";
    private int mReflectVersion = -1;
    private static String versionString = "{ ? = call %Library.CPPStoredProc_getVersion }";
    private CallableStatement mVersionCommand;
    protected ConnectionInfo mConnectionInfo;

    public JDBCAdapter(Connection connection) throws CacheException {
        super(connection);
    }

    private synchronized void initReflectionVersion() throws CacheServerException {
        block6: {
            if (this.mReflectVersion >= 0) {
                return;
            }
            try {
                try {
                    this.mVersionCommand = JDBCAdapter.prepareCall(this.mConnection, versionString);
                    this.mVersionCommand.registerOutParameter(1, 4);
                    this.runReflectionVersionSP();
                    this.mReflectVersion = this.mVersionCommand.getInt(1);
                }
                catch (CacheServerException cacheServerException) {
                    int n = cacheServerException.getCode();
                    if (n == 428) {
                        this.mReflectVersion = 1;
                        break block6;
                    }
                    throw cacheServerException;
                }
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
            }
        }
    }

    public void runReflectionVersionSP() throws CacheServerException {
        this.execute(this.mVersionCommand, versionString);
    }

    public synchronized int getReflectionVersion() throws CacheServerException {
        if (this.mReflectVersion <= 0) {
            this.initReflectionVersion();
        }
        return this.mReflectVersion;
    }

    @Override
    public void close(boolean bl) throws CacheServerException {
        try {
            if (this.mCountCommand != null) {
                this.mCountCommand.close();
            }
            if (this.mVersionCommand != null) {
                this.mVersionCommand.close();
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to close prepared statements: ", sQLException));
        }
        super.close(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheConnection getCacheConnection(Connection connection) throws CacheServerException {
        if (connection instanceof CacheConnection) {
            return (CacheConnection)connection;
        }
        try {
            CacheConnection cacheConnection;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery("**getQuickStatement**");
                cacheConnection = (CacheConnection)resultSet.getObject("**CacheConnection**");
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    finally {
                        statement.close();
                    }
                }
            }
            if (cacheConnection == null) {
                throw new CacheServerException("JDBC Connection object used is not obtained through Cache driver");
            }
            return cacheConnection;
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to obtain Cache Driver Connection. Probably JDBC Connection object used is not obtained through Cache driver");
        }
    }

    public ResultSet getCacheResultSet(String string) throws CacheServerException {
        CacheConnection cacheConnection = JDBCAdapter.getCacheConnection(this.mConnection);
        try {
            return cacheConnection.getCacheResultSet(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create java.sql.ResultSet by oref " + string);
        }
    }

    protected static String parametersErrorText(SQLException sQLException) {
        return JDBCAdapter.sqlErrorText("Failed to set parameters.", sQLException);
    }

    protected static String resultErrorText(SQLException sQLException, String string) {
        return JDBCAdapter.sqlErrorText("Failed to get the result of executing " + string, sQLException);
    }

    public void setupServerInfo(ObjectServerInfo objectServerInfo) throws CacheException {
        try {
            CacheConnection cacheConnection;
            block10: {
                int n;
                cacheConnection = (CacheConnection)this.mConnection;
                DatabaseMetaData databaseMetaData = cacheConnection.getMetaData();
                objectServerInfo.cacheSystemVersion = databaseMetaData.getDatabaseProductName();
                objectServerInfo.cacheObjectVersion = databaseMetaData.getDatabaseProductVersion();
                String string = "Cache Objects Version";
                if (objectServerInfo.cacheObjectVersion.startsWith(string)) {
                    objectServerInfo.cacheObjectVersion = objectServerInfo.cacheObjectVersion.substring(string.length());
                }
                objectServerInfo.cacheObjectVersion = objectServerInfo.cacheObjectVersion.trim();
                objectServerInfo.protocolClientVersion = objectServerInfo.protocolServerVersion = databaseMetaData.getDriverVersion();
                objectServerInfo.connectionInfo = databaseMetaData.getURL();
                objectServerInfo.isUnicode = cacheConnection.isServerUnicode();
                objectServerInfo.locale = objectServerInfo.isUnicode ? "UTF-8" : cacheConnection.getServerLocale();
                objectServerInfo.namespace = cacheConnection.getCatalog();
                if (objectServerInfo.namespace == null) {
                    String string2 = objectServerInfo.connectionInfo;
                    n = string2.indexOf("//");
                    int n2 = string2.indexOf(47, n + 2);
                    int n3 = string2.indexOf(47, n2 + 1);
                    objectServerInfo.namespace = n3 > 0 ? string2.substring(n2 + 1, n3) : string2.substring(n2 + 1);
                }
                objectServerInfo.processNumberString = cacheConnection.getCacheJobID();
                try {
                    objectServerInfo.processNumber = Long.parseLong(objectServerInfo.processNumberString);
                }
                catch (NumberFormatException numberFormatException) {
                    n = objectServerInfo.processNumberString.indexOf(58);
                    if (n <= 0) break block10;
                    String string3 = objectServerInfo.processNumberString.substring(0, n);
                    try {
                        objectServerInfo.processNumber = Long.parseLong(string3);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
            }
            objectServerInfo.IEEEDoubleSupported = cacheConnection.getConnectionInfo().isIEEEDoubleSupported();
            if (objectServerInfo.getMajorObjectVersion() < 2010) {
                objectServerInfo.clientVersionSupported = false;
                boolean bl = ConnectionUtils.determineUnsupportedServerOK();
                if (!bl) {
                    throw new CacheUnsupportedProtocolException(objectServerInfo, 2010);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Can not determine server metadata");
        }
        objectServerInfo.clientVersionSupported = true;
    }
}

