/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.LockAware15;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class LockAware
extends LockAware15 {
    public static final boolean ASSERT_LOCKS;
    private static Boolean TEST_MONITORS;
    private static Boolean TEST_LOCKS;

    private boolean owns(LockInfo lockInfo, Object object) {
        if (lockInfo == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        String string = object.getClass().getName();
        int n = System.identityHashCode(object);
        return string.equals(lockInfo.getClassName()) && n == lockInfo.getIdentityHashCode();
    }

    public static synchronized boolean lockControlSupported() {
        if (TEST_MONITORS == null || TEST_LOCKS == null) {
            LockAware.init(null);
        }
        return TEST_MONITORS != false && TEST_LOCKS != false;
    }

    private static synchronized void init(ThreadMXBean threadMXBean) {
        if (threadMXBean == null) {
            threadMXBean = ManagementFactory.getThreadMXBean();
        }
        TEST_MONITORS = threadMXBean.isObjectMonitorUsageSupported();
        TEST_LOCKS = threadMXBean.isSynchronizerUsageSupported();
    }

    @Override
    public boolean isLockedByCurrentThread() {
        return this.isLockedByCurrentThread(this);
    }

    @Override
    public boolean isLockedByCurrentThread(Object object) {
        LockInfo[] lockInfoArray;
        long l;
        ThreadInfo threadInfo;
        MonitorInfo[] monitorInfoArray;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (TEST_MONITORS == null || TEST_LOCKS == null) {
            LockAware.init(threadMXBean);
        }
        if ((monitorInfoArray = (threadInfo = threadMXBean.getThreadInfo(new long[]{l = Thread.currentThread().getId()}, TEST_MONITORS, TEST_LOCKS)[0]).getLockedMonitors()) != null) {
            lockInfoArray = monitorInfoArray;
            int n = lockInfoArray.length;
            for (int i = 0; i < n; ++i) {
                LockInfo lockInfo = lockInfoArray[i];
                if (!this.owns(lockInfo, object)) continue;
                return true;
            }
        }
        if ((lockInfoArray = threadInfo.getLockedSynchronizers()) != null) {
            for (LockInfo lockInfo : lockInfoArray) {
                if (!this.owns(lockInfo, object)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        TEST_MONITORS = null;
        TEST_LOCKS = null;
        String string = System.getProperty("com.intersys.debug.assertLocks");
        boolean bl = false;
        if (string != null) {
            if ("true".equalsIgnoreCase(string)) {
                bl = true;
            } else if ("1".equals(string)) {
                bl = true;
            }
        }
        ASSERT_LOCKS = bl;
    }
}

