/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.CacheEvent;
import com.intersys.cache.CacheEventListener;
import com.intersys.cache.CacheObject;
import com.intersys.cache.DatabaseWithReferenceMap;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.Oid;
import com.intersys.objects.ReferenceCountingException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractCacheObject
implements CacheObject {
    static final int CLOSED_OREF = -123;
    protected SysDatabase mDB;
    protected String mTypeName;
    private int mRef = -123;
    private boolean mAssertNotClosed = false;
    protected int mServerSideReferences = 0;
    protected CacheClass mCacheClass = null;
    private Object mUserData = null;
    private int mOrefBeforeClose = 0;
    private int mCount = -1;
    private boolean mClosedAtOnce = false;
    private Set mLockedThreads;
    protected int mState;

    protected AbstractCacheObject(Database database, String string, int n) {
        this.mDB = (SysDatabase)database;
        this.mTypeName = string;
        this.mRef = n;
        this.mLockedThreads = new HashSet();
    }

    @Override
    public CacheObject getMe() {
        return this;
    }

    @Override
    public String getTypeName() {
        return this.mTypeName;
    }

    @Override
    public SysDatabase getDatabase() {
        return this.mDB;
    }

    @Override
    public final int getOref() throws ObjectClosedException {
        if (this.mRef == -123) {
            throw new ObjectClosedException((CacheObject)this, this.mOrefBeforeClose);
        }
        return this.mRef;
    }

    protected final int getOrefForced() throws ObjectClosedException {
        if (this.mRef == -123) {
            if (this.mOrefBeforeClose <= 0) {
                throw new ObjectClosedException((CacheObject)this, "Attempt to access object that was never opened");
            }
            return this.mOrefBeforeClose;
        }
        return this.mRef;
    }

    private Id getIdInternal() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder dataholder = this.runInstanceMethod("%Id", dataholderArray, 0);
        return new Id(dataholder.getString());
    }

    protected Oid getOidInternal() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder dataholder = this.runInstanceMethod("%Oid", dataholderArray, 0);
        return new Oid(dataholder.getBinary());
    }

    @Override
    public int save(boolean bl) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(bl)};
        Dataholder dataholder = this.runInstanceMethod("%Save", dataholderArray, 0);
        return this.mDB.parseStatus(dataholder);
    }

    @Override
    public int saveRequiredFields() throws CacheException {
        return this.save(false);
    }

    @Override
    public Object getSerialState(Object object) throws CacheException {
        throw new CacheException("Object of class " + this.getCacheClass().getName() + " is not serializable.");
    }

    @Override
    public Dataholder runInstanceMethod(String string, Dataholder[] dataholderArray, int n) throws CacheException {
        int[] nArray = new int[]{};
        Dataholder[] dataholderArray2 = this.runInstanceMethod(string, nArray, dataholderArray, n);
        return dataholderArray2[0];
    }

    @Override
    public void increaseReferenceCount() throws CacheException {
        ++this.mServerSideReferences;
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println("ref count for oref " + this.getOref() + " now is " + this.mServerSideReferences);
        }
    }

    @Override
    public void decreaseReferenceCount() throws CacheException {
        --this.mServerSideReferences;
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println("ref count for oref " + this.getOref() + " now is " + this.mServerSideReferences);
        }
    }

    @Override
    public Object newJavaInstance() throws CacheException {
        return this.newJavaInstance(false);
    }

    @Override
    public Object newJavaInstance(boolean bl) throws CacheException {
        return this.getCacheClass().newInstance(this, bl);
    }

    @Override
    public CacheClass getCacheClass() throws CacheException {
        if (this.mCacheClass == null) {
            Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(true)};
            Dataholder dataholder = this.runInstanceMethod("%ClassName", dataholderArray, 0);
            String string = dataholder.getString();
            this.mCacheClass = this.mDB.getCacheClass(string);
            this.mTypeName = string;
        }
        return this.mCacheClass;
    }

    @Override
    public void setCacheClass(CacheClass cacheClass) throws CacheException {
        if (this.mCacheClass != null && cacheClass != null && !this.mCacheClass.equals(cacheClass)) {
            throw new SystemError("Attempt to replace CacheClass mCacheClass=" + this.mCacheClass.getName() + " with cl=" + cacheClass.getName());
        }
        this.mCacheClass = cacheClass;
        if (cacheClass != null) {
            this.mTypeName = this.mCacheClass.getName();
        }
    }

    public boolean equals(Object object) {
        try {
            CacheObject cacheObject = (CacheObject)object;
            return this.getOref() == cacheObject.getOref();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    public int hashCode() {
        int n = this.getDatabase().hashCode();
        int n2 = this.mRef > 0 ? 0 : this.mRef;
        return (n >>= 16) + (n2 <<= 16);
    }

    @Override
    public void forceClose() throws CacheException {
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println("Forcibly closed Oref " + this.getOref() + ": " + this.mCount);
        }
        this.close();
        this.sendEvent(200);
        this.removeFromMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseCount() throws CacheException {
        if (this.mCount == 0) {
            SysDatabase sysDatabase = this.mDB;
            synchronized (sysDatabase) {
                this.increaseCountSynchronized();
            }
        } else if (this.mCount != 0) {
            this.increaseCountSynchronized();
        } else {
            this.increaseCount();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void increaseCountSynchronized() throws CacheException {
        if (this.mRef == -123) {
            if (!this.mClosedAtOnce) throw new ObjectClosedException((CacheObject)this, this.mOrefBeforeClose);
            this.mCount = 0;
            this.mClosedAtOnce = false;
            this.mRef = this.mOrefBeforeClose;
            this.mOrefBeforeClose = 0;
        } else if (this.mCount == 0) {
            if (!this.isLockedByMe()) {
                throw new SystemError("Discarded obj is not locked: " + this.mRef);
            }
            DatabaseWithReferenceMap databaseWithReferenceMap = (DatabaseWithReferenceMap)this.mDB;
            if (Logger.getDebugReferenceCountLevel() > 2) {
                Logger.out.println(this.getOref() + ": " + this.toString());
            }
            databaseWithReferenceMap.objectReinstated(this.mRef, this);
        } else if (this.mCount == -1) {
            this.mCount = 0;
        }
        this.unlock();
        ++this.mCount;
        if (Logger.getDebugReferenceCountLevel() <= 2) return;
        Logger.out.println("Increase local count for " + this.getOref() + ": " + this.mCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decreaseCount() throws CacheException {
        SysDatabase sysDatabase = this.mDB;
        synchronized (sysDatabase) {
            this.decreaseCountSynchronized();
        }
    }

    public synchronized void decreaseCountSynchronized() throws CacheException {
        if (this.mRef == -123) {
            throw new ObjectClosedException((CacheObject)this, this.mOrefBeforeClose);
        }
        if (this.mCount <= 0) {
            throw new ReferenceCountingException("Attempt to decrease zero reference count for oref " + this.mRef);
        }
        --this.mCount;
        if (Logger.getDebugReferenceCountLevel() > 2) {
            Logger.out.println("Decrease local count for " + this.getOref() + ": " + this.mCount);
        }
        if (this.mCount == 0) {
            if (this.mAssertNotClosed) {
                String string = "Object with oref " + this.mRef + " registered for assertion " + "and is being closed";
                CacheException cacheException = new CacheException(string);
                cacheException.printStackTrace();
                if (Logger.getDebugReferenceCountLevel() > 2) {
                    cacheException.printStackTrace(Logger.out);
                }
                throw cacheException;
            }
            DatabaseWithReferenceMap databaseWithReferenceMap = (DatabaseWithReferenceMap)this.mDB;
            if (Logger.getDebugReferenceCountLevel() > 2) {
                Logger.out.println(this.getOref() + ": " + this.toString());
            }
            databaseWithReferenceMap.objectDiscarded(this.getOref());
            this.sendEvent(100);
        } else if (this.mAssertNotClosed && Logger.getDebugReferenceCountLevel() > 2) {
            String string = "Object with oref " + this.mRef + " registered for assertion. " + "Its reference count was decreased.";
            CacheException cacheException = new CacheException(string);
            cacheException.printStackTrace(Logger.out);
        }
    }

    @Override
    public void assertNotClosed(boolean bl) throws CacheException {
        if (this.isClosed()) {
            throw new ObjectClosedException((CacheObject)this, this.mOrefBeforeClose);
        }
        this.mAssertNotClosed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseCountImmediately() throws CacheException {
        SysDatabase sysDatabase = this.mDB;
        synchronized (sysDatabase) {
            if (this.mRef == -123) {
                throw new ObjectClosedException((CacheObject)this, this.mOrefBeforeClose);
            }
            if (this.mCount <= 0) {
                throw new ReferenceCountingException("Attempt to decrease zero reference count for oref " + this.mRef);
            }
            AbstractCacheObject abstractCacheObject = this;
            synchronized (abstractCacheObject) {
                --this.mCount;
            }
            if (Logger.getDebugReferenceCountLevel() > 2) {
                Logger.out.println("Decrease local count for " + this.getOref() + ": " + this.mCount);
            }
            if (this.mCount == 0) {
                if (Logger.getDebugReferenceCountLevel() > 2) {
                    Logger.out.println(this.getOref() + ": " + this.toString());
                }
                this.close();
                this.removeFromMap();
            }
        }
    }

    protected void sendEvent(int n) throws CacheException {
        if (this.mUserData instanceof CacheEventListener) {
            CacheEventListener cacheEventListener = (CacheEventListener)this.mUserData;
            CacheEvent cacheEvent = new CacheEvent(n, this);
            cacheEventListener.handleEvent(cacheEvent);
        }
    }

    @Override
    public Id getId() throws CacheException {
        return this.getOid().getId();
    }

    @Override
    public boolean isClosed() {
        return this.mRef == -123;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lock() {
        Set set = this.mLockedThreads;
        synchronized (set) {
            return this.mLockedThreads.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock() {
        Set set = this.mLockedThreads;
        synchronized (set) {
            return this.mLockedThreads.remove(Thread.currentThread());
        }
    }

    public boolean isLocked() {
        return !this.mLockedThreads.isEmpty();
    }

    public boolean isLockedByMe() {
        return this.mLockedThreads.contains(Thread.currentThread());
    }

    @Override
    public void setUserData(Object object) {
        this.mUserData = object;
    }

    @Override
    public Object getUserData() {
        return this.mUserData;
    }

    protected abstract void close() throws CacheException;

    protected void removeFromMap() throws CacheException {
        DatabaseWithReferenceMap databaseWithReferenceMap = (DatabaseWithReferenceMap)this.mDB;
        databaseWithReferenceMap.removeObjectFromMap(this.getOref());
        this.setOrefClosed();
    }

    void setOrefClosed() {
        this.mOrefBeforeClose = this.mRef;
        this.mRef = -123;
    }

    public String toString() {
        return super.toString() + '[' + String.valueOf(this.mRef) + ']';
    }

    @Override
    public String toOrefString() throws CacheException {
        return String.valueOf(this.mRef) + '@' + this.getCacheClass().getName();
    }

    @Override
    public void setStateReadDirty() {
        this.mState |= 0xFF01;
    }

    @Override
    public Object getPojo() {
        return null;
    }

    @Override
    public void setPojo(Object object) {
    }

    protected void finalize() throws Throwable {
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public void clearReadState() {
        this.mState &= 0xFFFFFFF0;
    }
}

