/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse;

public class DescribeDBSecurityGroupsIterable
implements SdkIterable<DescribeDbSecurityGroupsResponse> {
    private final RdsClient client;
    private final DescribeDbSecurityGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBSecurityGroupsIterable(RdsClient client, DescribeDbSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeDbSecurityGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBSecurityGroup> dbSecurityGroups() {
        Function<DescribeDbSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSecurityGroups() != null) {
                return response.dbSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbSecurityGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDbSecurityGroupsResponse> {
        private DescribeDbSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbSecurityGroupsResponse nextPage(DescribeDbSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSecurityGroupsIterable.this.client.describeDBSecurityGroups(DescribeDBSecurityGroupsIterable.this.firstRequest);
            }
            return DescribeDBSecurityGroupsIterable.this.client.describeDBSecurityGroups((DescribeDbSecurityGroupsRequest)((Object)DescribeDBSecurityGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

