/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.ActivityStreamMode;
import software.amazon.awssdk.services.rds.model.ActivityStreamStatus;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartActivityStreamResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, StartActivityStreamResponse> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(StartActivityStreamResponse.getter(StartActivityStreamResponse::kmsKeyId)).setter(StartActivityStreamResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> KINESIS_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KinesisStreamName").getter(StartActivityStreamResponse.getter(StartActivityStreamResponse::kinesisStreamName)).setter(StartActivityStreamResponse.setter(Builder::kinesisStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StartActivityStreamResponse.getter(StartActivityStreamResponse::statusAsString)).setter(StartActivityStreamResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(StartActivityStreamResponse.getter(StartActivityStreamResponse::modeAsString)).setter(StartActivityStreamResponse.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyImmediately").getter(StartActivityStreamResponse.getter(StartActivityStreamResponse::applyImmediately)).setter(StartActivityStreamResponse.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final SdkField<Boolean> ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EngineNativeAuditFieldsIncluded").getter(StartActivityStreamResponse.getter(StartActivityStreamResponse::engineNativeAuditFieldsIncluded)).setter(StartActivityStreamResponse.setter(Builder::engineNativeAuditFieldsIncluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineNativeAuditFieldsIncluded").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, KINESIS_STREAM_NAME_FIELD, STATUS_FIELD, MODE_FIELD, APPLY_IMMEDIATELY_FIELD, ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD));
    private final String kmsKeyId;
    private final String kinesisStreamName;
    private final String status;
    private final String mode;
    private final Boolean applyImmediately;
    private final Boolean engineNativeAuditFieldsIncluded;

    private StartActivityStreamResponse(BuilderImpl builder) {
        super(builder);
        this.kmsKeyId = builder.kmsKeyId;
        this.kinesisStreamName = builder.kinesisStreamName;
        this.status = builder.status;
        this.mode = builder.mode;
        this.applyImmediately = builder.applyImmediately;
        this.engineNativeAuditFieldsIncluded = builder.engineNativeAuditFieldsIncluded;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String kinesisStreamName() {
        return this.kinesisStreamName;
    }

    public final ActivityStreamStatus status() {
        return ActivityStreamStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ActivityStreamMode mode() {
        return ActivityStreamMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public final Boolean engineNativeAuditFieldsIncluded() {
        return this.engineNativeAuditFieldsIncluded;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineNativeAuditFieldsIncluded());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartActivityStreamResponse)) {
            return false;
        }
        StartActivityStreamResponse other = (StartActivityStreamResponse)((Object)obj);
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.kinesisStreamName(), other.kinesisStreamName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.engineNativeAuditFieldsIncluded(), other.engineNativeAuditFieldsIncluded());
    }

    public final String toString() {
        return ToString.builder((String)"StartActivityStreamResponse").add("KmsKeyId", (Object)this.kmsKeyId()).add("KinesisStreamName", (Object)this.kinesisStreamName()).add("Status", (Object)this.statusAsString()).add("Mode", (Object)this.modeAsString()).add("ApplyImmediately", (Object)this.applyImmediately()).add("EngineNativeAuditFieldsIncluded", (Object)this.engineNativeAuditFieldsIncluded()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "KinesisStreamName": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "EngineNativeAuditFieldsIncluded": {
                return Optional.ofNullable(clazz.cast(this.engineNativeAuditFieldsIncluded()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartActivityStreamResponse, T> g) {
        return obj -> g.apply((StartActivityStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String kinesisStreamName;
        private String status;
        private String mode;
        private Boolean applyImmediately;
        private Boolean engineNativeAuditFieldsIncluded;

        private BuilderImpl() {
        }

        private BuilderImpl(StartActivityStreamResponse model) {
            super(model);
            this.kmsKeyId(model.kmsKeyId);
            this.kinesisStreamName(model.kinesisStreamName);
            this.status(model.status);
            this.mode(model.mode);
            this.applyImmediately(model.applyImmediately);
            this.engineNativeAuditFieldsIncluded(model.engineNativeAuditFieldsIncluded);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getKinesisStreamName() {
            return this.kinesisStreamName;
        }

        public final void setKinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
        }

        @Override
        @Transient
        public final Builder kinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ActivityStreamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        @Transient
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        @Transient
        public final Builder mode(ActivityStreamMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        @Transient
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final Boolean getEngineNativeAuditFieldsIncluded() {
            return this.engineNativeAuditFieldsIncluded;
        }

        public final void setEngineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded) {
            this.engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded;
        }

        @Override
        @Transient
        public final Builder engineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded) {
            this.engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded;
            return this;
        }

        @Override
        public StartActivityStreamResponse build() {
            return new StartActivityStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartActivityStreamResponse> {
        public Builder kmsKeyId(String var1);

        public Builder kinesisStreamName(String var1);

        public Builder status(String var1);

        public Builder status(ActivityStreamStatus var1);

        public Builder mode(String var1);

        public Builder mode(ActivityStreamMode var1);

        public Builder applyImmediately(Boolean var1);

        public Builder engineNativeAuditFieldsIncluded(Boolean var1);
    }
}

