/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EngineFamily {
    MYSQL("MYSQL"),
    POSTGRESQL("POSTGRESQL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EngineFamily> VALUE_MAP;
    private final String value;

    private EngineFamily(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EngineFamily fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EngineFamily> knownValues() {
        EnumSet<EngineFamily> knownValues = EnumSet.allOf(EngineFamily.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EngineFamily.class, EngineFamily::toString);
    }
}

