/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils.yasjl;

import com.couchbase.client.core.utils.yasjl.Callbacks.JsonPointerCB;
import com.couchbase.client.core.utils.yasjl.JsonPointer;
import java.util.ArrayList;
import java.util.List;

public class JsonPointerTree {
    private final Node root = new Node("", null);
    private boolean isRootAPointer = false;

    JsonPointerTree() {
    }

    boolean addJsonPointer(JsonPointer jp) {
        if (this.isRootAPointer) {
            return false;
        }
        List<String> jpRefTokens = jp.tokens();
        int jpSize = jpRefTokens.size();
        if (jpSize == 1) {
            this.isRootAPointer = true;
            return true;
        }
        Node parent = this.root;
        boolean pathDoesNotExist = false;
        for (int i = 1; i < jpSize; ++i) {
            Node childMatch = parent.match(jpRefTokens.get(i));
            if (childMatch == null) {
                parent = parent.addChild(jpRefTokens.get(i), jp.jsonPointerCB());
                pathDoesNotExist = true;
                continue;
            }
            parent = childMatch;
        }
        return pathDoesNotExist;
    }

    boolean isIntermediaryPath(JsonPointer jp) {
        List<String> jpRefTokens = jp.tokens();
        int jpSize = jpRefTokens.size();
        if (jpSize == 1) {
            return false;
        }
        Node node = this.root;
        for (int i = 1; i < jpSize; ++i) {
            Node childMatch = node.match(jpRefTokens.get(i));
            if (childMatch == null) {
                return false;
            }
            node = childMatch;
        }
        return node.children != null;
    }

    boolean isTerminalPath(JsonPointer jp) {
        List<String> jpRefTokens = jp.tokens();
        int jpSize = jpRefTokens.size();
        Node node = this.root;
        if (jpSize == 1 && node.children == null) {
            return false;
        }
        for (int i = 1; i < jpSize; ++i) {
            Node childMatch = node.match(jpRefTokens.get(i));
            if (childMatch == null) {
                return false;
            }
            node = childMatch;
        }
        if (node != null && node.children == null) {
            jp.jsonPointerCB(node.jsonPointerCB);
            return true;
        }
        return false;
    }

    public String toString() {
        return "JsonPointerTree{root=" + this.root + ", isRootAPointer=" + this.isRootAPointer + '}';
    }

    class Node {
        private final String value;
        private final JsonPointerCB jsonPointerCB;
        private List<Node> children;

        Node(String value, JsonPointerCB jsonPointerCB) {
            this.value = value;
            this.children = null;
            this.jsonPointerCB = jsonPointerCB;
        }

        Node addChild(String value, JsonPointerCB jsonPointerCB) {
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            }
            Node child = new Node(value, jsonPointerCB);
            this.children.add(child);
            return child;
        }

        boolean isIndex(String s) {
            int len = s.length();
            for (int a = 0; a < len; ++a) {
                if (a == 0 && s.charAt(a) == '-' || Character.isDigit(s.charAt(a))) continue;
                return false;
            }
            return true;
        }

        public Node match(String value) {
            if (this.children == null) {
                return null;
            }
            for (Node child : this.children) {
                if (child.value.equals(value)) {
                    return child;
                }
                if (!child.value.equals("-") || !this.isIndex(value)) continue;
                return child;
            }
            return null;
        }

        public String toString() {
            return "Node{value='" + this.value + '\'' + ", jsonPointerCB=" + this.jsonPointerCB + ", children=" + this.children + '}';
        }
    }
}

