/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.metrics;

import com.couchbase.client.core.metrics.MetricsCollectorConfig;
import java.util.concurrent.TimeUnit;

public class DefaultMetricsCollectorConfig
implements MetricsCollectorConfig {
    public static final long EMIT_FREQUENCY = 1L;
    public static final TimeUnit EMIT_FREQUENCY_UNIT = TimeUnit.HOURS;
    private final long emitFrequency;
    private final TimeUnit emitFrequencyUnit;

    public static DefaultMetricsCollectorConfig disabled() {
        return DefaultMetricsCollectorConfig.create(0L, TimeUnit.SECONDS);
    }

    public static DefaultMetricsCollectorConfig create() {
        return new DefaultMetricsCollectorConfig(DefaultMetricsCollectorConfig.builder());
    }

    public static DefaultMetricsCollectorConfig create(long emitFrequency, TimeUnit emitFrequencyUnit) {
        Builder builder = DefaultMetricsCollectorConfig.builder();
        builder.emitFrequency(emitFrequency);
        builder.emitFrequencyUnit(emitFrequencyUnit);
        return builder.build();
    }

    private static Builder builder() {
        return new Builder();
    }

    protected DefaultMetricsCollectorConfig(Builder builder) {
        this.emitFrequency = builder.emitFrequency;
        this.emitFrequencyUnit = builder.emitFrequencyUnit;
    }

    @Override
    public long emitFrequency() {
        return this.emitFrequency;
    }

    @Override
    public TimeUnit emitFrequencyUnit() {
        return this.emitFrequencyUnit;
    }

    public static class Builder {
        private long emitFrequency = 1L;
        private TimeUnit emitFrequencyUnit = EMIT_FREQUENCY_UNIT;

        protected Builder() {
        }

        public Builder emitFrequency(long emitFrequency) {
            this.emitFrequency = emitFrequency;
            return this;
        }

        public Builder emitFrequencyUnit(TimeUnit emitFrequencyUnit) {
            this.emitFrequencyUnit = emitFrequencyUnit;
            return this;
        }

        public DefaultMetricsCollectorConfig build() {
            return new DefaultMetricsCollectorConfig(this);
        }
    }
}

