/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.observe;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.DocumentMutationLostException;
import com.couchbase.client.core.ReplicaNotConfiguredException;
import com.couchbase.client.core.ServiceNotAvailableException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.ResponseStatusDetails;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.message.kv.FailoverObserveSeqnoResponse;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.core.message.kv.NoFailoverObserveSeqnoResponse;
import com.couchbase.client.core.message.kv.ObserveSeqnoRequest;
import com.couchbase.client.core.message.observe.Observe;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class ObserveViaMutationToken {
    public static Observable<Boolean> call(ClusterFacade core, String bucket, String id, final MutationToken token, final Observe.PersistTo persistTo, final Observe.ReplicateTo replicateTo, final Delay delay, RetryStrategy retryStrategy, Span parent, final long cas) {
        Observable<CouchbaseResponse> observeResponses = ObserveViaMutationToken.sendObserveRequests(core, bucket, id, token, persistTo, replicateTo, retryStrategy, parent, cas);
        return observeResponses.map((Func1)new Func1<CouchbaseResponse, ObserveItem>(){

            public ObserveItem call(CouchbaseResponse response) {
                if (response.status() == ResponseStatus.ACCESS_ERROR) {
                    String details = ResponseStatusDetails.stringify(response.status(), response.statusDetails());
                    throw new AuthenticationException("The application is not authorized to perform the \"observe\" operation, make sure you have read privileges on this bucket: " + details);
                }
                if (response instanceof FailoverObserveSeqnoResponse) {
                    FailoverObserveSeqnoResponse fr = (FailoverObserveSeqnoResponse)response;
                    if (fr.lastSeqNoReceived() < token.sequenceNumber()) {
                        throw new DocumentMutationLostException("Document Mutation lost during a hard failover.", cas);
                    }
                    return ObserveItem.from(token, fr);
                }
                if (response instanceof NoFailoverObserveSeqnoResponse) {
                    return ObserveItem.from(token, (NoFailoverObserveSeqnoResponse)response);
                }
                throw new IllegalStateException("Unknown failover observe response: " + response);
            }
        }).scan((Object)ObserveItem.empty(), (Func2)new Func2<ObserveItem, ObserveItem, ObserveItem>(){

            public ObserveItem call(ObserveItem currentStatus, ObserveItem newStatus) {
                return currentStatus.add(newStatus);
            }
        }).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Void> observable) {
                return observable.zipWith(Observable.range((int)1, (int)Integer.MAX_VALUE), (Func2)new Func2<Void, Integer, Integer>(){

                    public Integer call(Void aVoid, Integer attempt) {
                        return attempt;
                    }
                }).flatMap(new Func1<Integer, Observable<?>>(){

                    public Observable<?> call(Integer attempt) {
                        return Observable.timer((long)delay.calculate(attempt.intValue()), (TimeUnit)delay.unit());
                    }
                });
            }
        }).skipWhile((Func1)new Func1<ObserveItem, Boolean>(){

            public Boolean call(ObserveItem status) {
                return !status.check(persistTo, replicateTo);
            }
        }).take(1).map((Func1)new Func1<ObserveItem, Boolean>(){

            public Boolean call(ObserveItem observeResponses) {
                return true;
            }
        });
    }

    private static Observable<CouchbaseResponse> sendObserveRequests(final ClusterFacade core, final String bucket, final String id, final MutationToken token, final Observe.PersistTo persistTo, final Observe.ReplicateTo replicateTo, RetryStrategy retryStrategy, final Span parent, final long cas) {
        final boolean swallowErrors = retryStrategy.shouldRetryObserve();
        return Observable.defer((Func0)new Func0<Observable<CouchbaseResponse>>(){

            public Observable<CouchbaseResponse> call() {
                return core.send(new GetClusterConfigRequest()).map((Func1)new Func1<GetClusterConfigResponse, Integer>(){

                    public Integer call(GetClusterConfigResponse response) {
                        CouchbaseBucketConfig conf = (CouchbaseBucketConfig)response.config().bucketConfig(bucket);
                        int numReplicas = conf.numberOfReplicas();
                        if (conf.ephemeral() && persistTo.value() != 0) {
                            throw new ServiceNotAvailableException("Ephemeral Buckets do not support PersistTo.");
                        }
                        if (replicateTo.touchesReplica() && replicateTo.value() > numReplicas) {
                            throw new ReplicaNotConfiguredException("Not enough replicas configured on the bucket.", cas);
                        }
                        if (persistTo.touchesReplica() && persistTo.value() - 1 > numReplicas) {
                            throw new ReplicaNotConfiguredException("Not enough replicas configured on the bucket.", cas);
                        }
                        return numReplicas;
                    }
                }).flatMap((Func1)new Func1<Integer, Observable<CouchbaseResponse>>(){

                    public Observable<CouchbaseResponse> call(Integer replicas) {
                        ArrayList<Observable> obs = new ArrayList<Observable>();
                        final ObserveSeqnoRequest activeReq = new ObserveSeqnoRequest(token.vbucketUUID(), true, 0, id, bucket, cas);
                        final CoreEnvironment env = core.ctx().environment();
                        if (env.operationTracingEnabled() && parent != null) {
                            Scope scope = env.tracer().buildSpan("observe_seqno").asChildOf(parent).withTag("couchbase.active", true).startActive(false);
                            activeReq.span(scope.span(), env);
                            scope.close();
                        }
                        Observable masterRes = core.send(activeReq).doOnUnsubscribe(new Action0(){

                            public void call() {
                                if (env.operationTracingEnabled() && parent != null) {
                                    env.tracer().scopeManager().activate(activeReq.span(), true).close();
                                }
                            }
                        });
                        if (swallowErrors) {
                            obs.add(masterRes.onErrorResumeNext(Observable.empty()));
                        } else {
                            obs.add(masterRes);
                        }
                        if (persistTo.touchesReplica() || replicateTo.touchesReplica()) {
                            for (short i = 1; i <= replicas; i = (short)(i + 1)) {
                                final ObserveSeqnoRequest replReq = new ObserveSeqnoRequest(token.vbucketUUID(), false, i, id, bucket, cas);
                                if (env.operationTracingEnabled() && parent != null) {
                                    Scope scope = env.tracer().buildSpan("observe_seqno").asChildOf(parent).withTag("couchbase.active", false).startActive(false);
                                    replReq.span(scope.span(), env);
                                    scope.close();
                                }
                                Observable res = core.send(replReq).doOnUnsubscribe(new Action0(){

                                    public void call() {
                                        if (env.operationTracingEnabled() && parent != null) {
                                            env.tracer().scopeManager().activate(replReq.span(), true).close();
                                        }
                                    }
                                });
                                if (swallowErrors) {
                                    obs.add(res.onErrorResumeNext(Observable.empty()));
                                    continue;
                                }
                                obs.add(res);
                            }
                        }
                        if (obs.size() == 1) {
                            return (Observable)obs.get(0);
                        }
                        return Observable.mergeDelayError((Observable)Observable.from(obs));
                    }
                });
            }
        });
    }

    static class ObserveItem {
        private final int replicated;
        private final int persisted;
        private final boolean persistedMaster;

        private ObserveItem(int replicated, int persisted, boolean persistedMaster) {
            this.replicated = replicated;
            this.persisted = persisted;
            this.persistedMaster = persistedMaster;
        }

        public static ObserveItem empty() {
            return new ObserveItem(0, 0, false);
        }

        public static ObserveItem from(MutationToken token, FailoverObserveSeqnoResponse response) {
            boolean replicated = response.currentSeqNo() >= token.sequenceNumber();
            boolean persisted = response.lastPersistedSeqNo() >= token.sequenceNumber();
            return new ObserveItem(replicated && !response.master() ? 1 : 0, persisted ? 1 : 0, response.master() && persisted);
        }

        public static ObserveItem from(MutationToken token, NoFailoverObserveSeqnoResponse response) {
            boolean replicated = response.currentSeqNo() >= token.sequenceNumber();
            boolean persisted = response.lastPersistedSeqNo() >= token.sequenceNumber();
            return new ObserveItem(replicated && !response.master() ? 1 : 0, persisted ? 1 : 0, response.master() && persisted);
        }

        public ObserveItem add(ObserveItem other) {
            return new ObserveItem(this.replicated + other.replicated, this.persisted + other.persisted, this.persistedMaster || other.persistedMaster);
        }

        public boolean check(Observe.PersistTo persistTo, Observe.ReplicateTo replicateTo) {
            boolean persistDone = false;
            boolean replicateDone = false;
            if (persistTo == Observe.PersistTo.MASTER) {
                if (this.persistedMaster) {
                    persistDone = true;
                }
            } else if (this.persisted >= persistTo.value()) {
                persistDone = true;
            }
            if (this.replicated >= replicateTo.value()) {
                replicateDone = true;
            }
            return persistDone && replicateDone;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("persisted ").append(this.persisted);
            if (this.persistedMaster) {
                sb.append(" (master)");
            }
            sb.append(", replicated ").append(this.replicated);
            return sb.toString();
        }
    }
}

