/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.util.regex.Pattern;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class QueryTransformerLimit
implements DBCQueryTransformer {
    public static final String KEYWORD_LIMIT = "LIMIT";
    public static final String KEYWORD_OFFSET = "OFFSET";
    public static final Pattern NON_LIMIT_QUERY_PATTERN = Pattern.compile("\\s+(LIMIT|OFFSET|INTO|UPDATE|PROCEDURE|FETCH)\\s+");
    private boolean supportsExtendedLimit;
    private boolean supportsOffsetKeyword;
    private Number offset;
    private Number length;
    private boolean limitSet;

    public QueryTransformerLimit() {
        this(true);
    }

    public QueryTransformerLimit(boolean supportsExtendedLimit) {
        this(supportsExtendedLimit, false);
    }

    public QueryTransformerLimit(boolean supportsExtendedLimit, boolean supportsOffsetKeyword) {
        this.supportsExtendedLimit = supportsExtendedLimit;
        this.supportsOffsetKeyword = supportsOffsetKeyword;
    }

    @Override
    public void setParameters(Object ... parameters) {
        this.offset = (Number)parameters[0];
        this.length = (Number)parameters[1];
    }

    @Override
    public String transformQueryString(SQLQuery query) throws DBCException {
        String newQuery;
        String testQuery = query.getText().toUpperCase().trim();
        SQLDialect dialect = SQLUtils.getDialectFromDataSource(query.getDataSource());
        boolean plainSelect = query.isPlainSelect();
        if (!plainSelect && query.getType() == SQLQueryType.UNKNOWN) {
            plainSelect = "SELECT".equals(SQLUtils.getFirstKeyword(dialect, testQuery));
        }
        if (plainSelect) {
            boolean bl = plainSelect = !NON_LIMIT_QUERY_PATTERN.matcher(testQuery).find();
        }
        if (!plainSelect) {
            this.limitSet = false;
            newQuery = query.getText();
        } else {
            if (this.supportsExtendedLimit) {
                newQuery = String.valueOf(query.getText()) + "\n" + KEYWORD_LIMIT + " " + this.offset + ", " + this.length;
            } else if (this.supportsOffsetKeyword) {
                newQuery = String.valueOf(query.getText()) + "\n" + KEYWORD_LIMIT + " " + this.length.longValue();
                if (this.offset.longValue() > 0L) {
                    newQuery = String.valueOf(newQuery) + " OFFSET " + this.offset.longValue();
                }
            } else {
                newQuery = String.valueOf(query.getText()) + "\n" + KEYWORD_LIMIT + " " + (this.offset.longValue() + this.length.longValue());
            }
            this.limitSet = this.supportsExtendedLimit || this.supportsOffsetKeyword;
        }
        return newQuery;
    }

    @Override
    public void transformStatement(DBCStatement statement, int parameterIndex) throws DBCException {
        if (!this.limitSet) {
            statement.setLimit(this.offset.longValue(), this.length.longValue());
        }
    }
}

