/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.auth;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMAuthToken;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.auth.SMSessionProviderService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SessionContextImpl
implements SMSessionContext {
    private static final Log log = Log.getLog(SessionContextImpl.class);
    private final SMSessionContext parentContext;
    private final List<SMSession> sessions = new ArrayList<SMSession>();

    public SessionContextImpl(SMSessionContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    @Nullable
    public SMSession getSpaceSession(@NotNull DBRProgressMonitor monitor, @NotNull SMAuthSpace space, boolean open) throws DBException {
        SMSessionProviderService sessionProviderService;
        SMSession session = this.findSpaceSession(space);
        if (session != null) {
            return session;
        }
        SMSession sMSession = session = this.parentContext == null ? null : this.parentContext.getSpaceSession(monitor, space, false);
        if (session == null && open && (sessionProviderService = DBWorkbench.getService(SMSessionProviderService.class)) != null) {
            try {
                session = sessionProviderService.acquireSession(monitor, this, space);
                if (session != null) {
                    this.addSession(session);
                }
            }
            catch (Exception e) {
                throw new DBException("Error acquiring session", e);
            }
        }
        return session;
    }

    @Override
    @Nullable
    public SMSession findSpaceSession(@NotNull SMAuthSpace space) {
        for (SMSession session : this.sessions) {
            if (!CommonUtils.equalObjects((Object)session.getSessionSpace(), (Object)space)) continue;
            return session;
        }
        return null;
    }

    @Override
    public SMAuthToken[] getSavedTokens() {
        return new SMAuthToken[0];
    }

    @Override
    public void addSession(@NotNull SMSession session) {
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
        } else {
            log.debug("Session '" + session + "' was added twice");
        }
    }

    @Override
    public boolean removeSession(@NotNull SMSession session) {
        if (this.sessions.remove(session)) {
            return true;
        }
        log.debug("Session '" + session + "' was removed twice");
        return false;
    }

    public void close() {
        this.sessions.clear();
    }
}

