/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.krb5;

import com.dbeaver.ui.auth.krb5.AuthModelKerberosMessages;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class AuthModelKerberosConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private static final Log log = Log.getLog(AuthModelKerberosConfigurator.class);
    private static final String SHOW_SERVICE_NAME = "krb5.show-service";
    private static final String SHOW_SSL_JKS = "krb5.show-ssl-jks";
    private Text kerberosUserText;
    private Text realmText;
    private Text kdcServerText;
    private TextWithOpenFile keytabText;
    private Button keytabCheckbox;
    private Button krb5DebugCheckbox;
    private Button krb5KDCOverTCPCheckbox;
    private Button kinitCheckbox;
    private Button sslJksCheckbox;
    private TextWithOpenFile sslJksText;
    private Text sslJksPassword;
    private Label serviceNameTextLabel;
    private Text serviceNameText;

    public void createControl(@NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        Composite kerberosGroup = parent;
        Label usernameLabel = UIUtils.createLabel((Composite)kerberosGroup, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        usernameLabel.setLayoutData((Object)new GridData(32));
        this.createUserNameControls(kerberosGroup, propertyChangeListener);
        this.kerberosUserText = UIUtils.createLabelText((Composite)kerberosGroup, (String)AuthModelKerberosMessages.model_kerberos_user, null, (int)2048, (Object)new GridData(768));
        this.kerberosUserText.setToolTipText(AuthModelKerberosMessages.model_kerberos_user_help);
        this.realmText = UIUtils.createLabelText((Composite)kerberosGroup, (String)AuthModelKerberosMessages.model_kerberos_realm, null);
        this.realmText.setLayoutData((Object)new GridData(768));
        this.realmText.setToolTipText(AuthModelKerberosMessages.model_kerberos_realm_help);
        this.kdcServerText = UIUtils.createLabelText((Composite)kerberosGroup, (String)AuthModelKerberosMessages.model_kerberos_kdc_server, null, (int)2048, (Object)new GridData(768));
        this.createPasswordControls(kerberosGroup, propertyChangeListener);
        this.serviceNameTextLabel = UIUtils.createControlLabel((Composite)kerberosGroup, (String)AuthModelKerberosMessages.model_kerberos_service_name);
        this.serviceNameText = new Text(kerberosGroup, 2048);
        this.serviceNameText.setLayoutData((Object)new GridData(768));
        this.serviceNameText.setToolTipText(AuthModelKerberosMessages.model_kerberos_service_name_help);
        this.sslJksCheckbox = UIUtils.createCheckbox((Composite)kerberosGroup, (boolean)false);
        this.sslJksCheckbox.setText(AuthModelKerberosMessages.model_kerberos_use_ssl);
        this.sslJksCheckbox.setToolTipText(AuthModelKerberosMessages.model_kerberos_use_ssl_help);
        this.sslJksCheckbox.setLayoutData((Object)new GridData(256));
        this.sslJksCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelKerberosConfigurator.this.updateKerberosSettingsVisibility();
            }
        });
        Composite sslJksGroup = UIUtils.createComposite((Composite)kerberosGroup, (int)3);
        sslJksGroup.setLayoutData((Object)new GridData(768));
        this.sslJksText = new TextWithOpenFile(sslJksGroup, AuthModelKerberosMessages.model_kerberos_ssl_jks_path, new String[]{"*.jks"});
        this.sslJksText.setLayoutData((Object)new GridData(768));
        this.sslJksText.setToolTipText(AuthModelKerberosMessages.model_kerberos_ssl_jks_path_help);
        this.sslJksPassword = UIUtils.createLabelText((Composite)sslJksGroup, (String)AuthModelKerberosMessages.model_kerberos_ssl_jks_password, null, (int)0x400800, (Object)new GridData(768));
        this.keytabCheckbox = UIUtils.createCheckbox((Composite)kerberosGroup, (boolean)false);
        this.keytabCheckbox.setText(AuthModelKerberosMessages.model_kerberos_use_keytab);
        this.keytabCheckbox.setToolTipText(AuthModelKerberosMessages.model_kerberos_use_keytab_help);
        this.keytabCheckbox.setLayoutData((Object)new GridData(32));
        this.keytabCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelKerberosConfigurator.this.updateKerberosSettingsVisibility();
            }
        });
        this.keytabText = new TextWithOpenFile(kerberosGroup, AuthModelKerberosMessages.model_kerberos_keytab_path, new String[]{"*.*"});
        this.keytabText.setLayoutData((Object)new GridData(256));
        UIUtils.addVariablesToControl((Control)this.keytabText.getTextControl(), (String[])this.getAvailableVariables(), (String)"Key tab pattern");
        Composite checksGroup = UIUtils.createComposite((Composite)parent, (int)3);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        checksGroup.setLayoutData((Object)gd);
        this.kinitCheckbox = UIUtils.createCheckbox((Composite)checksGroup, (boolean)false);
        this.kinitCheckbox.setText(AuthModelKerberosMessages.model_kerberos_use_kinit);
        this.kinitCheckbox.setToolTipText(AuthModelKerberosMessages.model_kerberos_use_kinit_help);
        this.kinitCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelKerberosConfigurator.this.updateKerberosSettingsVisibility();
            }
        });
        this.krb5KDCOverTCPCheckbox = UIUtils.createCheckbox((Composite)checksGroup, (boolean)false);
        this.krb5KDCOverTCPCheckbox.setText(AuthModelKerberosMessages.model_kerberos_force_tcp_for_kdc);
        this.krb5KDCOverTCPCheckbox.setToolTipText(AuthModelKerberosMessages.model_kerberos_force_tcp_for_kdc_help);
        this.krb5KDCOverTCPCheckbox.setLayoutData((Object)new GridData(256));
        this.krb5DebugCheckbox = UIUtils.createCheckbox((Composite)checksGroup, (boolean)false);
        this.krb5DebugCheckbox.setText(AuthModelKerberosMessages.model_kerberos_debug);
        this.krb5DebugCheckbox.setToolTipText(AuthModelKerberosMessages.model_kerberos_debug_help);
        this.krb5DebugCheckbox.setLayoutData((Object)new GridData(32));
    }

    private void updateKerberosSettingsVisibility() {
        boolean kinit = this.kinitCheckbox.getSelection();
        if (!kinit) {
            boolean keytab = this.keytabCheckbox.getSelection();
            this.showKeytabCheckbox(true);
            this.showKeytabText(keytab);
            this.showPassword(!keytab);
        } else {
            this.showKeytabText(false);
            this.showKeytabCheckbox(false);
            this.showPassword(false);
        }
        boolean ssl = this.sslJksCheckbox.getSelection();
        this.sslJksPassword.setEnabled(ssl);
        this.sslJksText.setEnabled(ssl);
        this.sslJksText.getTextControl().setEnabled(ssl);
    }

    private void showPassword(boolean show) {
        this.passwordText.setEnabled(show);
        this.savePasswordCheck.setEnabled(show);
        this.userManagementToolbar.setEnabled(show);
    }

    private void showKeytabCheckbox(boolean show) {
        this.keytabCheckbox.setEnabled(show);
    }

    private void showKeytabText(boolean show) {
        this.keytabText.setEnabled(show);
        this.keytabText.getTextControl().setEnabled(show);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        List kdcs;
        KrbClient client;
        super.loadSettings(dataSource);
        String realm = null;
        String kdcServer = null;
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        realm = configuration.getAuthProperty("krb5.realm");
        try {
            client = new KrbClient();
        }
        catch (Exception e) {
            log.warn((Object)"Kerberos config was ignored, using empty config", (Throwable)e);
            client = new KrbClient(new KrbConfig());
        }
        KrbConfig config = client.getKrbConfig();
        if (realm == null) {
            realm = config.getDefaultRealm();
        }
        if ((kdcServer = configuration.getAuthProperty("krb5.kdc_server")) == null && realm != null && (kdcs = config.getRealmSectionItems(realm, "kdc")) != null && kdcs.size() > 0 && kdcs.get(0) != null) {
            kdcServer = kdcs.get(0).toString();
        }
        this.realmText.setText(CommonUtils.notEmpty((String)realm));
        this.kdcServerText.setText(CommonUtils.notEmpty((String)kdcServer));
        this.krb5DebugCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("krb5.debug")));
        this.kerberosUserText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("krb5.user")));
        this.keytabCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("krb5.use_keytab")));
        this.keytabText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("krb5.keytab_path")));
        this.krb5KDCOverTCPCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("krb5.kdc_over_tcp")));
        this.kinitCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("krb5.use_kinit")));
        this.serviceNameText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("SERVICE_NAME")));
        this.sslJksCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("USE_SSL_JKS")));
        this.sslJksPassword.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("SSL_JKS_PASSWORD")));
        this.sslJksText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("SSL_JKS_PATH")));
        boolean showSslJks = CommonUtils.getBoolean((Object)dataSource.getDriver().getDriverParameter(SHOW_SSL_JKS), (boolean)Boolean.FALSE);
        boolean showService = CommonUtils.getBoolean((Object)dataSource.getDriver().getDriverParameter(SHOW_SERVICE_NAME), (boolean)Boolean.FALSE);
        if (!showService) {
            this.serviceNameText.setVisible(false);
            ((GridData)this.serviceNameText.getLayoutData()).exclude = true;
            this.serviceNameText.getParent().getParent().layout(true, true);
            this.serviceNameTextLabel.setVisible(false);
            ((GridData)this.serviceNameTextLabel.getLayoutData()).exclude = true;
            this.serviceNameTextLabel.getParent().getParent().layout(true, true);
        }
        if (!showSslJks) {
            this.sslJksCheckbox.setVisible(false);
            ((GridData)this.sslJksCheckbox.getLayoutData()).exclude = true;
            this.sslJksCheckbox.getParent().getParent().layout(true, true);
            this.sslJksText.getParent().setVisible(false);
            ((GridData)this.sslJksText.getParent().getLayoutData()).exclude = true;
            this.sslJksText.getParent().getParent().layout(true, true);
        }
        this.updateKerberosSettingsVisibility();
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("krb5.realm", this.realmText.getText());
        props.put("krb5.kdc_server", this.kdcServerText.getText());
        props.put("krb5.debug", String.valueOf(this.krb5DebugCheckbox.getSelection()));
        props.put("krb5.user", this.kerberosUserText.getText());
        props.put("krb5.use_keytab", String.valueOf(this.keytabCheckbox.getSelection()));
        props.put("krb5.keytab_path", this.keytabText.getText());
        props.put("krb5.kdc_over_tcp", String.valueOf(this.krb5KDCOverTCPCheckbox.getSelection()));
        props.put("krb5.use_kinit", String.valueOf(this.kinitCheckbox.getSelection()));
        props.put("USE_SSL_JKS", String.valueOf(this.sslJksCheckbox.getSelection()));
        props.put("SERVICE_NAME", this.serviceNameText.getText());
        props.put("SSL_JKS_PASSWORD", this.sslJksPassword.getText());
        props.put("SSL_JKS_PATH", this.sslJksText.getText());
        configuration.setAuthProperties(props);
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
    }

    public boolean isComplete() {
        return true;
    }

    @NotNull
    private String[] getAvailableVariables() {
        return (String[])Arrays.stream(DBPConnectionConfiguration.CONNECT_VARIABLES).map(x -> x[0]).toArray(String[]::new);
    }
}

