/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.gef3;

import org.eclipse.draw2dl.FigureCanvas;
import org.eclipse.gef3.EditPartViewer;
import org.eclipse.gef3.MouseWheelHandler;
import org.eclipse.gef3.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.graphiti.ui.internal.editor.GFFigureCanvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public class MouseWheelHorizontalScrollHandler
implements MouseWheelHandler {
    public static final MouseWheelHandler SINGLETON = new MouseWheelHorizontalScrollHandler();

    private MouseWheelHorizontalScrollHandler() {
    }

    public void handleMouseWheel(Event event, EditPartViewer viewer) {
        if (viewer instanceof ScrollingGraphicalViewer) {
            Control control = viewer.getControl();
            if (control instanceof FigureCanvas) {
                FigureCanvas canvas = (FigureCanvas)control;
                ScrollBar hBar = canvas.getHorizontalBar();
                int value = hBar.getSelection() + hBar.getIncrement() * event.count;
                canvas.scrollToX(value);
                event.doit = false;
            } else if (control instanceof GFFigureCanvas) {
                GFFigureCanvas canvas = (GFFigureCanvas)control;
                ScrollBar hBar = canvas.getHorizontalBar();
                int value = hBar.getSelection() + hBar.getIncrement() * event.count;
                int y = canvas.getViewport().getViewLocation().y;
                canvas.scrollTo(value, y);
                event.doit = false;
            }
        }
    }
}

