/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2dl;

import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Locator;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.geometry.PrecisionRectangle;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.handles.HandleBounds;
import org.eclipse.graphiti.ui.internal.util.draw2dl.GFHandleHelper;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;

public class ZoomingInsetsHandleLocator
implements Locator {
    private IFigure reference;
    private IConfigurationProvider configurationProvider;
    private Insets handleInsets;

    public ZoomingInsetsHandleLocator(IFigure reference, IConfigurationProvider configurationProvider, Insets handleInsets) {
        this.reference = reference;
        this.configurationProvider = configurationProvider;
        this.handleInsets = handleInsets;
    }

    public void relocate(IFigure target) {
        Insets insets = new Insets(this.handleInsets);
        double zoom = GFHandleHelper.getZoomLevel(this.configurationProvider);
        insets.top = (int)((double)insets.top * zoom);
        insets.bottom = (int)((double)insets.bottom * zoom);
        insets.left = (int)((double)insets.left * zoom);
        insets.right = (int)((double)insets.right * zoom);
        Rectangle bounds = this.reference instanceof HandleBounds ? ((HandleBounds)this.reference).getHandleBounds() : this.reference.getBounds();
        bounds = new PrecisionRectangle(bounds.getCopy());
        this.reference.translateToAbsolute((Translatable)bounds);
        target.translateToRelative((Translatable)bounds);
        bounds.translate(-insets.left, -insets.top);
        bounds.resize(insets.getWidth(), insets.getHeight());
        target.setBounds(bounds);
    }
}

