/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2dl;

import org.eclipse.draw2dl.BendpointLocator;
import org.eclipse.draw2dl.Cursors;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.Locator;
import org.eclipse.draw2dl.MidpointLocator;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.ConnectionEditPart;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.SharedCursors;
import org.eclipse.gef3.handles.BendpointHandle;
import org.eclipse.gef3.tools.ConnectionBendpointTracker;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.AddBendpointContext;
import org.eclipse.graphiti.features.context.impl.MoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.RemoveBendpointContext;
import org.eclipse.graphiti.tb.IConnectionSelectionInfo;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.ui.internal.util.draw2dl.GFHandleHelper;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.graphics.Color;

public class GFBendpointHandle
extends BendpointHandle {
    private static int LINE_WIDTH = 1;
    private static Dimension HANDLE_DIMENSION_CREATE = new Dimension(6, 6);
    private static Dimension HANDLE_DIMENSION_MOVE = new Dimension(8, 8);
    private static Color FG_COLOR_PRIMARY;
    private static Color FG_COLOR_SECONDARY;
    private static Color BG_COLOR_PRIMARY;
    private static Color BG_COLOR_SECONDARY;
    private IConfigurationProviderInternal configurationProvider;
    private String dragTrackerType;
    private IConnectionSelectionInfo connectionSelectionInfo;

    public GFBendpointHandle(ConnectionEditPart owner, int index, int locatorIndex, IConfigurationProviderInternal configurationProvider, Type type, IConnectionSelectionInfo connectionSelectionInfo) {
        this.connectionSelectionInfo = connectionSelectionInfo;
        this.setCursor(Cursors.NO);
        this.setConfigurationProvider(configurationProvider);
        this.setOwner((GraphicalEditPart)owner);
        this.setIndex(index);
        this.setOpaque(false);
        if (Type.CREATE.equals((Object)type)) {
            this.setLocator((Locator)new MidpointLocator(this.getConnection(), locatorIndex));
            if (this.checkAddBendpointFeature()) {
                this.setCursor(SharedCursors.SIZEALL);
            }
            this.dragTrackerType = "create bendpoint";
            this.setPreferredSize(HANDLE_DIMENSION_CREATE);
        } else if (Type.MOVE.equals((Object)type)) {
            this.setLocator((Locator)new BendpointLocator(this.getConnection(), locatorIndex));
            if (this.checkMoveBendpointFeature()) {
                this.setCursor(SharedCursors.SIZEALL);
            }
            this.dragTrackerType = "move bendpoint";
            this.setPreferredSize(HANDLE_DIMENSION_MOVE);
        } else {
            this.setCursor(null);
        }
    }

    protected DragTracker createDragTracker() {
        ConnectionBendpointTracker tracker = null;
        if (this.dragTrackerType != null && (this.dragTrackerType.equals("move bendpoint") && this.checkMoveBendpointFeature() || this.dragTrackerType.equals("create bendpoint") && this.checkRemoveBendpointFeature())) {
            tracker = new ConnectionBendpointTracker((ConnectionEditPart)this.getOwner(), this.getIndex());
            tracker.setType((Object)this.dragTrackerType);
            tracker.setDefaultCursor(this.getCursor());
        }
        return tracker;
    }

    private boolean isPrimarySelected() {
        return this.getOwner().getSelected() == 2;
    }

    public void paintFigure(Graphics g) {
        Color bg;
        Color fg;
        g.setAntialias(1);
        g.setLineWidth(this.getLineWidth());
        boolean primary = this.isPrimarySelected();
        if (primary) {
            fg = this.getFgColorPrimary();
            bg = this.getBgColorPrimary();
        } else {
            fg = this.getFgColorSecondary();
            bg = this.getBgColorSecondary();
        }
        if (fg != null) {
            g.setForegroundColor(fg);
        }
        if (bg != null) {
            g.setBackgroundColor(bg);
        }
        Rectangle r = GFFigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, this.getLineWidth());
        g.fillOval(r);
        g.drawOval(r);
    }

    private Color getFgColorPrimary() {
        IColorConstant color;
        if (this.connectionSelectionInfo != null && (color = this.connectionSelectionInfo.getPrimarySelectionBendpointForegroundColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (FG_COLOR_PRIMARY == null || FG_COLOR_PRIMARY.isDisposed()) {
            FG_COLOR_PRIMARY = this.configurationProvider.getResourceRegistry().getSwtColor("cc6a01");
        }
        return FG_COLOR_PRIMARY;
    }

    private Color getFgColorSecondary() {
        IColorConstant color;
        if (this.connectionSelectionInfo != null && (color = this.connectionSelectionInfo.getSecondarySelectionBendpointForegroundColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (FG_COLOR_SECONDARY == null || FG_COLOR_SECONDARY.isDisposed()) {
            FG_COLOR_SECONDARY = this.configurationProvider.getResourceRegistry().getSwtColor("cc6a01");
        }
        return FG_COLOR_SECONDARY;
    }

    private Color getBgColorPrimary() {
        IColorConstant color;
        if (this.connectionSelectionInfo != null && (color = this.connectionSelectionInfo.getPrimarySelectionBendpointBackgroundColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (BG_COLOR_PRIMARY == null || BG_COLOR_PRIMARY.isDisposed()) {
            BG_COLOR_PRIMARY = this.configurationProvider.getResourceRegistry().getSwtColor("ffaa2f");
        }
        return BG_COLOR_PRIMARY;
    }

    private Color getBgColorSecondary() {
        IColorConstant color;
        if (this.connectionSelectionInfo != null && (color = this.connectionSelectionInfo.getSecondarySelectionBendpointBackgroundColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (BG_COLOR_SECONDARY == null || BG_COLOR_SECONDARY.isDisposed()) {
            BG_COLOR_SECONDARY = this.configurationProvider.getResourceRegistry().getSwtColor("ffffff");
        }
        return BG_COLOR_SECONDARY;
    }

    private int getLineWidth() {
        double zoom = GFHandleHelper.getZoomLevel(this.getConfigurationProvider());
        return Math.max(1, (int)(zoom * (double)LINE_WIDTH));
    }

    private boolean checkMoveBendpointFeature() {
        boolean ret = false;
        IFeatureProvider fp = this.getConfigurationProvider().getFeatureProvider();
        ret = fp.getMoveBendpointFeature((IMoveBendpointContext)new MoveBendpointContext(null)) != null;
        return ret;
    }

    private boolean checkAddBendpointFeature() {
        boolean ret = false;
        IFeatureProvider fp = this.getConfigurationProvider().getFeatureProvider();
        ret = fp.getAddBendpointFeature((IAddBendpointContext)new AddBendpointContext(null, 0, 0, 0)) != null;
        return ret;
    }

    private boolean checkRemoveBendpointFeature() {
        boolean ret = false;
        IFeatureProvider fp = this.getConfigurationProvider().getFeatureProvider();
        ret = fp.getRemoveBendpointFeature((IRemoveBendpointContext)new RemoveBendpointContext(null, null)) != null;
        return ret;
    }

    private void setConfigurationProvider(IConfigurationProviderInternal configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected boolean isFixed() {
        if (this.checkMoveBendpointFeature() || this.checkRemoveBendpointFeature()) {
            return false;
        }
        return super.isFixed();
    }

    public static enum Type {
        CREATE,
        MOVE;

    }
}

