/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Shape;
import org.eclipse.gef3.ConnectionEditPart;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Handle;
import org.eclipse.gef3.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.tb.IConnectionSelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.GFPolylineConnection;
import org.eclipse.graphiti.ui.internal.parts.CompositeConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.IConnectionEditPart;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.ui.internal.util.draw2dl.GFColorConstants;
import org.eclipse.graphiti.ui.internal.util.draw2dl.GFConnectionEndpointHandle;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.graphics.Color;

public class ConnectionHighlightEditPolicy
extends ConnectionEndpointEditPolicy {
    private Map<IFigure, Color> figureToColor = new HashMap<IFigure, Color>();
    private Map<Shape, Integer> shapeToLineStyle = new HashMap<Shape, Integer>();
    private IConfigurationProviderInternal configurationProvider;

    protected ConnectionHighlightEditPolicy(IConfigurationProviderInternal configurationProvider) {
        this.setConfigurationProvider(configurationProvider);
    }

    protected final IConfigurationProviderInternal getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected void addSelectionHandles() {
        if (this.checkReconnectionFeature()) {
            super.addSelectionHandles();
        }
        this.showHighlight();
    }

    private boolean checkReconnectionFeature() {
        return true;
    }

    protected void removeSelectionHandles() {
        super.removeSelectionHandles();
        this.removeHighlight();
    }

    protected void showHighlight() {
        this.removeHighlight();
        Color newForeground = GFColorConstants.HANDLE_BG;
        int newLineStyle = 2;
        if (this.getHost() != null && this.getHost().getModel() instanceof Connection) {
            Connection connection = (Connection)this.getHost().getModel();
            IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            IConnectionSelectionInfo selectionInfo = tbp.getSelectionInfoForConnection(connection);
            if (selectionInfo != null) {
                LineStyle selectionLineStyle;
                IColorConstant selectionColor = selectionInfo.getColor();
                if (selectionColor != null) {
                    newForeground = DataTypeTransformation.toSwtColor(this.getConfigurationProvider().getResourceRegistry(), selectionColor);
                }
                if ((selectionLineStyle = selectionInfo.getLineStyle()) != null) {
                    newLineStyle = DataTypeTransformation.toDraw2dLineStyle(selectionLineStyle);
                }
            }
        }
        Collection<Shape> connectionFigures = this.getConnectionFigures();
        for (Shape connectionFigure : connectionFigures) {
            this.figureToColor.put((IFigure)connectionFigure, connectionFigure.getLocalForegroundColor());
            connectionFigure.setForegroundColor(newForeground);
            this.shapeToLineStyle.put(connectionFigure, connectionFigure.getLineStyle());
            connectionFigure.setLineStyle(newLineStyle);
            if (!(connectionFigure instanceof GFPolylineConnection)) continue;
            GFPolylineConnection polylineConnection = (GFPolylineConnection)connectionFigure;
            List<IFigure> allDecorations = polylineConnection.getAllDecorations();
            for (IFigure decoration : allDecorations) {
                if (decoration == null) continue;
                this.figureToColor.put(decoration, decoration.getLocalForegroundColor());
                decoration.setForegroundColor(newForeground);
                if (!(decoration instanceof Shape)) continue;
                Shape decorationShape = (Shape)decoration;
                this.shapeToLineStyle.put(decorationShape, new Integer(decorationShape.getLineStyle()));
                decorationShape.setLineStyle(newLineStyle);
            }
        }
    }

    protected void removeHighlight() {
        Set<IFigure> colorFigures = this.figureToColor.keySet();
        for (IFigure colorFigure : colorFigures) {
            Color oldColor = this.figureToColor.get(colorFigure);
            colorFigure.setForegroundColor(oldColor);
        }
        Set<Shape> lineStyleShapes = this.shapeToLineStyle.keySet();
        for (Shape lineStyleShape : lineStyleShapes) {
            int lineStyle = this.shapeToLineStyle.get(lineStyleShape);
            lineStyleShape.setLineStyle(lineStyle);
        }
        this.figureToColor.clear();
        this.shapeToLineStyle.clear();
    }

    private Collection<Shape> getConnectionFigures() {
        EditPart host = this.getHost();
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        if (host instanceof CompositeConnectionEditPart) {
            Collection<ConnectionEditPart> editParts = ((CompositeConnectionEditPart)host).getEditParts();
            for (ConnectionEditPart editPart : editParts) {
                shapes.add((Shape)editPart.getFigure());
            }
        } else {
            shapes.add((Shape)((GraphicalEditPart)this.getHost()).getFigure());
        }
        return shapes;
    }

    protected void hideSelection() {
        super.hideSelection();
        if (this.getHost() instanceof IConnectionEditPart) {
            IConnectionEditPart cep = (IConnectionEditPart)this.getHost();
            cep.forceVisualRefresh();
        }
    }

    private void setConfigurationProvider(IConfigurationProviderInternal configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        Connection connection = (Connection)this.getHost().getModel();
        ReconnectionContext sourceCtx = new ReconnectionContext(connection, connection.getStart(), null, null);
        ReconnectionContext targetCtx = new ReconnectionContext(connection, connection.getEnd(), null, null);
        IReconnectionFeature sourceReconnectionFeature = this.getConfigurationProvider().getFeatureProvider().getReconnectionFeature((IReconnectionContext)sourceCtx);
        IReconnectionFeature targetReconnectionFeature = this.getConfigurationProvider().getFeatureProvider().getReconnectionFeature((IReconnectionContext)targetCtx);
        if (sourceReconnectionFeature == null || sourceReconnectionFeature.canStartReconnect((IReconnectionContext)sourceCtx)) {
            list.add((Handle)new GFConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 2));
        }
        if (targetReconnectionFeature == null || targetReconnectionFeature.canStartReconnect((IReconnectionContext)targetCtx)) {
            list.add((Handle)new GFConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 3));
        }
        return list;
    }
}

