/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.AnchorListener;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.ConnectionAnchor;
import org.eclipse.draw2dl.ConnectionRouter;
import org.eclipse.draw2dl.DelegatingLayout;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LayoutManager;
import org.eclipse.draw2dl.RoutingListener;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.ui.internal.figures.BezierPoint;
import org.eclipse.graphiti.ui.internal.figures.FlexibleRotatableLocator;
import org.eclipse.graphiti.ui.internal.figures.GFPolyline;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;

public class GFPolylineConnection
extends GFPolyline
implements Connection,
AnchorListener {
    private ConnectionAnchor startAnchor;
    private ConnectionAnchor endAnchor;
    private ConnectionRouter connectionRouter = ConnectionRouter.NULL;
    private List<IFigure> decorations = new ArrayList<IFigure>();

    public GFPolylineConnection(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        super(pictogramElementDelegate, graphicsAlgorithm);
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.addPoint(new Point(0, 0));
        this.addPoint(new Point(100, 100));
        this.setGeneralBezierDistance(15);
    }

    @Override
    protected PointList getAdjustedPointList(PointList points, double zoom, double lw) {
        PointList pointsCopy = new PointList();
        pointsCopy.addAll(points);
        if (pointsCopy.size() >= 2) {
            int lastPointIndex = pointsCopy.size() - 1;
            this.adjustEndPoint(pointsCopy, 0, 1);
            this.adjustEndPoint(pointsCopy, lastPointIndex, lastPointIndex - 1);
        }
        PointList ret = new PointList();
        int i = 0;
        while (i < pointsCopy.size()) {
            Point point = pointsCopy.getPoint(i);
            point.scale(zoom);
            ret.addPoint(point);
            ++i;
        }
        return ret;
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            int halfLineWidth = this.getLineWidth() / 2;
            this.bounds.expand(halfLineWidth, halfLineWidth);
            int i = 0;
            while (i < this.getChildren().size()) {
                IFigure child = (IFigure)this.getChildren().get(i);
                this.bounds.union(child.getBounds());
                ++i;
            }
        }
        return this.bounds;
    }

    @Override
    protected List<BezierPoint> getBezierPoints(PointList points, double zoom) {
        ArrayList<BezierPoint> ret = new ArrayList<BezierPoint>(points.size());
        if (this.getSpecificBezierDistances() != null && points.size() == this.getSpecificBezierDistances().length / 2) {
            int i = 0;
            while (i < points.size()) {
                int bezierDistanceBefore = (int)((double)this.getSpecificBezierDistances()[2 * i] * zoom);
                int bezierDistanceAfter = (int)((double)this.getSpecificBezierDistances()[2 * i + 1] * zoom);
                Point point = points.getPoint(i);
                ret.add(new BezierPoint(point.x, point.y, bezierDistanceBefore, bezierDistanceAfter));
                ++i;
            }
        } else {
            int i = 0;
            while (i < points.size()) {
                int bezierDistance = (int)((double)this.getGeneralBezierDistance() * zoom);
                Point point = points.getPoint(i);
                ret.add(new BezierPoint(point.x, point.y, bezierDistance, bezierDistance));
                ++i;
            }
        }
        return ret;
    }

    @Override
    public void setSpecificBezierDistances(int[] bezierDistances) {
        super.setSpecificBezierDistances(bezierDistances);
        this.setGeneralBezierDistance(this.getMaxValue(bezierDistances));
    }

    public void addNotify() {
        super.addNotify();
        this.hookSourceAnchor();
        this.hookTargetAnchor();
    }

    public void addRoutingListener(RoutingListener listener) {
        if (this.connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier notifier = (RoutingNotifier)this.connectionRouter;
            notifier.listeners.add(listener);
        } else {
            this.connectionRouter = new RoutingNotifier(this.connectionRouter, listener);
        }
    }

    public void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    public ConnectionRouter getConnectionRouter() {
        if (this.connectionRouter instanceof RoutingNotifier) {
            return ((RoutingNotifier)this.connectionRouter).realRouter;
        }
        return this.connectionRouter;
    }

    public Object getRoutingConstraint() {
        if (this.getConnectionRouter() != null) {
            return this.getConnectionRouter().getConstraint((Connection)this);
        }
        return null;
    }

    public ConnectionAnchor getSourceAnchor() {
        return this.startAnchor;
    }

    public ConnectionAnchor getTargetAnchor() {
        return this.endAnchor;
    }

    private void hookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().addAnchorListener((AnchorListener)this);
        }
    }

    private void hookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().addAnchorListener((AnchorListener)this);
        }
    }

    public void layout() {
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            this.connectionRouter.route((Connection)this);
        }
        Rectangle oldBounds = this.bounds;
        super.layout();
        this.bounds = null;
        if (!this.getBounds().contains(oldBounds)) {
            this.getParent().translateToParent((Translatable)oldBounds);
            this.getUpdateManager().addDirtyRegion(this.getParent(), oldBounds);
        }
        this.repaint();
        this.fireFigureMoved();
    }

    public void removeNotify() {
        this.unhookSourceAnchor();
        this.unhookTargetAnchor();
        this.connectionRouter.remove((Connection)this);
        super.removeNotify();
    }

    public void removeRoutingListener(RoutingListener listener) {
        if (this.connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier notifier = (RoutingNotifier)this.connectionRouter;
            notifier.listeners.remove(listener);
            if (notifier.listeners.isEmpty()) {
                this.connectionRouter = notifier.realRouter;
            }
        }
    }

    public void revalidate() {
        super.revalidate();
        this.connectionRouter.invalidate((Connection)this);
    }

    public void setConnectionRouter(ConnectionRouter cr) {
        ConnectionRouter oldRouter;
        if (cr == null) {
            cr = ConnectionRouter.NULL;
        }
        if ((oldRouter = this.getConnectionRouter()) != cr) {
            this.connectionRouter.remove((Connection)this);
            if (this.connectionRouter instanceof RoutingNotifier) {
                ((RoutingNotifier)this.connectionRouter).realRouter = cr;
            } else {
                this.connectionRouter = cr;
            }
            this.firePropertyChange("connectionRouter", oldRouter, cr);
            this.revalidate();
        }
    }

    public void setRoutingConstraint(Object cons) {
        if (this.connectionRouter != null) {
            this.connectionRouter.setConstraint((Connection)this, cons);
        }
        this.revalidate();
    }

    public void setSourceAnchor(ConnectionAnchor anchor) {
        if (anchor == this.startAnchor) {
            return;
        }
        this.unhookSourceAnchor();
        this.startAnchor = anchor;
        if (this.getParent() != null) {
            this.hookSourceAnchor();
        }
        this.revalidate();
    }

    public void addDecoration(IFigure decoration, boolean distanceToStart, double relativeDistance, int absoluteDistance, double rotateDegrees) {
        if (decoration != null) {
            boolean removed = this.decorations.remove(decoration);
            if (removed) {
                this.remove(decoration);
            }
            this.decorations.add(decoration);
            this.add(decoration, (Object)new FlexibleRotatableLocator(this, distanceToStart, relativeDistance, absoluteDistance, rotateDegrees));
        }
    }

    public void removeAllDecorations() {
        for (IFigure decoration : this.decorations) {
            this.remove(decoration);
        }
        this.decorations.clear();
    }

    public List<IFigure> getAllDecorations() {
        return this.decorations;
    }

    public void setTargetAnchor(ConnectionAnchor anchor) {
        if (anchor == this.endAnchor) {
            return;
        }
        this.unhookTargetAnchor();
        this.endAnchor = anchor;
        if (this.getParent() != null) {
            this.hookTargetAnchor();
        }
        this.revalidate();
    }

    private void unhookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().removeAnchorListener((AnchorListener)this);
        }
    }

    private void unhookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().removeAnchorListener((AnchorListener)this);
        }
    }

    private int getMaxValue(int[] numbers) {
        int maxValue = numbers[0];
        int i = 1;
        while (i < numbers.length) {
            if (numbers[i] > maxValue) {
                maxValue = numbers[i];
            }
            ++i;
        }
        return maxValue;
    }

    private void adjustEndPoint(PointList pointsCopy, int endPointIndex, int previousPointIndex) {
        Point endPoint = pointsCopy.getPoint(endPointIndex);
        Point previousPoint = pointsCopy.getPoint(previousPointIndex);
        if (endPoint.x > previousPoint.x) {
            ++endPoint.x;
            pointsCopy.setPoint(endPoint, endPointIndex);
        }
        if (endPoint.y > previousPoint.y) {
            ++endPoint.y;
            pointsCopy.setPoint(endPoint, endPointIndex);
        }
    }

    final class RoutingNotifier
    implements ConnectionRouter {
        ConnectionRouter realRouter;
        List<RoutingListener> listeners = new ArrayList<RoutingListener>(1);

        RoutingNotifier(ConnectionRouter router, RoutingListener listener) {
            this.realRouter = router;
            this.listeners.add(listener);
        }

        public Object getConstraint(Connection connection) {
            return this.realRouter.getConstraint(connection);
        }

        public void invalidate(Connection connection) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).invalidate(connection);
                ++i;
            }
            this.realRouter.invalidate(connection);
        }

        public void route(Connection connection) {
            boolean consumed = false;
            int i = 0;
            while (i < this.listeners.size()) {
                consumed |= this.listeners.get(i).route(connection);
                ++i;
            }
            if (!consumed) {
                this.realRouter.route(connection);
            }
            i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).postRoute(connection);
                ++i;
            }
        }

        public void remove(Connection connection) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).remove(connection);
                ++i;
            }
            this.realRouter.remove(connection);
        }

        public void setConstraint(Connection connection, Object constraint) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).setConstraint(connection, constraint);
                ++i;
            }
            this.realRouter.setConstraint(connection, constraint);
        }
    }
}

