/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.Ellipse;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Vector;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredArea;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredLocation;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyleRegion;
import org.eclipse.graphiti.ui.internal.IResourceRegistryHolder;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.BezierPoint;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.util.PredefinedColoredAreas;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class GFFigureUtil {
    private static final float[] SINGLETON_BOUNDS = new float[4];

    public static void paintColorFlow(IResourceRegistryHolder registryHolder, Rectangle rectangle, Graphics graphics, GradientColoredArea coloredArea, double zoom, boolean vertical) {
        Rectangle fillRectangle;
        int end;
        int start;
        if (vertical) {
            start = PredefinedColoredAreas.getLocation((GradientColoredLocation)coloredArea.getStart(), (int)rectangle.height, (double)zoom);
            end = PredefinedColoredAreas.getLocation((GradientColoredLocation)coloredArea.getEnd(), (int)rectangle.height, (double)zoom);
            fillRectangle = new Rectangle(rectangle.x, rectangle.y + start, rectangle.width, end - start);
        } else {
            start = PredefinedColoredAreas.getLocation((GradientColoredLocation)coloredArea.getStart(), (int)rectangle.width, (double)zoom);
            end = PredefinedColoredAreas.getLocation((GradientColoredLocation)coloredArea.getEnd(), (int)rectangle.width, (double)zoom);
            fillRectangle = new Rectangle(rectangle.x + start, rectangle.y, end - start, rectangle.height);
        }
        org.eclipse.graphiti.mm.algorithms.styles.Color foregroundColor = coloredArea.getStart().getColor();
        Color foregroundColorSWT = DataTypeTransformation.toSwtColor(registryHolder.getResourceRegistry(), foregroundColor);
        org.eclipse.graphiti.mm.algorithms.styles.Color backgroundColor = coloredArea.getEnd().getColor();
        Color backgroundColorSWT = DataTypeTransformation.toSwtColor(registryHolder.getResourceRegistry(), backgroundColor);
        graphics.setForegroundColor(foregroundColorSWT);
        graphics.setBackgroundColor(backgroundColorSWT);
        graphics.fillGradient(fillRectangle.x, fillRectangle.y, fillRectangle.width, fillRectangle.height, vertical);
    }

    public static Boolean containsPointInEllipse(Rectangle r, int x, int y) {
        Ellipse ellipse = new Ellipse();
        ellipse.setBounds(r);
        return ellipse.containsPoint(x, y);
    }

    public static Boolean containsPointInLine(int x1, int y1, int x2, int y2, int x, int y, int lineWidth) {
        int halfLineWidth = lineWidth / 2;
        Rectangle lineBounds = Rectangle.SINGLETON;
        lineBounds.setSize(0, 0);
        lineBounds.setLocation(x1, y1);
        lineBounds.union(x2, y2);
        lineBounds.expand(halfLineWidth, halfLineWidth);
        if (!lineBounds.contains(x, y)) {
            return Boolean.FALSE;
        }
        long result = 0L;
        if (x1 != x2 && y1 != y2) {
            long v1x = x2 - x1;
            long v1y = y2 - y1;
            long v2x = x - x1;
            long v2y = y - y1;
            long numerator = v2x * v1y - v1x * v2y;
            long denominator = v1x * v1x + v1y * v1y;
            result = numerator * numerator / denominator;
        }
        if (result <= (long)(halfLineWidth * halfLineWidth)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static Boolean containsPointInPolyline(PointList points, int x, int y, int lineWidth) {
        int halfLineWidth = lineWidth / 2;
        Rectangle lineBounds = points.getBounds().getCopy();
        lineBounds.expand(halfLineWidth, halfLineWidth);
        if (!lineBounds.contains(x, y)) {
            return Boolean.FALSE;
        }
        int[] ints = points.toIntArray();
        int index = 0;
        while (index < ints.length - 3) {
            Boolean containsPointInLine = GFFigureUtil.containsPointInLine(ints[index], ints[index + 1], ints[index + 2], ints[index + 3], x, y, lineWidth);
            if (Boolean.TRUE.equals(containsPointInLine)) {
                return Boolean.TRUE;
            }
            index += 2;
        }
        return null;
    }

    public static Boolean containsPointInPolygon(PointList points, int x, int y) {
        if (!points.getBounds().contains(x, y)) {
            return Boolean.FALSE;
        }
        boolean isOdd = false;
        int[] pointsxy = points.toIntArray();
        int n = pointsxy.length;
        if (n > 3) {
            int x0 = pointsxy[n - 2];
            int y0 = pointsxy[n - 1];
            int i = 0;
            while (i < n) {
                int x1 = pointsxy[i++];
                int y1 = pointsxy[i++];
                if (y0 <= y && y < y1 && GFFigureUtil.crossProduct(x1, y1, x0, y0, x, y) > 0) {
                    boolean bl = isOdd = !isOdd;
                }
                if (y1 <= y && y < y0 && GFFigureUtil.crossProduct(x0, y0, x1, y1, x, y) > 0) {
                    isOdd = !isOdd;
                }
                x0 = x1;
                y0 = y1;
            }
            if (isOdd) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    private static int crossProduct(int ax, int ay, int bx, int by, int cx, int cy) {
        return (ax - cx) * (by - cy) - (ay - cy) * (bx - cx);
    }

    public static PointList getPointList(Polyline polyline) {
        int deltaX = polyline.getX();
        int deltaY = polyline.getY();
        PointList pointList = new PointList();
        for (org.eclipse.graphiti.mm.algorithms.styles.Point dtp : polyline.getPoints()) {
            pointList.addPoint(dtp.getX() + deltaX, dtp.getY() + deltaY);
        }
        return pointList;
    }

    public static Rectangle getPathBounds(Path path) {
        Rectangle ret = Rectangle.SINGLETON;
        path.getBounds(SINGLETON_BOUNDS);
        ret.setLocation((int)Math.floor(SINGLETON_BOUNDS[0]), (int)Math.floor(SINGLETON_BOUNDS[1]));
        ret.setSize((int)Math.ceil(SINGLETON_BOUNDS[2]), (int)Math.ceil(SINGLETON_BOUNDS[3]));
        return ret;
    }

    public static Rectangle getAdjustedRectangle(Rectangle rectangle, double zoom, int lw) {
        if (rectangle == null) {
            return null;
        }
        Rectangle ret = new Rectangle(rectangle);
        if (zoom != 1.0) {
            ret.x = (int)Math.floor((double)rectangle.x * zoom);
            ret.y = (int)Math.floor((double)rectangle.y * zoom);
            ret.width = (int)Math.floor((double)(rectangle.x + rectangle.width) * zoom) - ret.x;
            ret.height = (int)Math.floor((double)(rectangle.y + rectangle.height) * zoom) - ret.y;
        }
        int adjustmentTopLeft = lw / 2;
        int adjustmentBottomRight = lw;
        ret.x += adjustmentTopLeft;
        ret.y += adjustmentTopLeft;
        ret.width -= adjustmentBottomRight;
        ret.height -= adjustmentBottomRight;
        return ret;
    }

    public static PointList getAdjustedPointList(PointList points, double zoom, double lw) {
        Rectangle zoomedBounds = points.getBounds().getCopy().scale(zoom);
        double middlex = zoomedBounds.x + zoomedBounds.width / 2;
        double middley = zoomedBounds.y + zoomedBounds.height / 2;
        PointList ret = new PointList();
        int i = 0;
        while (i < points.size()) {
            Point point = points.getPoint(i);
            point.scale(zoom);
            double dx = (double)point.x < middlex ? Math.ceil((middlex - (double)point.x) / (double)zoomedBounds.width * lw) : Math.floor((middlex - (double)point.x) / (double)zoomedBounds.width * lw);
            double dy = (double)point.y < middley ? Math.ceil((middley - (double)point.y) / (double)zoomedBounds.height * lw) : Math.floor((middley - (double)point.y) / (double)zoomedBounds.height * lw);
            point.translate((int)dx, (int)dy);
            ret.addPoint(point);
            ++i;
        }
        return ret;
    }

    public static PointList getTranslatedPointList(PointList points, int dx, int dy) {
        PointList ret = new PointList();
        int i = 0;
        while (i < points.size()) {
            Point pt = points.getPoint(i);
            pt.x += dx;
            pt.y += dy;
            ret.addPoint(pt);
            ++i;
        }
        return ret;
    }

    public static Path getBezierPath(List<BezierPoint> origPoints, boolean isClosed) {
        Path path = new Path(null);
        ArrayList<BezierPoint> points = new ArrayList<BezierPoint>(origPoints.size() + 2);
        points.addAll(origPoints);
        if (points.size() < 3 || !GFFigureUtil.hasBezierDistance(origPoints)) {
            if (points.size() != 0) {
                path.moveTo((float)((BezierPoint)points.get(0)).getX(), (float)((BezierPoint)points.get(0)).getY());
                int i = 1;
                while (i < points.size()) {
                    path.lineTo((float)((BezierPoint)points.get(i)).getX(), (float)((BezierPoint)points.get(i)).getY());
                    ++i;
                }
            }
        } else {
            if (isClosed) {
                if (!((BezierPoint)points.get(points.size() - 1)).equals(points.get(0))) {
                    points.add((BezierPoint)points.get(0));
                }
                points.add((BezierPoint)points.get(1));
            }
            Point c = ((BezierPoint)points.get(0)).createDraw2dPoint();
            Point q = ((BezierPoint)points.get(1)).createDraw2dPoint();
            Point r = new Point();
            Point s = new Point();
            GFFigureUtil.determineBezierPoints(c, q, r, s, ((BezierPoint)points.get(0)).getBezierDistanceAfter(), ((BezierPoint)points.get(1)).getBezierDistanceBefore());
            if (!isClosed) {
                path.moveTo((float)((BezierPoint)points.get(0)).getX(), (float)((BezierPoint)points.get(0)).getY());
                path.lineTo((float)r.x, (float)r.y);
            } else {
                path.moveTo((float)r.x, (float)r.y);
            }
            int index = 2;
            while (index < points.size()) {
                c.setLocation(q);
                ((BezierPoint)points.get(index)).copyToDraw2dPoint(q);
                GFFigureUtil.determineBezierPoints(c, q, r, s, ((BezierPoint)points.get(index - 1)).getBezierDistanceAfter(), ((BezierPoint)points.get(index)).getBezierDistanceBefore());
                path.quadTo((float)c.x, (float)c.y, (float)s.x, (float)s.y);
                path.lineTo((float)r.x, (float)r.y);
                ++index;
            }
            if (!isClosed) {
                path.lineTo((float)((BezierPoint)points.get(points.size() - 1)).getX(), (float)((BezierPoint)points.get(points.size() - 1)).getY());
            }
        }
        if (isClosed) {
            path.close();
        }
        return path;
    }

    public static boolean hasBezierDistance(List<BezierPoint> points) {
        for (BezierPoint point : points) {
            if (point.getBezierDistanceBefore() == 0 && point.getBezierDistanceAfter() == 0) continue;
            return true;
        }
        return false;
    }

    private static void determineBezierPoints(Point c, Point q, Point r, Point s, int distanceAfterCurrent, int distanceBeforeNext) {
        int vx = q.x - c.x;
        int vy = q.y - c.y;
        Vector v = new Vector((double)vx, (double)vy);
        double absV = v.getLength();
        int mx = Math.round(c.x + vx / 2);
        int my = Math.round(c.y + vy / 2);
        int tolerance = distanceAfterCurrent + distanceBeforeNext;
        if (absV < (double)tolerance) {
            r.x = mx;
            r.y = my;
            s.x = mx;
            s.y = my;
        } else {
            double x = (absV - (double)distanceBeforeNext) / absV;
            r.x = Math.round((float)c.x + (float)x * (float)vx);
            r.y = Math.round((float)c.y + (float)x * (float)vy);
            double y = (double)distanceAfterCurrent / absV;
            s.x = Math.round((float)c.x + (float)y * (float)vx);
            s.y = Math.round((float)c.y + (float)y * (float)vy);
        }
    }

    public static void drawRichText(Graphics g, String draw, int x, int y, IConfigurationProviderInternal configurationProvider, AbstractText text) {
        GFFigureUtil.drawRichText(g, draw, x, y, -1, false, 0, configurationProvider, text);
    }

    protected static void drawRichText(Graphics g, String draw, int x, int y, int bidiLevel, boolean mirrored, int currentOffset, IConfigurationProviderInternal configurationProvider, AbstractText text) {
        if (bidiLevel == -1) {
            TextLayout tl = new TextLayout((Device)Display.getDefault());
            if (mirrored) {
                tl.setOrientation(0x4000000);
            }
            ArrayList<org.eclipse.swt.graphics.Font> fontsToDispose = new ArrayList<org.eclipse.swt.graphics.Font>();
            Font textFont = text.getFont();
            if (textFont != null) {
                tl.setFont(DataTypeTransformation.toSwtFont(textFont));
                fontsToDispose.add(tl.getFont());
            } else {
                tl.setFont(g.getFont());
            }
            tl.setText(draw);
            for (TextStyleRegion style : text.getStyleRegions()) {
                org.eclipse.graphiti.mm.algorithms.styles.Color strikeoutColor;
                org.eclipse.graphiti.mm.algorithms.styles.Color underlineColor;
                org.eclipse.graphiti.mm.algorithms.styles.Color background;
                org.eclipse.graphiti.mm.algorithms.styles.Color foreground;
                int start = style.getStart() - currentOffset;
                int end = style.getEnd() - currentOffset;
                if (start >= draw.length() || end < 0) continue;
                TextStyle textStyle = new TextStyle();
                org.eclipse.graphiti.mm.algorithms.styles.TextStyle gTextStyle = style.getStyle();
                textStyle.underline = gTextStyle.isUnderline();
                textStyle.strikeout = gTextStyle.isStrikeout();
                textStyle.underlineStyle = gTextStyle.getUnderlineStyle().getValue();
                Font font = gTextStyle.getFont();
                if (font != null) {
                    textStyle.font = DataTypeTransformation.toSwtFont(font);
                    fontsToDispose.add(textStyle.font);
                }
                if ((foreground = gTextStyle.getForeground()) != null) {
                    textStyle.foreground = DataTypeTransformation.toSwtColor(configurationProvider.getResourceRegistry(), foreground);
                }
                if ((background = gTextStyle.getBackground()) != null) {
                    textStyle.background = DataTypeTransformation.toSwtColor(configurationProvider.getResourceRegistry(), background);
                }
                if ((underlineColor = gTextStyle.getUnderlineColor()) != null) {
                    textStyle.underlineColor = DataTypeTransformation.toSwtColor(configurationProvider.getResourceRegistry(), underlineColor);
                }
                if ((strikeoutColor = gTextStyle.getStrikeoutColor()) != null) {
                    textStyle.strikeoutColor = DataTypeTransformation.toSwtColor(configurationProvider.getResourceRegistry(), strikeoutColor);
                }
                tl.setStyle(textStyle, start, end);
            }
            g.drawTextLayout(tl, x, y);
            tl.dispose();
            for (org.eclipse.swt.graphics.Font font : fontsToDispose) {
                font.dispose();
            }
        } else {
            TextLayout tl = new TextLayout((Device)Display.getDefault());
            if (mirrored) {
                tl.setOrientation(0x4000000);
            }
            tl.setFont(g.getFont());
            tl.setText(draw);
            g.drawTextLayout(tl, x, y);
            tl.dispose();
        }
    }
}

