/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import java.util.List;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef3.handles.HandleBounds;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.AdaptedGradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredArea;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.RenderingStyle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.ga.IVisualState;
import org.eclipse.graphiti.platform.ga.IVisualStateChangeListener;
import org.eclipse.graphiti.platform.ga.IVisualStateHolder;
import org.eclipse.graphiti.platform.ga.VisualStateChangedEvent;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IShapeSelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.DecoratorImageFigure;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.IGradientType;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;

public abstract class GFAbstractShape
extends org.eclipse.draw2dl.Shape
implements HandleBounds,
IVisualStateHolder,
IVisualStateChangeListener {
    private final IPictogramElementDelegate pictogramElementDelegate;
    private final GraphicsAlgorithm graphicsAlgorithm;
    private GraphicsAlgorithm selectionBorder;
    private GraphicsAlgorithm[] clickArea;

    public GFAbstractShape(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        this.pictogramElementDelegate = pictogramElementDelegate;
        this.graphicsAlgorithm = graphicsAlgorithm;
        this.getVisualState().addChangeListener((IVisualStateChangeListener)this);
    }

    protected abstract Path createPath(Rectangle var1, Graphics var2, boolean var3);

    protected IPictogramElementDelegate getPictogramElementDelegate() {
        return this.pictogramElementDelegate;
    }

    protected GraphicsAlgorithm getGraphicsAlgorithm() {
        return this.graphicsAlgorithm;
    }

    protected IConfigurationProviderInternal getConfigurationProvider() {
        return this.getPictogramElementDelegate().getConfigurationProvider();
    }

    protected double getZoomLevel(Graphics graphics) {
        return graphics.getAbsoluteScale();
    }

    protected int getLineWidth(Graphics graphics) {
        return this.getLineWidth();
    }

    protected void transformToFillBounds(Rectangle outlineBounds, Graphics graphics) {
        int lineWidth = this.getLineWidth(graphics);
        outlineBounds.x += (lineWidth + 1) / 2;
        outlineBounds.y += (lineWidth + 1) / 2;
        outlineBounds.height -= lineWidth - 1;
        outlineBounds.width -= lineWidth - 1;
    }

    protected GraphicsAlgorithm[] getClickArea() {
        return this.clickArea;
    }

    protected GraphicsAlgorithm getSelectionBorder() {
        return this.selectionBorder;
    }

    protected Boolean containsPointInArea(int x, int y) {
        List children2 = this.getChildren();
        for (IFigure figure : children2) {
            if (!(figure instanceof DecoratorImageFigure) || !figure.containsPoint(x, y)) continue;
            return Boolean.TRUE;
        }
        GraphicsAlgorithm[] gas = this.getClickArea();
        if (gas != null) {
            int i = 0;
            while (i < gas.length) {
                IFigure figure = this.getPictogramElementDelegate().getFigureForGraphicsAlgorithm(gas[i]);
                if (figure != null && !((Object)((Object)this)).equals(figure)) {
                    if (figure.containsPoint(x, y)) {
                        return Boolean.TRUE;
                    }
                } else {
                    return null;
                }
                ++i;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    protected boolean containsPointInFigure(int x, int y) {
        return super.containsPoint(x, y);
    }

    protected void fillPath(Graphics graphics, Path path) {
        RenderingStyle renderingStyle = Graphiti.getGaService().getRenderingStyle(this.graphicsAlgorithm, true);
        if (this.adaptBackgroundToHover(graphics)) {
            graphics.fillPath(path);
        } else if (renderingStyle != null && !this.isHighContrastMode()) {
            graphics.pushState();
            try {
                Rectangle pathBounds = GFFigureUtil.getPathBounds(path);
                graphics.clipPath(path);
                int styleAdaptation = this.getStyleAdaptation();
                AdaptedGradientColoredAreas adaptedGradientColoredAreas = renderingStyle.getAdaptedGradientColoredAreas();
                EList gradientColoredAreas = adaptedGradientColoredAreas.getAdaptedGradientColoredAreas();
                EList gradienColoredAreaList = null;
                gradienColoredAreaList = gradientColoredAreas != null && gradientColoredAreas.size() > 0 && gradientColoredAreas.size() - 1 >= styleAdaptation ? ((GradientColoredAreas)gradientColoredAreas.get(styleAdaptation)).getGradientColor() : ((GradientColoredAreas)gradientColoredAreas.get(0)).getGradientColor();
                boolean isVertical = true;
                if (adaptedGradientColoredAreas.getGradientType() != null && adaptedGradientColoredAreas.getGradientType().equals(IGradientType.HORIZONTAL)) {
                    isVertical = false;
                }
                for (GradientColoredArea gradientColoredArea : gradienColoredAreaList) {
                    GFFigureUtil.paintColorFlow(this.getConfigurationProvider(), pathBounds, graphics, gradientColoredArea, this.getZoomLevel(graphics), isVertical);
                }
            }
            finally {
                graphics.popState();
            }
        } else {
            this.setBackgroundWithoutStyle(graphics, path);
        }
    }

    private void setBackgroundWithoutStyle(Graphics graphics, Path path) {
        Color oldBackground = graphics.getBackgroundColor();
        int selectionFeedback = this.getVisualState().getSelectionFeedback();
        if (selectionFeedback == 1 || selectionFeedback == 2) {
            IColorConstant secondarySelectionBackGroundColor;
            IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            PictogramElement pe = this.getPictogramElementDelegate().getPictogramElement();
            IShapeSelectionInfo selectionInfo = null;
            if (pe instanceof Shape) {
                selectionInfo = tbp.getSelectionInfoForShape((Shape)pe);
            } else if (pe instanceof Anchor) {
                selectionInfo = tbp.getSelectionInfoForAnchor((Anchor)pe);
            }
            if (selectionInfo == null) {
                return;
            }
            if (selectionFeedback == 1) {
                IColorConstant primarySelectionBackGroundColor = selectionInfo.getPrimarySelectionBackgroundColor();
                if (primarySelectionBackGroundColor != null) {
                    graphics.setBackgroundColor(DataTypeTransformation.toSwtColor(this.getConfigurationProvider().getResourceRegistry(), primarySelectionBackGroundColor));
                }
            } else if (selectionFeedback == 2 && (secondarySelectionBackGroundColor = selectionInfo.getSecondarySelectionBackgroundColor()) != null) {
                graphics.setBackgroundColor(DataTypeTransformation.toSwtColor(this.getConfigurationProvider().getResourceRegistry(), secondarySelectionBackGroundColor));
            }
        }
        graphics.fillPath(path);
        graphics.setBackgroundColor(oldBackground);
    }

    private int getStyleAdaptation() {
        int styleAdaptation = 0;
        int selectionFeedback = this.getVisualState().getSelectionFeedback();
        if (selectionFeedback == 1) {
            styleAdaptation = 1;
        } else if (selectionFeedback == 2) {
            styleAdaptation = 2;
        }
        int actionTargetFeedback = this.getVisualState().getActionTargetFeedback();
        if (actionTargetFeedback == 1) {
            styleAdaptation = 2;
        }
        return styleAdaptation;
    }

    private boolean adaptBackgroundToHover(Graphics graphics) {
        if (this.getVisualState().getHoverFeedback() == 0) {
            IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            IFigure parent = this.getParent();
            boolean parentSelected = false;
            if (parent instanceof GFAbstractShape) {
                GFAbstractShape gfa = (GFAbstractShape)parent;
                IVisualState visualState = gfa.getVisualState();
                parentSelected = visualState.getSelectionFeedback() == 1;
            }
            PictogramElement pe = this.getPictogramElementDelegate().getPictogramElement();
            IShapeSelectionInfo selectionInfo = null;
            if (pe instanceof Shape) {
                Shape s = (Shape)pe;
                selectionInfo = tbp.getSelectionInfoForShape(s);
            } else if (pe instanceof Anchor) {
                Anchor anchor = (Anchor)pe;
                selectionInfo = tbp.getSelectionInfoForAnchor(anchor);
            }
            if (selectionInfo != null) {
                IColorConstant hoverColor = null;
                hoverColor = selectionInfo.getHoverColor();
                if (parentSelected) {
                    hoverColor = selectionInfo.getHoverColorParentSelected();
                }
                if (hoverColor != null) {
                    Color hoverColorSwt = DataTypeTransformation.toSwtColor(this.getConfigurationProvider().getResourceRegistry(), hoverColor);
                    graphics.setBackgroundColor(hoverColorSwt);
                    return true;
                }
            }
        }
        return false;
    }

    protected void paintShape(Graphics graphics, boolean isFill) {
        int oldLineWidth = graphics.getLineWidth();
        graphics.setLineWidth(this.getLineWidth(graphics));
        double zoom = this.getZoomLevel(graphics);
        int lw = this.getLineWidth(graphics);
        Rectangle pathbounds = GFFigureUtil.getAdjustedRectangle(this.getBounds(), zoom, lw);
        if (isFill) {
            this.transformToFillBounds(pathbounds, graphics);
        }
        Path path = this.createPath(pathbounds, graphics, isFill);
        if (isFill) {
            this.fillPath(graphics, path);
        } else {
            graphics.drawPath(path);
        }
        path.dispose();
        graphics.setLineWidth(oldLineWidth);
    }

    public void paintFigure(Graphics graphics) {
        if (GraphitiInternal.getEmfService().isObjectAlive((EObject)this.graphicsAlgorithm)) {
            double transparency = Graphiti.getGaService().getTransparency(this.graphicsAlgorithm, true);
            int alpha = (int)((1.0 - transparency) * 255.0);
            graphics.setAlpha(alpha);
            graphics.setAntialias(1);
            super.paintFigure(graphics);
        }
    }

    protected void fillShape(Graphics graphics) {
        this.paintShape(graphics, true);
    }

    protected void outlineShape(Graphics graphics) {
        this.paintShape(graphics, false);
    }

    public final boolean containsPoint(int x, int y) {
        Boolean ret = this.containsPointInArea(x, y);
        if (ret != null) {
            if (!ret.booleanValue() && this.getClickArea() != null && this.containsPointInFigure(x, y)) {
                List<IFigure> fList = this.getPictogramElementDelegate().getMainFiguresFromChildEditparts();
                for (IFigure figure : fList) {
                    if (!figure.containsPoint(x, y)) continue;
                    return true;
                }
            }
            return ret;
        }
        return this.containsPointInFigure(x, y);
    }

    public Rectangle getHandleBounds() {
        IFigure selectionFigure;
        Rectangle ret = null;
        GraphicsAlgorithm selectionGa = this.getSelectionBorder();
        if (selectionGa != null && (selectionFigure = this.getPictogramElementDelegate().getFigureForGraphicsAlgorithm(selectionGa)) != null) {
            ret = selectionFigure.getBounds();
        }
        if (ret == null) {
            ret = this.getBounds();
        }
        return ret;
    }

    public IVisualState getVisualState() {
        return this.getPictogramElementDelegate().getVisualState();
    }

    public void visualStateChanged(VisualStateChangedEvent e) {
        this.repaint();
    }

    public void setSelectionBorder(GraphicsAlgorithm selectionBorder) {
        this.selectionBorder = selectionBorder;
    }

    public void setClickArea(GraphicsAlgorithm[] clickArea) {
        this.clickArea = clickArea;
    }

    protected GFPreferences getPreferences() {
        return GFPreferences.getInstance();
    }

    private boolean isHighContrastMode() {
        boolean ret = false;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null) {
            ret = display.getHighContrast();
        }
        return ret;
    }
}

