/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.tools;

import java.util.List;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartViewer;
import org.eclipse.gef3.requests.DirectEditRequest;
import org.eclipse.gef3.requests.SelectionRequest;
import org.eclipse.gef3.tools.DelayedDirectEditHelper;
import org.eclipse.gef3.tools.TargetingTool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;

public class SelectEditPartTracker
extends TargetingTool
implements DragTracker {
    protected static final int FLAG_SELECTION_PERFORMED = 64;
    private static final int FLAG_ENABLE_DIRECT_EDIT = 128;
    protected static final int MAX_FLAG = 128;
    private EditPart editpart;

    public SelectEditPartTracker(EditPart owner) {
        this.setSourceEditPart(owner);
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.isInState(19)) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    protected String getCommandName() {
        return "Select Tracker";
    }

    @Override
    protected String getDebugName() {
        return "Select Tracker";
    }

    protected EditPart getSourceEditPart() {
        return this.editpart;
    }

    @Override
    protected boolean handleButtonDown(int button) {
        if ((button == 3 || button == 1) && this.isInState(1)) {
            this.performConditionalSelection();
        }
        if (button != 1) {
            this.setState(8);
            if (button == 3) {
                this.setState(0x40000000);
            }
            this.handleInvalidInput();
        } else {
            this.stateTransition(1, 2);
        }
        return true;
    }

    @Override
    protected boolean handleButtonUp(int button) {
        if (this.isInState(2)) {
            this.performSelection();
            if (this.getFlag(128)) {
                this.performDirectEdit();
            }
            if (button == 1 && this.getSourceEditPart().getSelected() != 0) {
                this.getCurrentViewer().reveal(this.getSourceEditPart());
            }
            this.setState(0x40000000);
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleDoubleClick(int button) {
        this.setFlag(128, false);
        if (button == 1) {
            this.setFlag(64, true);
            this.performOpen();
        }
        return true;
    }

    @Override
    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    protected boolean hasSelectionOccurred() {
        return this.getFlag(64);
    }

    protected void performConditionalSelection() {
        if (this.getSourceEditPart().getSelected() == 0) {
            this.performSelection();
        } else if (this.getCurrentInput().getModifiers() == 0) {
            this.setFlag(128, true);
        }
    }

    protected void performDirectEdit() {
        DirectEditRequest req = new DirectEditRequest();
        req.setLocation(this.getCurrentInput().getMouseLocation());
        new DelayedDirectEditHelper(this.getSourceEditPart().getViewer(), req, this.getSourceEditPart());
    }

    protected void performOpen() {
        SelectionRequest request = new SelectionRequest();
        request.setLocation(this.getLocation());
        request.setModifiers(this.getCurrentInput().getModifiers());
        request.setType("open");
        this.getSourceEditPart().performRequest(request);
    }

    protected void performSelection() {
        if (this.hasSelectionOccurred()) {
            return;
        }
        this.setFlag(64, true);
        EditPartViewer viewer = this.getCurrentViewer();
        List selectedObjects = viewer.getSelectedEditParts();
        if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
            if (selectedObjects.contains(this.getSourceEditPart())) {
                viewer.deselect(this.getSourceEditPart());
            } else {
                viewer.appendSelection(this.getSourceEditPart());
            }
        } else if (this.getCurrentInput().isShiftKeyDown()) {
            viewer.appendSelection(this.getSourceEditPart());
        } else {
            viewer.select(this.getSourceEditPart());
        }
    }

    @Override
    protected void resetFlags() {
        super.resetFlags();
        this.setFlag(64, false);
        this.setFlag(128, false);
    }

    protected void setSourceEditPart(EditPart part) {
        this.editpart = part;
    }
}

