/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.tools;

import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PrecisionRectangle;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartViewer;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.SharedCursors;
import org.eclipse.gef3.SnapToHelper;
import org.eclipse.gef3.requests.CreateRequest;
import org.eclipse.gef3.requests.CreationFactory;
import org.eclipse.gef3.tools.TargetingTool;
import org.eclipse.swt.graphics.Cursor;

public class CreationTool
extends TargetingTool {
    public static final Object PROPERTY_CREATION_FACTORY = "factory";
    private CreationFactory factory;
    private SnapToHelper helper;

    public CreationTool() {
        this.setDefaultCursor(SharedCursors.CURSOR_TREE_ADD);
        this.setDisabledCursor(SharedCursors.NO);
    }

    public CreationTool(CreationFactory aFactory) {
        this();
        this.setFactory(aFactory);
    }

    @Override
    protected void applyProperty(Object key, Object value) {
        if (PROPERTY_CREATION_FACTORY.equals(key)) {
            if (value instanceof CreationFactory) {
                this.setFactory((CreationFactory)value);
            }
            return;
        }
        super.applyProperty(key, value);
    }

    @Override
    protected Cursor calculateCursor() {
        return super.calculateCursor();
    }

    @Override
    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory(this.getFactory());
        return request;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.helper = null;
    }

    @Override
    protected String getCommandName() {
        return "create child";
    }

    protected CreateRequest getCreateRequest() {
        return (CreateRequest)this.getTargetRequest();
    }

    @Override
    protected String getDebugName() {
        return "Creation Tool";
    }

    protected CreationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected boolean handleButtonDown(int button) {
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
            return true;
        }
        if (this.stateTransition(1, 2)) {
            this.getCreateRequest().setLocation(this.getLocation());
            this.lockTargetEditPart(this.getTargetEditPart());
            if (this.getTargetEditPart() != null) {
                this.helper = (SnapToHelper)this.getTargetEditPart().getAdapter(SnapToHelper.class);
            }
        }
        return true;
    }

    @Override
    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(6, 0x40000000)) {
            this.eraseTargetFeedback();
            this.unlockTargetEditPart();
            this.performCreation(button);
        }
        this.setState(0x40000000);
        this.handleFinished();
        return true;
    }

    @Override
    protected boolean handleDragInProgress() {
        if (this.isInState(4)) {
            this.updateTargetRequest();
            this.setCurrentCommand(this.getCommand());
            this.showTargetFeedback();
        }
        return true;
    }

    @Override
    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    @Override
    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleHover() {
        if (this.isInState(1)) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    @Override
    protected boolean handleMove() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.setCurrentCommand(this.getCommand());
        this.showTargetFeedback();
        return true;
    }

    protected void performCreation(int button) {
        EditPartViewer viewer = this.getCurrentViewer();
        this.executeCurrentCommand();
        this.selectAddedObject(viewer);
    }

    private void selectAddedObject(EditPartViewer viewer) {
        Object model = this.getCreateRequest().getNewObject();
        if (model == null || viewer == null) {
            return;
        }
        Object editpart = viewer.getEditPartRegistry().get(model);
        viewer.flush();
        if (editpart != null && editpart instanceof EditPart && ((EditPart)editpart).isSelectable()) {
            viewer.select((EditPart)editpart);
        }
    }

    public void setFactory(CreationFactory factory) {
        this.factory = factory;
    }

    @Override
    protected void updateTargetRequest() {
        CreateRequest createRequest = this.getCreateRequest();
        if (this.isInState(4)) {
            Point loq = this.getStartLocation();
            Rectangle bounds = new Rectangle(loq, loq);
            bounds.union(loq.getTranslated(this.getDragMoveDelta()));
            createRequest.setSize(bounds.getSize());
            createRequest.setLocation(bounds.getLocation());
            createRequest.getExtendedData().clear();
            createRequest.setSnapToEnabled(!this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING));
            if (this.helper != null && createRequest.isSnapToEnabled()) {
                PrecisionRectangle baseRect = new PrecisionRectangle(bounds);
                PrecisionRectangle result = baseRect.getPreciseCopy();
                this.helper.snapRectangle((Request)createRequest, 29, baseRect, result);
                createRequest.setLocation(result.getLocation());
                createRequest.setSize(result.getSize());
            }
            this.enforceConstraintsForSizeOnDropCreate(createRequest);
        } else {
            createRequest.setSize(null);
            createRequest.setLocation(this.getLocation());
            createRequest.setSnapToEnabled(false);
        }
    }

    protected void enforceConstraintsForSizeOnDropCreate(CreateRequest request) {
        CreateRequest createRequest = (CreateRequest)this.getTargetRequest();
        if (createRequest.getSize() != null) {
            PrecisionRectangle constraint = new PrecisionRectangle(createRequest.getLocation(), createRequest.getSize());
            ((GraphicalEditPart)this.getTargetEditPart()).getContentPane().translateToRelative((Translatable)constraint);
            constraint.setSize(Dimension.max((Dimension)constraint.getSize(), (Dimension)this.getMinimumSizeFor(createRequest)));
            constraint.setSize(Dimension.min((Dimension)constraint.getSize(), (Dimension)this.getMaximumSizeFor(createRequest)));
            ((GraphicalEditPart)this.getTargetEditPart()).getContentPane().translateToAbsolute((Translatable)constraint);
            createRequest.setSize(constraint.getSize());
        }
    }

    protected Dimension getMaximumSizeFor(CreateRequest request) {
        return IFigure.MAX_DIMENSION;
    }

    protected Dimension getMinimumSizeFor(CreateRequest request) {
        return IFigure.MIN_DIMENSION;
    }
}

