/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import nl.knaw.dans.common.dbflib.Version;

class Util {
    static final int NR_OF_DIGITS_IN_YEAR = 4;

    private Util() {
    }

    static int changeEndianness(int integerValue) {
        boolean isNegative = false;
        int i = integerValue;
        if (i < 0) {
            isNegative = true;
            i &= Integer.MAX_VALUE;
        }
        int first = i >>> 24;
        if (isNegative) {
            first |= 0x80;
        }
        i = integerValue & 0xFF0000;
        int second = i >>> 16;
        i = integerValue & 0xFF00;
        int third = i >>> 8;
        int fourth = integerValue & 0xFF;
        return (fourth << 24) + (third << 16) + (second << 8) + first;
    }

    static short changeEndianness(short shortValue) {
        boolean isNegative = false;
        short s = shortValue;
        if (s < 0) {
            isNegative = true;
            s = (short)(s & Short.MAX_VALUE);
        }
        int first = s >>> 8;
        if (isNegative) {
            first |= 0x80;
        }
        int second = s & 0xFF;
        return (short)((second << 8) + first);
    }

    static int changeEndiannessUnsignedShort(int integerValue) {
        int third = (integerValue & 0xFF00) >>> 8;
        int fourth = integerValue & 0xFF;
        return (fourth << 8) + third;
    }

    static String stripExtension(String fileName) {
        int pointIndex = fileName.lastIndexOf(46);
        if (pointIndex == -1 || pointIndex == 0 || pointIndex == fileName.length() - 1) {
            return fileName;
        }
        return fileName.substring(0, pointIndex);
    }

    static File getMemoFile(File dbfFile, Version version) {
        String dbfBaseName;
        if (!dbfFile.exists()) {
            return null;
        }
        String extension = version == Version.FOXPRO_26 ? ".fpt" : ".dbt";
        String parentDirName = dbfFile.getParent();
        File parentDir = new File(parentDirName);
        String[] candidates = parentDir.list(new FilenameFilter(dbfBaseName = Util.stripExtension(dbfFile.getName()), extension){
            final /* synthetic */ String val$dbfBaseName;
            final /* synthetic */ String val$extension;
            {
                this.val$dbfBaseName = string;
                this.val$extension = string2;
            }

            @Override
            public boolean accept(File aDir, String aName) {
                return this.val$dbfBaseName.equalsIgnoreCase(Util.stripExtension(aName)) && aName.toLowerCase().endsWith(this.val$extension);
            }
        });
        if (candidates.length == 1) {
            return new File(parentDir, candidates[0]);
        }
        return null;
    }

    static void writeString(DataOutput dataOutput, String string, int length) throws IOException {
        char[] charArray = new char[length + 1];
        int lengthString = string.length();
        int i = 0;
        charArray = string.toCharArray();
        for (i = 0; i < length && i < lengthString; ++i) {
            dataOutput.writeByte(charArray[i]);
        }
        while (i < length) {
            dataOutput.writeByte(0);
            ++i;
        }
    }

    static String readString(DataInput dataInput, int length) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte c = 0;
        for (read = 1; (c = dataInput.readByte()) != 0 && read < length; ++read) {
            bos.write(c);
        }
        if (c != 0) {
            bos.write(c);
        }
        dataInput.skipBytes(length - read);
        return new String(bos.toByteArray());
    }

    static byte[] readStringBytes(DataInput dataInput, int length) throws IOException {
        int index;
        byte[] array = new byte[length];
        dataInput.readFully(array);
        for (index = 0; index != length && array[index] != 0; ++index) {
        }
        return Arrays.copyOf(array, index == 0 ? index + 1 : index);
    }

    static Date createDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        if (Integer.toString(year).length() > 4) {
            throw new IllegalArgumentException("Year more than4 digits long");
        }
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    static int getNumberOfIntDigits(Number number) {
        if (number instanceof Float || number instanceof Double || number instanceof Short || number instanceof Integer || number instanceof Long) {
            long longValue = number.longValue();
            if (longValue == 0L) {
                return 1;
            }
            return (int)Math.floor(Math.log10(Math.abs(longValue))) + 1;
        }
        BigInteger bi = null;
        if (number instanceof BigDecimal) {
            bi = ((BigDecimal)number).toBigInteger();
        }
        if (number instanceof BigInteger) {
            bi = (BigInteger)number;
        }
        return bi.abs().toString().length();
    }

    static int getSignWidth(Number number) {
        if (number instanceof Float || number instanceof Double || number instanceof Short || number instanceof Integer || number instanceof Long) {
            return number.longValue() < 0L ? 1 : 0;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).signum() == -1 ? 1 : 0;
        }
        if (number instanceof BigInteger) {
            return ((BigInteger)number).signum() == -1 ? 1 : 0;
        }
        throw new IllegalArgumentException("Unsupported Number type");
    }

    static byte[] repeat(byte byteValue, int times) {
        byte[] result = new byte[times];
        for (int i = 0; i < result.length; ++i) {
            result[i] = byteValue;
        }
        return result;
    }

    static String createString(byte[] bytes, String charsetName) {
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Programming error: found unsupported charset too late");
        }
    }

    static byte[] getStringBytes(String string, String charsetName) {
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Programming error: found unsupported charset too late");
        }
    }
}

