/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.util.regex.Pattern;
import nl.knaw.dans.common.dbflib.AbstractDataValidator;
import nl.knaw.dans.common.dbflib.DataMismatchException;
import nl.knaw.dans.common.dbflib.DbfLibException;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.Type;
import nl.knaw.dans.common.dbflib.Util;
import nl.knaw.dans.common.dbflib.ValueTooLargeException;

class NumberFormatValidator
extends AbstractDataValidator {
    private final Pattern stringPattern;

    NumberFormatValidator(Field field) {
        super(field);
        assert (field.getType() == Type.NUMBER || field.getType() == Type.FLOAT) : "Can only be validator for NUMBER or FLOAT fields";
        int beforeDecimalPointLength = field.getLength();
        String decimalPartPattern = "";
        if (field.getDecimalCount() > 0) {
            beforeDecimalPointLength -= field.getDecimalCount() - 1;
            decimalPartPattern = "\\.\\d{" + field.getDecimalCount() + "," + field.getDecimalCount() + "}";
        }
        String withSignAlternative = "";
        if (beforeDecimalPointLength > 1) {
            withSignAlternative = "\\-\\d{1," + (beforeDecimalPointLength - 1) + "}|";
        }
        String withoutSignAlternative = "\\d{1," + beforeDecimalPointLength + "}";
        String patternString = "(" + withSignAlternative + withoutSignAlternative + ")" + decimalPartPattern;
        this.stringPattern = Pattern.compile(patternString);
    }

    @Override
    public void validate(Object typedObject) throws DbfLibException {
        if (typedObject instanceof Number) {
            int nrPositionsForDecimals;
            Number numberValue = (Number)typedObject;
            int n = nrPositionsForDecimals = this.field.getDecimalCount() == 0 ? 0 : this.field.getDecimalCount() + 1;
            if (Util.getSignWidth(numberValue) + Util.getNumberOfIntDigits(numberValue) > this.field.getLength() - nrPositionsForDecimals) {
                throw new ValueTooLargeException("Number does not fit in the field '" + this.field.getName() + "': " + numberValue);
            }
            return;
        }
        if (typedObject instanceof String) {
            String stringValue = (String)typedObject;
            if (!this.stringPattern.matcher(stringValue = stringValue.trim()).matches()) {
                throw new DataMismatchException("The string '" + stringValue + "' does not contain a valid number, is too long or contains an incorrect number of decimals");
            }
            return;
        }
        throw new DataMismatchException("Cannot write objects of type '" + typedObject.getClass().getName() + "' to a NUMBER or FLOAT field");
    }
}

