/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.TimestampTranslator;
import java.sql.SQLException;

public class UnicodeInternalTimestampTranslator
extends TimestampTranslator {
    public UnicodeInternalTimestampTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected int parseYear(byte[] raw) {
        int year = (raw[1] - 48) * 1000;
        year += (raw[3] - 48) * 100;
        year += (raw[5] - 48) * 10;
        return year += raw[7] - 48;
    }

    protected int parseMonth(byte[] raw) {
        int month = (raw[9] - 48) * 10;
        return month += raw[11] - 48;
    }

    protected int parseDay(byte[] raw) {
        int day = (raw[13] - 48) * 10;
        return day += raw[15] - 48;
    }

    protected int parseHours(byte[] raw) {
        int hour = (raw[17] - 48) * 10;
        return hour += raw[19] - 48;
    }

    protected int parseMinutes(byte[] raw) {
        int min = (raw[21] - 48) * 10;
        return min += raw[23] - 48;
    }

    protected int parseSeconds(byte[] raw) {
        int sec = (raw[25] - 48) * 10;
        return sec += raw[27] - 48;
    }

    protected int parseNanoseconds(byte[] raw) {
        int milli = (raw[29] - 48) * 100;
        milli += (raw[31] - 48) * 10;
        int nano = ((milli += raw[33] - 48) * 10 + (raw[35] - 48)) * 100;
        nano += (raw[37] - 48) * 10;
        nano += raw[39] - 48;
        return nano *= 1000;
    }

    protected byte[] formatTimestamp(int year, int month, int day, int hour, int minute, int second, int nano) {
        byte[] formattedTimestamp = new byte[40];
        formattedTimestamp[1] = (byte)(48 + year / 1000);
        formattedTimestamp[3] = (byte)(48 + (year %= 1000) / 100);
        formattedTimestamp[5] = (byte)(48 + (year %= 100) / 10);
        formattedTimestamp[7] = (byte)(48 + (year %= 10));
        formattedTimestamp[9] = HighTime_C[month];
        formattedTimestamp[11] = LowTime_C[month];
        formattedTimestamp[13] = HighTime_C[day];
        formattedTimestamp[15] = LowTime_C[day];
        formattedTimestamp[17] = HighTime_C[hour];
        formattedTimestamp[19] = LowTime_C[hour];
        formattedTimestamp[21] = (byte)(48 + minute / 10);
        formattedTimestamp[23] = (byte)(48 + minute % 10);
        formattedTimestamp[25] = (byte)(48 + second / 10);
        formattedTimestamp[27] = (byte)(48 + second % 10);
        int tmpVal = nano / 1000;
        formattedTimestamp[29] = (byte)(48 + tmpVal / 100000);
        formattedTimestamp[31] = (byte)(48 + (tmpVal %= 100000) / 10000);
        formattedTimestamp[33] = (byte)(48 + (tmpVal %= 10000) / 1000);
        formattedTimestamp[35] = (byte)(48 + (tmpVal %= 1000) / 100);
        formattedTimestamp[37] = (byte)(48 + (tmpVal %= 100) / 10);
        formattedTimestamp[39] = (byte)(48 + (tmpVal %= 10));
        return formattedTimestamp;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            byte[] tmpArr = new byte[]{raw[1], raw[3], raw[5], raw[7], 45, raw[9], raw[11], 45, raw[13], raw[15], 32, raw[17], raw[19], 58, raw[21], raw[23], 58, raw[25], raw[27], 46, raw[29], raw[31], raw[33], raw[35], raw[37], raw[39]};
            result = new String(tmpArr);
        }
        return result;
    }
}

