/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StructMemberTranslator;
import com.sap.dbtech.jdbc.translators.Structure;
import com.sap.dbtech.jdbc.translators.StructureSQLOutput;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;

public class StructureTranslator
extends DBTechTranslator {
    DBProcParameterInfo parameterStructure;
    StructMemberTranslator[] structureConverter;
    boolean unicode;

    public StructureTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean unicode, boolean readOnly, boolean autoIncre) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
        this.unicode = unicode;
        this.structureConverter = new StructMemberTranslator[0];
    }

    protected void putSpecific(DataPart dataPart, Object data) throws SQLException {
        byte[] bytes = (byte[])data;
        dataPart.putDefineByte(0, this.bufpos_input - 1);
        dataPart.putBytes(bytes, this.bufpos_input, this.physicalLength - 1);
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] result = null;
        if (this.isNull(controller, mem)) {
            return 0;
        }
        result = mem.getBytes(this.bufpos_output, 1);
        return result[0];
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getBytes(this.bufpos_output, this.logicalLength);
        }
        return result;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] ba = this.getBytes(controller, mem);
        if (ba != null) {
            Object[] objArr = new Object[this.structureConverter.length];
            StructuredBytes sb = new StructuredBytes(ba);
            for (int i = 0; i < objArr.length; ++i) {
                objArr[i] = this.structureConverter[i].getObject(sb, 0);
            }
            return new Structure(objArr, this.parameterStructure.getSQLTypeName());
        }
        return null;
    }

    public Object transByteForInput(byte val) throws SQLException {
        byte[] barr = new byte[]{val};
        return this.transBytesForInput(barr);
    }

    public Object transBytesForInput(byte[] arg) throws SQLException {
        if (arg == null) {
            return arg;
        }
        this.checkFieldLimits(arg.length);
        return arg;
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof byte[]) {
            result = this.transBytesForInput((byte[])obj);
        } else if (obj instanceof Object[]) {
            result = this.transObjectArrayForInput((Object[])obj);
        } else if (obj instanceof Struct) {
            result = this.transObjectArrayForInput(((Struct)obj).getAttributes());
        } else if (obj instanceof SQLData) {
            result = this.transSQLDataForInput((SQLData)obj);
        }
        return result;
    }

    public Object transSQLDataForInput(SQLData sqlData) throws SQLException {
        StructureSQLOutput sqlOutput = new StructureSQLOutput(this);
        sqlData.writeSQL(sqlOutput);
        return sqlOutput.getData();
    }

    public Object transObjectArrayForInput(Object[] objectArray) throws SQLException {
        if (objectArray.length != this.structureConverter.length) {
            throw SQLExceptionSapDB.generateSQLException("error.structure.arraywronglength", new Integer(this.structureConverter.length), new Integer(objectArray.length));
        }
        StructuredBytes sb = new StructuredBytes(this.physicalLength - 1);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                throw SQLExceptionSapDB.generateSQLException("error.structure.element.null", new Integer(i + 1));
            }
            this.structureConverter[i].putObject(sb, objectArray[i]);
        }
        return sb.bytes();
    }

    public Object transCharacterStreamForInput(Reader stream, long length) throws SQLException {
        if (length <= 0L) {
            return null;
        }
        try {
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", "Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            char[] ba = new char[(int)length];
            int r = stream.read(ba);
            if ((long)r != length) {
                if (r == -1) {
                    r = 0;
                }
                char[] ba2 = ba;
                ba = new char[r];
                System.arraycopy(ba2, 0, ba, 0, r);
            }
            return this.transStringForInput(new String(ba));
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
        }
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        if (length <= 0L) {
            return null;
        }
        try {
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", "Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            byte[] ba = new byte[(int)length];
            int r = stream.read(ba);
            if ((long)r != length) {
                if (r == -1) {
                    r = 0;
                }
                byte[] ba2 = ba;
                ba = new byte[r];
                System.arraycopy(ba2, 0, ba, 0, r);
            }
            return this.transBytesForInput(ba);
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
        }
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        byte[] asBytes = this.getBytes(controller, mem);
        if (asBytes == null) {
            return null;
        }
        ByteArrayInputStream result = new ByteArrayInputStream(asBytes);
        return result;
    }

    public void setProcParamInfo(DBProcParameterInfo info) throws SQLException {
        this.parameterStructure = info;
        this.structureConverter = StructMemberTranslator.createStructMemberTranslators(info, this.unicode);
    }
}

