/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ColumnInfo;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.vsp001.FunctionCode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Vector;

public class Parseinfo {
    ConnectionSapDB connection;
    String sqlCmd;
    private byte[] parseid;
    private byte[] massParseid;
    DBTechTranslator[] paramInfos;
    DBProcParameterInfo[] procParamInfos;
    int inputCount;
    private boolean isMassCmd;
    boolean isSelect;
    boolean isDBProc;
    boolean hasLongs;
    boolean hasStreams;
    boolean cached;
    int functionCode;
    int sessionID;
    ColumnInfo[] columnNames;
    AbstractMap columnMap;
    DBTechTranslator[] columnInfos;
    boolean isClosed = false;
    boolean varDataInput = false;
    private static final int applicationCodeByte = 10;
    String updTableName;

    public Parseinfo(ConnectionSapDB connection, String sqlCmd, int functionCode) throws SQLException {
        this.connection = connection;
        this.sqlCmd = sqlCmd;
        this.massParseid = null;
        this.paramInfos = null;
        this.inputCount = 0;
        this.isSelect = false;
        this.isDBProc = false;
        this.hasLongs = false;
        this.hasStreams = false;
        this.isMassCmd = false;
        this.functionCode = functionCode;
        this.sessionID = -1;
        this.updTableName = null;
        this.cached = false;
        this.varDataInput = false;
        if (functionCode == 4 || functionCode == 216 || functionCode == 248 || functionCode == 27) {
            this.isSelect = true;
        }
        if (functionCode == 248 || functionCode == 34) {
            this.isDBProc = true;
        }
        this.columnNames = null;
        this.columnMap = null;
        if (functionCode == 34) {
            try {
                this.describeProcedureCall();
            }
            catch (SQLException sqlex) {
                this.procParamInfos = new DBProcParameterInfo[0];
            }
        }
    }

    void describeProcedureCall() throws SQLException {
        if (this.connection.getKernelVersion() <= 70402) {
            this.procParamInfos = new DBProcParameterInfo[0];
            return;
        }
        char[] cmdchars = this.sqlCmd.trim().toCharArray();
        int i = 0;
        int cmdchars_len = cmdchars.length;
        if (cmdchars[i] == '{') {
            ++i;
        }
        if (i == cmdchars_len) {
            return;
        }
        while (Character.isSpace(cmdchars[i])) {
            if (++i != cmdchars_len) continue;
            return;
        }
        if (cmdchars[i] == 'C' || cmdchars[i] == 'c') {
            if (++i == cmdchars_len) {
                return;
            }
        } else {
            return;
        }
        if (cmdchars[i] == 'A' || cmdchars[i] == 'a') {
            if (++i == cmdchars_len) {
                return;
            }
        } else {
            return;
        }
        if (cmdchars[i] == 'L' || cmdchars[i] == 'l') {
            if (++i == cmdchars_len) {
                return;
            }
        } else {
            return;
        }
        if (cmdchars[i] == 'L' || cmdchars[i] == 'l') {
            if (++i == cmdchars_len) {
                return;
            }
        } else {
            return;
        }
        while (Character.isSpace(cmdchars[i])) {
            if (++i != cmdchars_len) continue;
            return;
        }
        int idstart = i;
        int idend = i;
        boolean quoted = false;
        if (cmdchars[i] == '\"') {
            ++idstart;
            ++idend;
            quoted = true;
            if (++i == cmdchars_len) {
                return;
            }
        }
        while (!(cmdchars[i] == '.' && !quoted || cmdchars[i] == '(' && !quoted || Character.isSpace(cmdchars[i]) && !quoted || quoted && cmdchars[i] == '\"')) {
            ++idend;
            if (++i != cmdchars_len) continue;
            return;
        }
        String procedureName = new String(cmdchars, idstart, idend - idstart);
        String ownerName = null;
        if (!quoted) {
            procedureName = procedureName.toUpperCase();
        }
        if (cmdchars[i] == '\"') {
            ++i;
        }
        while (i < cmdchars_len && Character.isSpace(cmdchars[i]) && ++i != cmdchars_len) {
        }
        if (i < cmdchars_len && cmdchars[i] == '.') {
            if (++i == cmdchars_len) {
                return;
            }
            while (Character.isSpace(cmdchars[i])) {
                if (++i != cmdchars_len) continue;
                return;
            }
            idstart = i;
            idend = i;
            quoted = false;
            if (cmdchars[i] == '\"') {
                ++idstart;
                ++idend;
                quoted = true;
                if (++i == cmdchars_len) {
                    return;
                }
            }
            while (!(cmdchars[i] == '.' && !quoted || cmdchars[i] == '(' && !quoted || Character.isSpace(cmdchars[i]) && !quoted || quoted && cmdchars[i] == '\"')) {
                ++idend;
                if (++i != cmdchars_len) continue;
                return;
            }
            ownerName = procedureName;
            procedureName = new String(cmdchars, idstart, idend - idstart);
            if (!quoted) {
                procedureName = procedureName.toUpperCase();
            }
        }
        PreparedStatement ps = null;
        String stmtstring = "SELECT 1 FROM DUAL WHERE FALSE";
        if (ownerName == null) {
            stmtstring = this.connection.getKernelVersion() >= 70600 ? "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, ASCII_OFFSET, UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=USER AND SCHEMANAME = CURRENT_SCHEMA AND DBPROCEDURE=? ORDER BY PARAM_NO,ASCII_OFFSET" : (this.connection.getKernelVersion() > 70402 ? "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, ASCII_OFFSET, UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=USER AND DBPROCEDURE=? ORDER BY PARAM_NO,ASCII_OFFSET" : "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, OFFSET AS ASCII_OFFSET, OFFSET AS UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=USER AND DBPROCEDURE=? ORDER BY PARAM_NO,OFFSET");
            ps = this.connection.prepareStatement(stmtstring);
            ps.setString(1, procedureName);
        } else {
            stmtstring = this.connection.getKernelVersion() >= 70600 ? "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, ASCII_OFFSET, UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE SCHEMANAME=? AND DBPROCEDURE=? ORDER BY PARAM_NO,ASCII_OFFSET" : (this.connection.getKernelVersion() > 70402 ? "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, ASCII_OFFSET, UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=? AND DBPROCEDURE=? ORDER BY PARAM_NO,ASCII_OFFSET" : "SELECT PARAM_NO, DATATYPE, CODE, LEN, DEC, \"IN/OUT-TYPE\", OFFSET, OFFSET AS ASCII_OFFSET, OFFSET AS UNICODE_OFFSET FROM DBPROCPARAMINFO WHERE OWNER=? AND DBPROCEDURE=? ORDER BY PARAM_NO,OFFSET");
            ps = this.connection.prepareStatement(stmtstring);
            ps.setString(1, ownerName);
            ps.setString(2, procedureName);
        }
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            this.procParamInfos = new DBProcParameterInfo[0];
            rs.close();
            rs = null;
            ps.close();
            ps = null;
            return;
        }
        Vector<DBProcParameterInfo> parameterInfos = new Vector<DBProcParameterInfo>();
        DBProcParameterInfo currentInfo = null;
        int currentIndex = 0;
        do {
            String datatype;
            int index;
            if ((index = rs.getInt(1)) != currentIndex) {
                datatype = rs.getString(2);
                if (datatype.equals("ABAPTABLE") || datatype.equals("STRUCTURE")) {
                    int len = rs.getInt(4);
                    int dec = rs.getInt(5);
                    currentInfo = new DBProcParameterInfo(datatype, len, dec);
                    parameterInfos.addElement(currentInfo);
                } else {
                    currentInfo = null;
                    parameterInfos.addElement(currentInfo);
                }
                currentIndex = index;
                continue;
            }
            datatype = rs.getString(2);
            String code = rs.getString(3);
            int len = rs.getInt(4);
            int dec = rs.getInt(5);
            int offset = rs.getInt(7);
            int asciiOffset = rs.getInt(8);
            int unicodeOffset = rs.getInt(9);
            currentInfo.addStructureElement(datatype, code, len, dec, offset, asciiOffset, unicodeOffset);
        } while (rs.next());
        rs.close();
        rs = null;
        ps.close();
        ps = null;
        this.procParamInfos = parameterInfos.toArray(new DBProcParameterInfo[0]);
    }

    public byte[] getMassParseid() {
        return this.massParseid;
    }

    public byte[] getActualParseid() {
        return this.isMassCmd ? this.massParseid : this.parseid;
    }

    public boolean setMassParseid(byte[] aMassParseid) {
        this.massParseid = aMassParseid;
        if (aMassParseid == null) {
            return false;
        }
        for (int i = 0; i < FunctionCode.massCmdAppCodes.length; ++i) {
            if (aMassParseid[10] != FunctionCode.massCmdAppCodes[i]) continue;
            this.isMassCmd = true;
            return true;
        }
        return false;
    }

    public boolean isMassCmd() {
        return this.isMassCmd;
    }

    public void setUpdateTableName(String atablename) {
        this.updTableName = atablename;
    }

    public boolean isValid() {
        return this.sessionID == this.connection.sessionID;
    }

    public DBTechTranslator[] getColumnInfos() {
        return this.columnInfos;
    }

    public void setParseIdAndSession(byte[] parseId, int sessionId) {
        this.sessionID = sessionId;
        this.parseid = parseId;
    }

    public synchronized void dropParseIDs() {
        if (this.parseid != null && this.connection != null) {
            this.connection.dropParseid(this.parseid);
            this.parseid = null;
        }
        if (this.massParseid != null && this.connection != null) {
            this.connection.dropParseid(this.massParseid);
            this.massParseid = null;
        }
    }

    protected void finalize() {
        this.cached = false;
        this.dropParseIDs();
    }

    public DBTechTranslator[] getParamInfo() {
        return this.paramInfos;
    }

    public void setSelect(boolean select) {
        this.isSelect = select;
    }

    public byte[] getParseId() {
        return this.parseid;
    }

    public boolean isAlreadyExecuted() {
        return this.parseid != null && this.parseid[10] == 1;
    }

    public void setShortInfosAndColumnNames(DBTechTranslator[] shortInfo, ColumnInfo[] columnNames) throws SQLException {
        this.inputCount = 0;
        this.hasLongs = false;
        this.hasStreams = false;
        this.columnNames = null;
        this.paramInfos = null;
        this.columnMap = null;
        this.columnInfos = null;
        this.columnNames = columnNames;
        if (shortInfo == null && columnNames == null) {
            this.columnInfos = new DBTechTranslator[0];
            this.paramInfos = this.columnInfos;
            return;
        }
        if (this.functionCode == 4) {
            if (columnNames == null || columnNames.length == 0) {
                this.paramInfos = shortInfo;
                for (int i = 0; i < this.paramInfos.length; ++i) {
                    DBTechTranslator current = shortInfo[i];
                    if (current.isInput()) {
                        current.setColIndex(i);
                        ++this.inputCount;
                    }
                    this.hasLongs |= current.isLongKind();
                    this.hasStreams |= current.isStreamKind();
                }
            } else {
                int column_count = columnNames.length;
                this.columnInfos = new DBTechTranslator[column_count];
                this.paramInfos = new DBTechTranslator[shortInfo.length - column_count];
                int colInfoIdx = 0;
                int paramInfoIdx = 0;
                for (int i = 0; i < shortInfo.length; ++i) {
                    DBTechTranslator current = shortInfo[i];
                    if (current.isInput()) {
                        if (paramInfoIdx == this.paramInfos.length) {
                            throw SQLExceptionSapDB.generateSQLException("error.internal.unexpectedinput", Integer.toString(paramInfoIdx));
                        }
                        current.setColIndex(paramInfoIdx);
                        this.paramInfos[paramInfoIdx] = current;
                        ++paramInfoIdx;
                        ++this.inputCount;
                    } else {
                        if (colInfoIdx == this.columnInfos.length) {
                            throw SQLExceptionSapDB.generateSQLException("error.internal.unexpectedoutput", Integer.toString(colInfoIdx));
                        }
                        this.columnInfos[colInfoIdx] = current;
                        current.setColIndex(colInfoIdx);
                        current.setColName(columnNames[colInfoIdx]);
                        ++colInfoIdx;
                    }
                    this.hasLongs |= shortInfo[i].isLongKind();
                    this.hasStreams |= shortInfo[i].isStreamKind();
                }
            }
        } else {
            this.paramInfos = shortInfo;
            if (columnNames != null) {
                if (columnNames.length == this.paramInfos.length) {
                    for (int i = 0; i < columnNames.length; ++i) {
                        DBTechTranslator current = this.paramInfos[i];
                        current.setColIndex(i);
                        current.setColName(columnNames[i]);
                        if (this.procParamInfos != null && i < this.procParamInfos.length) {
                            current.setProcParamInfo(this.procParamInfos[i]);
                        }
                        this.inputCount += current.isInput() ? 1 : 0;
                        this.hasLongs |= current.isLongKind();
                        this.hasStreams |= current.isStreamKind();
                    }
                } else {
                    int colNameIdx = 0;
                    for (int j = 0; j < this.paramInfos.length; ++j) {
                        DBTechTranslator current = this.paramInfos[j];
                        current.setColIndex(j);
                        if (this.procParamInfos != null && j < this.procParamInfos.length) {
                            current.setProcParamInfo(this.procParamInfos[j]);
                        }
                        if (current.isOutput()) {
                            current.setColName(columnNames[colNameIdx++]);
                        } else {
                            ++this.inputCount;
                        }
                        this.hasLongs |= current.isLongKind();
                        this.hasStreams |= current.isStreamKind();
                    }
                }
            } else {
                for (int i = 0; i < this.paramInfos.length; ++i) {
                    DBTechTranslator current = this.paramInfos[i];
                    current.setColIndex(i);
                    if (this.procParamInfos != null && i < this.procParamInfos.length) {
                        current.setProcParamInfo(this.procParamInfos[i]);
                    }
                    this.inputCount += current.isInput() ? 1 : 0;
                    this.hasLongs |= current.isLongKind();
                    this.hasStreams |= current.isStreamKind();
                }
            }
        }
    }

    public AbstractMap getColumnMap() throws SQLException {
        if (this.columnMap != null) {
            return this.columnMap;
        }
        if (this.columnNames == null) {
            throw SQLExceptionSapDB.generateSQLException("error.no.columnnames");
        }
        this.columnMap = new HashMap(this.columnNames.length);
        for (int i = 0; i < this.paramInfos.length; ++i) {
            DBTechTranslator current = this.paramInfos[i];
            String colname = current.getColumnName();
            if (colname == null) continue;
            this.columnMap.put(colname, current);
        }
        return this.columnMap;
    }

    void doDescribeParseId() throws SQLException {
        ColumnInfo[] columnNames = null;
        DBTechTranslator[] infos = null;
        RequestPacket requestPacket = this.connection.getRequestPacket(false);
        requestPacket.initDbsCommandThrowSQLExc(false, "Describe ", 1003);
        requestPacket.addParseidPart(this.parseid);
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 1);
        PartEnumeration enuma = replyPacket.partEnumeration();
        block5: while (enuma.hasMoreElements()) {
            enuma.nextElement();
            switch (enuma.partKind()) {
                case 2: {
                    columnNames = replyPacket.parseColumnNames(columnNames);
                    continue block5;
                }
                case 14: {
                    infos = replyPacket.parseShortFields(this.connection, false, null, false);
                    continue block5;
                }
                case 32: {
                    this.varDataInput = true;
                    infos = replyPacket.parseShortFields(this.connection, false, null, true);
                    continue block5;
                }
            }
        }
        this.setMetaData(infos, columnNames);
    }

    void setMetaData(DBTechTranslator[] info, ColumnInfo[] colName) throws SQLException {
        int colCount = info.length;
        this.columnNames = colName;
        if (colCount == colName.length) {
            this.columnInfos = info;
            for (int i = 0; i < colCount; ++i) {
                DBTechTranslator currentInfo = info[i];
                ColumnInfo currentName = colName[i];
                currentInfo.setColName(currentName);
                currentInfo.setColIndex(i);
            }
        } else {
            int outputColCnt = 0;
            this.columnInfos = new DBTechTranslator[colName.length];
            for (int i = 0; i < colCount; ++i) {
                if (!info[i].isOutput()) continue;
                DBTechTranslator currentInfo = this.columnInfos[outputColCnt] = info[i];
                ColumnInfo currentName = colName[outputColCnt];
                currentInfo.setColName(currentName);
                currentInfo.setColIndex(outputColCnt++);
            }
        }
    }

    public String getSqlCommand() {
        return this.sqlCmd;
    }
}

