/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.Proxy;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.gds.ng.jna.NativeResourceTracker;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FbClientResource
extends NativeResourceTracker.NativeResource {
    private volatile FbClientLibrary library;
    private final AbstractNativeDatabaseFactory owner;

    FbClientResource(FbClientLibrary library, AbstractNativeDatabaseFactory owner) {
        this.library = library;
        this.owner = owner;
    }

    FbClientLibrary get() {
        FbClientLibrary local = this.library;
        if (local == null) {
            throw new IllegalStateException("Library was already disposed");
        }
        return local;
    }

    @Override
    void dispose() {
        final FbClientLibrary local = this.library;
        if (local == null) {
            return;
        }
        try {
            this.owner.disposing(this, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FbClientResource.this.library = null;
                    if (NativeResourceTracker.isNativeResourceShutdownDisabled()) {
                        return;
                    }
                    Logger logger = LoggerFactory.getLogger(FbClientResource.class);
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Calling fb_shutdown on " + local);
                        }
                        local.fb_shutdown(0, 1);
                    }
                    finally {
                        Library.Handler handler = (Library.Handler)Proxy.getInvocationHandler(local);
                        NativeLibrary nativeLibrary = handler.getNativeLibrary();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Disposing JNA native library " + nativeLibrary);
                        }
                        try {
                            nativeLibrary.dispose();
                        }
                        catch (Throwable e) {
                            logger.error("Error disposing of " + nativeLibrary, e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(FbClientResource.class).error("Error disposing of " + local, e);
        }
    }
}

