/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.meta.Association;

public class TeradataDatabase
extends GenericSchema
implements DBPImageProvider {
    private boolean isUser;
    private final List<TeradataDatabase> childDatabases;

    TeradataDatabase(@NotNull GenericDataSource dataSource, @NotNull String catalogName, boolean isUser) {
        super(dataSource, null, catalogName);
        this.isUser = isUser;
        this.childDatabases = new ArrayList<TeradataDatabase>();
    }

    void addChildDatabase(@NotNull TeradataDatabase database) {
        this.childDatabases.add(database);
    }

    @Association
    public List<TeradataDatabase> getCatalogList() {
        GenericDataSource dataSource = this.getDataSource();
        if (dataSource instanceof TeradataDatasource && !((TeradataDatasource)dataSource).showDatabasesHierarchically()) {
            return null;
        }
        return this.childDatabases;
    }

    @Nullable
    public DBPImage getObjectImage() {
        if (this.isUser) {
            return DBIcon.TREE_USER;
        }
        return DBIcon.TREE_DATABASE;
    }
}

