/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataMetaModelExt;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class TeradataDataSourceProvider
extends GenericDataSourceProvider {
    public long getFeatures() {
        return 2L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        boolean useTLS = CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("use-tls-protocol@"));
        if (useTLS) {
            StringBuilder url = new StringBuilder();
            url.append("jdbc:teradata://");
            url.append(connectionInfo.getHostName());
            url.append("/DATABASE=").append(connectionInfo.getDatabaseName());
            url.append(",HTTPS_PORT=");
            String hostPort = connectionInfo.getHostPort();
            if (!CommonUtils.isEmpty((String)hostPort)) {
                url.append(hostPort);
            } else {
                url.append("443");
            }
            return url.toString();
        }
        return super.getConnectionURL(driver, connectionInfo);
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new TeradataDatasource(monitor, container, (GenericMetaModel)new TeradataMetaModelExt());
    }
}

