/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.core;

import com.simba.athena.amazonaws.Protocol;
import com.simba.athena.amazonaws.services.athena.model.GetWorkGroupResult;
import com.simba.athena.athena.AJMetadataRetrievalMethod;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJClientConfigPropertyKey;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJEnvironment;
import com.simba.athena.athena.core.AJPropertyKey;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.core.AJStatement;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJUtilities;
import com.simba.athena.dsi.core.impl.DSIConnection;
import com.simba.athena.dsi.core.impl.DSILogger;
import com.simba.athena.dsi.core.interfaces.IStatement;
import com.simba.athena.dsi.core.utilities.ConnSettingRequestMap;
import com.simba.athena.dsi.core.utilities.ConnSettingResponseMap;
import com.simba.athena.dsi.core.utilities.PropertyUtilities;
import com.simba.athena.dsi.core.utilities.Variant;
import com.simba.athena.dsi.exceptions.BadAuthException;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.dsi.exceptions.NumericOverflowException;
import com.simba.athena.jdbc.common.ProductInfoHandler;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class AJConnection
extends DSIConnection {
    private static AtomicInteger s_logNumber = new AtomicInteger(1);
    private static final String LOG_PREFIX_NAME = "AthenaJDBC_Connection_";
    protected ILogger m_log;
    private long m_preparedStatementCounter;
    private long m_preparedStatement;
    private Map<String, String> m_storedPrepared = new HashMap<String, String>();
    private AJSettings m_settings;
    private AJClient m_client;
    private ExecutorService m_threadPool;
    private Map<String, List<String>> m_connectionKeyAliasesMap = AJConnection.initializeConnectionKeyAliasMap();
    private ProductInfoHandler m_productInfoHandler;

    protected AJConnection(AJEnvironment aJEnvironment) throws ErrorException {
        super(aJEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), aJEnvironment);
        this.m_productInfoHandler = new ProductInfoHandler("SimbaAthenaJDBCDriver.lic", "Simba Athena JDBC Driver", AJDriver.AJ_DRIVER_VERSION, AJDriver.class);
        this.setDefaultProperties();
        this.m_threadPool = Executors.newCachedThreadPool();
    }

    private static Map<String, List<String>> initializeConnectionKeyAliasMap() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RegionFromEndpointOverride");
        arrayList.add("RegionFromEndpoint");
        hashMap.put("AwsRegion", arrayList);
        arrayList = new ArrayList();
        arrayList.add("AthenaEndpointFromUrl");
        hashMap.put("EndpointOverride", arrayList);
        arrayList = new ArrayList();
        arrayList.add("s3_staging_dir");
        hashMap.put("S3OutputLocation", arrayList);
        arrayList = new ArrayList();
        arrayList.add("query_results_encryption_option");
        hashMap.put("S3OutputEncOption", arrayList);
        arrayList = new ArrayList();
        arrayList.add("query_results_aws_kms_key");
        hashMap.put("S3OutputEncKMSKey", arrayList);
        arrayList = new ArrayList();
        arrayList.add("aws_credentials_provider_class");
        arrayList.add("plugin_name");
        hashMap.put("AwsCredentialsProviderClass", arrayList);
        arrayList = new ArrayList();
        arrayList.add("aws_credentials_provider_arguments");
        hashMap.put("AwsCredentialsProviderArguments", arrayList);
        arrayList = new ArrayList();
        arrayList.add("CatalogFromEndpointOverride");
        hashMap.put("CatalogFromEndpoint", arrayList);
        hashMap.put("Catalog", arrayList);
        arrayList = new ArrayList();
        arrayList.add("max_error_retries");
        hashMap.put("MaxErrorRetry", arrayList);
        return hashMap;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_threadPool.shutdownNow();
    }

    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException, BadAuthException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, AJDriver.AJ_DRIVER_VERSION);
        try {
            this.m_productInfoHandler.validateLicense();
        }
        catch (Exception exception) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.LICENSE_VALIDATION_ERROR.name(), (Throwable)exception);
        }
        this.m_settings = new AJSettings();
        this.m_settings.m_defaultRoleSessionNamePrefix = "athena";
        Variant variant = null;
        variant = this.getRequiredSetting("AwsRegion", connSettingRequestMap);
        this.m_settings.m_awsRegion = variant.getString();
        variant = this.getOptionalSetting("AwsCredentialsProviderClass", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            this.m_settings.m_awsCredentialsProviderClass = variant.getString();
            variant = this.getOptionalSetting("AwsCredentialsProviderArguments", connSettingRequestMap);
            if (null != variant && !variant.getString().isEmpty()) {
                AJUtilities.parseCredentialsProviderArgs(this.getConnectionLog(), variant.getString(), this.m_settings.m_awsCredentialProviderArgs);
            }
        }
        if (null != (variant = this.getOptionalSetting("UID", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_uid = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("PWD", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_pwd = variant.getString();
        }
        this.parseIPluginSettings(connSettingRequestMap);
        if (null == this.m_settings.m_awsCredentialsProviderClass && null == this.m_settings.m_profile && (null == this.m_settings.m_uid || null == this.m_settings.m_pwd)) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.MISSING_CREDENTIALS_ERR);
        }
        variant = this.getOptionalSetting("S3OutputLocation", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            this.m_settings.m_s3OutputLocation = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("S3OutputEncOption", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_s3OutputEncryptionOption = variant.getString();
            if ((this.m_settings.m_s3OutputEncryptionOption.equals("SSE_KMS") || this.m_settings.m_s3OutputEncryptionOption.equals("CSE_KMS")) && null != (variant = this.getRequiredSetting("S3OutputEncKMSKey", connSettingRequestMap)) && !variant.getString().isEmpty()) {
                this.m_settings.m_s3OutputEncryptionKmsKey = variant.getString();
            }
        }
        if (null != (variant = this.getOptionalSetting("Schema", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_schema = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("Catalog", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.setProperty(22, variant);
            this.m_settings.m_defaultCatalog = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("EndpointOverride", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_athenaEndpoint = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("GlueEndpointOverride", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_glueEndpointOverride = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("StreamingEndpointOverride", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_streamingEndpointOverride = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("Workgroup", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_workgroup = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("MetadataRetrievalMethod", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            String string = variant.getString();
            if (string.equalsIgnoreCase("ProxyAPI")) {
                this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API;
            } else if (string.equalsIgnoreCase("Auto")) {
                this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.AUTO_DETECT_GLUE;
            } else if (string.equalsIgnoreCase("Glue")) {
                this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE;
            } else if (string.equalsIgnoreCase("Query")) {
                this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
            }
        }
        if (null != (variant = this.getOptionalSetting("PreProduction", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                if (1 == variant.getInt()) {
                    this.m_settings.m_usePreProduction = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("RightTrimNonGlueColumnName", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                if (0 == variant.getInt()) {
                    this.m_settings.m_rightTrimNonGlueColumnName = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        variant = this.getOptionalSetting("MinQueryExecutionPollingInterval", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 < variant.getInt()) {
                this.m_settings.m_minQueryExecPollingInterval = variant.getInt();
            } else {
                this.m_settings.m_minQueryExecPollingInterval = 5;
                LogUtilities.logWarning("MinQueryExecPollingInterval configuration value needs to be positive.Setting to minimum value of 5 ms instead.", this.getConnectionLog());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("MaxQueryExecutionPollingInterval", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                if (variant.getInt() > this.m_settings.m_minQueryExecPollingInterval) {
                    this.m_settings.m_maxQueryExecPollingInterval = variant.getInt();
                } else {
                    this.m_settings.m_maxQueryExecPollingInterval = this.m_settings.m_minQueryExecPollingInterval;
                    LogUtilities.logWarning("MaxQueryExecPollingInterval configuration value is too small.Setting to minimum value of " + this.m_settings.m_minQueryExecPollingInterval + " ms instead.", this.getConnectionLog());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("QueryExecutionPollingIntervalMultiplier", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                if (variant.getInt() > this.m_settings.m_execPollingIntervalMultiplier) {
                    this.m_settings.m_execPollingIntervalMultiplier = variant.getInt();
                } else {
                    this.m_settings.m_execPollingIntervalMultiplier = 2;
                    LogUtilities.logWarning("PollingIntervalMultiplier configuration value is too small.Setting to minimum value of 2 ms instead.", this.getConnectionLog());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("UseResultsetStreaming", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            try {
                if (0 == variant.getInt()) {
                    this.m_settings.m_useStreamClient = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_settings.m_rowsToFetchPerBlock = this.m_settings.m_useStreamClient ? 10000 : 1000;
        variant = this.getOptionalSetting("MaxNumRowsToFetchPerBlock", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_maxNumRowsToFetchPerBlock = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("RowsToFetchPerBlock", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 < variant.getInt()) {
                if (variant.getInt() > this.m_settings.m_maxRowsToFetchForStream && this.m_settings.m_useStreamClient) {
                    LogUtilities.logWarning("Query retrival exceeded limitation of 10000000 records hence max limit set to 10000000 for streaming", this.getConnectionLog());
                    this.m_settings.m_rowsToFetchPerBlock = this.m_settings.m_maxRowsToFetchForStream;
                } else {
                    this.m_settings.m_rowsToFetchPerBlock = variant.getInt();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("StringColumnLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_stringColumnLength = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("BinaryColumnLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_binaryColumnLength = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("ComplexTypeColumnLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_complexTypeColumnLength = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("MaxCatalogNameLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_maxCatalogNameLength = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("MaxSchemaNameLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_maxSchemaNameLength = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("MaxTableNameLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_maxTableNameLength = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("MaxColumnNameLength", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_maxColumnNameLength = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("UseDoubleBuffering", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_enableDoubleBuffering = 1 == variant.getInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("ParseBadResultRowsAsTabDelimited", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_parseResultRowsAsTabDelimited = 1 == variant.getInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("SuppressWarningDuringFetch", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_suppressWarningDuringFetch = 1 == variant.getInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("UseAwsLogger", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_useAwsLogger = 1 == variant.getInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("UseArraySupport", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_useArraySupport = 0 != variant.getInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("ForceTableTypeTable", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_forceTableTypeTable = 1 == variant.getInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("MapAllViewTypeToView", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_mapAllViewTypeToView = 1 == variant.getInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("GlueDetectionMaxRetry", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                if (0 <= variant.getInt()) {
                    this.m_settings.m_glueDetectionMaxRetry = variant.getInt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("TableTypesList", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_customTableTypesList = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("ConnectionTest", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                if (0 == variant.getInt()) {
                    this.m_settings.m_performConnectionTest = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        variant = this.getOptionalSetting("StreamingClientPort", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 < variant.getInt()) {
                this.m_settings.m_athenaStreamClientPort = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("MaxStreamErrorRetry", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 < variant.getInt()) {
                this.m_settings.m_maxStreamErrorRetry = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setClientConfigPropertyValues(connSettingRequestMap);
        this.setConnectedPropertyValues();
        this.m_preparedStatement = Math.abs(new Random().nextInt());
        this.m_client = new AJClient(this.m_log, this.m_settings);
        try {
            this.setDbmsVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addPreparedStatement(String string, String string2) throws ErrorException {
        if (this.m_storedPrepared.containsKey(string)) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.PREPARED_STATEMENT_ALREADY_EXISTS_ERR.name(), string);
        }
        this.m_storedPrepared.put(string, string2);
    }

    public void deallocatePrepareStatement(String string) throws ErrorException {
        if (this.m_client.deallocatePrepareStatement(string)) {
            this.m_storedPrepared.remove(string);
        }
    }

    public synchronized String getPreparedStatementCounter() {
        ++this.m_preparedStatementCounter;
        return "stmt" + this.m_preparedStatement + this.m_preparedStatementCounter;
    }

    public synchronized String getPreparedStatementValue(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        String string2 = this.m_storedPrepared.get(string);
        if (string2 == null) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.PREPARED_STATEMENT_NOT_FOUND_ERR.name(), string);
        }
        return string2;
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        String string = this.getProperty(22).getString();
        return new AJStatement(this, this.m_settings, string);
    }

    @Override
    public void disconnect() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    public AJClient getClient() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), this.m_client);
        assert (this.m_client != null);
        return this.m_client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            AJConnection aJConnection = this;
            synchronized (aJConnection) {
                this.m_log = new DSILogger(LOG_PREFIX_NAME + s_logNumber.getAndIncrement() + ".log");
                this.m_log.setLocale(this.getLocale());
            }
        }
        return this.m_log;
    }

    public ExecutorService getThreadPool() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_threadPool;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        for (String iterator : AJPropertyKey.getRequiredKeys()) {
            this.verifyRequiredSetting(iterator, connSettingRequestMap, connSettingResponseMap);
        }
        for (String string : AJPropertyKey.getOptionalKeys()) {
            this.verifyOptionalSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        Variant variant = this.getOptionalSetting("S3OutputEncOption", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty() && (variant.getString().equals("SSE_KMS") || variant.getString().equals("CSE_KMS"))) {
            this.verifyRequiredSetting("S3OutputEncKMSKey", connSettingRequestMap, connSettingResponseMap);
        }
        for (String string : AJClientConfigPropertyKey.getRequiredKeys()) {
            this.verifyRequiredSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        for (String string : AJClientConfigPropertyKey.getOptionalKeys()) {
            this.verifyOptionalSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        return connSettingResponseMap;
    }

    @Override
    protected void doReset() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.setDefaultProperties();
    }

    @Override
    protected Variant getOptionalSetting(String string, ConnSettingRequestMap connSettingRequestMap) {
        Variant variant;
        block1: {
            String string2;
            variant = super.getOptionalSetting(string, connSettingRequestMap);
            if (null != variant || !this.m_connectionKeyAliasesMap.containsKey(string)) break block1;
            List<String> list = this.m_connectionKeyAliasesMap.get(string);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext() && null == (variant = super.getOptionalSetting(string2 = iterator.next(), connSettingRequestMap))) {
            }
        }
        return variant;
    }

    @Override
    protected Variant getRequiredSetting(String string, ConnSettingRequestMap connSettingRequestMap) throws BadAuthException {
        Variant variant;
        block6: {
            variant = null;
            try {
                variant = super.getRequiredSetting(string, connSettingRequestMap);
            }
            catch (BadAuthException badAuthException) {
                if (this.m_connectionKeyAliasesMap.containsKey(string)) {
                    List<String> list = this.m_connectionKeyAliasesMap.get(string);
                    for (String string2 : list) {
                        try {
                            variant = super.getRequiredSetting(string2, connSettingRequestMap);
                            if (null == variant) continue;
                            break;
                        }
                        catch (BadAuthException badAuthException2) {
                            if (list.indexOf(string2) < list.size()) continue;
                            throw badAuthException;
                        }
                    }
                }
                if (null != variant) break block6;
                throw badAuthException;
            }
        }
        return variant;
    }

    @Override
    protected void verifyRequiredSetting(String string, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        boolean bl = false;
        if (this.m_connectionKeyAliasesMap.containsKey(string)) {
            List<String> list = this.m_connectionKeyAliasesMap.get(string);
            for (String string2 : list) {
                if (null == connSettingRequestMap.getProperty(string2)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.verifyOptionalSetting(string, string, connSettingRequestMap, connSettingResponseMap);
        } else {
            this.verifyRequiredSetting(string, string, connSettingRequestMap, connSettingResponseMap);
        }
    }

    private void parseIPluginSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Variant variant = this.getOptionalSetting("profile", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_profile = variant.getString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toLowerCase(Locale.getDefault());
            String string2 = connSettingRequestMap.getProperty(string).getString();
            if ("*".equals(string2)) continue;
            this.m_settings.m_pluginArgs.put(string, string2);
        }
    }

    private void setClientConfigPropertyValues(ConnSettingRequestMap connSettingRequestMap) {
        Variant variant = null;
        try {
            variant = this.getProperty(23);
            if (null != variant && -1 < variant.getInt()) {
                this.m_settings.m_clientConfig.setConnectionTimeout(variant.getInt() * 1000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("ConnectTimeout", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && -1 < variant.getInt()) {
                this.m_settings.m_clientConfig.setConnectionTimeout(variant.getInt() * 1000);
            } else {
                variant = this.getOptionalSetting("connection_timeout", connSettingRequestMap);
                if (null != variant && !variant.getString().isEmpty() && -1 < variant.getInt()) {
                    this.m_settings.m_clientConfig.setConnectionTimeout(variant.getInt());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            variant = this.getProperty(21);
            if (null != variant && -1 < variant.getInt()) {
                this.m_settings.m_clientConfig.setSocketTimeout(variant.getInt() * 1000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("SocketTimeout", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && -1 < variant.getInt()) {
                this.m_settings.m_clientConfig.setSocketTimeout(variant.getInt() * 1000);
            } else {
                variant = this.getOptionalSetting("socket_timeout", connSettingRequestMap);
                if (null != variant && !variant.getString().isEmpty() && -1 < variant.getInt()) {
                    this.m_settings.m_clientConfig.setSocketTimeout(variant.getInt());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("Protocol", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            if (variant.getString().equalsIgnoreCase("HTTP")) {
                this.m_settings.m_clientConfig.setProtocol(Protocol.HTTP);
            } else if (variant.getString().equalsIgnoreCase("HTTPS")) {
                this.m_settings.m_clientConfig.setProtocol(Protocol.HTTPS);
            }
        }
        variant = this.getOptionalSetting("MaxConnections", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_clientConfig.setMaxConnections(variant.getInt());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_settings.m_clientConfig.setUserAgentPrefix("sbAthenaJDBCDriver/2.0-preview");
        variant = this.getOptionalSetting("UserAgentPrefix", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setUserAgentPrefix(variant.getString());
        }
        if (null != (variant = this.getOptionalSetting("UserAgentSuffix", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setUserAgentSuffix(variant.getString());
        }
        if (null != (variant = this.getOptionalSetting("ProxyHost", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setProxyHost(variant.getString());
            this.m_settings.m_proxyHost = variant.getString();
        }
        variant = this.getOptionalSetting("ProxyPort", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_clientConfig.setProxyPort(variant.getInt());
                this.m_settings.m_proxyPort = variant.getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("ProxyUID", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setProxyUsername(variant.getString());
            this.m_settings.m_proxyUid = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("ProxyPWD", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setProxyPassword(variant.getString());
            this.m_settings.m_proxyPwd = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("ProxyDomain", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setProxyDomain(variant.getString());
            this.m_settings.m_proxyDomain = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("ProxyWorkstation", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setProxyWorkstation(variant.getString());
            this.m_settings.m_proxyWorkstation = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("NonProxyHosts", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setNonProxyHosts(variant.getString());
        }
        this.m_settings.m_clientConfig.setMaxErrorRetry(10);
        variant = this.getOptionalSetting("MaxErrorRetry", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_clientConfig.setMaxErrorRetry(variant.getInt());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("RequestTimeout", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && -1 < variant.getInt()) {
                this.m_settings.m_clientConfig.setRequestTimeout(variant.getInt() * 1000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("ClientExecutionTimeout", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && -1 < variant.getInt()) {
                this.m_settings.m_clientConfig.setClientExecutionTimeout(variant.getInt() * 1000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("UseReaper", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_clientConfig.setUseReaper(1 == variant.getInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("UseThrottledRetries", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_clientConfig.setUseThrottleRetries(1 == variant.getInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        variant = this.getOptionalSetting("MaxConsecutiveRetriesBeforeThrottling", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 < variant.getInt()) {
                this.m_settings.m_clientConfig.setMaxErrorRetry(variant.getInt());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("UseGzip", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_clientConfig.setUseGzip(1 == variant.getInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("SignerOverride", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            this.m_settings.m_clientConfig.setSignerOverride(variant.getString());
        }
        if (null != (variant = this.getOptionalSetting("PreemptiveBasicProxyAuth", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_clientConfig.setPreemptiveBasicProxyAuth(1 == variant.getInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        variant = this.getOptionalSetting("ConnectionTTL", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && -1L < variant.getLong()) {
                this.m_settings.m_clientConfig.setConnectionTTL(variant.getLong() * 1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("ConnectionMaxIdleSecs", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && -1L < variant.getLong()) {
                this.m_settings.m_clientConfig.setConnectionMaxIdleMillis(variant.getLong() * 1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("ValidateAfterInactivitySecs", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && -1 < variant.getInt()) {
                this.m_settings.m_clientConfig.setValidateAfterInactivityMillis(variant.getInt() * 1000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("UseTcpKeepAlive", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_clientConfig.setUseTcpKeepAlive(1 == variant.getInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (variant = this.getOptionalSetting("CacheResponseMetadata", connSettingRequestMap)) && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_clientConfig.setCacheResponseMetadata(1 == variant.getInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        variant = this.getOptionalSetting("ResponseMetadataCacheSize", connSettingRequestMap);
        try {
            if (null != variant && !variant.getString().isEmpty() && 0 <= variant.getInt()) {
                this.m_settings.m_clientConfig.setResponseMetadataCacheSize(variant.getInt());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        variant = this.getOptionalSetting("UseExpectContinue", connSettingRequestMap);
        if (null != variant && !variant.getString().isEmpty()) {
            try {
                this.m_settings.m_clientConfig.setUseExpectContinue(1 == variant.getInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setConnectedPropertyValues() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        try {
            this.setProperty(65, new Variant(3, this.m_settings.m_binaryColumnLength));
            this.setProperty(66, new Variant(3, this.m_settings.m_maxCatalogNameLength));
            this.setProperty(81, new Variant(3, this.m_settings.m_maxSchemaNameLength));
            this.setProperty(83, new Variant(3, this.m_settings.m_maxTableNameLength));
            this.setProperty(68, new Variant(3, this.m_settings.m_maxColumnNameLength));
            this.setProperty(139, new Variant(0, this.m_settings.m_uid));
        }
        catch (Exception exception) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.CONN_PROP_ERR.name(), (Throwable)exception);
        }
    }

    private void setDefaultProperties() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        try {
            PropertyUtilities.setCatalogSupport(this, true);
            PropertyUtilities.setReadOnly(this, true);
            PropertyUtilities.setSavepointSupport(this, false);
            PropertyUtilities.setSchemaSupport(this, true);
            PropertyUtilities.setStoredProcedureSupport(this, false);
            PropertyUtilities.setStoredFunctionsCallsSupport(this, false);
            this.setProperty(22, new Variant(0, "AwsDataCatalog"));
            this.setProperty(26, new Variant(3, 0L));
            this.setProperty(101, new Variant(0, "AWS.Athena"));
            this.setProperty(41, new Variant(0, "AWS.Athena"));
            this.setProperty(42, new Variant(0, "01.00.0000"));
            this.setProperty(45, new Variant(3, 0L));
            this.setProperty(90, new Variant(3, 0xFFFFFFL));
            this.setProperty(104, new Variant(3, 0xB55FFFL));
            this.setProperty(131, new Variant(3, 4L));
            this.setProperty(133, new Variant(3, 0L));
            this.setProperty(134, new Variant(3, 0L));
            this.setProperty(135, new Variant(3, 0x1FFFFFL));
            this.setProperty(89, new Variant(2, Character.valueOf('\u0004')));
            this.setProperty(57, new Variant(2, Character.valueOf('\u0002')));
            this.setProperty(98, new Variant(2, Character.valueOf('\u0002')));
            this.setProperty(106, new Variant(3, 29084L));
            this.setProperty(107, new Variant(3, 0L));
            this.setProperty(108, new Variant(3, 29084L));
            this.setProperty(109, new Variant(3, 257L));
            this.setProperty(110, new Variant(3, 0L));
            this.setProperty(111, new Variant(3, 33024L));
            this.setProperty(112, new Variant(3, 29084L));
            this.setProperty(113, new Variant(3, 29084L));
            this.setProperty(114, new Variant(3, 0L));
            this.setProperty(115, new Variant(3, 29084L));
            this.setProperty(116, new Variant(3, 0L));
            this.setProperty(117, new Variant(3, 0L));
            this.setProperty(118, new Variant(3, 0L));
            this.setProperty(119, new Variant(3, 0L));
            this.setProperty(120, new Variant(3, 0L));
            this.setProperty(121, new Variant(3, 0L));
            this.setProperty(122, new Variant(3, 29084L));
            this.setProperty(123, new Variant(3, 0L));
            this.setProperty(124, new Variant(3, 164096L));
            this.setProperty(125, new Variant(3, 29084L));
            this.setProperty(126, new Variant(3, 2048L));
            this.setProperty(127, new Variant(3, 194973L));
            this.setProperty(128, new Variant(3, 0L));
            this.setProperty(129, new Variant(3, 0L));
            this.setProperty(130, new Variant(3, 0L));
            this.setProperty(94, new Variant(0, "Y"));
            this.setProperty(93, new Variant(0, "Y"));
            this.setProperty(137, new Variant(3, 0L));
        }
        catch (Exception exception) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.CONN_DEFAULT_PROP_ERR.name(), (Throwable)exception);
        }
    }

    public void setDbmsVersion() throws ErrorException, IncorrectTypeException, NumericOverflowException {
        GetWorkGroupResult getWorkGroupResult = this.m_client.fetchWorkGroup();
        if (200 == getWorkGroupResult.getSdkHttpMetadata().getHttpStatusCode()) {
            String string = String.format("%02d", Integer.valueOf(getWorkGroupResult.getWorkGroup().getConfiguration().getEngineVersion().getEffectiveEngineVersion().replaceAll("[^0-9]", "")));
            String string2 = string + ".00.0000";
            this.setProperty(42, new Variant(0, string2));
        }
    }
}

