/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.lakeformation.model;

import com.simba.athena.amazonaws.AmazonWebServiceRequest;
import com.simba.athena.amazonaws.services.lakeformation.model.DataLakePrincipal;
import com.simba.athena.amazonaws.services.lakeformation.model.Permission;
import com.simba.athena.amazonaws.services.lakeformation.model.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RevokePermissionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalogId;
    private DataLakePrincipal principal;
    private Resource resource;
    private List<String> permissions;
    private List<String> permissionsWithGrantOption;

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public RevokePermissionsRequest withCatalogId(String catalogId) {
        this.setCatalogId(catalogId);
        return this;
    }

    public void setPrincipal(DataLakePrincipal principal) {
        this.principal = principal;
    }

    public DataLakePrincipal getPrincipal() {
        return this.principal;
    }

    public RevokePermissionsRequest withPrincipal(DataLakePrincipal principal) {
        this.setPrincipal(principal);
        return this;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public RevokePermissionsRequest withResource(Resource resource) {
        this.setResource(resource);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public RevokePermissionsRequest withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public RevokePermissionsRequest withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public RevokePermissionsRequest withPermissions(Permission ... permissions) {
        ArrayList<String> permissionsCopy = new ArrayList<String>(permissions.length);
        for (Permission value : permissions) {
            permissionsCopy.add(value.toString());
        }
        if (this.getPermissions() == null) {
            this.setPermissions(permissionsCopy);
        } else {
            this.getPermissions().addAll(permissionsCopy);
        }
        return this;
    }

    public List<String> getPermissionsWithGrantOption() {
        return this.permissionsWithGrantOption;
    }

    public void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
        if (permissionsWithGrantOption == null) {
            this.permissionsWithGrantOption = null;
            return;
        }
        this.permissionsWithGrantOption = new ArrayList<String>(permissionsWithGrantOption);
    }

    public RevokePermissionsRequest withPermissionsWithGrantOption(String ... permissionsWithGrantOption) {
        if (this.permissionsWithGrantOption == null) {
            this.setPermissionsWithGrantOption(new ArrayList<String>(permissionsWithGrantOption.length));
        }
        for (String ele : permissionsWithGrantOption) {
            this.permissionsWithGrantOption.add(ele);
        }
        return this;
    }

    public RevokePermissionsRequest withPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
        this.setPermissionsWithGrantOption(permissionsWithGrantOption);
        return this;
    }

    public RevokePermissionsRequest withPermissionsWithGrantOption(Permission ... permissionsWithGrantOption) {
        ArrayList<String> permissionsWithGrantOptionCopy = new ArrayList<String>(permissionsWithGrantOption.length);
        for (Permission value : permissionsWithGrantOption) {
            permissionsWithGrantOptionCopy.add(value.toString());
        }
        if (this.getPermissionsWithGrantOption() == null) {
            this.setPermissionsWithGrantOption(permissionsWithGrantOptionCopy);
        } else {
            this.getPermissionsWithGrantOption().addAll(permissionsWithGrantOptionCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: ").append(this.getCatalogId()).append(",");
        }
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getPermissionsWithGrantOption() != null) {
            sb.append("PermissionsWithGrantOption: ").append(this.getPermissionsWithGrantOption());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokePermissionsRequest)) {
            return false;
        }
        RevokePermissionsRequest other = (RevokePermissionsRequest)obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getPermissionsWithGrantOption() == null ^ this.getPermissionsWithGrantOption() == null) {
            return false;
        }
        return other.getPermissionsWithGrantOption() == null || other.getPermissionsWithGrantOption().equals(this.getPermissionsWithGrantOption());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionsWithGrantOption() == null ? 0 : this.getPermissionsWithGrantOption().hashCode());
        return hashCode;
    }

    @Override
    public RevokePermissionsRequest clone() {
        return (RevokePermissionsRequest)super.clone();
    }
}

